/*
 * Fuzzy Fingerprinting - Attacking vulnerabilities in the Human Brain
 * Copyright 2002 Plasmoid <plasmoid@thc.org> - All rights reserved. 
 * On behalf of The Hacker's Choice - http://www.thc.org
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright   
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright   
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR `AS IS'' AND ANY EXPRESS OR     
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _XKEY_H
#define _XKEY_H

#include <openssl/rsa.h>
#include <openssl/dsa.h>

#define XKEY_RSA_SLOPPY 0x0001
#define XKEY_DSA_SLOPPY 0x0002

enum xkey_types {
   XKEY_RSA,
   XKEY_DSA
};

typedef struct {
   int type;
   int bits;
   int flags;

   void *alg;

   int (*init_key) (void **alg, int bits, BIGNUM ** alpha, BIGNUM ** beta);
   int (*next_key) (void *alg, int flags, BIGNUM * alpha, BIGNUM * beta);
   int (*complete_key) (void *alg);
   void (*free_key) (void *alg, BIGNUM * alpha, BIGNUM * beta);
   int (*clone_key) (void **alg1, BIGNUM ** alpha1, BIGNUM ** beta1,
		     void *alg2, BIGNUM * alpha2, BIGNUM * beta2);
   int (*read_key) (void **alg, int fd, BIGNUM ** alpha, BIGNUM ** beta);
   int (*write_key) (void *alg, int fd, BIGNUM * alpha, BIGNUM * beta);
   void (*print_key) (void *alg, FILE * out, BIGNUM * alpha, BIGNUM * beta);

   BIGNUM *alpha;
   BIGNUM *beta;
} xkey_t;


void xkey_set_ops(xkey_t * xkey, int type);
int xkey_init(xkey_t ** xkey, int type, int bits, int flags);
void xkey_free(xkey_t * xkey);
int xkey_next(xkey_t * xkey);
int xkey_complete(xkey_t * xkey);
int xkey_clone(xkey_t ** xkey1, xkey_t * xkey2);
int xkey_read(xkey_t ** xkey, int fd);
int xkey_write(xkey_t * xkey, int fd);
void xkey_print(xkey_t * xkey, FILE * out);
int xkey_type_from_name(char *name);

#endif				/* _XKEY_H */
