/*
 * Fuzzy Fingerprinting - Attacking vulnerabilities in the Human Brain
 * Copyright 2002 Plasmoid <plasmoid@thc.org> - All rights reserved. 
 * On behalf of The Hacker's Choice - http://www.thc.org
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright   
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright   
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR `AS IS'' AND ANY EXPRESS OR     
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _STATE_H
#define _STATE_H

#define STATE_MAGIC "FFP"
#define STATE_MAGIC_LEN 3

typedef struct {
   xkey_t *xkey;
   fmap_t *fmap;
   list_t *list;

   double seconds;
   double hashs;

   int xkey_type;
   int hash_type;
   int fmap_type;

   char *state_file;
   unsigned char *target_hash;
} state_t;

int state_init(state_t ** s, int key_type, int hash_type, int map_type,
	       unsigned char *hash, char *file);
int state_set_ptr(state_t * s, fmap_t * fmap, xkey_t * xkey, list_t * lst);
void state_free(state_t * s);
int state_read(state_t ** s, int fd);
int state_write(state_t * s, int fd);
void state_update(state_t * s, unsigned long h, time_t secs);
void state_print(state_t * s, FILE * out);

#endif				/* _STATE_H */
