/*
 * Fuzzy Fingerprinting - Attacking vulnerabilities in the Human Brain
 * Copyright 2002 Plasmoid <plasmoid@thc.org> - All rights reserved. 
 * On behalf of The Hacker's Choice - http://www.thc.org
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright   
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright   
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR `AS IS'' AND ANY EXPRESS OR     
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _RSA_H
#define _RSA_H

#include <openssl/rsa.h>
#include <openssl/dsa.h>

int RSA_init_key(RSA ** rsa, int bits, BIGNUM ** alpha, BIGNUM ** beta);
int RSA_next_key(RSA * rsa, int flags, BIGNUM * alpha, BIGNUM * beta);
int RSA_complete_key(RSA * rsa);
int RSA_clone_key(RSA ** rsa1, BIGNUM ** alpha1, BIGNUM ** beta1,
		  RSA * rsa2, BIGNUM * alpha2, BIGNUM * beta2);
void RSA_free_key(RSA * rsa, BIGNUM * alpha, BIGNUM * beta);
int RSA_read_key(RSA ** rsa, int fd, BIGNUM ** alpha, BIGNUM ** beta);
int RSA_write_key(RSA * rsa, int fd, BIGNUM * alpha, BIGNUM * beta);
void RSA_print_key(RSA * rsa, FILE * out, BIGNUM * alpha, BIGNUM * beta);

#endif				/* _RSA_H */
