/*
 * Fuzzy Fingerprinting - Attacking vulnerabilities in the Human Brain
 * Copyright 2002 Plasmoid <plasmoid@thc.org> - All rights reserved. 
 * On behalf of The Hacker's Choice - http://www.thc.org
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright   
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright   
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR `AS IS'' AND ANY EXPRESS OR     
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _HASH_H
#define _HASH_H

#include "fmap.h"

enum fp_type {
   HASH_MD5,
   HASH_SHA1,
   HASH_RIPEMD
};

typedef struct {
   int type;

   unsigned char *hash;
   unsigned short hash_len;

   unsigned char *data;
   unsigned long data_len;

   unsigned long quality;

   int (*calc_hash) (unsigned char *data, unsigned long n,
		     unsigned char *md);
   void (*print_hash) (FILE * out);

} hash_t;

void hash_set_ops(hash_t * h, int type);
int hash_init(hash_t ** h, int type);
int hash_clone(hash_t ** h1, hash_t * h2);
void hash_free(hash_t * h);
void hash_free_data(hash_t * h);
void hash_print(hash_t * h, FILE * out);
int hash_hash(hash_t * h, unsigned char *data, unsigned long n);
int hash_read(hash_t ** h, int fd);
int hash_write(hash_t * h, int fd);
int hash_length(int type);
int hash_quality(hash_t * h, fmap_t * fmap, unsigned char *real_hash);
int hash_calc(hash_t * h, unsigned char *data, unsigned long n);
int hash_type_from_name(char *name);

#endif				/* _HASH_H */
