/*
 * Fuzzy Fingerprinting - Attacking vulnerabilities in the Human Brain
 * Copyright 2002 Plasmoid <plasmoid@thc.org> - All rights reserved. 
 * On behalf of The Hacker's Choice - http://www.thc.org
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright   
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright   
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR `AS IS'' AND ANY EXPRESS OR     
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _FMAP_H
#define _FMAP_H

enum {
   FMAP_INV_GAUSS,
   FMAP_COSINE
};

typedef struct {
   int type;
   unsigned int *weights;
   unsigned int *rmd;
   unsigned int *fmd;
   unsigned int length;
   unsigned long sum;
} fmap_t;

int fmap_init(fmap_t ** fmap, int type, float sigma, float my, int len);
unsigned long fmap_quality(fmap_t * fmap, unsigned char *rmd,
			   unsigned char *fmd);
float fmap_normalize(fmap_t * fmap, unsigned long n);
void fmap_free(fmap_t * fmap);
int fmap_clone(fmap_t ** fmap1, fmap_t * fmap2);
int fmap_read(fmap_t ** fmap, int fd);
int fmap_write(fmap_t * fmap, int fd);
void fmap_print(fmap_t * fmap, FILE * out);
int fmap_type_from_name(char *name);

#endif				/* _FMAP_H */
