/*
 * Fuzzy Fingerprinting - Attacking vulnerabilities in the Human Brain
 * Copyright 2002 Plasmoid <plasmoid@thc.org> - All rights reserved. 
 * On behalf of The Hacker's Choice - http://www.thc.org
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright   
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright   
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR `AS IS'' AND ANY EXPRESS OR     
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _DSA_H
#define _DSA_H

#include <openssl/rsa.h>
#include <openssl/dsa.h>

int DSA_init_key(DSA ** dsa, int bits, BIGNUM ** alpha, BIGNUM ** beta);
int DSA_next_key(DSA * dsa, int flags, BIGNUM * alpha, BIGNUM * beta);
int DSA_complete_key(DSA * dsa);
int DSA_clone_key(DSA ** dsa1, BIGNUM ** alpha1, BIGNUM ** beta1,
		  DSA * dsa2, BIGNUM * alpha2, BIGNUM * beta2);
void DSA_free_key(DSA * dsa, BIGNUM * alpha, BIGNUM * beta);
int DSA_read_key(DSA ** dsa, int fd, BIGNUM ** alpha, BIGNUM ** beta);
int DSA_write_key(DSA * dsa, int fd, BIGNUM * alpha, BIGNUM * beta);
void DSA_print_key(DSA * dsa, FILE * out, BIGNUM * alpha, BIGNUM * beta);

#endif				/* _DSA_H */
