/*
 * Copyright (c) 2018 Sergey Lavrushkin
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file
 * Default cnn weights for x2 upsampling with srcnn filter.
 */
#ifndef AVFILTER_SRCNN_H
#define AVFILTER_SRCNN_H

/// First convolution kernel
static const double conv1_kernel[] = {
-0.08866337686777115, 0.055409565567970276, 0.037196505814790726, -0.11961404234170914, -0.12341991066932678, 0.2996342182159424, -0.09118170291185379, -0.00013613555347546935, -0.049023594707250595,
0.038421183824539185, -0.07726779580116272, 0.027273094281554222, 0.45762088894844055, 0.023581644520163536, -0.20363852381706238, -0.07738441973924637, 0.07288403809070587, 0.06679897010326385,
-0.07315085083246231, 0.2665306031703949, 0.07836370915174484, -0.2898528277873993, -0.506912887096405, 0.0446651317179203, -0.06246858835220337, -0.024424826726317406, -0.029072929173707962,
-0.16884787380695343, 0.20686236023902893, -0.2536700665950775, -0.38499701023101807, -0.12601901590824127, 0.7257882356643677, 0.09588377922773361, -0.04487278312444687, -0.011251595802605152,
-0.02955852635204792, 0.2211706042289734, -0.3845316469669342, -0.053509537130594254, 0.10955915600061417, 0.3725738823413849, -0.28968045115470886, -0.10883618891239166, 0.19628790020942688,
0.09746792912483215, -0.005647096782922745, -0.13035884499549866, 0.6254252195358276, 0.19104234874248505, -0.011692332103848457, -0.27067890763282776, -0.030754156410694122, 0.029875505715608597,
0.016808750107884407, -0.1831790804862976, -0.16016070544719696, 0.3598291277885437, -0.1889011114835739, -0.22343340516090393, -0.11111768335103989, 0.3221142590045929, -0.18514074385166168,
-0.06647012382745743, 0.1800554096698761, -0.0356597937643528, -0.25352174043655396, -0.18370479345321655, 0.2839542329311371, 0.0030237233731895685, 0.24072711169719696, -0.1435547173023224,
0.0474187433719635, -0.03221237286925316, -0.08801338076591492, 0.2959175109863281, 0.04108741134405136, -0.103544220328331, -0.11681117117404938, -0.010267493315041065, 0.023703521117568016,

-0.043954458087682724, 0.0953388437628746, 0.12233797460794449, -0.0521148182451725, 0.068812295794487, 0.0576486811041832, 0.08686650544404984, -0.12001238018274307, 0.02353638783097267,
-0.022270673885941505, -0.06377912312746048, 0.010644146241247654, -0.27824145555496216, -0.23719865083694458, -0.21418367326259613, -0.09665020555257797, 0.10458534955978394, 0.06599418818950653,
-0.031174281612038612, -0.03465353325009346, 0.022143816575407982, -0.24322354793548584, -0.08923598378896713, -0.02724810689687729, -0.09314896911382675, -0.03740973770618439, 0.07819665223360062,
0.12521375715732574, 0.11189836263656616, 0.34981977939605713, 0.24303556978702545, 0.21350803971290588, 0.3712073266506195, 0.12192775309085846, -0.15492133796215057, 0.01884031854569912,
-0.08351074159145355, -0.305499792098999, -0.11462165415287018, -0.11833594739437103, -0.35027629137039185, -0.007749142590910196, -0.05184945464134216, -0.14423955976963043, -0.04047594219446182,
0.18357796967029572, 0.16708122193813324, 0.0748625323176384, 0.17892862856388092, 0.12331069260835648, 0.16825254261493683, -0.040668703615665436, 0.12498869001865387, 0.12445469200611115,
-0.08529794961214066, -0.23087382316589355, -0.2426449954509735, -0.003364269156008959, -0.019013511016964912, 0.007406715769320726, -0.09762480109930038, 0.09727375954389572, -0.14308449625968933,
0.20924511551856995, 0.047315631061792374, 0.17839451134204865, 0.20142769813537598, -0.2138431817293167, -0.16858182847499847, 0.07769212126731873, 0.11478294432163239, 0.002249526558443904,
-0.09524660557508469, -0.11904185265302658, -0.1190405860543251, 0.1193549856543541, 0.040786921977996826, -0.07873278856277466, 0.19328512251377106, -0.06008544936776161, -0.03619224950671196,

-0.03508936986327171, -0.02129603736102581, 0.04467615857720375, 0.0351480171084404, 0.047732554376125336, -0.036008983850479126, -0.09819480776786804, -0.07464613020420074, 0.16331301629543304,
0.05766148120164871, -0.06068359687924385, 0.023710887879133224, 0.04077879339456558, 0.0195282194763422, -0.04709528759121895, -0.0026468061842024326, 0.01308137271553278, -0.04843336343765259,
-0.05547124147415161, -0.007511544041335583, -0.0018498365534469485, 0.006324829533696175, 0.08334493637084961, -0.03534594178199768, -0.05873340740799904, -0.11714734137058258, -0.049685098230838776,
-0.01065769698470831, 0.08840381354093552, 0.06828710436820984, 0.020970111712813377, 0.2620500922203064, 0.11938150972127914, 0.04214100167155266, -0.0640568658709526, -0.04790668934583664,
0.05482594668865204, 0.07402177155017853, 0.21512433886528015, 0.25780582427978516, 0.42716339230537415, 0.18216213583946228, 0.12531153857707977, 0.10390171408653259, -0.010482890531420708,
-0.07587306201457977, -0.01289812009781599, 0.10065701603889465, 0.07373074442148209, 0.15948989987373352, -0.08611098676919937, 0.00668379059061408, 0.10756229609251022, -0.10216449201107025,
-0.12100939452648163, 0.009513840079307556, 0.04604566842317581, 0.06705893576145172, 0.21903297305107117, 0.026905395090579987, 0.005323861725628376, 0.0006765045691281557, -0.04283676669001579,
-0.025259271264076233, -0.009707702323794365, -0.0009789661271497607, 0.04325764626264572, 0.0880921259522438, 0.018156062811613083, -0.012795506976544857, -0.10799489170312881, 0.04463301599025726,
0.135641410946846, 0.03334195539355278, -0.12862707674503326, -0.13122200965881348, -0.009230302646756172, -0.01939813420176506, -0.005852208007127047, -0.05510852858424187, -0.039392534643411636,

0.03604253754019737, -0.017754223197698593, 0.012287494726479053, 0.08819247782230377, -0.04256458953022957, -0.08412624895572662, 0.0034042259212583303, 0.0951397642493248, -0.019551629200577736,
-0.09674753248691559, 0.18024282157421112, -0.08090511709451675, -0.2444406896829605, 0.006856921128928661, 0.13041719794273376, 0.025669438764452934, -0.239430770277977, 0.0447552353143692,
-0.0160992369055748, -0.1801433265209198, -0.1196504458785057, 0.15631894767284393, 0.23565492033958435, -0.016446923837065697, 0.08860990405082703, 0.03030352108180523, 0.03708450496196747,
0.20704922080039978, -0.30848193168640137, 0.29852479696273804, 0.5171792507171631, 0.008160743862390518, -0.3112908899784088, -0.12307851761579514, 0.23214605450630188, -0.03460124507546425,
-0.053407326340675354, 0.1022569090127945, 0.21641655266284943, -0.00649402616545558, -0.25075840950012207, -0.20448848605155945, 0.05053631216287613, 0.12135548144578934, -0.24142836034297943,
-0.2844122350215912, 0.33926066756248474, -0.18576817214488983, -0.49420735239982605, -0.09703129529953003, 0.003108662785962224, 0.15142951905727386, -0.08352979272603989, 0.115256167948246,
0.15754960477352142, 0.11142445355653763, 0.0034580992069095373, -0.17606016993522644, 0.16817983984947205, 0.09105344116687775, 0.0391756035387516, -0.09479036927223206, 0.05635075643658638,
0.025231560692191124, -0.24550069868564606, 0.06336600333452225, 0.16318576037883759, 0.2175760567188263, -0.10586289316415787, -0.08236701786518097, 0.06969913840293884, -0.02470541186630726,
-0.05397476255893707, 0.1786981225013733, -0.02780720219016075, -0.1967526525259018, -0.10373450070619583, 0.00851354282349348, 0.1325003206729889, -0.04592644423246384, -0.0030838586390018463,

-0.04047795757651329, 0.049372006207704544, -0.13666890561580658, 0.1378665715456009, -0.13875751197338104, 0.2965521812438965, 0.17230957746505737, -0.1306699514389038, -0.04865024611353874,
0.04459606111049652, -0.03141403943300247, 0.03123670630156994, 0.14699892699718475, -0.48831430077552795, -0.44782617688179016, -0.32052814960479736, 0.2229323387145996, 0.1162572130560875,
0.03055264800786972, -0.1319550722837448, -0.09584920108318329, 0.0705055445432663, -0.14855937659740448, 0.10478757321834564, -0.16068053245544434, -0.1229013130068779, -0.1337907612323761,
0.024233104661107063, 0.23596088588237762, -0.02100684866309166, 0.18905019760131836, 0.5085715055465698, 0.6372939348220825, 0.21577122807502747, 0.011278441175818443, 0.18822115659713745,
-0.15459269285202026, -0.0407223254442215, -0.10378250479698181, -0.20680242776870728, -0.00483810156583786, -0.08054018765687943, -0.20550838112831116, -0.1687704175710678, -0.13454553484916687,
0.2471650391817093, -0.055626824498176575, 0.2678316533565521, -0.060780562460422516, -0.303755521774292, -0.16147832572460175, 0.13623715937137604, 0.2936753034591675, 0.047969236969947815,
-0.030661728233098984, -0.3058367073535919, -0.08003056794404984, 0.10655707865953445, -0.018742285668849945, 0.0358792282640934, -0.025629207491874695, -0.11310984939336777, -0.14455994963645935,
0.04050181433558464, 0.28120800852775574, -0.05849621072411537, 0.09595921635627747, -0.004120929166674614, 0.14832600951194763, 0.051878951489925385, -0.024979719892144203, 0.12018022686243057,
-0.05971016362309456, -0.02700062096118927, -0.15200918912887573, 0.17205531895160675, -0.10738909244537354, -0.04203944280743599, -0.051565732806921005, 0.04735837131738663, -0.020336713641881943,

0.07923562824726105, 0.0198534969240427, 0.048436764627695084, -0.002480322029441595, -0.030445646494627, 0.043048497289419174, -0.0205036923289299, -0.06609753519296646, 0.12097517400979996,
0.0073249018751084805, -0.1222478523850441, -0.05323218181729317, -0.05764566361904144, -0.02026738040149212, -0.02420945279300213, -0.0054551986977458, 0.009971958585083485, 0.02396593615412712,
-0.00814845971763134, -0.005118967965245247, 0.021225877106189728, -0.00796600803732872, 0.08807612955570221, 0.014100071974098682, -0.025872008875012398, -0.07725587487220764, 0.03290954977273941,
0.03431324660778046, 0.09776207059621811, 0.13437990844249725, 0.05204648897051811, 0.2355445921421051, 0.1828816831111908, 0.09693129360675812, -0.05040072277188301, -0.04832229018211365,
-0.09905002266168594, -0.007481470704078674, 0.19846895337104797, 0.14758875966072083, 0.23091012239456177, 0.1373375654220581, 0.13091282546520233, 0.09288259595632553, -0.0527421310544014,
-0.1716664880514145, -0.0430670902132988, 0.14391253888607025, 0.03829243406653404, 0.08738404512405396, -0.02923797443509102, 0.06396066397428513, 0.12762053310871124, -0.028018195182085037,
-0.1265193074941635, 0.024751774966716766, 0.10589214414358139, 0.09887334704399109, 0.24562613666057587, 0.1253046840429306, 0.061612073332071304, -0.024125540629029274, 0.007247811183333397,
-0.047855667769908905, 0.013432897627353668, 0.03482811152935028, 0.077229805290699, 0.10088468343019485, 0.044684406369924545, -0.02041577361524105, -0.15163108706474304, -0.0034704350400716066,
0.1224449947476387, 0.039203088730573654, -0.06930789351463318, -0.015424877405166626, -0.016137346625328064, -0.04581397399306297, 0.013485562987625599, 0.02408866584300995, 0.01687670312821865,

0.12519507110118866, -0.041654638946056366, 0.03898311033844948, -0.22598722577095032, -0.09394078701734543, 0.1919124722480774, 0.029383260756731033, 0.10377474129199982, -0.2492591291666031,
-0.043930936604738235, -0.3671221435070038, 0.3154682517051697, 0.36849597096443176, 0.03571537509560585, -0.22950607538223267, -0.32223397493362427, 0.11626888066530228, 0.36967718601226807,
0.07823024690151215, -0.03394254669547081, -0.16880908608436584, -0.10228093713521957, 0.10619838535785675, 0.18821090459823608, 0.23802940547466278, -0.3408791124820709, -0.07126303762197495,
0.061694081872701645, 0.4341343641281128, 0.018764551728963852, -0.5168696641921997, -0.18586228787899017, 0.023195838555693626, 0.41148796677589417, -0.16325277090072632, -0.04624730721116066,
-0.24675504863262177, -0.24047937989234924, 0.5096768140792847, -0.11603347212076187, -0.16423484683036804, -0.4146907329559326, 0.03169603273272514, 0.2864610254764557, -0.04983063042163849,
0.28279417753219604, -0.529873788356781, 0.44762998819351196, 0.38769611716270447, 0.10861404985189438, -0.451587438583374, -0.280461847782135, 0.25342127680778503, -0.006180415395647287,
0.061705078929662704, -0.42082899808883667, -0.3081591725349426, 0.3025337755680084, 0.429571270942688, 0.21554873883724213, 0.13188275694847107, -0.20662707090377808, -0.04069284722208977,
0.12084224075078964, 0.5464516878128052, -0.07281342148780823, -0.3835149109363556, -0.27153536677360535, -0.07571228593587875, 0.18072815239429474, -0.09978610277175903, -0.018040550872683525,
-0.06959383934736252, -0.3904227018356323, 0.31299376487731934, 0.034528203308582306, 0.02515311911702156, 0.10656317323446274, -0.11172980815172195, 0.03748366981744766, 0.047296296805143356,

0.09683134406805038, -0.0490269660949707, -0.037623628973960876, 0.10789167135953903, -8.220049494411796e-06, -0.14363789558410645, -0.16596809029579163, -0.08668889105319977, 0.18112757802009583,
0.18681281805038452, -0.03149910271167755, 0.04626822471618652, 0.180941641330719, 0.13341115415096283, -0.00802976917475462, -0.01218352746218443, 0.017653124406933784, -0.14602351188659668,
0.026090171188116074, -0.028547901660203934, 0.028874900192022324, 0.05083140358328819, 0.020649630576372147, -0.08328215032815933, -0.023062726482748985, 0.010069028474390507, -0.12333136796951294,
0.053707439452409744, -0.0324716679751873, -0.03936217725276947, -0.08829819411039352, -0.1376572996377945, -0.11359868198633194, 0.0130832614377141, 0.022561145946383476, 0.132071852684021,
0.136616051197052, 0.04625130817294121, 0.0588667057454586, 0.0007978741195984185, -0.012749897316098213, -0.010349061340093613, 0.07410106062889099, 0.07395953685045242, 0.18698151409626007,
-0.04733249172568321, 0.048088040202856064, 0.0830550268292427, 0.030247695744037628, 0.06644177436828613, 0.012841179966926575, 0.03576447069644928, 0.021402418613433838, 0.06981246918439865,
-0.25763800740242004, -0.04209354147315025, 0.006816637236624956, 0.05338362976908684, 0.08177036046981812, 0.05133795365691185, 0.1127142459154129, 0.017543654888868332, 0.07357458770275116,
-0.08409541845321655, -0.034381840378046036, 0.0006349623436108232, 0.10339710861444473, 0.034956417977809906, -0.05212416872382164, -0.012170637957751751, -0.06977469474077225, 0.07710030674934387,
0.19582803547382355, -0.11509156227111816, -0.06393624097108841, 0.06701605021953583, 0.034070633351802826, 0.023426907137036324, -0.012323208153247833, -0.004050432704389095, 0.0735023096203804,

-0.050630632787942886, 0.08542390912771225, -0.0671345442533493, -0.01851995475590229, -0.3399946689605713, 0.059590741991996765, 0.02107023261487484, 0.021752946078777313, -0.06753665208816528,
0.010389531962573528, -0.11542703211307526, -0.0027277180925011635, 0.10986809432506561, 0.26090121269226074, 0.15581563115119934, -0.10301733762025833, 0.017184121534228325, 0.03874387592077255,
0.10182108730077744, -0.04267549142241478, -0.052380189299583435, 0.14567996561527252, 0.22389087080955505, 0.018040284514427185, -0.12593504786491394, 0.10430043935775757, -0.03315733000636101,
-0.14966940879821777, 0.16408929228782654, -0.05998832359910011, -0.015550674870610237, -0.46872779726982117, 0.008157094940543175, 0.011156035587191582, -0.0006008691270835698, 0.0005489904433488846,
-0.2431062012910843, 0.3261091411113739, 0.21652723848819733, -0.22604592144489288, -0.9168027639389038, -0.17663948237895966, 0.21353387832641602, 0.32204127311706543, -0.220024973154068,
0.0037586877588182688, 0.029378486797213554, 0.05196898803114891, 0.007423775736242533, -0.32089659571647644, -0.15943418443202972, -0.08669042587280273, 0.17428545653820038, -0.2017044574022293,
0.11773359775543213, -0.09072963893413544, -0.18743669986724854, 0.11423009634017944, 0.19110383093357086, 0.043780069798231125, -0.01969584822654724, 0.03457418084144592, 0.10652895271778107,
-0.0077469912357628345, 0.057167161256074905, -0.07428690791130066, 0.10680720210075378, 0.23509608209133148, 0.11014974117279053, 0.005297536496073008, -0.09246116131544113, 0.08342938125133514,
-0.05754890292882919, 0.0387006439268589, 0.04286401718854904, 0.004276377614587545, -0.28811076283454895, -0.012603707611560822, 0.029502470046281815, 0.06630267202854156, -0.04321223124861717,

-0.04078223183751106, -0.12889280915260315, 0.00378090119920671, -0.04499083012342453, -0.17399507761001587, -0.0889720693230629, -0.0762118324637413, -0.13595382869243622, 0.1422111839056015,
0.14240193367004395, -0.029453754425048828, 0.1309717893600464, 0.11728502064943314, 0.056849636137485504, 0.10260996967554092, 0.1364084780216217, 0.06682252138853073, 0.041533179581165314,
-0.06190625578165054, -0.03482181206345558, 0.13024269044399261, 0.08779320120811462, -0.009105866774916649, -0.08456816524267197, -0.021619636565446854, -0.0503055639564991, -0.056489184498786926,
-0.07594376057386398, 0.09475210309028625, 0.19542919099330902, 0.13114997744560242, 0.011391323991119862, -0.14203785359859467, -0.05326744168996811, -0.05350463092327118, 0.03762698918581009,
-0.11648685485124588, 0.07287167757749557, 0.15281938016414642, 0.12073400616645813, 0.12067076563835144, -0.0056082638911902905, 0.04571988061070442, 0.024191811680793762, 0.048591308295726776,
-0.17068271338939667, -0.05672881007194519, -0.012579147703945637, -0.09227554500102997, 0.02230173908174038, 0.0004932500305585563, 0.00950812827795744, 0.0031514225993305445, -0.00889667496085167,
-0.05413658916950226, 0.047616228461265564, 0.06174631789326668, 0.02442876808345318, 0.12186183035373688, 0.09169657528400421, 0.047002628445625305, -0.0075267525389790535, 0.01986403949558735,
-0.01424704771488905, 0.0007475072052329779, 0.0003156432358082384, 0.04763738438487053, 0.06383068859577179, 0.003278251737356186, -0.01552825327962637, -0.09433456510305405, -0.008774847723543644,
0.11492444574832916, -0.08672236651182175, -0.13945794105529785, -0.11357706785202026, -0.06397917866706848, 0.005938075017184019, 0.03685227036476135, 0.007383051328361034, 0.01781647838652134,

0.12231902033090591, -0.1332593411207199, 0.025870023295283318, 0.10824725776910782, 0.10331027209758759, 0.25639644265174866, -0.059610120952129364, -0.10638877749443054, 0.003959098365157843,
-0.11812649667263031, -0.04782481864094734, 0.1282173991203308, -0.04403266683220863, -0.2635486125946045, 0.09152621030807495, 0.19478914141654968, 0.2014356553554535, -0.06887999176979065,
0.09494968503713608, 0.0008627189672552049, 0.11727812886238098, -0.10687321424484253, -0.4276202321052551, -0.22730430960655212, -0.24313688278198242, -0.06356537342071533, -0.05558193847537041,
0.03284458443522453, -0.14488743245601654, -0.06454713642597198, 0.035593390464782715, 0.1627628654241562, 0.4332711398601532, -0.03525981679558754, 0.07995440810918808, 0.32160332798957825,
-0.02787955291569233, 0.06924286484718323, -0.02763601392507553, -0.07363066077232361, 0.0028215220663696527, 0.1994757354259491, -0.3216938376426697, -0.2148716002702713, -0.022139549255371094,
0.04032602161169052, 0.1799757331609726, 0.10570091009140015, 0.06988003104925156, -0.03948461636900902, -0.012861414812505245, -0.1395958960056305, 0.05889321118593216, -0.02811681292951107,
-0.10384295135736465, -0.1494208127260208, -0.15001268684864044, 0.004614438395947218, -0.09650319069623947, -0.03012348897755146, 0.07189778983592987, 0.15020400285720825, 0.008814077824354172,
0.03591006621718407, 0.021772446110844612, 0.005769453477114439, 0.09402872622013092, 0.015208454802632332, 0.09444975107908249, 0.027698298916220665, -0.0674431249499321, -0.07676154375076294,
0.014581595547497272, -0.0036740561481565237, 0.06329377740621567, -0.054385025054216385, -0.05358858034014702, 0.028128311038017273, -0.09020408242940903, 0.06944200396537781, 0.014859440736472607,

-0.005160152446478605, 0.01375893410295248, 0.062362246215343475, 0.10193950682878494, 0.05305499583482742, -0.2313140481710434, -0.22592732310295105, 0.03434952720999718, 0.13069109618663788,
-0.10505129396915436, 0.055356789380311966, -0.026555435732007027, -0.016221890226006508, -0.0673375278711319, 0.29508867859840393, 0.2490212768316269, -0.04586341232061386, -0.13178391754627228,
-0.0017491007456555963, -0.10163252055644989, -0.19645392894744873, -0.2106999158859253, -0.3647651672363281, 0.1470862478017807, 0.13710150122642517, -0.030172884464263916, 0.04172680154442787,
0.23463378846645355, 0.12248606234788895, 0.16099709272384644, 0.2875089645385742, 0.06577456742525101, -0.04996803030371666, -0.16703690588474274, -0.11296173930168152, 0.032325565814971924,
-0.194684699177742, -0.19403424859046936, -0.1389089971780777, 0.2883749306201935, 0.175620898604393, 0.05886877328157425, -0.15678346157073975, -0.20327216386795044, 0.2553490400314331,
-0.03820692375302315, 0.10567138344049454, -0.055865220725536346, 0.048038050532341, 0.03708084300160408, 0.3200385868549347, 0.10980627685785294, -0.15385061502456665, 0.028807630762457848,
0.15568581223487854, 0.17938005924224854, -0.07448218762874603, -0.2856184244155884, -0.35392215847969055, -0.023577706888318062, -0.03370700031518936, 0.010182502679526806, 0.014598316513001919,
0.04377548396587372, -0.13170590996742249, -0.039992351084947586, 0.03889957070350647, -0.09751184284687042, -0.05208892747759819, 0.010670154355466366, 0.053134288638830185, -0.0034348545596003532,
-0.17609059810638428, 0.0654265433549881, 0.10833371430635452, 0.12016133219003677, 0.2053433358669281, 0.022898679599165916, -0.005226183217018843, -0.041576020419597626, -0.01749270036816597,

0.04755033180117607, 0.02835986763238907, -0.09969023615121841, 0.05305624380707741, 0.0671200305223465, -0.02495085448026657, 0.09633297473192215, 0.1224144771695137, 0.06672052294015884,
-0.14968997240066528, 0.006965477950870991, -0.0101174246519804, 0.1153266578912735, 0.070655457675457, -0.059816814959049225, 0.056025292724370956, 0.11349499225616455, -0.07753042131662369,
0.00633694464340806, 0.11751654744148254, 0.026646621525287628, 0.056598562747240067, 0.023606441915035248, -0.10963784903287888, -0.042333852499723434, 0.061614494770765305, 0.005725272931158543,
0.02671220153570175, 0.011555863544344902, -0.1333906203508377, -0.12263333052396774, -0.053668566048145294, -0.09383269399404526, -0.02531207539141178, 0.04083413630723953, 0.11758150905370712,
0.06897315382957458, 0.09025383740663528, -0.048477206379175186, -0.04428590089082718, -0.00994509644806385, -0.08149151504039764, -0.015064210630953312, 0.008549756370484829, 0.05929453298449516,
0.08121351897716522, 0.18622539937496185, 0.024635188281536102, 0.05900023132562637, 0.06015000864863396, -0.04819020256400108, 0.056722432374954224, 0.008928965777158737, -0.04534973204135895,
0.03157646209001541, 0.07381211221218109, -0.10185391455888748, 0.007117577362805605, 0.0659014955163002, 0.03364647552371025, 0.1454240083694458, 0.040063224732875824, -0.019146164879202843,
0.041676461696624756, 0.011365608312189579, -0.09844156354665756, -0.0134221026673913, -0.03245968744158745, -0.0808059424161911, -0.006428427528589964, -0.05743950605392456, -0.08071335405111313,
-0.07342201471328735, -0.04317256808280945, 0.051688309758901596, 0.18833208084106445, 0.03716733306646347, -0.10183736681938171, -0.03289051353931427, 0.004819261375814676, -0.027331547811627388,

0.11519625782966614, -0.10764797031879425, -0.030568554997444153, -0.020863555371761322, -0.07997738569974899, -0.12052356451749802, -0.05828532204031944, -0.1472300887107849, -0.06770514696836472,
-0.01562062930315733, 0.015726376324892044, 0.1413108855485916, 0.11010552197694778, 0.04810444265604019, 0.07543331384658813, 0.0912747010588646, 0.08718889206647873, 0.2342718243598938,
-0.14150191843509674, -0.009130681864917278, -0.038059089332818985, 0.01774609461426735, 0.12451276183128357, 0.10040413588285446, -0.023616507649421692, -0.07792382687330246, -0.04633943736553192,
0.08530189096927643, 0.1388300657272339, -0.06484226137399673, -0.0574176125228405, -0.005594234447926283, -0.04882295802235603, 0.0208494383841753, 0.11939211934804916, 0.0362018346786499,
0.013776280917227268, -0.05286431312561035, -0.12257250398397446, -0.0317244753241539, -0.15581031143665314, -0.3350363075733185, -0.17516198754310608, 0.05554129555821419, -0.0686616599559784,
0.05185200646519661, 0.010789181105792522, 0.09104238450527191, 0.24157585203647614, 0.14322906732559204, -0.06151513382792473, 0.035073213279247284, 0.2104591578245163, -0.013173309154808521,
-0.027040261775255203, -0.08000551909208298, -0.046120285987854004, 0.02919718250632286, -0.012629073113203049, -0.10132584720849991, -0.017108483240008354, 0.11031834781169891, -0.0014046418946236372,
0.06428524851799011, 0.025128263980150223, -0.012446816079318523, -0.004635910969227552, -0.1081504076719284, -0.22872592508792877, -0.05087840557098389, 0.07903845608234406, 0.007435936946421862,
-0.026907602325081825, 0.03015039674937725, -0.003209742484614253, -0.007098188158124685, -0.02275368571281433, -0.11266212910413742, 0.08625403791666031, 0.11682000011205673, -0.1131199449300766,

0.1638965606689453, 0.08308251202106476, 0.044147979468107224, 0.0804295688867569, 0.06370081752538681, -0.10228355973958969, -0.10279213637113571, -0.11453505605459213, -0.13203175365924835,
-0.1876012235879898, -0.263865202665329, -0.004500165581703186, 0.06932093948125839, 0.12449021637439728, 0.14221718907356262, 0.3287881910800934, 0.3420238494873047, 0.08183267712593079,
0.21325354278087616, -0.22493533790111542, -0.12725761532783508, 0.09147705882787704, 0.1290125548839569, -0.030734121799468994, -0.27371203899383545, -0.10408978164196014, 0.14720973372459412,
0.10748197883367538, -0.1599961668252945, -0.05009974539279938, -0.08701540529727936, -0.20689280331134796, 0.07116125524044037, -0.2347627431154251, -0.26232045888900757, -0.013499017804861069,
0.025579001754522324, -0.2004159539937973, 0.2018989771604538, 0.09299933165311813, -0.11280879378318787, 0.39264678955078125, 0.0753006786108017, -0.12662969529628754, 0.06762414425611496,
0.15581151843070984, -0.18859748542308807, 0.13877420127391815, -0.019523711875081062, -0.09793340414762497, 0.18235981464385986, -0.16306428611278534, -0.08839341253042221, 0.11948712915182114,
-0.05991736426949501, -0.14886321127414703, 0.09461961686611176, -0.08510956168174744, -0.13966059684753418, 0.24795463681221008, 0.11794982105493546, 0.05069331079721451, -0.012114989571273327,
0.04457290470600128, -0.04815959185361862, 0.1882898360490799, 0.1909743845462799, -0.28103575110435486, -0.0955992266535759, -0.024672048166394234, -0.08950752019882202, -0.1380532830953598,
0.0033542094752192497, -0.05668618530035019, -0.08821909874677658, -0.06438030302524567, 0.06170225515961647, 0.20625977218151093, -0.1312813013792038, 0.13963045179843903, 0.028703266754746437,

-0.04330714792013168, 0.047828178852796555, 0.02259783074259758, 0.028202934190630913, 0.11306528747081757, 0.04620766639709473, 0.03325071558356285, 0.013018330559134483, -0.030188586562871933,
-0.09428548812866211, 0.008304737508296967, -0.012987429276108742, -0.014564705081284046, -0.017758160829544067, -0.08705758303403854, -0.007289479952305555, 0.03306053951382637, -0.0745755285024643,
-0.04534974694252014, 0.09827587753534317, 0.011266577057540417, 0.014672774821519852, 0.08231431990861893, -0.03596215322613716, -0.06713400781154633, -0.05937987565994263, 0.013066737912595272,
0.0018231334397569299, 0.06210479512810707, -0.022566145285964012, -0.016408411785960197, 0.2281709462404251, 0.10552603006362915, -0.002925910521298647, -0.07945609092712402, -0.038855068385601044,
0.04577802121639252, 0.04221392795443535, 0.0668831318616867, 0.15467569231987, 0.31194326281547546, 0.12416514754295349, 0.07539507746696472, 0.05988781899213791, 0.03964969143271446,
-0.0502743236720562, 0.008425815962255001, -0.016213499009609222, 0.038200847804546356, 0.09047190845012665, -0.12545324862003326, -0.01555199921131134, 0.053054459393024445, -0.04037122800946236,
-0.046121809631586075, 0.02309240587055683, -0.06815005838871002, 0.019335538148880005, 0.14722861349582672, -0.034557852894067764, -0.009797059930860996, 0.008686223067343235, -0.02284996584057808,
-0.032456208020448685, 0.005591321736574173, -0.040950026363134384, 0.013277396559715271, 0.06872589141130447, -0.008198446594178677, -0.0033175325952470303, -0.021463187411427498, 0.024988390505313873,
-0.10292976349592209, 0.05840924382209778, -0.014231771230697632, -0.009959504008293152, 0.05161023512482643, -0.03409617766737938, 0.008187868632376194, 0.04731370136141777, 0.048039115965366364,

0.0802970826625824, -0.04051158204674721, 0.04360191896557808, 0.05865092575550079, -0.1622205376625061, -0.024287313222885132, 0.0836285799741745, 0.06500931084156036, -0.05659390985965729,
-0.2624095678329468, 0.13464407622814178, -0.18771032989025116, 0.11550064384937286, 0.16735835373401642, 0.11418536305427551, 0.04208488389849663, -0.28944122791290283, 0.19866064190864563,
0.1005323976278305, 0.349872350692749, -0.06771906465291977, 0.07137097418308258, 0.16644106805324554, -0.13974255323410034, 0.027255967259407043, 0.08780799806118011, -0.04396819323301315,
-0.043444134294986725, -0.15180604159832, 0.0619785338640213, 0.017747757956385612, -0.034784309566020966, -0.44199270009994507, -0.18068085610866547, 0.30195340514183044, -0.1637018322944641,
0.10270186513662338, 0.04544973373413086, 0.2248280793428421, -0.12152138352394104, 0.010336581617593765, -0.01738337054848671, 0.055105287581682205, 0.1704106330871582, -0.042338646948337555,
-0.19112332165241241, 0.03816298022866249, -0.04613948240876198, -0.49528568983078003, -0.05306403338909149, 0.18114855885505676, 0.04686790704727173, -0.20611685514450073, 0.05648867040872574,
0.12168501317501068, 0.028137346729636192, 0.0594622865319252, -0.14465802907943726, 0.09685065597295761, 0.07187637686729431, 0.1801527738571167, -0.043932389467954636, -0.058578118681907654,
-0.024302706122398376, -0.2215542495250702, 0.12393766641616821, 0.25892123579978943, 0.18990910053253174, -0.2777440547943115, -0.09749724715948105, 0.09521270543336868, 0.08916869014501572,
0.0026095544453710318, 0.11813537031412125, -0.009317749179899693, -0.22345435619354248, -0.049469027668237686, 0.06460578739643097, 0.06491654366254807, -0.039918966591358185, -0.06013340875506401,

-0.0022389348596334457, 0.07565576583147049, -0.07352778315544128, 0.06510433554649353, -0.12369297444820404, 0.014344852417707443, 0.03208686411380768, 0.09831662476062775, 0.03037380240857601,
0.061919935047626495, -0.013876724056899548, -0.15071509778499603, 0.034635160118341446, 0.04767913743853569, 0.13710123300552368, -0.09395329654216766, -0.06332149356603622, -0.08442047983407974,
-0.08935949951410294, 0.01231801975518465, 0.07064413279294968, 0.14218099415302277, 0.11146871745586395, 0.2414155900478363, -0.20935581624507904, -0.16613058745861053, -0.01560592744499445,
0.019988715648651123, 0.06758933514356613, -0.0719168558716774, -0.01236981712281704, -0.10486599057912827, 0.17582540214061737, -0.1299474686384201, -0.04703458026051521, 0.15262652933597565,
0.07538525015115738, 0.11724765598773956, -0.1910475194454193, -0.014827147126197815, -0.22970618307590485, 0.11626717448234558, -0.01903100498020649, -0.041880253702402115, 0.06078922003507614,
-0.02890881896018982, 0.04699661582708359, -0.26935461163520813, 0.1876785308122635, -0.14111796021461487, 0.2596698999404907, 0.10678144544363022, -0.18526306748390198, -0.0190057884901762,
0.09745893627405167, -0.05590953305363655, -0.08272332698106766, 0.31723424792289734, -0.0658387690782547, 0.09415221959352493, -0.07164923846721649, -0.06966632604598999, 0.02662808448076248,
-0.19949419796466827, -0.0246206633746624, 0.21311849355697632, 0.2718130350112915, 0.01648002304136753, -0.1393970400094986, -0.34433266520500183, 0.001598656876012683, 0.0038846421521157026,
0.051192447543144226, 0.1691122204065323, -0.2610856890678406, -0.07406745105981827, -0.029053758829832077, 0.13458499312400818, 0.11526892334222794, -0.03541361168026924, 0.056526754051446915,

0.002176720881834626, -0.0005761379143223166, 0.0005373261519707739, 0.00019933497242163867, 0.0013520611682906747, 0.0007539301295764744, -0.0001342654722975567, -0.0011657949071377516, 0.0012583840871229768,
0.0005933881038799882, -0.0017465304117649794, -0.001484010019339621, 0.00039301998913288116, -0.0004645275475922972, -0.0016878750175237656, 0.0002233775012427941, -0.001029559294693172, -0.0009793323697522283,
-0.0006459116702899337, -0.0021235670428723097, -0.00032014321186579764, -0.0012910895748063922, 0.0002855791535694152, 2.8073684006812982e-05, -7.394276326522231e-05, -5.34655264345929e-05, -0.00032978097442537546,
-0.0003956406144425273, -0.0008609459619037807, 0.001455773483030498, 0.0010776156559586525, 0.0011523488210514188, 0.00021282589295879006, -0.0011867907596752048, -0.0007682160357944667, -0.00032176540116779506,
-5.27907905052416e-05, 0.00013192533515393734, -0.0010120510123670101, 8.375827746931463e-05, -0.0008451887406408787, -0.0004846166411880404, 0.0008424000116065145, 0.00021478746202774346, -0.0005068618338555098,
-0.002082191640511155, -0.0006638173945248127, -0.0008866858552210033, -0.0006656062905676663, 0.00026315945433452725, 0.0006128559471108019, -0.0025304651353508234, 0.0015004959423094988, 0.00043555640149861574,
-0.0018750375602394342, 0.0002780657378025353, 0.0007915541646070778, 0.000905690947547555, -7.55542641854845e-05, -8.375364996027201e-05, 0.0005546159227378666, 0.0028697361703962088, -0.0006116626900620759,
0.00037985286326147616, -0.0023933311458677053, 0.0007050145650282502, 0.0002475101500749588, -0.0005008446169085801, 0.0007629976025782526, -0.00047074357280507684, 0.00195360672660172, -0.0003873295499943197,
-0.00015744158008601516, -0.0015861615538597107, -0.0007085212273523211, 0.00038756319554522634, -0.0016021300107240677, -0.0005903082783333957, 0.00042594975093379617, -0.0003776818630285561, -0.0018262226367369294,

-0.054790906608104706, 0.2536484897136688, -0.27960002422332764, 0.10039357095956802, -0.12157637625932693, 0.20832301676273346, 0.18832406401634216, 0.058016110211610794, -0.19121704995632172,
0.07001335173845291, 0.011789658106863499, -0.14975960552692413, 0.32273632287979126, -0.4436017572879791, -0.171577587723732, -0.1372644156217575, -0.3071932792663574, 0.38878709077835083,
-0.15567609667778015, 0.1787453144788742, -0.19251511991024017, 0.1917136162519455, -0.014789951965212822, 0.25968435406684875, -0.03754926845431328, -0.2848123610019684, 0.04102560505270958,
-0.19286713004112244, 0.42374134063720703, -0.14859318733215332, -0.024421747773885727, 0.21294380724430084, 0.6637654900550842, 0.01166415773332119, -0.20433177053928375, 0.0004903928493149579,
-0.10848186165094376, 0.20892439782619476, -0.14281906187534332, -0.3483707904815674, -0.5034167766571045, 0.3756079375743866, 0.1145843118429184, -0.4429202973842621, 0.05628497153520584,
0.0797097459435463, -0.023797867819666862, 0.10833027213811874, 0.18675033748149872, -0.2089790254831314, 0.04415358230471611, 0.25636789202690125, -0.1085459291934967, 0.14499802887439728,
0.03994300961494446, -0.043282948434352875, -0.20615562796592712, 0.09225345402956009, 0.08605579286813736, -0.21106603741645813, -0.07366359978914261, 0.05395741015672684, -0.047547996044158936,
-0.1271095871925354, 0.2529429793357849, -0.09454374760389328, 0.025951437652111053, 0.0771566703915596, 0.17352186143398285, 0.044705767184495926, -0.06119989976286888, -0.039735082536935806,
0.010745588690042496, 0.02310154214501381, -0.06094783544540405, 0.048681072890758514, -0.20067468285560608, 0.08646697551012039, 0.03963540866971016, -0.13203775882720947, 0.08694609999656677,

-0.09722302109003067, 0.03210695460438728, -0.07559206336736679, -0.012425316497683525, 0.09689220786094666, -0.07424142956733704, -0.023912370204925537, 0.045455969870090485, -0.08255463093519211,
-0.13820241391658783, 0.05437605455517769, -0.02811860293149948, -0.01956179551780224, -0.04275551065802574, -0.09518728405237198, 0.0649702250957489, 0.15782667696475983, -0.06812569499015808,
-0.031783927232027054, 0.14993485808372498, 0.018872646614909172, 0.04746113717556, 0.05827770754694939, -0.039790987968444824, -0.010545185767114162, 0.03882989659905434, 0.04108560457825661,
-0.01779293827712536, 0.04831157997250557, -0.06487990915775299, -0.016816694289445877, 0.1503911018371582, 0.008327034302055836, -0.05022227019071579, -0.047379978001117706, 0.013194894418120384,
0.08495984971523285, 0.0397963710129261, 0.004932734649628401, 0.1605139672756195, 0.3089984953403473, 0.13151097297668457, 0.050496067851781845, 0.01862998679280281, 0.06326597183942795,
-0.0008310661069117486, 0.029276559129357338, -0.07300391793251038, 0.03156458958983421, 0.09604397416114807, -0.07065139710903168, -0.01909143477678299, -0.022223643958568573, -0.09892617911100388,
0.02422359213232994, 0.09269452840089798, -0.07475303113460541, -0.016138877719640732, 0.07657403498888016, -0.05603542551398277, -0.00701037235558033, 0.056756410747766495, -0.018174193799495697,
0.07398765534162521, 0.09504812210798264, -0.06857247650623322, -0.08990290015935898, -0.030557651072740555, -0.061947084963321686, 0.002213288564234972, 0.08159051090478897, 0.05168388783931732,
0.020383579656481743, 0.17409996688365936, -0.0038788863457739353, -0.07470913231372833, 0.03962652012705803, -0.030469411984086037, -0.009616252034902573, 0.018628180027008057, -0.0447019524872303,

0.0011134855449199677, -0.0011197625426575541, 0.00028048010426573455, 0.0004587448784150183, 6.948400550754741e-05, -0.0012169212568551302, 0.00019439002790022641, 0.0005519872065633535, 0.0007525513065047562,
-0.000916541088372469, -0.0007435868610627949, -0.0005027623265050352, 0.0012707291170954704, -0.0004001464694738388, 0.0018891592044383287, 0.0008733655558899045, -0.0005721450434066355, -0.0006271543097682297,
0.0005203100154176354, 0.001399348140694201, -0.00164745410438627, 0.0006773479981347919, -0.001439067185856402, -5.636991772917099e-05, 0.0006965023349039257, -0.0009332018089480698, -0.0023588379845023155,
0.0006780097610317171, -0.0021587773226201534, 0.0006371110212057829, -0.0008876072242856026, -0.0003492744581308216, -0.0009850499918684363, 0.0009845952736213803, -0.0015154257416725159, -0.00014025077689439058,
0.0026105847209692, -0.000629860907793045, -0.0005694304709322751, 0.00135590392164886, 0.001492034294642508, -0.001354074920527637, 2.806216116368887e-06, 0.0004825407231692225, -0.00041581306140869856,
-0.0007369396626017988, -0.001763421343639493, 0.0001726301125017926, 0.0009360493277199566, 0.00018216429452877492, 0.0002068042813334614, 0.0019893869757652283, -0.0005855539930053055, -0.0011269997339695692,
-0.00021704420214518905, -0.001588256098330021, -0.0006783627322874963, 0.0014362453948706388, -0.0009027141495607793, -0.002311782445758581, -0.0011867601424455643, -0.0014500886900350451, 0.00023469516600016505,
-0.00021923855820205063, -0.000187889818334952, 0.0004802521434612572, 0.0013267970643937588, -0.0009545548819005489, 0.0009784998837858438, 0.0004759304574690759, -0.0006459070718847215, 0.0006639648345299065,
0.0013779453001916409, 0.0016899800393730402, -0.0011343491496518254, -0.0014891978353261948, -0.0005899216630496085, -0.0007052959408611059, -0.0008034939528442919, -0.0008974294760264456, -0.0005873892805539072,

0.001997949555516243, 0.00038864839007146657, -0.0010013188002631068, 0.001064236625097692, 0.0007615702925249934, 0.0005331269931048155, 4.9322476115776226e-05, -0.0004924519453197718, -0.000549216172657907,
-0.000953887531068176, -0.000806727388408035, -0.0022148157004266977, 0.0006371723720803857, -0.0007776754791848361, 0.00013404866331256926, -0.0007302353042177856, 3.658763307612389e-05, 0.0006877999403513968,
0.00028875935822725296, -0.00021337946236599237, -0.0018511258531361818, -0.0001520185760455206, 0.0002033752971328795, -0.0008148921187967062, -0.0012771745678037405, 7.278051634784788e-05, 0.0018562816549092531,
-0.0005795079632662237, 0.0021367198787629604, 0.00037966063246130943, -0.00025460298638790846, -0.00028426345670595765, -0.0003711270110215992, 8.817698835628107e-05, -0.0013910559937357903, -0.00087404326768592,
-0.0013343970058485866, -0.0001950975856743753, -0.00012777128722518682, 0.0003881152952089906, -0.00031405629124492407, -0.00037136347964406013, -0.0019521546782925725, 0.001345470896922052, -0.0020607116166502237,
0.002132078167051077, -0.0007246605819091201, -0.0012057367712259293, 0.0004841535701416433, 0.0012451520888134837, 0.0009222452063113451, 0.00042793742613866925, -6.94207483320497e-05, -0.0007683316362090409,
-0.0001312245731242001, -8.655225246911868e-05, -8.890397111827042e-06, 0.0007705824682489038, -0.0006850814097560942, 0.0010243412107229233, 8.739300392335281e-05, -0.0013965679099783301, 0.0006112000555731356,
0.0009240308427251875, -0.0014342877548187971, -0.00021028138871770352, 0.0008153088856488466, -0.0007925853715278208, -0.00010381962056271732, -0.0007340257870964706, -0.001259033801034093, -0.0001811065012589097,
-0.0017119715921580791, -0.00044205767335370183, -4.566427378449589e-05, -0.00017785138334147632, 0.0002857264771591872, -0.0008472527842968702, 0.0012532157124951482, 0.0001405022048857063, 0.001547528663650155,

-0.0010427614906802773, 0.0007475833990611136, 0.0029893710743635893, 0.0010094214230775833, 0.001213993295095861, -0.0031357628758996725, -0.001727048889733851, 0.00022000611352268606, -0.0017372133443132043,
0.0006355569930747151, 0.0015863387379795313, 0.0034089884720742702, 0.0012360273394733667, 0.0023517278023064137, -0.001312332577072084, 0.0004263900627847761, -0.00298516103066504, -0.0020501846447587013,
-0.002186942845582962, -0.0028350544162094593, 0.0015414305962622166, 0.0020203643944114447, 0.0009336156072095037, -0.00011486181028885767, -0.003162732347846031, -0.0004121828533243388, -0.0021209099795669317,
-0.0005692229024134576, -0.00028354019741527736, 0.0010228734463453293, 0.0023090748582035303, 0.0011307382956147194, 0.0007596202194690704, -0.0016434324206784368, -0.0027102408930659294, -0.0015361955156549811,
-0.0022551275324076414, -0.0007140388479456306, -1.4683435438200831e-05, 0.0009901500307023525, 0.0009438516572117805, 0.0011072073830291629, -0.00010429092799313366, -0.0009952072286978364, -0.0010037280153483152,
-0.0029726577922701836, -0.0008929024334065616, -3.998647662228905e-05, 0.0007388826343230903, 0.0006245546974241734, -1.1670941603370011e-05, -0.0009585865773260593, 0.00022638247173745185, -0.00017370296700391918,
-3.671366721391678e-05, 0.0005166505579836667, 0.0007188158924691379, -0.001319343806244433, 2.4574779672548175e-05, -0.0004365151980891824, -0.0004397975280880928, -0.0007993369945324957, -0.0005081442068330944,
-0.0033734093885868788, -0.0010377391008660197, 0.000367781292879954, 0.002041769912466407, -0.0007499930798076093, -0.000623529776930809, 1.958497887244448e-05, 0.0005294838338159025, 0.0019362326711416245,
-0.0032374155707657337, -0.0022865859791636467, 0.00020928609592374414, 0.00032419478520751, -0.0005169984651729465, 0.0011239422019571066, 0.00023473604233004153, 0.0006507424404844642, 0.0005158171989023685,

0.0008587247575633228, 0.0007473339210264385, -0.0002584163739811629, -0.001316582434810698, 0.0004300776345189661, -9.040193253895268e-05, 0.0011788200354203582, -0.00025176192866638303, 0.00037236002390272915,
8.983260340755805e-05, -0.0005132769583724439, -1.6655694707878865e-05, 0.0004661396669689566, -0.0002495500666555017, -0.0005246942746452987, 0.0006304687703959644, -0.0009184961672872305, -0.0014047521399334073,
0.00019007973605766892, -0.0011629501823335886, -0.0015439189737662673, 0.00013563164975494146, 0.0006293953629210591, -0.0005517981480807066, 0.00043078605085611343, -0.0013739519054070115, -5.2912975661456585e-05,
-0.0012539810268208385, -0.0010593991028144956, -0.0009878211421892047, -0.0022236520890146494, 0.000829606840852648, -0.0016500352649018168, -1.0490934073459357e-05, 0.00028435621061362326, -0.0009808980394154787,
-0.000259050284512341, 0.0019392730901017785, 0.0008278421009890735, -0.0005646470235660672, -0.0008060720283538103, -0.00030645757215097547, -0.0009889212669804692, 0.00044436316238716245, -0.00042043571011163294,
-0.002695289673283696, 0.0010895334417000413, -0.00011561972496565431, 0.0005394463078118861, -0.0005808002315461636, -0.0007317991694435477, -0.0006932075484655797, -0.002503905212506652, 0.0004994494374841452,
0.0024093480315059423, 0.00011227242794120684, 0.0005490590119734406, 0.0010854867286980152, 0.00010402601037640125, 0.0008677217410877347, 0.001215033931657672, -0.0012397676473483443, 0.000507814809679985,
0.0012428320478647947, 0.0002220383903477341, 0.0004693296505138278, 0.0008965278975665569, 0.0009469942306168377, -0.0002011579053942114, 0.0002707711246330291, -0.0018706030678004026, 0.000484568125102669,
-0.001637203386053443, 0.00026659315335564315, -2.5258643290726468e-05, -0.0007849052199162543, -5.2908373618265614e-05, 0.00039768844726495445, -0.0002964452432934195, -0.0009756496292538941, -0.0014156108954921365,

0.0003856481926050037, -0.001212604925967753, -0.000904262880794704, 3.360929622431286e-05, -0.0018874986562877893, -0.0001533487520646304, -0.0018861304270103574, 0.0017776829190552235, 0.00016214024799410254,
0.00023579505796078593, 8.009988960111514e-05, 0.0013927384279668331, 4.347561116446741e-05, 0.001186807407066226, 0.0008408004650846124, -0.0020491660106927156, -0.0001422875648131594, -0.0006434610695578158,
0.0016842157347127795, -0.001294660265557468, 0.00047094645560719073, -0.00044661093852482736, -0.0009288711589761078, 0.0001795340795069933, -0.00142458186019212, -0.000755635614041239, 0.0016061861533671618,
-0.0005091765779070556, -0.00045300094643607736, -0.0005541217979043722, 0.0013322398299351335, 0.0020650443620979786, -0.0011003280524164438, -0.0005448736483231187, 0.0023095596116036177, -0.0003353827924001962,
-0.0018162043998017907, 0.00035935279447585344, -0.0009035704424604774, -0.002102227881550789, 0.0001305204350501299, 0.0005287351086735725, -0.0010279424022883177, -0.0017553223296999931, -0.002096771728247404,
0.0013198802480474114, 0.0006331317126750946, 0.0009742425172589719, -0.0010674268705770373, 0.0007410091930069029, -0.0011616927804425359, -0.0010435463627800345, -0.00031434709671884775, -8.537543908460066e-05,
-0.0010591731406748295, 0.0004485169192776084, 3.478356302366592e-05, 4.190777690382674e-05, 0.0017519649118185043, -0.0014920301036909223, 0.0006929075461812317, 0.00014945838483981788, -0.0007377660367637873,
-0.0009233593591488898, -0.0018209881382063031, -0.0011583733139559627, -0.0020634103566408157, -0.0002967732725664973, 0.0002826419658958912, 0.0003014251124113798, -0.0006948530790396035, -0.00020492024486884475,
-0.0003761191910598427, 0.0009522800683043897, -0.00020505432621575892, -0.00018598373571876436, 0.0002603780885692686, 0.0003521517792250961, -0.0034440699964761734, -0.0018377675442025065, 2.3874636099208146e-06,

0.0006360554252751172, -0.0009710857411846519, -7.977831046446227e-06, -0.001699639018625021, -0.0024402178823947906, -0.0001274187961826101, 0.0005870650056749582, -0.0008972165524028242, -0.000437656621215865,
-0.0008047414594329894, 7.705861207796261e-05, 9.641000360716134e-05, -0.0012318945955485106, 0.002631072886288166, -0.00041180712287314236, -0.0007209548493847251, -0.0011394981993362308, 0.0005692940321750939,
-0.00045051955385133624, -0.00025276365340687335, 0.001458307495340705, -0.0005518250400200486, -0.0011509619653224945, -0.0008050539181567729, -0.001469335868023336, -0.0019164368277415633, 0.0005840056692250073,
0.0008659129962325096, 4.304258618503809e-05, 0.0016309093916788697, -0.0017815963365137577, -0.0015453101368620992, 0.0006758600939065218, 0.0017389063723385334, -8.210347004933283e-05, -6.285516428761184e-05,
0.0007429956458508968, 0.00015477144916076213, -0.0006847582990303636, -0.0008278150926344097, 0.0002104933955706656, -0.0007440023473463953, -0.0016221420373767614, -5.559242708841339e-05, 0.00027263155789114535,
0.00014730646216776222, 0.0009805591544136405, -0.0005271364934742451, 0.0003343402058817446, -0.0012365932343527675, 0.002469699364155531, 0.0002483265707269311, -0.000703160825651139, -0.0007623662822879851,
0.0002486954035703093, -0.001247091917321086, -0.00042475422378629446, -0.0008385458495467901, -0.00032578266109339893, 0.000684012658894062, -0.00036420574178919196, 0.00016933643200900406, -0.0014108269242569804,
0.0008613021345809102, -2.7615646104095504e-05, 0.0009708671132102609, -0.0006175179732963443, 0.0007720505236648023, -0.00018883791926782578, 0.0010553146712481976, 0.00023790985869709402, 0.0004205219156574458,
0.0010172834154218435, -0.0005163013120181859, 0.00017585823661647737, -0.0008456491632387042, -2.4885055609047413e-05, -0.0032960865646600723, -0.0011469046585261822, -9.369684266857803e-05, -0.0014493244234472513,

-0.09623150527477264, 0.10484742373228073, -0.06315137445926666, 0.03981892392039299, -0.0014363162918016315, -0.15151703357696533, 0.03972433879971504, 0.053064364939928055, -0.07438027858734131,
0.013472521677613258, -0.030749836936593056, 0.02667129598557949, -0.10884711146354675, 0.12398511171340942, 0.24107839167118073, -0.0677260160446167, -0.06766591221094131, 0.15236033499240875,
0.13828368484973907, -0.09877052903175354, -0.040509145706892014, 0.21814708411693573, -0.008984211832284927, -0.22859829664230347, -0.020129911601543427, 0.14800673723220825, -0.2521049976348877,
-0.005165863316506147, -0.07101031392812729, -0.06273972988128662, 0.17722730338573456, -0.06705157458782196, -0.31079158186912537, 0.10386946052312851, 0.42850062251091003, -0.00998199637979269,
-0.0881059393286705, 0.22323323786258698, 0.17002424597740173, -0.24257099628448486, -0.2324901670217514, 0.1448778212070465, -0.011191468685865402, -0.3301706314086914, -0.09063249081373215,
-0.14185571670532227, 0.041417982429265976, -0.04946373030543327, -0.36716076731681824, 0.0672827661037445, 0.6863768100738525, 0.40520086884498596, -0.2974955141544342, 0.107406385242939,
0.3318110406398773, -0.0507020577788353, -0.18288807570934296, 0.0851796492934227, 0.2671677768230438, 0.11542657762765884, -0.06862573325634003, -0.24572831392288208, 0.1606084555387497,
-0.2889135479927063, -0.054239045828580856, 0.17383809387683868, 0.36030352115631104, -0.18709352612495422, -0.32287633419036865, -0.17500734329223633, -0.19725677371025085, 0.019927935674786568,
0.1390623301267624, 0.01530418824404478, -0.0403677262365818, -0.17014822363853455, -0.12203854322433472, 0.22162851691246033, 0.0035465240944176912, -0.05675896257162094, 0.139779731631279,

-0.000999591313302517, -0.0018199908081442118, -3.204034146619961e-05, 0.0010188516462221742, 0.0022817589342594147, 0.0005225748755037785, -0.0007992828032001853, -1.511336176918121e-05, 0.0004997086944058537,
-0.0011138567933812737, 5.3657749958802015e-05, -0.0005994696402922273, -0.0003766038571484387, 9.267463610740378e-05, -0.0001617281377548352, -0.0007714454550296068, -0.0011691150721162558, -0.0006346438312903047,
-0.0009605013183318079, 0.0005671675899066031, -0.0004041976644657552, 0.0007465955568477511, 0.0007372794789262116, -0.0002457468945067376, -0.002008889801800251, 0.0007998430519364774, 0.00017297892190981656,
0.00011949692270718515, 0.002030887408182025, -0.0012711266754195094, 0.0017400160431861877, -0.0009765626164153218, -0.001242497586645186, -0.0011190898949280381, 0.0006954757263883948, -0.0008800528012216091,
0.0007153828046284616, 7.409717363771051e-05, -0.0007912390865385532, 0.0007713124505244195, 0.0010325011098757386, 0.001399247907102108, -0.0017962774727493525, -0.0007862639031372964, 7.117007044143975e-05,
-0.0012064576148986816, 0.0013150176964700222, -5.5957279982976615e-05, -0.0005160821601748466, 5.7979163102572784e-05, -0.0006840011337772012, 0.0006929343799129128, -0.0006910475203767419, -0.0003176646423526108,
0.000555074424482882, -0.000510676356498152, -0.0009097403381019831, -0.000386804313166067, -0.0005443727131932974, -0.0003146363887935877, 0.00019219621026422828, -0.0007658776012249291, 0.0007142896647565067,
0.0006583535578101873, -0.00038801910704933107, 0.00032448387355543673, -0.00019720595446415246, 0.0005076671950519085, -0.00041441080975346267, 0.0003269248700235039, 0.00016967565170489252, 0.00044187737512402236,
-0.0007283112499862909, -0.0014942106790840626, 0.00012876458640675992, 0.00020544099970720708, -0.0016892614075914025, 0.0007097275811247528, 0.0010939198546111584, -0.0006068685324862599, -0.0010073768207803369,

-0.0012665025424212217, 0.01675419881939888, 0.26304855942726135, 0.13983741402626038, -0.11388019472360611, -0.10658132284879684, -0.06519941240549088, 0.07726431638002396, 0.01794479787349701,
0.0069109126925468445, -0.07727132737636566, -0.24356147646903992, -0.3049158751964569, 0.0015241295332089067, 0.1969120055437088, -0.11370117962360382, -0.2005273997783661, 0.05501388758420944,
0.02110806480050087, 0.11378795653581619, 0.12822550535202026, -0.1203264519572258, -0.08205731958150864, 0.1863396316766739, 0.08031539618968964, 0.039802875369787216, 0.10264290124177933,
-0.0690830871462822, -0.06739896535873413, 0.015076566487550735, 0.06080116704106331, -0.025706810876727104, -0.09290605783462524, -0.17364826798439026, -0.04425707459449768, -0.13037621974945068,
0.11020895838737488, 0.020617492496967316, -0.17159339785575867, 0.13234134018421173, 0.3949457108974457, 0.226732075214386, -0.13186287879943848, 0.07432274520397186, 0.22734342515468597,
-0.043330006301403046, 0.053376249969005585, -0.10662541538476944, -0.08419434726238251, -0.013403806835412979, -0.08028654754161835, -0.2835564613342285, -0.0710369274020195, -0.023827288299798965,
-0.04627927392721176, 0.04351762682199478, 0.06323342025279999, 0.014668399468064308, -0.07495369017124176, -0.12317760288715363, -0.006352022755891085, 0.2899240553379059, -0.10756435245275497,
0.04353008046746254, -0.0598263293504715, -0.10739217698574066, 0.11630450934171677, 0.020550796762108803, -0.16120344400405884, 0.017646459862589836, 0.29593849182128906, -0.07455079257488251,
-0.06086743250489235, 0.062209602445364, -0.07078734785318375, 0.14284056425094604, 0.016841856762766838, 0.00821782648563385, 0.15606606006622314, 0.014022826217114925, -0.1754223257303238,

-0.001540240366011858, 0.0002556523832026869, -0.0006723375408910215, 0.0004470753774512559, -9.546260844217613e-05, -3.559109609341249e-05, 0.001132538658566773, -0.00026728174998424947, -0.0018261182121932507,
0.0014168687630444765, 3.492621181067079e-05, 0.00011063399870181456, 0.00025745798484422266, -0.0002557227562647313, -0.002036771969869733, -8.944633009377867e-05, -0.0012297306675463915, 0.0007957581547088921,
-0.0012314687483012676, 0.0010770674562081695, -0.0005917696980759501, -0.00212976080365479, -0.00031171709997579455, 0.0010827910155057907, 0.0002682326012291014, -0.0011721514165401459, 0.00025861989706754684,
-0.0029963550623506308, 0.002098196418955922, 0.0007173329940997064, 0.0018209400586783886, -0.0017951689660549164, 0.00018901099974755198, 0.0005738816689699888, -0.001167795155197382, -0.0008625764166936278,
-0.002416105940937996, 0.00042315051541663706, -0.0017523716669529676, 0.0010439404286444187, -5.785029134131037e-05, -0.0013305781176313758, 0.0002850339515134692, -0.00041882999357767403, 8.28917691251263e-05,
0.0006170418346300721, 0.0006563257775269449, 0.00011567169713089243, -0.00011426987475715578, 0.0010820204624906182, 0.0016165240667760372, 0.00018961820751428604, 0.0019755263347178698, -0.0015524612972512841,
-0.001710549695417285, 0.0011875538621097803, -0.0002842131070792675, -0.0014970755437389016, -0.0005015296628698707, -0.0007049585692584515, -0.0006768153398297727, 8.989968773676082e-05, -0.00017749393009580672,
-0.0013356966665014625, -0.001025702222250402, 0.00025018033920787275, 0.001610269770026207, 0.0007577651413157582, -0.0009380839765071869, -0.00034315226366743445, 0.00015070832159835845, -0.0014308240497484803,
-0.0005565301398746669, -0.0007534055621363223, 2.647791916388087e-05, -6.859315362817142e-06, 0.00040427775820717216, -0.0009358926326967776, -0.0004737813724204898, -0.000845718604978174, 5.376041735871695e-05,

-0.15451224148273468, 0.19095458090305328, 0.20473194122314453, 0.026090022176504135, 0.09018351137638092, -0.03866922855377197, -0.2947196960449219, 0.11171706020832062, 0.12668751180171967,
-0.08547264337539673, -0.11372412741184235, -0.4545639157295227, -0.1695876270532608, 0.0816875770688057, 0.38936617970466614, 0.3428002893924713, -0.3308902382850647, -0.17786070704460144,
0.06210101768374443, 0.1786593496799469, -0.10510437935590744, -0.06503064185380936, -0.246371328830719, -0.22606316208839417, 0.19956804811954498, 0.2003280371427536, 0.09104062616825104,
0.20660510659217834, 0.029972387477755547, 0.21238666772842407, 0.3268944025039673, -0.13860951364040375, -0.2788946330547333, -0.3092181384563446, -0.0003468827635515481, -0.14993233978748322,
-0.06072603166103363, -0.21059197187423706, -0.04442582651972771, 0.09012393653392792, -0.22182731330394745, -0.07031314820051193, -0.05164662376046181, 0.11668866127729416, 0.044493451714515686,
-0.022964412346482277, 0.13738542795181274, -0.1268226057291031, 0.20749592781066895, 0.5986675024032593, 0.44717782735824585, 0.12741205096244812, -0.06192497909069061, -0.0699167549610138,
-0.040256306529045105, 0.09093724191188812, -0.16429461538791656, -0.1690693348646164, 0.07666178792715073, -0.15648046135902405, -0.13331539928913116, -0.016347618773579597, 0.047096144407987595,
0.03429550677537918, -0.08356120437383652, 0.1696685552597046, -0.06695079803466797, -0.17493395507335663, -0.24848990142345428, 0.016458017751574516, 0.13108165562152863, 0.028971169143915176,
-0.04448648914694786, -0.01828574761748314, 0.11338123679161072, -0.11078592389822006, 0.09166978299617767, 0.17844493687152863, -0.03845813870429993, 0.02441604807972908, -0.0284543726593256,

0.0648932009935379, 0.03015816956758499, 0.06663703173398972, 0.015556380152702332, -0.008408942259848118, -0.01015086192637682, -0.04535888880491257, -0.07108950614929199, 0.008901793509721756,
0.0383647084236145, 0.008252307772636414, 0.057061534374952316, 0.02177751064300537, 0.021049227565526962, 0.03981384262442589, 0.019147386774420738, -0.016650844365358353, -0.00012338250235188752,
-0.05576663836836815, -0.008446862921118736, 0.008782737888395786, -0.012964257970452309, 0.0306203905493021, 0.019870450720191002, -0.014466973021626472, -0.054479945451021194, 0.0083492835983634,
-0.04714462161064148, 0.036334384232759476, 0.020698098465800285, -0.006391490343958139, 0.09398287534713745, 0.0364663265645504, -0.016738135367631912, -0.06626389920711517, -0.021750694140791893,
-0.02035997062921524, 0.0033441465348005295, 0.014848344959318638, 0.024313975125551224, 0.1340191513299942, 0.04788660630583763, 0.005272587761282921, -0.0055662221275269985, -0.011406347155570984,
0.010810546576976776, -0.008090125396847725, -0.02175883576273918, -0.052334014326334, 0.01757221855223179, -0.03152087330818176, 0.0052301958203315735, 0.0456184446811676, -0.025735914707183838,
0.09220990538597107, 0.05665971711277962, 0.03320348635315895, 0.009712934494018555, 0.034622952342033386, -0.020982015877962112, -0.002861678134649992, 0.002392107155174017, -0.050432782620191574,
0.10869601368904114, 0.029779020696878433, 0.04789482802152634, 0.07702136784791946, 0.0493718720972538, 0.004437380935996771, 0.02696411684155464, -0.02077019400894642, -0.03136833757162094,
-0.002712647430598736, -0.05146724358201027, 0.0021101508755236864, 0.048718471080064774, 0.050533365458250046, 0.056156277656555176, 0.1252497434616089, 0.08561249077320099, 0.010004137642681599,

0.04881306365132332, -0.040069226175546646, -0.02489537000656128, 0.10931528359651566, 0.026437178254127502, -0.18237268924713135, 0.06956560909748077, 0.04613293707370758, 0.0629517212510109,
-0.0011143248993903399, -0.124015212059021, -0.07959514111280441, -0.08567380160093307, 0.2911008298397064, 0.07841300964355469, -0.15799833834171295, -0.1863882839679718, 0.008791344240307808,
-0.005785984452813864, 0.31174561381340027, 0.17794767022132874, -0.19377553462982178, 0.1001155897974968, 0.09263832122087479, 0.22075343132019043, -0.13299359381198883, 0.021534152328968048,
-0.25834542512893677, 0.07808665931224823, -0.2475024163722992, -0.46278488636016846, 0.09057627618312836, 0.05654537305235863, 0.282428115606308, -0.21025048196315765, 0.09985244274139404,
0.028137871995568275, 0.1312556117773056, 0.29870033264160156, -0.17317332327365875, 0.06542570143938065, -0.02981092594563961, 0.11451898515224457, 0.12770536541938782, 0.06928875297307968,
0.08405459672212601, -0.28732311725616455, 0.13365082442760468, -0.04514949768781662, -0.16095976531505585, -0.4304209351539612, -0.08290921151638031, 0.30299392342567444, -0.23473845422267914,
0.12784703075885773, 0.040431540459394455, 0.05410665646195412, 0.23238302767276764, 0.18373283743858337, -0.25010836124420166, -0.05561486631631851, 0.11793294548988342, -0.1825789213180542,
-0.18931150436401367, -0.011875620111823082, -0.15526539087295532, -0.1144055649638176, 0.1240239068865776, 0.15735426545143127, -0.007772465702146292, 0.06703273952007294, 0.18275801837444305,
0.12089535593986511, -0.07851406186819077, 0.11984454840421677, 0.03476141020655632, -0.0482468418776989, -0.10134965181350708, -0.12304190546274185, 0.05240076035261154, -0.05573711544275284,

-0.16772988438606262, 0.11109595000743866, -0.010658840648829937, -0.19189690053462982, -0.05638456717133522, 0.05707361176609993, -0.11251163482666016, -0.05410575494170189, 0.03964550793170929,
0.2867584228515625, -0.06264916062355042, 0.189626082777977, 0.11861971765756607, 0.05483229458332062, 0.1319660246372223, 0.06443878263235092, 0.129139244556427, -0.033468782901763916,
-0.09380505979061127, -0.39508914947509766, -0.04549768567085266, -0.052516210824251175, 0.07953311502933502, -0.098055899143219, -0.14163537323474884, -0.12616392970085144, 0.03034469299018383,
0.04507668688893318, 0.3311437964439392, 0.27322667837142944, -0.20558588206768036, 0.007871289737522602, 0.02692217379808426, 0.212126687169075, 0.006659271195530891, 0.07345736026763916,
-0.22250953316688538, 0.01236119493842125, -0.2367575317621231, -0.3587864935398102, -0.051800575107336044, -0.28915828466415405, -0.11290644854307175, 0.1451025754213333, -0.22573742270469666,
0.225347101688385, 0.17198264598846436, 0.10329369455575943, 0.48186585307121277, 0.653626561164856, 0.13932093977928162, -0.12812262773513794, 0.29185861349105835, -0.011542456224560738,
-0.056727126240730286, -0.24614256620407104, -0.25707218050956726, 0.1379314363002777, -0.13671821355819702, -0.029103154316544533, -0.009799652732908726, -0.20076780021190643, -0.0156412310898304,
-0.11022096127271652, 0.156456857919693, -0.12290013581514359, -0.07961051166057587, -0.36028215289115906, 0.04407414421439171, 0.2383071482181549, -0.04626668989658356, 0.1948043704032898,
0.07021071761846542, 0.011512591503560543, -0.014199885539710522, 0.10593896359205246, -0.11554862558841705, 0.07183084636926651, -0.1556750386953354, -0.015137303620576859, -0.07752346247434616,

-0.0010569588048383594, -0.00011932790948776528, -0.0011503883870318532, 0.0010949814459308982, -0.0004188964085187763, 0.0006611710414290428, 0.0006870609358884394, -0.0004792710824403912, 0.0007725628092885017,
-0.0001330224476987496, -0.00022430284298025072, -0.0011843695538118482, -0.0016817374853417277, 0.0008879866218194366, -0.0007197565864771605, -0.002647122135385871, -0.0003594874287955463, -0.0006840709247626364,
-0.000479323003673926, -0.00033403729321435094, -0.00018967413052450866, -0.0019072171999141574, 0.002235217485576868, -0.0017468531150370836, 6.825732270954177e-05, 0.00010220736294286326, -0.0016980438958853483,
-0.0011177853448316455, -0.00035529123852029443, -0.00017950011533685029, 0.0019975679460912943, 0.000719986273907125, 0.0019489218248054385, -0.0014096435625106096, -0.00018343084957450628, -0.0011374281020835042,
-0.0001280792785109952, -0.0007536893826909363, -0.00018412877398077399, -0.0004588938900269568, 0.00011560072016436607, 0.0005447586881928146, 0.001000233693048358, -0.0003539245226420462, 0.0011272527044638991,
-0.0010926933027803898, -0.00033766948035918176, 0.00040509772952646017, 0.0014269507955759764, -0.0005572892259806395, -0.0008279934991151094, 0.0011004118714481592, 0.0006056654383428395, 0.0003419063286855817,
0.0007174558122642338, 0.001560462056659162, -0.00029264582553878427, -0.00012326946307439357, -0.000526961637660861, -1.4816179827903397e-05, -0.0006620470085181296, -0.0007735520484857261, -0.000649213616270572,
-0.0008610342629253864, 0.0018013716908171773, 0.0006441452424041927, -0.0004435580049175769, -0.0008992920047603548, -0.00024224862863775343, 0.0010501362849026918, -0.0011598471319302917, -0.0006570105324499309,
0.0011456088395789266, 0.00048621694440953434, -0.0018411156488582492, -0.0013611650792881846, -0.0002690771361812949, -0.0005640559829771519, -0.0013652503257617354, -1.7089094399125315e-05, -3.355400258442387e-05,

-0.2104903906583786, 0.12132132053375244, 0.029365696012973785, -0.11713844537734985, -0.02783479355275631, -0.054204922169446945, 0.038977138698101044, 0.1672254204750061, 0.1155354231595993,
0.1673756092786789, 0.05393429100513458, -0.014358943328261375, 0.05143103376030922, 0.08754843473434448, -0.02964305318892002, -0.008091827854514122, -0.04258943721652031, -0.2442554533481598,
-0.19025211036205292, 0.13267463445663452, 0.07090611010789871, -0.128496915102005, -0.11497974395751953, -0.1456131637096405, -0.06282735615968704, 0.037712614983320236, -0.03053300455212593,
0.0022425830829888582, 0.08074657618999481, 0.05704525113105774, -0.07564388960599899, 0.015597454272210598, 0.15354526042938232, 0.09632490575313568, 0.14457924664020538, 0.09841959178447723,
0.13968202471733093, -0.11876171082258224, -0.18226979672908783, 0.022941624745726585, 0.09503066539764404, -0.03277856856584549, -0.21077322959899902, -0.002112059388309717, -0.038146600127220154,
0.010349348187446594, -0.0073541575111448765, -0.07239490747451782, 0.10508517175912857, 0.18381674587726593, -0.04836629331111908, -0.18059268593788147, 0.12591232359409332, 0.10520373284816742,
0.034999772906303406, 0.18793611228466034, -0.04791635274887085, -0.33946871757507324, -0.2302446961402893, -0.028468219563364983, 0.05462699756026268, 0.0032924155239015818, -0.14790956676006317,
-0.04179050028324127, 0.0870656743645668, 0.020350122824311256, -0.0474969707429409, -0.073038749396801, -0.03616800159215927, 0.09759104251861572, 0.07510336488485336, 0.13184534013271332,
-0.06964278966188431, 0.08661947399377823, 0.08370254933834076, 0.16909433901309967, 0.05051512271165848, -0.12434079498052597, -0.02095050737261772, 0.049961697310209274, -0.0955386683344841,

0.09808865934610367, -0.04217420145869255, 0.11261221021413803, -0.0979318916797638, -0.009376952424645424, 0.10382681339979172, -0.3147989809513092, 0.0416661836206913, -0.007494060788303614,
0.005175380501896143, -0.44516095519065857, 0.07864353060722351, 0.35873913764953613, -0.003262945916503668, 0.14902269840240479, 0.22528132796287537, 0.06613346934318542, -0.005277388729155064,
0.08456676453351974, -0.09523081034421921, 0.02938992716372013, 0.040525492280721664, -0.23032791912555695, -0.11449328809976578, 0.1439978927373886, 0.2597081661224365, -0.06926484405994415,
0.19865450263023376, -0.20608408749103546, -0.16858400404453278, 0.08890511840581894, 0.04442805424332619, -0.3010995090007782, -0.4741572141647339, 0.1444513350725174, -0.212602898478508,
0.21730554103851318, -0.3936820328235626, 0.1668621450662613, 0.4914481043815613, 0.2517930269241333, 0.020509615540504456, -0.06409702450037003, 0.25522953271865845, 0.10250972956418991,
-0.028641317039728165, -0.5098336338996887, 0.20008642971515656, -0.014031358063220978, -0.24628593027591705, -0.0365581214427948, 0.04390503093600273, -0.24576334655284882, -0.0461585558950901,
0.018607139587402344, 0.0004107145650777966, 0.2500346601009369, -0.23970988392829895, -0.04864475503563881, 0.06339922547340393, 0.1972377449274063, 0.14954879879951477, 0.05787830427289009,
-0.09056226164102554, 0.19932805001735687, 0.16785289347171783, -0.14021965861320496, 0.18159927427768707, -0.16833806037902832, -0.18337807059288025, 0.004240002948790789, -0.1689908653497696,
0.07772572338581085, -0.3002279996871948, 0.09108152985572815, -0.05846348777413368, 0.10295788198709488, -0.023347485810518265, 0.08548326790332794, -0.06645601242780685, 0.1568939983844757,

-0.013950671069324017, 0.14006301760673523, 0.10362653434276581, 0.05748048797249794, -0.035415343940258026, -0.14677655696868896, -0.0029044041875749826, -0.038839202374219894, 0.05247412621974945,
-0.06640616804361343, -0.020092647522687912, -0.4638631343841553, -0.3031516373157501, 0.14792288839817047, 0.14735998213291168, 0.10991434752941132, 0.05494896322488785, -0.11660435795783997,
0.10017690062522888, 0.132282093167305, 0.1628856360912323, 0.27559641003608704, 0.2845847010612488, 0.25922486186027527, 0.12390350550413132, -0.22476986050605774, 0.11786532402038574,
-0.13220100104808807, 0.019541751593351364, 0.18495215475559235, -0.29292935132980347, -0.5955057740211487, -0.6024948954582214, -0.18879005312919617, -0.10200955718755722, 0.026657283306121826,
0.016031596809625626, 0.2025860697031021, 0.2550431489944458, 0.10817043483257294, 0.2741820216178894, -0.0038298428989946842, 0.10149059444665909, 0.14858447015285492, -0.09560362994670868,
-0.14666630327701569, -0.31975531578063965, -0.4732024669647217, -0.17723801732063293, 0.21804086863994598, 0.19206535816192627, 0.2133888453245163, 0.0029941254761070013, 0.12964513897895813,
0.1364160180091858, 0.023268448188900948, -0.10686001926660538, 0.21463102102279663, 0.03751311078667641, -0.14985856413841248, -0.04363644868135452, -0.14079639315605164, 0.08981011062860489,
-0.19653163850307465, 0.2189231812953949, 0.3163636326789856, 0.4429551959037781, -0.06580221652984619, -0.20929275453090668, -0.06716730445623398, -0.011130502447485924, -0.06049836799502373,
0.17359021306037903, -0.11022380739450455, -0.26505905389785767, -0.17634817957878113, -0.08740302920341492, 0.22814320027828217, 0.11242003738880157, 0.01158397737890482, -0.03695908561348915,

-0.08051258325576782, 0.03413045033812523, 0.020185938104987144, 0.0325036458671093, -0.05675344914197922, -0.227550208568573, 0.014012614265084267, 0.15816405415534973, -0.09465190023183823,
0.10396259278059006, 0.053352758288383484, -0.06670495867729187, 0.021227216348052025, 0.3165081739425659, -0.01980353146791458, -0.09758850187063217, 0.07518550008535385, -0.10593143850564957,
-0.07598112523555756, 0.17637503147125244, 0.024622337892651558, -0.06120745465159416, 0.15002694725990295, -0.16977781057357788, -0.023900222033262253, 0.10342928022146225, 0.056688107550144196,
-0.16326774656772614, 0.08476721495389938, -0.17347368597984314, -0.22374482452869415, -0.02916521020233631, -0.10966647416353226, 0.1251721978187561, -0.11273764073848724, 0.10270598530769348,
-0.08524306863546371, 0.4950140714645386, -0.03410574048757553, -0.40578487515449524, -0.09272392094135284, -0.18247631192207336, 0.17320168018341064, 0.13147477805614471, -0.0038696087431162596,
-0.03570012375712395, 0.7016220092773438, 0.20242898166179657, -0.38785088062286377, 0.11948063969612122, -0.16032521426677704, -0.1441739946603775, 0.11564136296510696, -0.26699280738830566,
-0.2192683219909668, 0.35552096366882324, 0.05954338237643242, -0.199520081281662, 0.10670266300439835, -0.023357881233096123, 0.00961100123822689, 0.04293111339211464, -0.0579170323908329,
-0.32589980959892273, 0.06420989334583282, -0.11756125092506409, 0.05695319175720215, 0.0677061676979065, -0.04878150299191475, 0.1706743985414505, -0.010371199809014797, 0.1252160221338272,
0.045665398240089417, 0.3343423902988434, -0.11480693519115448, -0.19743719696998596, 0.1504960060119629, -0.1380237489938736, -0.07210364192724228, 0.030029352754354477, -0.03706291690468788,

0.03939378634095192, -0.23628199100494385, 0.03345371037721634, -0.013991202227771282, -0.05054478347301483, -0.015119356103241444, -0.026974914595484734, 0.014346917159855366, 0.08018133044242859,
0.22023628652095795, 0.06720942258834839, 0.015866054221987724, 0.11437360942363739, 0.032059792429208755, -0.017130417749285698, -0.010584225878119469, -0.281844824552536, -0.11845685541629791,
-0.18145181238651276, 0.04549989476799965, 0.06611192971467972, 0.25537383556365967, 0.1269979029893875, 0.07849577069282532, 0.19416430592536926, -0.011851524002850056, 0.1791917234659195,
-0.16963504254817963, -0.11547959595918655, -0.1932094693183899, -0.2265874445438385, -0.14010992646217346, -0.043412987142801285, 0.0482562892138958, -0.02022138610482216, -0.025581691414117813,
0.09596209228038788, 0.07362937927246094, 0.02321452647447586, -0.11330754309892654, 0.07633958011865616, 0.09335443377494812, 0.057872358709573746, 0.11146388202905655, 0.10320734232664108,
0.09972687810659409, 0.030443429946899414, 0.10441126674413681, -0.03630651533603668, -0.024392854422330856, -0.12362377345561981, -0.18422561883926392, -0.15097342431545258, -0.20117345452308655,
0.12026863545179367, -0.025150498375296593, 0.1429918110370636, 0.05642174184322357, 0.02950388751924038, 0.14781424403190613, 0.07158076763153076, 0.056343890726566315, -0.0183302853256464,
-0.1693364679813385, -0.23443996906280518, -0.017875906080007553, -0.006481344345957041, -0.03439946472644806, 0.16573406755924225, 0.07892756164073944, 0.09992554783821106, -0.011556487530469894,
0.16742345690727234, -0.06860154867172241, -0.030658090487122536, 0.07158920913934708, -0.0056269061751663685, -0.09347712248563766, -0.06864652037620544, 0.07023963332176208, -0.0793459415435791,

-0.0006428726483136415, 0.000488331716042012, 0.00035403258516453207, 0.0008115165401250124, 0.000657112686894834, 0.0004166678700130433, -0.0008603823371231556, 0.00019007190712727606, -0.0007043906953185797,
0.0008286830852739513, -0.0013949848944321275, -0.0006009201752021909, -0.0008206788334064186, -0.0005576505209319293, -0.00040472447290085256, -0.0002731344720814377, -0.00028334444505162537, 0.0013878886820748448,
0.0002315448655281216, 0.0010704207234084606, -0.000650928181130439, 0.00012547745427582413, -0.0003032054810319096, 0.0007429635152220726, 0.0005865327548235655, 0.0005176231497898698, -0.0007537910132668912,
-0.001887444406747818, -0.0008026676950976253, 0.0008491867920383811, 0.0018599305767565966, -0.0011441382812336087, 0.0005058692768216133, 0.0018451297655701637, -0.0024096802808344364, 0.0003023534081876278,
1.643709583731834e-05, -0.001602975302375853, 0.0006561074987985194, 0.0002454979403410107, -0.0002888222225010395, -0.00041606990271247923, -0.0009814610239118338, -0.0006613695295527577, 0.0008126229513436556,
-0.00016825305647216737, -0.000440552132204175, -0.0008257260196842253, 0.00014283164637163281, 0.0013927987311035395, -0.0006570022087544203, -0.0012004850432276726, 0.0001159723469754681, -4.097333294339478e-05,
-0.0006579493056051433, -0.0017888189759105444, -0.00034246634459123015, 0.00011627476487774402, -0.00150908506475389, -6.259272777242586e-05, 0.0011954504298046231, 0.00033649426768533885, 0.0006129689863882959,
0.0008567073964513838, 0.0007649981998838484, 0.0007854680297896266, -0.001363289775326848, 0.0006838893750682473, 0.0019097343320026994, 0.0008629354415461421, -0.0006856460822746158, 0.0007754159742034972,
-0.001088864402845502, 0.001463291933760047, -0.002013310557231307, 0.00016314579988829792, -0.001032473286613822, 0.00033582706237211823, -0.00038609615876339376, -0.0004923777305521071, -0.0016131643205881119,

-0.0004456422757357359, 0.0010814889101311564, 0.0005628557992167771, -0.0004485500685404986, -0.00041329918894916773, 0.00043358109542168677, 0.0006361532723531127, 0.0007210673647932708, -0.0005090286140330136,
-0.0019742720760405064, 0.0011092027416452765, -0.0002474093053024262, 0.0007939984207041562, 0.0010134715121239424, 0.0004600287356879562, -0.0008518119575455785, -0.0008610775112174451, 0.00046291472972370684,
0.00037765264278277755, -0.0012405083980411291, -0.0013560752850025892, -0.001598319155164063, -0.0027604049537330866, -0.0008856443455442786, -0.002181252231821418, 0.0005053703207522631, -0.0006051689269952476,
-0.0004186882288195193, -0.0018904530443251133, 0.0008870303281582892, 0.001194408512674272, 0.001241408521309495, -0.001254814094863832, -0.0009206035174429417, 0.0006136148003861308, -0.0004433081194292754,
0.0006065598572604358, 0.000389905646443367, -0.0012466158950701356, 0.0008100384729914367, -6.510643288493156e-05, -0.0009399616974405944, 0.0005137275438755751, -0.001236491953022778, -4.065340544912033e-05,
-0.0009114352287724614, 0.0006394930533133447, 0.00019928911933675408, -0.00144667224958539, -0.0013846795773133636, 0.0005617966526187956, 0.002516231732442975, -3.009583906532498e-06, 0.0008146064355969429,
0.0019322566222399473, -0.0006341896951198578, -0.00018798155360855162, -0.0003901624004356563, 0.000518886256031692, 0.001849320367909968, 0.0004188966122455895, -0.0006617121398448944, -0.0004492557782214135,
0.0006135111325420439, 0.000742141215596348, -0.0005494406213983893, -0.0006980114267207682, -0.0007641997653990984, -2.5958908736356534e-05, 0.0002973320661112666, 0.0014494009083136916, -0.0003449160431046039,
-0.00037503743078559637, 0.0016391781391575933, -0.0014316720189526677, -0.0002957980032078922, -0.001616672845557332, -0.0008017887594178319, -0.0015348978340625763, 0.0005996475811116397, -0.0016865015495568514,

-0.0003782430721912533, -0.0009570475667715073, -0.0011277267476543784, 0.00180433364585042, -0.0012193359434604645, -0.00025961469509638846, -0.0005134602542966604, 0.0004996838979423046, -0.001138967229053378,
-0.0002948046021629125, 0.0015175279695540667, -0.0007555886986665428, 0.0009787778835743666, -0.00032182762515731156, 0.0003316574729979038, 0.0004339139850344509, -0.0019948366098105907, 0.0001716409606160596,
-0.0001913684536702931, -0.001357423490844667, 0.0003162807261105627, 0.0010474604787304997, -0.0010326545452699065, 0.0010362850734964013, -0.000715647533070296, -0.0012617540778592229, 0.0007311622612178326,
0.000554826867301017, 0.0010243835859000683, -0.00015997685841284692, -0.00037371201324276626, 0.0010334982071071863, -0.0011573940282687545, -0.0009114354616031051, -0.00015830635675229132, -0.00037357458495534956,
-7.87905155448243e-05, -0.0011626767227426171, -3.205699977115728e-05, 0.0011860980885103345, -0.0009154521394520998, -0.0015579010359942913, -0.0006612959550693631, 5.901557597098872e-05, 8.923883433453739e-05,
0.0009732882608659565, 0.0003239764482714236, 0.00041627956670708954, 0.0009620821219868958, -5.0443610234651715e-05, -0.0008907017763704062, -0.0007431871490553021, 9.633138688514009e-05, 0.00024185508664231747,
0.0005224959459155798, -0.0006632294389419258, -0.0008217195281758904, -0.0005752366851083934, 0.00031895251595415175, 0.0002101064019370824, 0.0008412789320573211, -0.0006362818530760705, -0.0014072611229494214,
0.00012794735084753484, -0.0010524755343794823, 0.00041546058491803706, 0.0004859249747823924, -0.0008785720565356314, -0.00011088411702075973, -1.293869354412891e-05, -0.0005055746296420693, 0.0002222969924332574,
-4.7033518058015034e-05, -0.00023998097458388656, 0.0007468517287634313, -0.0005776738980785012, 0.0007398471352644265, -0.00020299215975683182, 3.6905283195665106e-05, 1.2206623978272546e-05, 0.0002736823516897857,

-0.03736849129199982, 0.04365527629852295, 0.06155460327863693, -0.1716172844171524, -0.0010409214301034808, -0.04572901129722595, 0.04417017474770546, 0.07768265157938004, -0.020297184586524963,
-0.03644590452313423, 0.056331146508455276, -0.05258964002132416, -0.06396597623825073, 0.19313600659370422, -0.03913743793964386, -0.021271653473377228, -0.07504606246948242, -0.055963337421417236,
0.06264857202768326, 0.016320379450917244, 0.13311290740966797, -0.023342447355389595, 0.26079943776130676, 0.13220031559467316, -0.012500042095780373, 0.04158882424235344, 0.16334477066993713,
-0.13021895289421082, -0.0784955620765686, -0.022617965936660767, -0.3279626667499542, -0.2588888108730316, -0.20799389481544495, -0.1206822469830513, -0.11035464704036713, -0.12220873683691025,
-0.03091897815465927, 0.33149954676628113, 0.19554510712623596, 0.046737976372241974, 0.1616290956735611, 0.03888147696852684, 0.2579796016216278, 0.14620491862297058, 0.007622802630066872,
-0.10936261713504791, -0.1670931726694107, -0.2986741364002228, -0.3148256242275238, -0.17730216681957245, -0.27363529801368713, -0.09459452331066132, 0.004572989419102669, -0.09038140624761581,
0.24828805029392242, 0.00444217212498188, 0.2955993413925171, 0.26263442635536194, -0.021756025031208992, -0.10917024314403534, -0.01959892362356186, 0.2114255428314209, -0.016222991049289703,
-0.04402846843004227, -0.31911346316337585, 0.05083457753062248, 0.4427645802497864, 0.34853658080101013, 0.03003772161900997, -0.12291555106639862, -0.06384014338254929, 0.04527098685503006,
0.08414127677679062, 0.1413649320602417, -0.2351425439119339, -0.1072976142168045, 0.08654502034187317, -0.11958473920822144, 0.09183238446712494, 0.012878400273621082, -0.01705048605799675,

-0.006039154715836048, 0.03949546068906784, -0.011575731448829174, 0.006279857363551855, -0.1589278131723404, -0.13559673726558685, -0.03175828605890274, 0.23796051740646362, -0.10436321049928665,
-0.052519164979457855, 0.06477516144514084, -0.12236672639846802, 0.1001957505941391, 0.2222730964422226, 0.1282365322113037, -0.17412245273590088, -0.11293517053127289, 0.12766453623771667,
0.037720873951911926, 0.10460034012794495, -0.010523390024900436, -0.08484049886465073, -0.08106663078069687, 0.016814621165394783, 0.14951832592487335, 0.21620815992355347, -0.1444082260131836,
0.008106019347906113, -0.05704783648252487, 0.08020181953907013, 0.027755845338106155, -0.16613860428333282, -0.31643152236938477, -0.09622111916542053, 0.19705040752887726, -0.09236286580562592,
0.028923651203513145, 0.12215514481067657, -0.17038926482200623, -0.06258074194192886, 0.2327783703804016, -0.03029259480535984, -0.1037127748131752, 0.1127760037779808, 0.055294569581747055,
-0.25348609685897827, 0.3195784389972687, -0.22876809537410736, -0.2852574586868286, 0.19749993085861206, 0.12394383549690247, 0.02494964562356472, 0.059626124799251556, -0.1868988573551178,
-0.1002478376030922, 0.28243741393089294, 0.05382262542843819, -0.0476568378508091, -0.07640890032052994, -0.02594071812927723, 0.051651544868946075, 0.2132013738155365, 0.09989402443170547,
0.04011467844247818, -0.1656808704137802, -0.02633637748658657, 0.2999736964702606, 0.01089830044656992, -0.01921241544187069, -0.220767542719841, -0.18564729392528534, -0.06696341931819916,
-0.008030825294554234, 0.14637136459350586, -0.12054266780614853, -0.03475150465965271, -0.12024424225091934, -0.006053747609257698, 0.07263869792222977, 0.22074611485004425, -0.04448912665247917,

0.0006250826991163194, 0.00025321784778498113, -0.0006213007727637887, -0.0015586045337840915, 0.00019673650967888534, 4.0992490539792925e-05, 0.0005109728081151843, -0.000818026892375201, 0.0006000426365062594,
0.0013118486385792494, 0.00022630002058576792, 0.001409410615451634, 0.00019255076767876744, 0.0014892208855599165, -0.001496430137194693, 0.0002712619607336819, -0.00038198454421944916, 0.00041936407797038555,
-0.0012490005465224385, -0.001264261780306697, -0.0004584481939673424, -0.0011733782012015581, -4.561951573123224e-05, -0.0005391144659370184, 0.0002757500915322453, -0.0006565628573298454, -0.0008967100875452161,
-0.00032052514143288136, 0.00022494931181427091, 0.0011180717265233397, -0.00020910664170514792, -0.0004391624534036964, 0.00027699192287400365, -0.0003378525725565851, -0.0014030055608600378, -0.0006759516545571387,
0.0006139400647953153, -0.0022016470320522785, 0.00012558326125144958, 0.0009765625, 0.0007221876294352114, 0.00037710374454036355, 0.0006737160147167742, -0.0005643939366564155, -0.00027717393822968006,
0.00023619906278327107, -0.00045731684076599777, 0.0010594852501526475, -0.0005888597806915641, -0.0002965823805425316, 0.0008524410077370703, 0.0013599888188764453, -0.00015138449089135975, 0.0011892274487763643,
-0.0009940434247255325, -0.0003757642989512533, -0.00010083214874612167, -0.00023670538212172687, -0.0008980531129054725, -0.0014064302667975426, -0.00029100850224494934, 0.0014966630842536688, 0.0010810298845171928,
0.00021364731946960092, 0.0009359430987387896, -0.00016503942606505007, 0.000262673303950578, -0.00010171475150855258, 0.00024299902725033462, -0.0008212047978304327, 0.0006338569219224155, -0.0016348923090845346,
-0.0010945484973490238, 0.0005988877383060753, -1.602505835762713e-05, -5.4157433623913676e-05, -0.001482457504607737, -0.0008715541334822774, 0.0011129374615848064, -0.0001318278955295682, -0.002296140417456627,

0.17284061014652252, -0.14111408591270447, 0.10063678026199341, 0.005746697075664997, 0.050703804939985275, 0.22103580832481384, -0.1472020298242569, -0.04842706397175789, 0.02013232372701168,
-0.12004679441452026, -0.0742301270365715, -0.05826102942228317, 0.0992998331785202, -0.17802651226520538, -0.11883419007062912, -0.028431612998247147, 0.21510490775108337, 0.027911612764000893,
-0.14689165353775024, -0.020232772454619408, 0.094025157392025, -0.0012694153701886535, -0.18498755991458893, -0.0609661266207695, -0.058673154562711716, 0.016928398981690407, -0.1290483921766281,
0.35038602352142334, -0.28308266401290894, 0.2224612981081009, 0.13651202619075775, 0.11935136467218399, 0.3060019314289093, 0.06760019063949585, 0.03333614766597748, -0.00952786672860384,
0.1332116425037384, -0.726008415222168, 0.08535729348659515, 0.4763098955154419, -0.19916561245918274, -0.2749485969543457, -0.132002055644989, 0.10678057372570038, -0.07221490144729614,
0.00609905319288373, -0.4555383026599884, 0.15451014041900635, 0.7070696353912354, -0.13663916289806366, -0.26515766978263855, 0.06781400740146637, 0.2422860562801361, -0.11982966959476471,
0.09466011077165604, -0.3005658686161041, -0.08268623799085617, 0.19890904426574707, -0.0784890428185463, 0.07587721198797226, -0.01952339895069599, 0.0505908727645874, 0.09709587693214417,
0.43917468190193176, -0.21970848739147186, -0.11905573308467865, -0.08539357036352158, -0.05298444628715515, 0.2720917761325836, -0.12296230345964432, -0.0797475278377533, -0.11200760304927826,
-0.21936149895191193, -0.043866679072380066, 0.13711780309677124, 0.21605870127677917, -0.05168034881353378, -0.11497469991445541, -0.08998537808656693, 0.14204952120780945, 0.04491521790623665,

0.08475593477487564, -0.12500524520874023, 0.0818956270813942, 0.06346095353364944, -0.08375908434391022, 0.02340308576822281, 0.3324766755104065, -0.2539294958114624, -0.10861039906740189,
-0.07820148020982742, 0.09686487168073654, 0.04988621175289154, -0.16384856402873993, -0.021932026371359825, -0.20120397210121155, -0.2186552733182907, 0.46495747566223145, 0.06402875483036041,
-0.10432115197181702, -0.13829052448272705, 0.10032239556312561, 0.0857432633638382, 0.35272789001464844, 0.1566157042980194, -0.40212327241897583, -0.04044492170214653, 0.06077650934457779,
0.1759919822216034, 0.10821150243282318, -0.05979682877659798, -0.21598543226718903, -0.020273715257644653, 0.24804268777370453, 0.25499242544174194, -0.4772827923297882, 0.0259281974285841,
-0.15391652286052704, 0.10168275982141495, 0.02931969240307808, -0.41325128078460693, -0.22017991542816162, 0.10987938940525055, 0.5936839580535889, -0.28483670949935913, -0.0488273911178112,
-0.04071445018053055, -0.01655392162501812, 0.4505804479122162, -0.07227533310651779, -0.21291671693325043, -0.3825633227825165, 0.20127400755882263, 0.20242591202259064, -0.009533259086310863,
-0.044821105897426605, -0.3547975718975067, 0.15691491961479187, 0.2215028554201126, 0.14318227767944336, -0.2578320801258087, -0.06082449108362198, 0.11715211719274521, 0.0364273265004158,
0.3480159342288971, -0.0069186207838356495, -0.2593964636325836, -0.22054295241832733, 0.09065118432044983, 0.2732687294483185, 0.029627498239278793, -0.28665095567703247, -0.010202422738075256,
-0.2108430564403534, 0.09641014784574509, 0.18107344210147858, 0.02776975929737091, -0.12536992132663727, -0.09545121341943741, 0.1293669193983078, -0.012780215591192245, 0.06353791058063507,

0.05025120824575424, -0.09270341694355011, 0.11697094887495041, -0.013291548006236553, -0.05260244384407997, 0.1347111016511917, 0.13054533302783966, 0.018617941066622734, 0.024347543716430664,
0.03725617378950119, -0.16716597974300385, 0.1298164427280426, 0.01851983554661274, 0.02865925058722496, 0.005449098069220781, -0.1963779181241989, -0.1690814346075058, -0.03218362107872963,
0.02701590210199356, -0.08872615545988083, 0.15607257187366486, -0.14616113901138306, -0.16309647262096405, -0.06884926557540894, -0.07366567850112915, 0.20055846869945526, -0.01212327741086483,
-0.1651327759027481, 0.03811539709568024, 0.23738747835159302, -0.07941732555627823, -0.022930026054382324, 0.10594610869884491, 0.023792311549186707, 0.19175145030021667, -0.005928630009293556,
0.05853213742375374, 0.04073227196931839, 0.07557129114866257, -0.12856370210647583, 0.09656723588705063, 0.1839374452829361, -0.15239326655864716, -0.13476403057575226, 0.00944619718939066,
0.15141914784908295, -0.031781505793333054, -0.021443869918584824, -0.11567530781030655, 0.09248095005750656, 0.09602309763431549, -0.31865689158439636, -0.15197482705116272, 0.06484188139438629,
-0.12134963274002075, -0.0435468889772892, -0.09549347311258316, -0.14034700393676758, -0.03895963728427887, 0.03225155174732208, -0.10894597321748734, 0.21686305105686188, 0.02231641672551632,
-0.1602472960948944, 0.2123928815126419, 0.04229843243956566, -0.026489026844501495, -0.007051259744912386, 0.10272929072380066, 0.050375036895275116, 0.1877114325761795, -0.21782025694847107,
-0.01221636962145567, 0.1566271185874939, -0.053639501333236694, -0.0013596039498224854, -0.0109223248437047, 0.0381101556122303, -0.07428624480962753, -0.03700941056013107, 0.020875973626971245,

-1.3220475921116304e-05, -0.0002351427247049287, -0.0003017344861291349, 0.0011701176408678293, 0.0005219589802436531, -0.00017714938439894468, -0.0008295010193251073, 0.0026146171148866415, -0.000917407451197505,
0.0005582848098129034, 0.0002470496401656419, -0.0002831489546224475, 0.0004936241894029081, -0.0015356694348156452, -0.00012244866229593754, -0.00040164185338653624, 0.00031529582338407636, 0.0011554387165233493,
0.0010136263445019722, -0.0006100599421188235, 0.0010524714598432183, -0.001444124965928495, -0.00040138920303434134, 0.00031088918331079185, -0.0016401804750785232, -0.0019646992441266775, -0.0018860558047890663,
-0.0013858844758942723, -0.0004839716129936278, 0.0017164674354717135, 0.0001480509527027607, -0.0008143277373164892, 0.0006042238674126565, 0.0002973862283397466, 0.0011475378414615989, -0.0008238251903094351,
-0.001087642041966319, 0.0007561984821222723, -0.002661481499671936, 0.00013971570297144353, -0.0014026494463905692, -0.001581064541824162, 0.001193301286548376, 0.0009497179416939616, -0.001035139779560268,
-0.0015486932825297117, -0.001599774113856256, 0.0005479166866280138, -0.0018494618125259876, -0.0014196261763572693, 0.0003441201406531036, -0.00011232276301598176, 0.0006711058085784316, -0.0007719260174781084,
0.000127462248201482, -9.49866880546324e-05, 0.001740365056321025, -0.0004452465509530157, -0.0008572018123231828, 0.00015534927661065012, -7.274309609783813e-05, -0.0012182462960481644, -0.00019183973199687898,
5.020199296268402e-06, 0.0013708925107493997, -0.0012655328027904034, -0.0012379607651382685, -0.0020387996919453144, 0.000924676307477057, 0.000656351272482425, -0.0014400534564629197, -0.0009926535421982408,
-0.0005899652605876327, -0.0006870461511425674, 0.0004465800302568823, 0.00010915540769929066, 8.505984442308545e-05, 0.0009823464788496494, -0.0011803755769506097, 0.000518362270668149, 0.0018982960609719157,

0.06675630807876587, 0.10011044889688492, -0.13682027161121368, -0.20919878780841827, 0.07835565507411957, 0.26173344254493713, 0.14700977504253387, -0.10170216113328934, -0.015684163197875023,
-0.1015508845448494, 0.20361636579036713, 0.07913091778755188, -0.18289819359779358, -0.06950816512107849, -0.2127251923084259, -0.212612122297287, 0.006008985918015242, 0.09304043650627136,
-0.2301769107580185, 0.09825221449136734, 0.09731166064739227, -0.26144886016845703, -0.05017643794417381, 0.014347923919558525, 0.08888933062553406, 0.14839166402816772, -0.04708436131477356,
0.04767187684774399, 0.2252310812473297, 0.15061306953430176, -0.05101091414690018, 0.00885249674320221, 0.028482967987656593, 0.05058392509818077, -0.2315424531698227, -0.01981641910970211,
-0.11485124379396439, 0.040154892951250076, 0.16232730448246002, 0.08625652641057968, 0.15995582938194275, -0.03382885083556175, 0.07821764796972275, 0.021595515310764313, -0.0025906157679855824,
-0.04775497689843178, -0.23395177721977234, 0.07294104993343353, -0.1123623251914978, -0.048968635499477386, -0.30034151673316956, -0.04912468045949936, 0.3725926876068115, -0.17659033834934235,
0.011824085377156734, -0.021366603672504425, 0.07659834623336792, 0.09914397448301315, 0.045059047639369965, -0.15567144751548767, -0.057691991329193115, 0.1250881850719452, -0.006354268174618483,
0.08547789603471756, 0.09305590391159058, -0.221578910946846, 0.06795856356620789, 0.032484132796525955, 0.14592225849628448, 0.11007429659366608, -0.17674657702445984, 0.017361314967274666,
-0.1605878621339798, 0.08126337826251984, 0.17253640294075012, -0.048549190163612366, -0.11558538675308228, -0.010670696385204792, -0.11523112654685974, 0.1372087001800537, -0.0009926814818754792,

-0.09413260221481323, 0.10116744041442871, 0.07690484821796417, 0.029048291966319084, -0.04245157539844513, -0.05786983668804169, -0.01547294296324253, 0.013779924251139164, 0.0616614893078804,
-0.047353655099868774, 0.046854954212903976, -0.036578219383955, -0.04329188913106918, -0.050822511315345764, -0.012540447525680065, 0.0035728050861507654, -0.027613501995801926, -0.04868010804057121,
-0.006213999819010496, 0.06741014122962952, -0.02601684257388115, -0.040222957730293274, -0.0857955738902092, -0.038291215896606445, 0.01885293610394001, 0.024483531713485718, -0.04164252057671547,
-0.08545178920030594, 0.05634567141532898, 0.01995071955025196, 0.032319460064172745, -0.03407850116491318, -0.03887287527322769, 0.015596751123666763, 0.06087765842676163, -0.05568878352642059,
-0.10009366273880005, -0.007524869870394468, -0.05845760554075241, 0.040348220616579056, 0.070225790143013, 0.03150505945086479, 0.009345185942947865, 0.04165501520037651, -0.03276044875383377,
-0.01210689265280962, -0.012162122875452042, -0.08978217840194702, 0.0596056692302227, 0.132981538772583, 0.08955609798431396, 7.772523531457409e-05, -0.019989119842648506, 0.005661839619278908,
-0.0031503867357969284, 0.017818868160247803, 0.02696438506245613, 0.158264622092247, 0.11290949583053589, 0.01896071247756481, -0.037726029753685, -0.025289025157690048, 0.03947709500789642,
-0.013129609636962414, -0.043903741985559464, -0.005181447137147188, 0.10662806779146194, -0.05138043314218521, -0.1440013349056244, -0.07620743662118912, -0.0017911434406414628, 0.0463654100894928,
0.09102503210306168, -0.08506592363119125, -0.10052367299795151, 0.08344101160764694, 0.005159033462405205, -0.029293766245245934, 0.03669429570436478, -0.018124781548976898, -0.0538988821208477,

0.04917022958397865, -0.03377075493335724, 0.029063474386930466, -0.028347650542855263, 0.1519852876663208, -0.06072525307536125, -0.15768304467201233, -0.0811757892370224, 0.20282413065433502,
0.1640767902135849, -0.10849152505397797, -0.020853949710726738, 0.021501943469047546, 0.05948794633150101, 0.0715864971280098, 0.13787654042243958, 0.067623570561409, -0.17588138580322266,
-0.13236074149608612, -0.06981933861970901, -0.15008942782878876, -0.05620679631829262, 0.1363605260848999, 0.033482443541288376, 0.01452409103512764, -0.0830564945936203, -0.05323179066181183,
-0.08940479159355164, -0.03083725832402706, -0.17281045019626617, -0.1394493132829666, 0.3879155218601227, 0.0497780404984951, -0.0697089359164238, -0.16060182452201843, 0.052770957350730896,
0.2116864174604416, -0.002660884289070964, 0.05467509850859642, 0.3558388948440552, 0.9080133438110352, 0.30998682975769043, 0.09166785329580307, 0.007900921627879143, 0.16260871291160583,
-0.05938250944018364, -0.062445562332868576, -0.0721784234046936, 0.011742359958589077, 0.3000011742115021, -0.22053758800029755, -0.07178082317113876, 0.0781649723649025, -0.1341457962989807,
-0.15025712549686432, 0.039412666112184525, 0.049940239638090134, 0.11276823282241821, 0.26087385416030884, -0.17119522392749786, -0.04244593158364296, 0.08794930577278137, -0.07500926405191422,
0.07495568692684174, -0.05116410180926323, 0.06247921660542488, 0.15666399896144867, 0.09825385361909866, -0.1090649738907814, -0.002613720018416643, -0.07971512526273727, 0.119465172290802,
0.03241422772407532, -0.1202617809176445, -0.1062789037823677, -0.17203739285469055, 0.026307545602321625, 0.019237080588936806, 0.09277630597352982, -0.09537709504365921, -0.029367761686444283,

-0.04339740425348282, -0.12510566413402557, 0.15651321411132812, -0.1196160614490509, -0.0378347709774971, -0.11157974600791931, 0.10787242650985718, 0.16347242891788483, 0.028084397315979004,
0.13742677867412567, -0.03305390104651451, -0.010310225188732147, -0.07586779445409775, 0.21541397273540497, 0.014253620989620686, -0.28478729724884033, -0.11460007727146149, -0.06586463004350662,
0.11692309379577637, 0.0028135753236711025, 0.1513238102197647, -0.08193404972553253, 0.08263155817985535, -0.1510469764471054, -0.08710040152072906, 0.325381338596344, 0.07270590215921402,
-0.11571937054395676, -0.3155165910720825, 0.19886457920074463, -0.09982964396476746, 0.1113453209400177, -0.42221325635910034, 0.05658431723713875, 0.44419950246810913, -0.3280166685581207,
0.029110971838235855, 0.015313864685595036, 0.2397228628396988, -0.2372417002916336, 0.3109285831451416, -0.23003371059894562, 0.08986680209636688, 0.4076293706893921, 0.07154352217912674,
-0.0030942123848944902, 0.16851001977920532, 0.039231281727552414, -0.5238041281700134, 0.052800748497247696, -0.07276545464992523, -0.013563654385507107, -0.16536971926689148, -0.13748593628406525,
-0.0029227472841739655, 0.08835767209529877, 0.10154743492603302, -0.14176765084266663, 0.15699006617069244, 0.07332859933376312, 0.10024779289960861, 0.12034513801336288, 0.18203359842300415,
-0.1910303682088852, -0.11690597981214523, 0.014915727078914642, -0.05264352634549141, 0.09419392049312592, -0.12761491537094116, -0.1488305628299713, 0.14345036447048187, -0.130315363407135,
0.05057041719555855, 0.13296523690223694, 0.010911411605775356, -0.11275137960910797, 0.06476783752441406, -0.040463536977767944, -0.020888565108180046, 0.1671391725540161, -0.07143936306238174,

-0.0749134048819542, -0.060479842126369476, 0.07323461025953293, 0.128266841173172, -0.043285220861434937, -0.03357171639800072, -0.09970749169588089, -0.05523056909441948, 0.06289239227771759,
0.21901138126850128, -0.035849299281835556, -0.08650030195713043, -0.018982043489813805, 0.0695781335234642, 0.4145001173019409, -0.027209550142288208, -0.004038578364998102, 0.06541971862316132,
0.12227083742618561, -0.1073189526796341, -0.0841955840587616, -0.15702803432941437, -0.7429218888282776, -0.04395433887839317, -0.011260250583291054, 0.10814431309700012, -0.28268298506736755,
-0.12526658177375793, -0.026223644614219666, 0.08096180856227875, 0.6802259683609009, 0.13561013340950012, 0.08618369698524475, -0.0501398928463459, 0.35771113634109497, -0.041319262236356735,
0.27181851863861084, -0.23890241980552673, -0.5387949347496033, 0.21392858028411865, 0.07953313738107681, 0.019276024773716927, -0.5713126063346863, -0.037591978907585144, 0.1565358191728592,
0.15565475821495056, 0.00460081035271287, -0.0456286296248436, 0.10213345289230347, 0.17657290399074554, 0.6814069747924805, -0.13053438067436218, -0.06998789310455322, 0.003884716657921672,
-0.44260460138320923, 0.28802698850631714, 0.2503567337989807, -0.3661724030971527, -0.6118166446685791, 0.052883099764585495, -0.009912409819662571, -0.022988222539424896, 0.010322963818907738,
-0.021636782214045525, 0.05146769434213638, 0.11953992396593094, 0.3151896297931671, -0.035797424614429474, -0.17633333802223206, 0.014319990761578083, -0.09696750342845917, 0.19342084228992462,
0.08160614222288132, -0.08066563308238983, -0.1464836746454239, -0.13353408873081207, 0.15164321660995483, 0.05195532366633415, 0.0950581356883049, -0.02673575095832348, -0.08893080055713654,

0.08918213844299316, 0.08657902479171753, 0.005215317010879517, -0.006473506335169077, 0.04260111600160599, 0.016859546303749084, -0.013135830871760845, -0.05732234939932823, -0.06841449439525604,
-0.08908746391534805, -0.015611836686730385, -0.061792485415935516, -0.07461176067590714, -0.03767390176653862, -0.06813358515501022, 0.008849180303514004, 0.034659937024116516, -0.11153175681829453,
-0.018928145989775658, 0.12819842994213104, 0.03857557848095894, 0.01105338055640459, 0.08118841797113419, -0.020579038187861443, -0.016684940084815025, -0.010985679924488068, 0.035327933728694916,
0.06822128593921661, 0.11152952909469604, 0.013529916293919086, -0.016081996262073517, 0.18805059790611267, 0.0926079973578453, 0.032322220504283905, -0.07684376835823059, -0.0065249307081103325,
0.018553031608462334, 0.022786445915699005, 0.026319757103919983, 0.05849913880228996, 0.206848606467247, 0.08509713411331177, 0.09237775206565857, 0.03649907559156418, 0.0662459060549736,
-0.08157840371131897, 0.028796279802918434, -0.022867100313305855, -0.04078856483101845, 0.027245769277215004, -0.1352597326040268, 0.003301734570413828, 0.036037247627973557, -0.001803244580514729,
-0.021063758060336113, 0.09868303686380386, -0.004615786485373974, 0.06155001372098923, 0.1704898625612259, -0.009244422428309917, 0.04022917151451111, 0.00843940768390894, 0.017657065764069557,
1.8606752973937546e-06, 0.022133613005280495, -0.02020549401640892, 0.07613987475633621, 0.07413829118013382, -0.038554999977350235, 0.006358420941978693, -0.03960535675287247, 0.005950190592557192,
-0.08430261164903641, 0.0006188381812535226, -0.002441024174913764, 0.08848552405834198, 0.06897841393947601, -0.03736359626054764, 0.0491594560444355, 0.08249298483133316, 0.0369696244597435,

-0.002494501881301403, -0.07609808444976807, 0.1119963526725769, -0.10137500613927841, 0.12085500359535217, 0.020787041634321213, -0.08020990341901779, -0.07437735795974731, -0.016652707010507584,
0.1702006757259369, -0.0884813442826271, 0.04040154069662094, 0.04366397485136986, -0.04981914907693863, -0.10109864920377731, 0.18095622956752777, 0.07635517418384552, 0.16501443088054657,
0.04764076694846153, -0.29989609122276306, -0.10478614270687103, -0.1188390702009201, 0.02361522614955902, -0.15416087210178375, 0.04873557388782501, 0.04563599079847336, -0.35214775800704956,
0.24584366381168365, -0.10939999669790268, 0.23839618265628815, 0.12754511833190918, 0.20347249507904053, -0.0935775637626648, 0.0144122913479805, 0.2616703510284424, 0.05943511798977852,
0.0567740872502327, -0.03670964017510414, 0.07175207138061523, -0.1313132643699646, -0.1811451017856598, -0.24757787585258484, 0.05534401535987854, -0.11349410563707352, -0.1484820395708084,
-0.18046405911445618, 0.12988997995853424, 0.10476439446210861, -0.1005360409617424, 0.012329879216849804, 0.251142293214798, 0.3151717782020569, -0.15847274661064148, 0.3126358389854431,
-0.2669127285480499, -0.010338036343455315, 0.1929193139076233, -0.09310273081064224, -0.03839711472392082, 0.058026671409606934, -0.1498262733221054, -0.320158451795578, 0.24430842697620392,
0.24325047433376312, 0.055703017860651016, 0.04047559201717377, -0.11337616294622421, 0.03028351254761219, -0.1718759685754776, -0.0747850239276886, -0.058253467082977295, 0.045693881809711456,
-0.12651756405830383, 0.0029598521068692207, -0.0746246948838234, 0.04430631548166275, 0.15831680595874786, -0.06299256533384323, 0.20761297643184662, -0.18382751941680908, 0.04795093461871147,

0.03453255072236061, 0.08143798261880875, -0.07827461510896683, -0.008095886558294296, 0.09633331745862961, -0.032731134444475174, 0.03896036744117737, 0.07796624302864075, -0.09800060838460922,
-0.17390114068984985, 0.013836466707289219, -0.0955653116106987, -0.06489729881286621, -0.06499230861663818, -0.12440793216228485, 0.07461445778608322, 0.16298134624958038, -0.14313311874866486,
-0.02622191607952118, 0.17264506220817566, 0.01862080581486225, 0.041154250502586365, 0.057074639946222305, -0.06986492872238159, -0.011844002641737461, 0.03608855977654457, 0.004727501422166824,
0.054055534303188324, 0.06472594290971756, -0.07746946066617966, -0.04556572064757347, 0.1383574903011322, 0.006478244438767433, -0.03284274414181709, -0.10053438693284988, -0.030013108626008034,
0.08107316493988037, 0.05337893217802048, 0.016869626939296722, 0.12709975242614746, 0.2540443539619446, 0.09076768904924393, 0.07549874484539032, -0.013449955731630325, 0.05161766707897186,
-0.049904003739356995, 0.11237815767526627, -0.004943950101733208, 0.03591571003198624, 0.05699837952852249, -0.14426246285438538, -0.014709394425153732, -0.04324657842516899, -0.09033934026956558,
-0.006868680473417044, 0.17643220722675323, -0.01222564373165369, 0.07162804156541824, 0.1575816571712494, -0.031030887737870216, 0.05114923045039177, 0.04688235744833946, 0.004272202495485544,
0.045018624514341354, 0.09796737879514694, -0.05488642305135727, -0.004248837940394878, 0.025244703516364098, -0.06603638082742691, 0.026735050603747368, 0.06231154873967171, 0.045271750539541245,
-0.031672630459070206, 0.13647104799747467, -0.0009657645132392645, 0.018488561734557152, 0.041390109807252884, -0.10096877068281174, -0.009352818131446838, 0.0745505690574646, 0.02882414497435093,

-0.133609339594841, -0.03819651901721954, 0.001151051837950945, 0.019290350377559662, 0.047142498195171356, 0.031506381928920746, 0.06336957216262817, 0.032302893698215485, 0.006281350739300251,
-0.03740052878856659, 0.050428763031959534, 0.08101901412010193, 0.07232176512479782, 0.01183471642434597, -0.04791678488254547, -0.019763002172112465, -0.006771337240934372, 0.027429305016994476,
-0.005318525247275829, 0.03478771448135376, 0.007166128605604172, -0.008718438446521759, -0.012047640979290009, -0.06000327318906784, -0.10047216713428497, -0.09047075361013412, 0.006131005007773638,
-0.018347835168242455, 0.03032604046165943, -0.009940189309418201, -0.026144159957766533, 0.0716538354754448, 0.03843644633889198, -0.03604808822274208, -0.02366860769689083, -0.015906482934951782,
0.03831234574317932, 0.07807328552007675, 0.08553636074066162, 0.09884383529424667, 0.12573787569999695, 0.04602298140525818, 0.004538014996796846, 0.07166740298271179, 0.01014549657702446,
0.05794878304004669, 0.02658366598188877, 0.036963190883398056, 0.07439740002155304, 0.07202591001987457, -0.0015225837705656886, 0.017082151025533676, 0.08737485110759735, -0.005794626194983721,
0.026332100853323936, -0.055387429893016815, -0.10465177893638611, -0.0627688392996788, 0.027715779840946198, 0.017957618460059166, -0.0010449641849845648, 0.013926751911640167, -0.0266911368817091,
-0.022419702261686325, -0.045605115592479706, -0.09064694494009018, -0.06312739849090576, 0.036068208515644073, 0.06525775790214539, 0.019389934837818146, 0.006056784652173519, 0.0026107390876859426,
-0.07533064484596252, -0.004264597315341234, -0.05940620228648186, -0.04531720280647278, 0.01771579310297966, 0.01073805894702673, 0.02580205351114273, 0.061774905771017075, 0.049093276262283325,

0.06254594027996063, -0.08440928906202316, -0.05960290879011154, -0.21179302036762238, -0.03749246150255203, 0.1320458948612213, 0.02225368283689022, -0.20560918748378754, 0.09833671897649765,
-0.010864592157304287, 0.1312112659215927, 0.2729310095310211, 0.2852783203125, 0.036214154213666916, -0.17419104278087616, 0.10605451464653015, 0.11146654188632965, -0.05312469229102135,
-0.034706000238657, -0.40110114216804504, -0.17413057386875153, -0.002180312993004918, -0.023289639502763748, -0.014259926974773407, -0.04321160912513733, -0.1015881896018982, -0.0019524767994880676,
0.25281256437301636, 0.1888352781534195, 0.2182304710149765, -0.07753387838602066, -0.1263069063425064, 0.20391452312469482, 0.17332755029201508, -0.05573255568742752, 0.08542720973491669,
-0.27624428272247314, -0.0939950942993164, -0.34804075956344604, -0.18735791742801666, -0.3288903534412384, -0.24964070320129395, 0.023052500560879707, -0.0032602131832391024, -0.09734013676643372,
0.24850279092788696, 0.4498615860939026, 0.2392505258321762, 0.7578790783882141, 0.4650757908821106, -0.09640157222747803, 0.030361128970980644, 0.13835501670837402, 0.03452449291944504,
-0.491862952709198, -0.3327092230319977, -0.115897998213768, 0.08189888298511505, 0.14717335999011993, 0.09036838263273239, -0.1914467215538025, -0.1619413048028946, 0.07546339184045792,
0.4778578579425812, 0.03341726213693619, -0.2200295627117157, -0.6558915376663208, -0.49498724937438965, 0.2652202248573303, 0.30143415927886963, -0.004251368809491396, -0.011420469731092453,
-0.1778731644153595, 0.03058483451604843, 0.15715107321739197, 0.23354242742061615, 0.017105156555771828, -0.19644701480865479, 0.014484168030321598, -0.17201600968837738, 0.07568902522325516,

0.028962446376681328, -0.06878253817558289, 0.05019852891564369, 0.05476095899939537, -0.04770945757627487, -0.1367853879928589, -0.16251084208488464, -0.056205764412879944, 0.09791768342256546,
0.16366638243198395, -0.12979918718338013, 0.002729258267208934, 0.03414570540189743, 0.06860813498497009, 0.06334712356328964, 0.04867345467209816, 0.07738835364580154, -0.003124517621472478,
-0.07452563941478729, -0.20245549082756042, 0.027065815404057503, -0.0021526585333049297, 0.051124200224876404, 0.1550229787826538, 0.14651484787464142, 0.0758848711848259, -0.10572951287031174,
-0.06748813390731812, -0.1996242254972458, 0.047433897852897644, -0.011952214874327183, -0.02098195068538189, 0.1696663796901703, 0.14325915277004242, 0.026020854711532593, -0.0003333611530251801,
0.06684102863073349, -0.1179869994521141, 0.08975568413734436, 0.027904972434043884, 0.07524381577968597, 0.2602478861808777, 0.16163015365600586, 0.005560749676078558, 0.018227512016892433,
0.029731912538409233, -0.07488886266946793, 0.1038120687007904, 0.0014797549229115248, 0.052478183060884476, 0.1951654702425003, 0.0512106716632843, -0.07954861223697662, -0.05595332756638527,
-0.10098253190517426, -0.04282565042376518, 0.12107565999031067, 0.015420041978359222, -0.02609303407371044, 0.09977199882268906, 0.0654386356472969, -0.05860965698957443, -0.04621657729148865,
-0.024240786209702492, 0.003574902657419443, 0.09980470687150955, 0.041678234934806824, -0.047122664749622345, 0.01244963426142931, 0.02494264580309391, -0.03977813571691513, 0.08772413432598114,
0.12657013535499573, -0.076152004301548, -0.0581919401884079, -0.09207551181316376, -0.05024847760796547, 0.08484440296888351, 0.011602652259171009, -0.06636865437030792, 0.07597231864929199,

0.03471222519874573, 0.11924102157354355, -0.09907552599906921, 0.0718424990773201, -0.11197686940431595, 0.07318370789289474, 0.11031656712293625, -0.468844473361969, 0.09414266049861908,
-0.1416342854499817, 0.15163519978523254, -0.13412059843540192, 0.11831796914339066, 0.0874205157160759, 0.015127725899219513, 0.02830408699810505, 0.2779788076877594, 0.04213378205895424,
-0.11278911679983139, -0.019549937918782234, -0.1138615533709526, -0.0007093751919455826, -0.13948887586593628, 0.17623040080070496, 0.276247501373291, -0.2456439584493637, -0.16273942589759827,
0.1998843401670456, 0.029753731563687325, 0.11769873648881912, -0.0947619378566742, -0.3595242202281952, 0.08280224353075027, 0.14039701223373413, -0.5054993033409119, 0.32306021451950073,
-0.09488756209611893, 0.18297874927520752, 0.021063625812530518, -0.10248441249132156, 0.31057217717170715, 0.49288955330848694, -0.06318224221467972, -0.5325169563293457, 0.016925616189837456,
-0.23778969049453735, 0.22520707547664642, -0.28116437792778015, -0.25012317299842834, 0.045585665851831436, 0.21047309041023254, 0.13688251376152039, -0.01049390621483326, 0.18622957170009613,
-0.06745558977127075, 0.05942220240831375, 0.07465878874063492, 0.17600689828395844, -0.24391280114650726, -0.1395273208618164, -0.14145755767822266, -0.22604353725910187, 0.0404188446700573,
0.2511400878429413, -0.04146436229348183, 0.06866158545017242, 0.0936383605003357, -0.17196893692016602, 0.35007256269454956, 0.1466590315103531, -0.11697538942098618, -0.08733940124511719,
-0.1187233105301857, 0.06795468926429749, -0.19596466422080994, 0.09043551236391068, -0.07781103998422623, 0.06362947076559067, -0.04456653818488121, -0.13828079402446747, 0.1451389342546463,

0.002784173935651779, 0.01319826114922762, 0.03299565985798836, -0.009061452932655811, -0.03782084956765175, 0.05905524268746376, 0.03665812313556671, -0.03293836489319801, 0.007655598223209381,
-0.02654659003019333, -0.051362812519073486, -0.019685762003064156, -0.04363385960459709, -0.033689528703689575, -0.04015159234404564, -0.030751371756196022, -0.02246842533349991, 0.018601812422275543,
0.012158050201833248, 0.015349633991718292, 0.03493561968207359, -0.01330295018851757, 0.03794550150632858, -0.003826811444014311, -0.044383760541677475, -0.07613663375377655, 0.014979931525886059,
0.0436096116900444, 0.06885120272636414, 0.09881002455949783, 0.031302209943532944, 0.12420085072517395, 0.15065008401870728, 0.07978155463933945, -0.027734771370887756, -0.05383369326591492,
-0.0678027868270874, 0.002182385651394725, 0.13103488087654114, 0.05609790235757828, 0.05619135499000549, 0.08134319633245468, 0.10918274521827698, 0.10301676392555237, -0.02375829964876175,
-0.08856120705604553, -0.03078402765095234, 0.08737516403198242, 0.013652728870511055, 0.01163883414119482, -0.00604214845225215, 0.056429434567689896, 0.10691829025745392, 0.041128937155008316,
-0.04340420290827751, -0.002507368801161647, 0.012957162223756313, 0.012340170331299305, 0.11861597746610641, 0.09244049340486526, 0.034744489938020706, -0.024895809590816498, 0.035870663821697235,
-0.040758680552244186, 0.013552304357290268, -0.009587780572474003, 0.01752828061580658, 0.07450903207063675, 0.0692441463470459, 0.0011354148155078292, -0.06966304779052734, 0.008092116564512253,
0.02915072999894619, 0.04350604489445686, -0.03975748270750046, 0.014310178346931934, 0.0008435412310063839, -0.013759381137788296, 0.02635800465941429, 0.08823874592781067, 0.0821344256401062
};

/// First convolution biases
static const double conv1_biases[] = {
-0.01660689152777195,
-0.011107334867119789,
-0.00483096856623888,
-0.048673778772354126,
-0.030040957033634186,
-0.07297247648239136,
-0.01945866458117962,
-0.009738028049468994,
0.6951230764389038,
-0.07369442284107208,
-0.01354204025119543,
0.010336088016629219,
-0.02956176921725273,
0.018691286444664,
-0.02167515829205513,
0.004088825546205044,
-0.08033090084791183,
-0.02080247923731804,
-0.00025044166250154376,
0.015665635466575623,
-0.024439847096800804,
-0.00014609392383135855,
-5.004818376619369e-05,
-0.0011854040203616023,
-8.353819430340081e-05,
0.0,
-0.00037626884295605123,
0.02971580997109413,
-9.940328891389072e-05,
-0.020136557519435883,
-0.00029498152434825897,
0.019285818561911583,
0.005577716510742903,
-0.0700315311551094,
-0.024398552253842354,
-1.7726930309436284e-05,
0.0050997124053537846,
-0.011211924254894257,
0.004536128137260675,
-0.024612177163362503,
-0.0225357823073864,
-0.00016232267080340534,
-0.00017362962535116822,
-1.552602043375373e-05,
-0.06559696048498154,
-0.0065806107595562935,
6.683926585537847e-06,
0.0252289529889822,
-0.0013730665668845177,
0.030351819470524788,
0.0,
0.003285621991381049,
0.0055278814397752285,
0.020766519010066986,
-0.00849062204360962,
0.026332268491387367,
-0.04678987339138985,
0.010329566895961761,
-0.023649320006370544,
0.027851572260260582,
0.05440746247768402,
-0.08068252354860306,
-0.009446502663195133,
-0.04663233831524849
};

/// Second convolution kernel
static const double conv2_kernel[] = {
-0.24004751443862915, 0.10371380299329758, 0.11173403263092041, 0.04352091997861862, -0.2372848093509674, 0.1215374693274498, -0.23676058650016785, -0.28548064827919006, -0.6127380132675171, -0.12218937277793884, -0.06005159020423889, 0.18506519496440887, 0.16014674305915833, 0.13922938704490662, 0.2135942578315735, 0.10787945240736008, -0.26999104022979736, -0.14241325855255127, -0.0013871012488380075, -0.004951587878167629, 0.3402169644832611, 0.0005581695586442947, 4.7351106331916526e-05, 0.0037513396237045527, 0.0011569701600819826, 0.001654176157899201, -0.0011876021744683385, 0.049887992441654205, -7.201619882835075e-05, -0.17735491693019867, 0.0011244657216593623, -0.22381487488746643, 0.0035836962051689625, -0.3210694193840027, -0.16167263686656952, -0.0007922835648059845, 0.05056063085794449, 0.21074672043323517, 0.07716237753629684, -0.3315621614456177, 0.06265880912542343, 0.0002542850561439991, -0.0012989661190658808, 0.0004486947145778686, -0.41594547033309937, -0.019950004294514656, 0.0002566903131082654, 0.17913155257701874, -0.5950504541397095, 0.3259836733341217, 0.0013792524114251137, -0.08931709825992584, -0.13066786527633667, 0.21108511090278625, -0.05854453891515732, -0.11937838047742844, 0.08559372276067734, -0.11413642764091492, 0.28384047746658325, -0.011619674041867256, 0.32102328538894653, -0.20085231959819794, -0.34134379029273987, -0.029155191034078598,

-0.15286806225776672, -0.45100340247154236, -0.07077684253454208, 0.14408659934997559, 0.05953073874115944, -0.03657171502709389, 0.3870140314102173, -0.12762507796287537, 0.059950776398181915, 0.00540902791544795, 0.16427578032016754, -0.042501527816057205, 0.032962359488010406, -0.19972456991672516, -0.2558594048023224, -0.05479712411761284, -0.1335245817899704, 0.051931269466876984, -0.0005906695732846856, 0.14123854041099548, -0.06595169752836227, 0.0002593870449345559, 0.0004935731994919479, 0.0018757024081423879, -0.0004157331713940948, 0.0006128620007075369, -0.0008253702544607222, 0.00875023566186428, 0.000315613579005003, -0.031592708081007004, -0.0011055622017011046, 0.5397407412528992, 0.16837793588638306, 0.10016077756881714, -0.04458073899149895, -0.0008208212675526738, 0.14558495581150055, 0.05370355769991875, 0.3998671770095825, 0.3651335835456848, -6.220484647201374e-05, -0.0015507896896451712, 0.00019759316637646407, 0.001477571902796626, 0.17199119925498962, 0.20428548753261566, 0.0007169281598180532, -0.15589089691638947, 0.13173037767410278, 0.0430227592587471, 0.0005358970374800265, -0.14488573372364044, -0.056273844093084335, 0.04060659557580948, 0.12327120453119278, -0.0687263160943985, 0.1168481707572937, 0.20592212677001953, -0.07642778009176254, -0.10591034591197968, -0.2585831880569458, -0.234173983335495, 0.1204083263874054, -0.09154298901557922,

0.1729278564453125, 0.12093151360750198, 0.12173106521368027, -0.17765463888645172, -0.03842559829354286, 0.1379096508026123, -0.018014583736658096, -0.00353326671756804, 0.052375391125679016, -0.013713608495891094, -0.023778876289725304, 0.08754374086856842, 0.009544276632368565, 0.002218334935605526, 0.005476833321154118, 0.14335989952087402, -0.30521509051322937, -0.027671312913298607, 0.0002961017016787082, -0.09087705612182617, 0.08001929521560669, 0.000289166287984699, 8.447665459243581e-05, 0.0032733778934925795, -0.0009773650672286749, 0.000969415414147079, 0.0023891173768788576, 0.1590563803911209, 0.00069234031252563, -0.23975391685962677, 0.0003552400739863515, -0.15277449786663055, 0.09689000993967056, -0.13403186202049255, -0.10830442607402802, -0.0011496500810608268, -0.0791272521018982, -0.04548552632331848, 0.07143749296665192, -0.11953869462013245, 0.06519463658332825, 0.0004770815430674702, -0.0012068727519363165, 0.00023571185010951012, -0.02185177616775036, -0.10972553491592407, -0.0004428153915796429, -0.06199837476015091, -0.02185823768377304, 0.13159608840942383, 0.0011464811395853758, -0.12141252309083939, -0.06273757666349411, 0.2553664743900299, 0.1002097874879837, 0.13120368123054504, 0.16516226530075073, -0.14927655458450317, 0.14413973689079285, 0.039363794028759, 0.19443942606449127, -0.01614764891564846, -0.0876186192035675, 0.08571985363960266,

-0.034732215106487274, 0.08880914747714996, 0.115323506295681, -0.2509199380874634, -0.18177348375320435, 0.11170994490385056, -0.06447608023881912, -0.04730312153697014, -0.13159127533435822, 0.01896033063530922, -0.2969268262386322, 0.31513679027557373, 0.016690406948328018, 0.0855814516544342, 0.01695072464644909, 0.1360795795917511, -0.008597755804657936, -0.15839214622974396, -0.0006356500089168549, 0.14604529738426208, 0.029391299933195114, -0.0021237179171293974, -0.0021662425715476274, 0.0011421579401940107, 0.00031981870415620506, -0.00031888089142739773, -0.0013892676215618849, 0.4037177860736847, 0.0010367054492235184, -0.08923333138227463, 0.001726223505102098, 0.04937814548611641, 0.03052854910492897, -0.10994968563318253, 0.041772034019231796, -0.0003509650705382228, -0.09172547608613968, -0.1121240183711052, 0.018248941749334335, -0.1032114252448082, 0.03656036779284477, -0.0008534444496035576, 0.0005108112818561494, 0.001955348066985607, -0.17280977964401245, -0.15745718777179718, 0.0016406632494181395, 0.10295743495225906, -0.056333065032958984, 0.12174493074417114, -0.00029968394665047526, -0.046295735985040665, -0.05203622952103615, 0.17915867269039154, 0.17138905823230743, 0.20149874687194824, 0.14662422239780426, -0.06499027460813522, 0.0864318460226059, 0.026575079187750816, -0.26568517088890076, -0.10079117864370346, -0.20195038616657257, 0.07289135456085205,

0.20596843957901, 0.1484273374080658, 0.11689981073141098, -0.292439341545105, 0.02092818170785904, 0.14047744870185852, -0.032774657011032104, 0.013994990848004818, 0.04893071949481964, -0.0856017917394638, 0.07281561940908432, 0.0699431449174881, -0.006538144778460264, 0.08474163711071014, 0.013837413862347603, 0.10437792539596558, -0.32318544387817383, -0.033461928367614746, -0.0006234075990505517, -0.25232645869255066, 0.08134997636079788, -0.0012573037529364228, -0.00025874844868667424, 0.002164048608392477, 0.000704825681168586, 0.0008626107592135668, -0.0004994627670384943, 0.1802779585123062, 0.0005355331813916564, -0.3850158154964447, -0.000660755904391408, -0.15524353086948395, 0.0770384892821312, -0.1990944892168045, -0.04059717804193497, 0.00019839264859911054, -0.08954143524169922, -0.1745176762342453, 0.19342899322509766, -0.039949242025613785, -0.05351455509662628, 0.0010188281303271651, 0.0012863714946433902, -4.699235432781279e-05, 0.04647690802812576, -0.1538148671388626, -0.0009432003716938198, 0.06832418590784073, -0.07473438233137131, 0.19692155718803406, -0.00023191161744762212, -0.07189866900444031, -0.08010462671518326, 0.22581109404563904, 0.11592476069927216, 0.17914976179599762, 0.13195598125457764, -0.1110662892460823, 0.12462127208709717, 0.006350248120725155, 0.09321404248476028, 0.032797329127788544, 0.0406208336353302, 0.07625015079975128,

0.26654642820358276, 0.006987582892179489, 0.056940462440252304, -0.21681314706802368, 0.07780187577009201, 0.0550677552819252, -0.07760556042194366, 0.03872932121157646, -0.7930355668067932, -0.1105983555316925, 0.11750592291355133, 0.13262803852558136, -0.06422358006238937, 0.02154429443180561, 0.10654937475919724, 0.05221962183713913, -0.48878803849220276, -0.22840070724487305, 0.0011379553470760584, 0.15314219892024994, 0.07926332950592041, 0.0003804231819231063, 0.0017872434109449387, 0.0007042611250653863, 0.0002458576636854559, -0.001502114930190146, 0.00033512181835249066, 0.1798011213541031, -0.00030350624001584947, -0.09183648973703384, -0.00031797270639799535, -0.17676876485347748, 0.05354951694607735, -0.30156299471855164, 0.019367441534996033, -0.00010185350402025506, -0.03712425008416176, -0.07796591520309448, -0.1688132882118225, -0.5796422958374023, 0.15654867887496948, -0.0013217078521847725, -0.001091445330530405, 0.0011883607367053628, 0.10660554468631744, -0.12484317272901535, 0.0004226503078825772, 0.09296494722366333, -0.38826271891593933, 0.2994518280029297, 0.0007777059799991548, -0.2824214696884155, -0.09771981835365295, 0.30562764406204224, 0.21152275800704956, 0.07008504122495651, 0.08235848695039749, -0.009461170062422752, 0.14994531869888306, 0.025700503960251808, 0.2208600640296936, 0.016543129459023476, -0.04067225754261017, 0.012883936055004597,

0.00617796229198575, -0.013291561044752598, 0.1916685402393341, -0.017105795443058014, -0.07506846636533737, 0.18045775592327118, -0.30787673592567444, 0.04832560196518898, 0.05962129309773445, 0.1261044591665268, -0.2459549754858017, 0.12365790456533432, 0.028636902570724487, -0.006177236791700125, -0.04891420155763626, 0.16809219121932983, -0.10486529022455215, -0.10494883358478546, -0.0004520704969763756, 0.23579229414463043, 0.05076323449611664, -0.001182716921903193, -0.0001052700899890624, 0.0018256279872730374, 0.0008991276263259351, -0.001528103486634791, -0.0005336360190995038, 0.16323579847812653, 0.0020393324084579945, 0.015845002606511116, 0.0016316768014803529, -0.06386037170886993, 0.0540936253964901, -0.14962895214557648, -0.014346976764500141, 0.0012925119372084737, -0.12354017049074173, 0.016353895887732506, -0.2519243061542511, -0.042811259627342224, 0.19090451300144196, -0.00022991615696810186, 0.0018943509785458446, -0.0005430503515526652, -0.11097119003534317, -0.05055755749344826, -0.001144487177953124, -0.002318614162504673, -0.11912520974874496, -0.022436127066612244, 0.00014450220623984933, -0.1372481733560562, -0.02418547123670578, 0.24273015558719635, 0.1387740820646286, 0.1362992823123932, 0.15725626051425934, -0.157984659075737, 0.10887137055397034, 0.07719193398952484, 0.09739567339420319, -0.09165967255830765, -0.2062297910451889, 0.11893536150455475,

-0.09508167952299118, -0.07543941587209702, 0.2706283628940582, 0.08787128329277039, 0.10140055418014526, 0.26852965354919434, -0.5909307599067688, 0.19821986556053162, 0.08937512338161469, 0.05567803606390953, -0.11613370478153229, 0.03911638632416725, 0.06315726786851883, 0.10782184451818466, -0.01980738714337349, 0.1451241374015808, -0.060943953692913055, -0.07014007121324539, 0.00016978045459836721, 0.17468222975730896, 0.06063257157802582, -7.286974141607061e-05, 0.0005939672118984163, 0.0018404772272333503, 0.001129048760049045, 0.00019233254715800285, 0.0019600382074713707, 0.07629802823066711, 0.0003428335185162723, -0.0005339051713235676, -0.00011325302330078557, -0.03201869875192642, 0.04179591313004494, -0.3185126781463623, 0.08271040767431259, 0.0021725951228290796, -0.16681934893131256, -0.031819552183151245, -0.3288743495941162, 0.0464513823390007, 0.17611919343471527, 0.000690086861141026, 7.961438677739352e-05, -0.00019473303109407425, -0.0969485193490982, -0.03324940800666809, -0.0008172128000296652, 0.22586534917354584, -0.2223370373249054, -0.05459794029593468, -9.828664769884199e-05, -0.14924103021621704, -0.03904952108860016, 0.2069503366947174, 0.07704979181289673, 0.1661059856414795, 0.14414143562316895, -0.23807625472545624, 0.10244176536798477, 0.09765428304672241, 0.08840622752904892, -0.024117084220051765, 0.0006691144080832601, 0.1786615550518036,

0.11667780578136444, 0.10861541330814362, 0.11338424682617188, -0.23225265741348267, -0.054111186414957047, 0.12930895388126373, -0.0307441595941782, -0.02359997294843197, -0.023976676166057587, -0.022300291806459427, -0.10048258304595947, 0.16049188375473022, -0.0047802492044866085, 0.040883637964725494, 0.0047388202510774136, 0.1291704773902893, -0.213030144572258, -0.07274895906448364, 0.000262087385635823, -0.03659924119710922, 0.05907992646098137, 0.0006437263218685985, -0.00039178295992314816, 0.0010649684118106961, 0.0009931239765137434, -0.001187134999781847, -0.00032986601581797004, 0.2431180775165558, 0.0009192879660986364, -0.2085084170103073, 0.0003986647061537951, -0.07371655851602554, 0.06816515326499939, -0.1429450958967209, -0.029881343245506287, -0.000824992370326072, -0.09339576214551926, -0.11395471543073654, 0.07046190649271011, -0.11395901441574097, 0.027631817385554314, -0.0014277909649536014, -0.0007467216928489506, 0.0006686572451144457, -0.053210023790597916, -0.14419393241405487, -0.0019058359321206808, 0.036102715879678726, -0.04545225203037262, 0.139390766620636, 0.00020870001753792167, -0.09519004821777344, -0.06584736704826355, 0.2246185541152954, 0.12797732651233673, 0.17647592723369598, 0.151839479804039, -0.12066972255706787, 0.12076413631439209, 0.023683056235313416, 0.007647241000086069, -0.04053515940904617, -0.10980767756700516, 0.07816174626350403,

0.061100080609321594, 0.11834853887557983, 0.10444382578134537, -0.26339831948280334, -0.055349256843328476, 0.12657754123210907, -0.0721798986196518, -0.009455498307943344, -0.09344962984323502, -0.0802626758813858, -0.09195737540721893, 0.19737976789474487, 0.0019429458770900965, 0.11292064189910889, 0.060309577733278275, 0.10732085257768631, -0.1505124568939209, -0.07656053453683853, 0.0009079906158149242, -0.04649633541703224, 0.04843819886445999, 0.00026802558568306267, 5.694820356438868e-05, 0.0008316751336678863, 0.0002835642662830651, 0.0023435538168996572, -0.0005214237025938928, 0.2892228364944458, 0.0005180890439078212, -0.24499383568763733, -0.0007466924726031721, -0.01638364978134632, 0.05805094540119171, -0.19633056223392487, 0.02277335338294506, -0.0004780170856975019, -0.09063353389501572, -0.14776253700256348, 0.11926158517599106, -0.09643642604351044, -0.012329957447946072, 0.0002932265342678875, -0.0010079203639179468, 0.0007461232598870993, -0.10432128608226776, -0.17565423250198364, -0.0005480855470523238, 0.1477205902338028, -0.04583200067281723, 0.16930179297924042, -0.0022354074753820896, -0.07354242354631424, -0.08135280013084412, 0.18026238679885864, 0.11273177713155746, 0.2046148031949997, 0.14012843370437622, -0.12387369573116302, 0.1051713153719902, 0.010817605070769787, -0.1169809103012085, -0.0354679673910141, -0.05115516483783722, 0.07571343332529068,

0.19351886212825775, 0.20593607425689697, 0.07896959036588669, -0.33665135502815247, -0.32912901043891907, 0.1311604529619217, -0.12087904661893845, -0.11019665747880936, -0.04586197808384895, -0.05841420218348503, -0.1608307659626007, 0.1279541403055191, -0.06888389587402344, 0.21972012519836426, 0.14308209717273712, 0.05686735361814499, -0.15417329967021942, -0.09022870659828186, -0.0011901074321940541, 0.09590200334787369, 0.04330392926931381, -5.3807907534064725e-05, 0.001777792233042419, 0.0006894676480442286, -0.00033517132396809757, -0.0005324449157342315, 0.0007019898039288819, 0.25493136048316956, 0.0005385744734667242, -0.1634291112422943, 0.0002379299548920244, -0.14627431333065033, -0.05289393663406372, -0.026358943432569504, -0.35610511898994446, 0.0010252121137455106, -0.07270371168851852, 0.08896159380674362, 0.36057522892951965, -0.037234626710414886, 0.1761675626039505, -0.0003619832277763635, 0.0015530900564044714, -0.00037672193138860166, -0.07125220447778702, -0.10503887385129929, 0.0010542566888034344, -0.0016337715787813067, -0.3988116979598999, 0.134470134973526, 0.0006067991489544511, -0.033088233321905136, -0.04511095583438873, 0.11759932339191437, 0.15916945040225983, 0.18349163234233856, 0.01695222593843937, -0.12615448236465454, 0.03231247141957283, -0.07025880366563797, 0.14372707903385162, 0.02411520481109619, -0.1478198766708374, 0.030958378687500954,

0.018110373988747597, 0.0032062772661447525, 0.17049916088581085, -0.06647303700447083, -0.011934344656765461, 0.17750558257102966, -0.24867764115333557, 0.044788628816604614, -0.04207496717572212, 0.05448312684893608, -0.19995054602622986, 0.15366168320178986, 0.026441816240549088, 0.02933470346033573, -0.012454435229301453, 0.14892686903476715, -0.10988327115774155, -0.08087613433599472, 0.0001221925049321726, 0.15185034275054932, 0.04708150774240494, 0.0001845993538154289, 0.0005538420518860221, 0.001505792373791337, -0.000440931529738009, 0.0009733336046338081, -0.0017067187000066042, 0.20057405531406403, -0.0008939944091252983, -0.050562240183353424, -0.0015461782459169626, -0.0059439134784042835, 0.058647263795137405, -0.17914725840091705, 0.05602758377790451, -0.0010231140768155456, -0.11976835131645203, -0.047966599464416504, -0.18322475254535675, -0.09234234690666199, 0.1217731386423111, -0.0010735170217230916, -0.00041024936945177615, 0.0027656294405460358, -0.10717014223337173, -0.09432367980480194, 0.0008920943364500999, 0.09821601212024689, -0.09381942451000214, 0.039275601506233215, 0.0005028316518291831, -0.1312291920185089, -0.049590714275836945, 0.22643135488033295, 0.11420116573572159, 0.19309410452842712, 0.15799318253993988, -0.1569855809211731, 0.11330551654100418, 0.05707332119345665, -0.01931406930088997, -0.07615601271390915, -0.1903579980134964, 0.1156894862651825,

0.29868146777153015, 0.2621471583843231, 0.0739680752158165, -0.29489800333976746, -0.2417578399181366, 0.17589415609836578, -0.27745792269706726, -0.10191231220960617, -0.08991255611181259, -0.14531028270721436, -0.03777451440691948, 0.05493539199233055, -0.08815383911132812, 0.3060028553009033, 0.021281538531184196, 0.11163488030433655, -0.28069040179252625, -0.08377792686223984, -0.000337329605827108, 0.2569867670536041, -0.09372756630182266, 0.0003124471986666322, -0.0016112583689391613, 0.003361871698871255, -0.0012185999657958746, 0.00024745031259953976, 0.0016050598351284862, 0.3054409921169281, 0.0014631702797487378, -0.08110663294792175, 0.0004203330900054425, -0.2962694466114044, -0.08452557027339935, -0.2335229068994522, -0.3915978968143463, -0.003352527040988207, -0.26286593079566956, -0.11437088996171951, 0.347025066614151, 0.015164190903306007, 0.27905312180519104, -8.584331226302311e-05, -0.0015158120077103376, -0.001472564646974206, -0.22591261565685272, -0.2607177793979645, 0.0001534872135380283, 0.2501680850982666, -0.25719815492630005, 0.3345649838447571, -0.0002178192517021671, -0.11384007334709167, -0.1319349855184555, 0.06937117129564285, 0.21919402480125427, 0.21284064650535583, 0.06282124668359756, 0.010206482373178005, -0.04854616895318031, -0.06433264911174774, 0.1578097641468048, -0.08521135151386261, -0.055268801748752594, 0.07648278772830963,

-0.00010575991473160684, 0.04665142670273781, -0.027792232111096382, 0.01500304602086544, 0.04195406660437584, 0.031171903014183044, 0.010691693983972073, 0.02777182310819626, -0.12541678547859192, -0.02871341072022915, 0.021159546449780464, 0.02487073466181755, -0.15170784294605255, 0.00523396534845233, 0.10481467843055725, -0.0001556316128699109, 0.006126591004431248, 0.05031902715563774, -0.0007278556004166603, 0.05776864290237427, -0.10945794731378555, 0.0001513513852842152, -9.668108395999297e-05, -0.0012627975083887577, 0.001964129041880369, -0.0014381138607859612, -0.0002854411432053894, 0.0322754941880703, -0.0009819171391427517, 0.011005657725036144, 0.00159688841085881, -0.020184390246868134, -0.0731026902794838, -0.0316985547542572, -0.06435973942279816, 0.0003220072539988905, -0.04301263019442558, 0.0711648091673851, 0.039700645953416824, 0.0003244304098188877, -0.047405045479536057, -0.0007848550449125469, 0.00013456093438435346, -0.0005822238745167851, -0.0017034433549270034, -0.007983226329088211, -0.00011821248335763812, 0.1486232429742813, -0.021435147151350975, 0.006910500582307577, 0.0007702793809585273, 0.031719792634248734, -0.05022577568888664, 0.0721825510263443, -0.09057949483394623, 0.0737101137638092, -0.05377780273556709, 0.0665883719921112, -0.21249739825725555, 0.015977008268237114, -0.00941646657884121, 0.11146848648786545, -0.0005758441402576864, 0.0472751222550869,

0.781975507736206, 0.37960657477378845, 0.03272693231701851, -0.28089267015457153, 0.22352634370326996, -0.12401213496923447, -0.4067041873931885, -0.3048173785209656, -0.35138216614723206, -0.23154616355895996, -0.10113122314214706, 0.3372840881347656, -0.2702421247959137, 0.27499210834503174, -0.09876541048288345, 0.13186600804328918, 0.07296609878540039, -0.19797584414482117, 0.0011230787495151162, 0.1960086077451706, 0.16111373901367188, 0.0005952963838353753, 0.00046917094732634723, 0.0044456892646849155, 0.0007404674543067813, -0.00024113738618325442, -0.0016018481692299247, 0.21070629358291626, 0.0005836702766828239, -0.1405683010816574, -0.0016807341016829014, -0.10318609327077866, 0.12230227142572403, 0.05313204228878021, -0.2396201193332672, -0.0012194296577945352, 0.026986459270119667, -0.14691154658794403, 0.42727014422416687, 0.09681635349988937, -0.1673794686794281, -0.0004913041484542191, 4.6706092689419165e-05, 0.0014882906107231975, -0.09899148344993591, -0.025237521156668663, 0.0008506514132022858, 0.05678943917155266, -0.5185197591781616, 0.10666226595640182, -0.00023312223493121564, -0.007294082082808018, -0.13186568021774292, 0.23598931729793549, 0.20316912233829498, 0.566847562789917, -0.07514189183712006, -0.20775924623012543, -0.11928928643465042, 0.20094870030879974, 0.6164610385894775, -0.04960522800683975, -0.022526942193508148, -0.028901606798171997,

0.21188300848007202, 0.2405261993408203, -0.07698339223861694, -0.13883154094219208, -0.055531032383441925, -0.2375558614730835, 0.28573524951934814, 0.03992413356900215, -0.9206651449203491, -0.013998176902532578, -0.12727387249469757, 0.3952792286872864, 0.07067631930112839, 0.1806037425994873, 0.1761077344417572, 0.05328483134508133, -0.30852004885673523, -0.3813927471637726, 0.0009541350300423801, 0.30039337277412415, 0.1905553936958313, -0.0005604876787401736, 0.0019473531283438206, 0.0032517502550035715, 0.00010508529521757737, -0.001481074490584433, 0.0004614403878804296, 0.20663593709468842, 0.0007600265089422464, -0.12085086107254028, -0.0010492709698155522, 0.09087085723876953, 0.05694036930799484, -0.3447076082229614, -0.09469543397426605, 0.0001678231346886605, -0.2950378656387329, -0.36681267619132996, 0.21864719688892365, -0.14170704782009125, 0.4879303276538849, 0.0011960845440626144, -6.022544403094798e-05, 0.0005331283900886774, -0.16001726686954498, 0.03743210434913635, -0.00021726726845372468, 0.3313266932964325, -0.30647024512290955, 0.27082064747810364, 9.696875349618495e-05, -0.30780351161956787, -0.1308862566947937, 0.3703761100769043, 0.42197176814079285, 0.3842725157737732, 0.04671148210763931, -0.06044485419988632, 0.20956452190876007, -0.0273875929415226, -0.06308720260858536, -0.12154579907655716, -0.5266167521476746, -0.2093556523323059,

0.024492472410202026, -0.01688135415315628, 0.1614481657743454, -0.08910459280014038, -0.00625749072059989, 0.1662115603685379, -0.24252848327159882, 0.019117627292871475, -0.11481768637895584, 0.09575249254703522, -0.24898689985275269, 0.1546192616224289, 0.008766685612499714, 0.03397709131240845, -0.04453384503722191, 0.13077662885189056, -0.09351975470781326, -0.13370542228221893, -0.0009880498982965946, 0.16824176907539368, 0.03804728016257286, 0.0001322835887549445, -0.0006708246073685586, -0.0007444632356055081, 0.0006262425449676812, -0.0008887790027074516, 0.0017322112107649446, 0.2981349229812622, -0.00025256158551201224, -0.07412469387054443, -0.000709141546394676, 0.06684921681880951, 0.04770127311348915, -0.18591390550136566, 0.18864713609218597, -0.00014441998791880906, -0.13065147399902344, -0.1551971286535263, -0.24286536872386932, -0.15781882405281067, 0.07999241352081299, 0.00010765799379441887, -0.0006827941397204995, 0.0019762900192290545, -0.049114152789115906, -0.1470019519329071, 0.00040130404522642493, 0.15922510623931885, -0.0737387165427208, 0.06720581650733948, 0.00010335831757402048, -0.10612066090106964, -0.05503140762448311, 0.22272370755672455, 0.14349280297756195, 0.18940821290016174, 0.14842472970485687, -0.0762753039598465, 0.09673067927360535, 0.030849341303110123, -0.2037247270345688, -0.09014026075601578, -0.2943384647369385, 0.0990203395485878,

-0.030464544892311096, 0.11649622768163681, 0.12869562208652496, -0.2019595354795456, -0.19043362140655518, 0.16854296624660492, -0.130128875374794, -0.01962784118950367, -0.2848023772239685, -0.07435786724090576, -0.16502301394939423, 0.1924588829278946, 0.0041489615105092525, 0.09214484691619873, 0.1567409336566925, 0.09973850846290588, -0.16423098742961884, -0.07790619134902954, -6.373770884238183e-05, 0.1647956520318985, 0.05766422674059868, -0.00039432113408111036, 0.0013715368695557117, 0.0007824432686902583, 0.00029224393074400723, 0.00017986197781283408, -0.0003319591924082488, 0.24195845425128937, -7.136537897167727e-05, -0.13562294840812683, -0.000933053728658706, -0.07413394749164581, 0.08342456072568893, -0.15317930281162262, -0.19517791271209717, 0.00148514355532825, -0.029484964907169342, 0.001942847273312509, 0.057081129401922226, -0.22925201058387756, 0.146196186542511, 0.0012510264059528708, 0.00010126081178896129, -0.0003905408666469157, -0.24597647786140442, -0.16584426164627075, 0.0012137924786657095, 0.07583404332399368, -0.08079935610294342, 0.06291083246469498, -0.0005715941078960896, -0.15605197846889496, -0.07930884510278702, 0.2294745296239853, 0.12577450275421143, 0.1095908135175705, 0.1091529130935669, -0.24638739228248596, 0.09495566040277481, 0.01805233396589756, 0.10493237525224686, 0.09752503782510757, -0.03345528244972229, 0.09173640608787537,

0.035121917724609375, -0.012224041856825352, 0.22503045201301575, 0.061404041945934296, 0.061417434364557266, 0.23071503639221191, -0.36218610405921936, 0.13237452507019043, 0.11726908385753632, 0.06162475049495697, -0.09451764076948166, 0.04841994494199753, 0.06916531920433044, 0.005315071437507868, -0.033620934933423996, 0.17620307207107544, -0.18929144740104675, -0.002844623988494277, -9.99654148472473e-05, 0.09864691644906998, 0.08314168453216553, -0.0009181399364024401, 0.0010274209780618548, 0.0025985620450228453, -0.0007772474782541394, -0.0005799527280032635, -0.0003456129925325513, 0.03559359163045883, 1.361823160550557e-05, -0.030749648809432983, 0.0016638300148770213, -0.09849388897418976, 0.08416562527418137, -0.2074243724346161, -0.0394037663936615, -0.0003693282196763903, -0.13116320967674255, 0.04843345284461975, -0.23493613302707672, -0.0196854118257761, 0.19204646348953247, -0.000498787616379559, 0.0011031931499019265, 0.0015117436414584517, -0.07586933672428131, -0.011957114562392235, -0.0009661896037869155, 0.014168323948979378, -0.13225039839744568, -0.025543833151459694, 0.0007655065855942667, -0.1791975051164627, -0.03549480065703392, 0.2630745768547058, 0.06795809417963028, 0.16245238482952118, 0.1785755604505539, -0.24873539805412292, 0.1459806114435196, 0.10194675624370575, 0.26067620515823364, -0.034242063760757446, -0.08598243445158005, 0.1556018888950348,

0.026411421597003937, 0.1371377408504486, 0.1032228097319603, -0.2804514169692993, -0.13542413711547852, 0.11264710128307343, -0.08351562172174454, -0.02179337479174137, -0.06979263573884964, -0.061935409903526306, -0.13550320267677307, 0.23030072450637817, -0.00871200766414404, 0.10866809636354446, 0.0497213639318943, 0.11688140779733658, -0.1250639259815216, -0.09306376427412033, -0.00022386127966456115, -0.004283077549189329, 0.04169982299208641, 0.0009118496673181653, -0.0008109525078907609, 0.0007483593071810901, 0.0006327131413854659, 0.00017271233082283288, -0.001036191126331687, 0.30264371633529663, 0.0011931763729080558, -0.21438635885715485, -0.0009880413999781013, -0.050168510526418686, 0.04696370288729668, -0.16580359637737274, -0.05413884297013283, -0.0019725554157048464, -0.08276491612195969, -0.10874659568071365, 0.14453460276126862, -0.04755062982439995, 0.006570218130946159, 0.0006489380612038076, -0.0020688786171376705, -0.0007024707738310099, -0.1325901448726654, -0.1628909409046173, -0.0007988433353602886, 0.07362775504589081, -0.05793583020567894, 0.14488251507282257, -0.00014863298565614969, -0.051708512008190155, -0.06531919538974762, 0.17627118527889252, 0.13228054344654083, 0.1856907606124878, 0.13333867490291595, -0.11718687415122986, 0.09605160355567932, 0.016215788200497627, -0.07810702174901962, -0.04658879339694977, -0.02942507155239582, 0.07355301827192307,

0.07738786935806274, 0.2557215988636017, -0.04797876626253128, -0.27457714080810547, -0.31406286358833313, -0.0053909714333713055, 0.06608100235462189, -0.03574952483177185, -0.18250392377376556, -0.026767071336507797, -0.3163924217224121, 0.32746946811676025, 0.028152136132121086, 0.0840410441160202, 0.16643166542053223, 0.1446515917778015, -0.15841087698936462, -0.05994470417499542, 0.0003715221246238798, 0.21763429045677185, -0.026036810129880905, 0.0009066544589586556, 0.0020251532550901175, 0.00112155731767416, -2.7174330170964822e-05, -0.00023491682077292353, -0.0008873417391441762, 0.19854094088077545, -0.0005235429271124303, -0.11500878632068634, 0.00032298933365382254, -0.1693935990333557, 0.06887480616569519, -0.2119518220424652, -0.3423440158367157, 0.0012092364486306906, -0.013734867796301842, -0.0653458759188652, 0.15181542932987213, -0.31960684061050415, 0.041757192462682724, -0.00014504468708764762, -0.00021558062871918082, 0.0019134348258376122, -0.39524045586586, -0.22582143545150757, 0.00033609752426855266, -0.04095302149653435, -0.316020667552948, 0.11691403388977051, 0.0013048043474555016, -0.08292253315448761, -0.11387242376804352, -0.0203652735799551, 0.22901533544063568, 0.18764251470565796, 0.1956499069929123, -0.26261869072914124, 0.09850314259529114, 0.0586855448782444, 0.3142436742782593, -0.2335508018732071, -0.28227970004081726, 0.05928327143192291,

0.4220556616783142, 0.13853681087493896, -0.07974079251289368, -0.28322118520736694, -0.40077316761016846, -0.09291478991508484, 0.06344619393348694, 0.015596907585859299, 0.08445969969034195, -0.35864076018333435, -0.3662203550338745, 0.5097247362136841, 0.27634140849113464, -0.19642598927021027, 0.25680243968963623, 0.13327637314796448, 0.280800998210907, 0.2786795496940613, -4.945172258885577e-05, 0.30511370301246643, 0.2847779095172882, 0.0007782087195664644, 0.0004407037631608546, 0.0006270427256822586, 0.0011128803016617894, 0.0015029642963781953, -0.0013614558847621083, 0.03007437475025654, 0.00024808960733935237, -0.23818452656269073, -0.0002574801037553698, -0.6114383935928345, -0.17171214520931244, -0.09153186529874802, -0.6117807626724243, -0.0009181717759929597, -0.0967414379119873, -0.4326273202896118, 0.4761175513267517, -0.21955332159996033, 0.0667901486158371, -0.0001348876248812303, -0.000852166092954576, 0.00013284964370541275, -0.059048935770988464, -0.09228495508432388, 0.0007294120150618255, 0.546248733997345, 0.14149892330169678, -0.01085625495761633, -0.0003078498411923647, -0.21022716164588928, -0.029572339728474617, -0.24736040830612183, 0.40329939126968384, 0.9525308609008789, 0.09457506984472275, -0.754457414150238, 0.30124425888061523, 0.021452993154525757, 0.4867626130580902, -0.11234220862388611, -0.37761691212654114, -0.018424540758132935,

0.07296043634414673, 0.059598665684461594, 0.15687276422977448, -0.0901293158531189, -0.051758281886577606, 0.1581657975912094, -0.1850733757019043, 0.03285215422511101, 0.05787590891122818, 0.030771929770708084, -0.11312294751405716, 0.11000683903694153, 0.023252423852682114, 0.005411882884800434, -0.0015659639611840248, 0.1528671681880951, -0.20434851944446564, -0.04512418434023857, -0.0005631562089547515, 0.06380896270275116, 0.06644926220178604, 0.0019462676718831062, 0.0009024663595482707, -0.00042241447954438627, 0.0011456989450380206, -0.0002029708557529375, -0.00033927091863006353, 0.12988103926181793, 0.0015715904301032424, -0.11117144674062729, -0.00038432778092101216, -0.12948954105377197, 0.07843686640262604, -0.14989915490150452, -0.09634395688772202, -0.0008795724133960903, -0.10043833404779434, 0.0174106415361166, -0.06870433688163757, -0.04150473698973656, 0.12913593649864197, -0.000440707168309018, -0.001461806590668857, 0.0006592623540200293, -0.09094303101301193, -0.07315244525671005, 0.0005479883984662592, -0.02734993025660515, -0.08471165597438812, 0.05207296088337898, 0.0007967037963680923, -0.128276526927948, -0.04384586215019226, 0.23764999210834503, 0.10660409927368164, 0.14838819205760956, 0.1610168069601059, -0.18025170266628265, 0.12617826461791992, 0.06321094930171967, 0.19476288557052612, -0.047945622354745865, -0.09910640120506287, 0.10489463061094284,

0.31174272298812866, 0.17876870930194855, 0.0671195387840271, -0.3080553710460663, -0.09571441262960434, 0.10039818286895752, 0.07631450891494751, -0.0675632655620575, -0.24513782560825348, -0.15668077766895294, 0.05690973624587059, 0.026750029996037483, 0.08245972543954849, 0.1525106430053711, 0.24399538338184357, 0.06084120273590088, -0.3411810100078583, 0.07206688076257706, 0.00015646808606106788, -0.091340072453022, 0.10626246780157089, -0.0014722481137141585, 0.0016895094886422157, 0.002699741395190358, -0.001371864229440689, -0.0026647173799574375, -0.0008388282731175423, 0.21276696026325226, 0.00016302347648888826, -0.3645952343940735, -0.0008157907286658883, -0.2292739599943161, 0.03067493438720703, -0.1424441635608673, -0.23961757123470306, 0.00041020888602361083, -0.01843574270606041, 0.02354291081428528, 0.15005604922771454, -0.18100228905677795, 0.1082988977432251, 0.0004687744367402047, -0.0012580720940604806, 0.0012965286150574684, -0.03979327157139778, -0.2458619326353073, 0.00038768877857364714, -0.056720197200775146, 0.0029552646446973085, 0.16940858960151672, 0.0005496086669154465, -0.18932172656059265, -0.10476215183734894, 0.32681241631507874, 0.08416284620761871, 0.1447017639875412, 0.05377953499555588, -0.10248151421546936, 0.1314099282026291, -0.033546920865774155, 0.32360348105430603, 0.19320127367973328, -0.024356121197342873, 0.005296692252159119,

0.4052349328994751, 0.49614378809928894, 0.13982562720775604, -0.007345773745328188, -0.4696809649467468, 0.14894501864910126, -0.46269744634628296, -0.3503655195236206, -0.1077059730887413, -0.08109541982412338, -0.6809036731719971, 0.20223145186901093, 0.026866978034377098, 0.3777364194393158, 0.481438010931015, 0.10477909445762634, -0.13513599336147308, -0.0812123492360115, 0.0014552903594449162, -0.06327852606773376, -0.02870774269104004, 0.0004329517832957208, -0.0011517673265188932, 0.0015288515714928508, -0.0006172074936330318, 0.0008385198307223618, 0.0010456811869516969, 0.01569998636841774, -0.0006724033737555146, -0.12893185019493103, -0.0004979344084858894, -0.32698556780815125, 0.01128858420997858, -0.23095175623893738, -0.26603373885154724, 0.0017219865694642067, -0.1702866554260254, -0.710411012172699, 0.46758681535720825, -0.21591220796108246, 0.27160272002220154, 0.00028149038553237915, -0.0004901826032437384, 0.0005413974868133664, -0.37873539328575134, -0.00503732031211257, -0.0004305214388296008, 0.31203070282936096, 0.22263260185718536, 0.04931274801492691, 0.001340289949439466, 0.0394599512219429, -0.14459095895290375, -0.12290305644273758, 0.19186249375343323, 0.48828527331352234, -0.05747799947857857, -0.23646961152553558, -0.07343593239784241, 0.271612286567688, 0.6543834805488586, -0.2427511215209961, -0.4466550946235657, 0.16535279154777527,

-0.2479468435049057, 0.06146467104554176, 0.17414550483226776, 0.016206011176109314, -0.5824593305587769, 0.05943576991558075, -0.7229606509208679, -0.02598274126648903, -0.04847854748368263, 0.08963076770305634, 0.06716503202915192, -0.10923458635807037, -0.040528614073991776, 0.10978879779577255, 0.015184581279754639, 0.10107836872339249, -0.3244306445121765, -0.21291957795619965, 8.499811769979715e-07, -0.03931288421154022, 0.14752653241157532, -7.933970482554287e-05, -0.0018961630994454026, 0.0029354626312851906, 0.0002081806305795908, 0.0016619798261672258, -0.0005892612389288843, -0.12100479751825333, 0.00015967310173437, -0.28751471638679504, 0.0007489687413908541, -0.4753653407096863, 0.05302731320261955, -0.1765511929988861, -0.36400631070137024, 8.51985314511694e-05, -0.13303719460964203, 0.23279732465744019, 0.10961515456438065, -0.04283628612756729, 0.17726311087608337, 0.0026858814526349306, -0.0006007496849633753, -0.0013181654503569007, -0.2937462329864502, -0.057609207928180695, -0.0008921355474740267, -0.019780876114964485, -0.6995654106140137, 0.12351425737142563, 0.0019983360543847084, -0.05452769994735718, -0.0644039660692215, 0.20872725546360016, -0.14296092092990875, -0.33345451951026917, 0.07298847287893295, 0.09911219030618668, 0.0946020781993866, 0.04455017298460007, 0.4430745542049408, -0.16802725195884705, 0.022962426766753197, 0.008335250429809093,

4.970770169165917e-05, -0.0025146163534373045, 2.311794742126949e-05, 1.5305355191230774e-05, 0.0014284845674410462, -0.00043277646182104945, 0.00029742848710156977, 0.00020736988517455757, -0.0009878313867375255, -0.0017866966081783175, 0.0002106996689690277, -0.0007617949158884585, 0.0006641677464358509, 0.0011071038898080587, 0.001078135916031897, -0.003074847860261798, -0.000611280498560518, 0.0005082837305963039, 0.0025799130089581013, 0.001191113842651248, -0.0017789171542972326, 0.0015459605492651463, -0.0004226936143822968, 0.00028610375011339784, -0.0009467246127314866, -0.0005137818516232073, 0.0004890620475634933, 0.0006118919118307531, 0.0008442935068160295, -0.0006955136777833104, 0.0007786106434650719, -0.0008063556742854416, -0.001883144024759531, 0.0027368501760065556, 0.0005387529381550848, 0.0017444468103349209, 0.001049600075930357, 0.00025057903258129954, 0.0010602751281112432, 0.0009044823818840086, -0.0009020579745993018, -0.0009210603893734515, -0.00040788849582895637, -0.0010924988891929388, 0.0005280947079882026, 0.001131681026890874, -0.0007959590293467045, 0.0010164364939555526, -6.472439417848364e-05, -0.0016699479892849922, -0.0007493608281947672, -0.0006797112873755395, -0.0009642835357226431, -0.0027087812777608633, -0.0005998702254146338, 0.00010552174353506416, -0.0009133603889495134, -0.0018779592355713248, 2.6404981326777488e-05, -6.863032467663288e-05, -0.0007041083299554884, 0.0013223381247371435, -0.00032540818210691214, -0.0013105971738696098,

0.2008306086063385, 0.23285944759845734, 0.032523319125175476, -0.3651238679885864, -0.4688774347305298, -0.265067994594574, -0.3326340317726135, -0.06471677124500275, -0.7383081912994385, -0.1875872015953064, -0.20191927254199982, 0.28061121702194214, 0.1835753619670868, -0.0011513835052028298, -0.27076488733291626, 0.20028293132781982, -0.2847100496292114, -0.19433282315731049, -0.0007925034151412547, 0.005094475578516722, 0.21328584849834442, 0.0005703603965230286, -0.0004742382443509996, 0.001109711010940373, -0.00021286675473675132, 0.001028736005537212, -0.00041788932867348194, 0.17428971827030182, 4.756428825203329e-05, -0.2271847277879715, 0.001528558204881847, -0.06005639582872391, -0.04465782269835472, -0.08158594369888306, 0.15957322716712952, -0.0010575406486168504, -0.22036440670490265, -0.2788655459880829, 0.2829512357711792, -0.023275787010788918, 0.03609989956021309, 0.0005879831733182073, 0.0012141724582761526, -0.0008610974764451385, -0.09079775959253311, -0.09200086444616318, 9.190638229483739e-05, 0.11324892938137054, -0.24395419657230377, 0.20444488525390625, -0.001347557408735156, 0.0043305507861077785, -0.01617995835840702, 0.5016491413116455, 0.5222550630569458, 0.11929945647716522, 0.07638437300920486, -0.1246342808008194, 0.1602180153131485, 0.14887090027332306, -0.06664828211069107, -0.33419695496559143, 0.44983458518981934, -0.16605113446712494,

-0.28657612204551697, 0.10606735944747925, 0.19532410800457, -0.018673300743103027, -0.3525301516056061, 0.17785897850990295, -0.6952473521232605, -0.03807840868830681, -0.27942490577697754, -0.0858394056558609, 0.009105074219405651, -0.11475539952516556, 0.04365213215351105, 0.23203201591968536, 0.1461806446313858, 0.03170369565486908, -0.11271949112415314, -0.15111447870731354, 4.355954661150463e-05, 0.05246283486485481, 0.2124815434217453, -0.00018582690972834826, 7.506563179049408e-06, 0.0030571287497878075, 0.0004258464905433357, -0.00036943473969586194, 0.0002402888931101188, 0.234027698636055, 0.0011033815098926425, -0.31993141770362854, 0.0012660169741138816, -0.07348214834928513, 0.007266503293067217, -0.3315317928791046, -0.08673960715532303, -0.0005167861236259341, -0.14679645001888275, 0.02549666538834572, 0.056328680366277695, -0.20351658761501312, 0.16413918137550354, -0.0010637915693223476, 0.0009137586457654834, -0.002721658907830715, -0.3825833797454834, -0.1024346575140953, 6.492737884400412e-05, 0.14496567845344543, -0.5215505957603455, 0.1925288736820221, 0.000574815203435719, -0.021673772484064102, -0.1108362153172493, 0.2138546258211136, 0.03116424009203911, -0.18227392435073853, 0.03188356012105942, -0.011020283214747906, 0.1178126409649849, -0.0004974040784873068, -0.0630144402384758, 0.03483017534017563, -0.052280452102422714, 0.045389324426651,

0.0005521097918972373, 0.017729170620441437, -0.1722581833600998, 0.0037039422895759344, 0.001567360362969339, -0.10055038332939148, 0.021108632907271385, 0.020772647112607956, 0.14595064520835876, -0.04253007844090462, 0.013751122169196606, 0.0076897949911653996, 0.04191797226667404, 0.01694018393754959, 0.002107905922457576, -0.06683442741632462, 0.020539015531539917, 0.02914385125041008, -7.801321044098586e-05, 0.00048368109855800867, -0.01766815409064293, -0.0005448150914162397, 0.0010524365352466702, -0.0007671643979847431, -0.00012459020945243537, 0.0008768694824539125, -0.0005135779501870275, -0.0037997858598828316, 0.00038613981450907886, 0.014108768664300442, 0.0006932157557457685, -0.0067222160287201405, -0.0209006667137146, 0.026551542803645134, -0.0011496779043227434, -0.0007507435511797667, 0.02834414131939411, 0.009201196022331715, 0.0057718404568731785, 0.02169930189847946, -0.014502635225653648, -3.491714596748352e-05, -0.0003578605828806758, -0.001178428647108376, 0.06057244539260864, 0.020316433161497116, -0.0011969138868153095, -0.04873412102460861, 0.023842258378863335, -0.023542333394289017, 0.0017061911057680845, 0.021966224536299706, 0.0003367953177075833, -0.1909828633069992, 0.06507214158773422, -0.02517489530146122, -0.04564562439918518, 0.030473219230771065, -0.035557761788368225, 0.0190313421189785, 0.025006592273712158, 0.0028738449327647686, 0.013087435625493526, -0.017678551375865936,

0.5722816586494446, 0.44931724667549133, 0.033467985689640045, -0.05215294659137726, -0.1651076078414917, 0.09514902532100677, -0.2535097599029541, -0.31727728247642517, 0.020857004448771477, 0.01630846969783306, -0.09314350038766861, 0.1957118958234787, -0.39591383934020996, 0.26922011375427246, 0.3317633271217346, 0.11175347119569778, -0.2671031951904297, -0.056412164121866226, -0.0015118089504539967, 0.2937302589416504, 0.1793442815542221, -0.001025194302201271, 0.0010095476172864437, 0.0035850228741765022, 0.0006587953539565206, 0.000939257733989507, 0.0003379232657607645, 0.3479364216327667, -0.0004258739354554564, -0.0808158591389656, 0.00038307232898660004, -0.011362356133759022, -0.0033058011904358864, -0.08819703757762909, -0.32478445768356323, -0.0011537037789821625, -0.273912638425827, -0.11553899198770523, 0.17199908196926117, -0.0041303266771137714, 0.41343948245048523, 0.0003570480039343238, 0.0014987858012318611, 0.0013575225602835417, -0.55711829662323, -0.28808870911598206, -0.002448621904477477, 0.17940248548984528, -0.20062221586704254, 0.31715089082717896, 0.0008355412282980978, -0.07066480815410614, -0.13722951710224152, -0.10970398038625717, 0.05873332545161247, 0.24034948647022247, 0.182510644197464, 0.11015398055315018, 0.24339579045772552, -0.04150482639670372, 0.19960984587669373, -0.15185965597629547, -0.27342841029167175, 0.13767993450164795,

0.22348885238170624, -0.008877726271748543, -0.171895369887352, -0.43331223726272583, 0.20232950150966644, 0.043170031160116196, -0.36004438996315, -0.006740920711308718, 0.18264558911323547, -0.11805032193660736, -0.07412461191415787, 0.032417088747024536, 0.051556725054979324, 0.08561589568853378, 0.4091699719429016, -0.0786430686712265, -0.22887086868286133, -0.2439272403717041, 0.00014124371227808297, 0.6468839049339294, -0.036077044904232025, -0.0014531002379953861, -0.0011161002330482006, 0.003305896883830428, 0.0017938324017450213, -3.7506528315134346e-05, -0.0016759017016738653, 0.40134409070014954, -0.0007333348621614277, -0.2809791564941406, -0.001019181334413588, 0.019602011889219284, 0.09314858913421631, -0.5306268334388733, 0.17580009996891022, -1.5525150956818834e-05, -0.2091640830039978, -0.6634456515312195, -0.14848995208740234, -0.06595541536808014, -0.034880805760622025, -1.1966582178501994e-06, 0.00036120228469371796, -0.0012568037491291761, -0.10609765350818634, -0.5816946625709534, -0.0006648825947195292, 0.4456590414047241, -0.512170672416687, 0.24637466669082642, 0.0010917421896010637, -0.23795755207538605, -0.2328575998544693, -0.07656370103359222, 0.33030301332473755, 0.2731899917125702, 0.09424741566181183, -0.1698189079761505, 0.01702292636036873, -0.10659436136484146, 0.11089695990085602, -0.08941251039505005, -0.35293179750442505, 0.06545879691839218
};

/// Second convolution biases
static const double conv2_biases[] = {
0.12326373159885406,
0.13270756602287292,
0.07082673907279968,
0.051456157118082047,
0.05844561755657196,
0.1315319687128067,
0.08097290247678757,
0.10153213143348694,
0.055915363132953644,
0.052281659096479416,
-0.11212895810604095,
0.07462140917778015,
-0.10300768911838531,
0.108175128698349,
0.15686865150928497,
0.18225829303264618,
0.06780990958213806,
-0.027867194265127182,
0.10957542806863785,
0.03425288572907448,
0.05988423153758049,
-0.04818560183048248,
0.07478125393390656,
-0.07338137924671173,
-0.022100606933236122,
-0.04947621747851372,
0.00016185229469556361,
0.16787314414978027,
-0.08640440553426743,
0.060469429939985275,
-0.17337509989738464,
0.26549988985061646
};

/// Third convolution kernel
static const double conv3_kernel[] = {
-0.01733648031949997, 0.014926089905202389, 0.019393086433410645, -0.00444532185792923, 0.02693970873951912, 0.0003883102326653898, 0.004221527837216854, 0.0050745452754199505, 0.012986100278794765, 0.008007168769836426, 0.008950762450695038, 0.005279690958559513, 0.01519874669611454, -0.010862989351153374, 0.011825689114630222, -0.019965801388025284, 0.007991938851773739, -0.004620695952326059, 0.011911056004464626, 0.0043943473137915134, -0.01527450606226921, 0.007058924064040184, 0.010290278121829033, 0.013065044768154621, -0.010343007743358612, 0.017746344208717346, -4.6092932279862e-06, -0.0030044177547097206, 0.004238004796206951, 0.011623515747487545, 0.004292194731533527, 0.003601675620302558, 0.02504684589803219, -0.012476416304707527, -0.001889116014353931, -0.014844696037471294, 0.0037114194128662348, 0.0015292391180992126, -0.01960979402065277, -0.023836420848965645, -0.004658454097807407, -0.005420898552983999, -0.011578674428164959, -0.012782600708305836, -0.013413185253739357, -0.0026978880632668734, -0.008449232205748558, -0.001977386884391308, -0.009994491934776306, -0.019018622115254402, -0.01420928630977869, -0.010814856737852097, -0.012635751627385616, -0.02571050450205803, -0.011209324933588505, 0.006185243371874094, -0.028722697868943214, -0.015991590917110443, -7.262170129251899e-06, 0.0059218574315309525, -0.012753800489008427, 0.004631821997463703, -0.012866009026765823, -0.015347815118730068, 0.015386374667286873, 0.023364262655377388, -0.008774848654866219, 0.0003316070360597223, -0.013394287787377834, 0.01839779131114483, -0.0010600975947454572, 0.0013282642466947436, -0.0046541206538677216, -0.003481027204543352, -0.03873523697257042, 0.00432006549090147, -0.012688318267464638, 0.005344531964510679, -0.029875176027417183, 0.009807406924664974, 0.013965515419840813, -0.003954270388931036, -0.002595012541860342, -0.01060534082353115, -0.022159360349178314, -0.04049196094274521, -0.00826672650873661, -0.019309749826788902, -0.005398318637162447, -0.02717643231153488, -7.683406693104189e-06, 0.005884414538741112, -0.0025554620660841465, 0.003152097575366497, 0.007737628649920225, -0.0016007261583581567, 0.009788384661078453, -0.00019503672956489027, -0.016453150659799576, -0.009283055551350117, -0.023557187989354134, 0.0199913140386343, -0.0016918116016313434, 0.006789462175220251, -0.015027258545160294, -0.013967354781925678, -0.025483066216111183, -0.0011143273441120982, -0.024852922186255455, -0.0025222464464604855, -0.006810196675360203, -0.00522286631166935, 0.003403729060664773, -0.00575729925185442, 3.009885585925076e-05, -0.01669410802423954, -0.02657824568450451, -0.0558585524559021, -0.010408259928226471, -0.02449175715446472, -0.01373971812427044, -0.0016934958985075355, -6.971432412683498e-06, 0.016726776957511902, 0.012803487479686737, 0.0015065578045323491, -0.009287698194384575, -0.026466000825166702, 0.011461018584668636, 0.01290250662714243, 0.011383261531591415, -0.014642436988651752, 0.0025061562191694975, -0.005041358061134815, 0.020811449736356735, 0.036239612847566605, 4.4364631321514025e-05, -0.0060895150527358055, -0.0045987810008227825, 0.013829104602336884, -0.009625028818845749, -0.0024851823691278696, 0.011963721364736557, 0.005744087975472212, 0.004409838002175093, -0.002875274745747447, 0.03727300092577934, -0.00797036848962307, -0.023841897025704384, -0.020694682374596596, 0.01830098032951355, -0.0013982733944430947, -0.029326260089874268, 0.03960532322525978, -4.999998509447323e-06, 0.002121264347806573, 0.017022226005792618, 0.00307935057207942, 0.004140383563935757, -0.024156462401151657,
-0.006691846530884504, 0.014618276618421078, 0.0088097108528018, -0.003097307402640581, 0.0045377472415566444, 0.022115124389529228, 0.0010284727904945612, -0.011907028965651989, 0.003773882519453764, -0.003491810755804181, -0.001970492536202073, -0.0022535324096679688, -0.0008858706569299102, -0.009839004836976528, -0.011421483010053635, 0.02180883288383484, -0.0011487964075058699, -0.004101413302123547, -0.00041377657908014953, -0.0025395506527274847, -0.017455890774726868, -0.01648567058146, 0.0025676502846181393, 0.007391395978629589, -0.049815498292446136, -0.008180997334420681, -5.978379249427235e-06, 0.01758566126227379, -0.011831379495561123, 0.011075240559875965, -0.01834580861032009, -0.02892209403216839, -0.008543230593204498, -0.02222561091184616, 0.00198202021420002, -0.0173275638371706, -0.002889616647735238, -0.016437765210866928, -0.0019898039754480124, -0.0046544563956558704, -0.005625379737466574, -0.012663842178881168, -0.0021303114481270313, -0.005864009726792574, -0.02050960063934326, -0.0041898381896317005, -0.001599422306753695, -0.014543072320520878, -0.012980197556316853, -0.012110203504562378, 0.005697437096387148, -0.01134384237229824, -0.006273128557950258, -0.020269395783543587, 0.00206595566123724, -0.006627210881561041, -0.036355212330818176, -0.009883278980851173, -6.210894298419589e-06, -0.026439880952239037, -0.028891965746879578, -0.0013150871964171529, -0.02360166423022747, -0.010725725442171097, -0.02183191105723381, 0.039243895560503006, 0.024056749418377876, 0.016758441925048828, 0.022510681301355362, -0.01064172014594078, 0.01852872408926487, 0.018505385145545006, 0.02285805717110634, 0.019767427816987038, 0.009467927739024162, 0.021334582939743996, 0.006701075471937656, 0.004998492076992989, 0.013553347438573837, -0.01105016004294157, 0.021290680393576622, 0.017781538888812065, 0.023486388847231865, 0.016260700300335884, 0.024738412350416183, 0.06549705564975739, 0.020338254049420357, 0.017187029123306274, -0.005591356195509434, -0.030282070860266685, -3.964171810366679e-06, -0.04010002315044403, -0.02367369644343853, 0.003125580260530114, 0.0036818883381783962, 0.0356549471616745, -0.04779026657342911, -0.011736183427274227, -0.006996487732976675, -0.0037266379222273827, -0.004441506695002317, -0.013957538641989231, -0.01441804226487875, -0.015041263774037361, -0.004064843058586121, -0.001813759095966816, -0.019498180598020554, -0.009017589502036572, -0.022034406661987305, -0.0017824879614636302, -0.02208147756755352, -0.023862911388278008, -0.011861376464366913, -0.009369430132210255, -0.011684310622513294, -0.002783849136903882, 0.0015959303127601743, 0.013797302730381489, -0.009703001007437706, -0.016293305903673172, -0.002277540508657694, -0.058384086936712265, -5.658412646880606e-06, -0.010031881742179394, -0.0515611469745636, -0.0016375213162973523, -0.03382877632975578, -0.014860027469694614, 0.010203640908002853, -0.01677648164331913, -0.008142654784023762, -0.015476839616894722, -0.009880786761641502, -0.009551423601806164, 0.0052429791539907455, 0.025618556886911392, -0.011334288865327835, -0.01023068092763424, -0.007289142347872257, 0.001425967551767826, -0.0038161007687449455, -9.109660459216684e-05, -0.010165611281991005, 0.012489739805459976, -0.00568031333386898, -0.010443033650517464, 0.016427909955382347, -0.009935266338288784, -0.022226503118872643, 0.015649763867259026, 0.0014033179031684995, -0.026624053716659546, -0.0072030117735266685, 0.02539876475930214, -6.032416877133073e-06, 0.02203439362347126, 0.02422020398080349, -0.002492350060492754, -0.0025713376235216856, -0.024256963282823563,
0.028391066938638687, -0.008681230247020721, -0.0075459606014192104, -0.006617182400077581, -0.021044472232460976, -0.014440059661865234, -0.006936822552233934, -0.029412558302283287, -0.011166023090481758, -0.01849893480539322, -0.0005780624924227595, -0.014950568787753582, -0.005253868643194437, -0.005220833234488964, -0.028963478282094002, 0.021637193858623505, -0.019347840920090675, -0.011709429323673248, -0.014264274388551712, -0.011820941232144833, 0.00298744416795671, -0.04346560686826706, -0.008389514870941639, -0.020286206156015396, 0.018381241708993912, 0.009402075782418251, -6.492645752587123e-06, 0.023731611669063568, -0.012512442655861378, 0.0038244938477873802, -0.009620792232453823, -0.07217538356781006, -0.013373111374676228, -0.034088119864463806, 0.018013516440987587, 0.03110465221107006, 0.00410833302885294, -0.03156536445021629, 0.022587930783629417, 0.0012497875140979886, 0.018505631014704704, 0.015937509015202522, 0.03397117182612419, 0.018751027062535286, 0.028309335932135582, 0.0013284453889355063, -0.003424218390136957, -0.049040183424949646, 0.017518097534775734, 0.02935495600104332, 0.012375129386782646, 0.021071018651127815, 0.043245572596788406, -0.0017072117188945413, 0.019170910120010376, 0.02005029283463955, 0.0443248376250267, 0.0003568085958249867, -3.7825570871063974e-06, -0.05497012287378311, 0.00025986708351410925, -0.0030980752781033516, 0.04201911762356758, -0.014718047343194485, 0.09136182069778442, 0.050251998007297516, 0.047536175698041916, 0.055385034531354904, 0.04384322464466095, 0.09153757244348526, 0.05585036426782608, 0.057650815695524216, 0.04947146400809288, 0.049772344529628754, 0.06513509154319763, 0.05598533898591995, 0.07879935204982758, 0.04116233438253403, 0.11658136546611786, 0.11621594429016113, 0.055703893303871155, 0.061708055436611176, 0.05569135770201683, 0.05010691657662392, 0.053597111254930496, 0.11819006502628326, 0.05187384411692619, 0.05305469036102295, 0.09488381445407867, 0.059720080345869064, 0.03125, 0.0926225483417511, 0.07122859358787537, 0.03559500724077225, 0.10132692754268646, 0.033046673983335495, 0.008198931813240051, 0.0003483742184471339, 0.01791943609714508, 0.001972371246665716, 0.028092924505472183, -0.03384608402848244, -0.002994880545884371, 0.007743468973785639, 0.014146284200251102, 0.018825070932507515, 0.014400491490960121, 0.0019946275278925896, 0.02691826969385147, 0.0009523414191789925, 0.02702765353024006, -0.052713021636009216, -0.008234074339270592, 0.018862949684262276, 0.009218212217092514, 0.018653536215424538, 0.018532507121562958, 0.01908375509083271, 0.011865130625665188, 0.020338265225291252, 0.04508337005972862, 0.023039977997541428, -2.3969303128978936e-06, -0.03341738134622574, 0.0004288993077352643, -0.0008280515321530402, 0.010723913088440895, 0.0077158669009804726, 0.006444958969950676, -0.019155774265527725, -5.477798913489096e-05, -0.02078878879547119, 0.008315970189869404, 0.010842232033610344, -0.031902797520160675, -0.026402516290545464, -0.006352603901177645, -0.0014378208434209228, 0.009403265081346035, -0.0235301461070776, 0.030138930305838585, 0.0009560910402797163, 0.0034558959305286407, 0.013105751015245914, -0.03245479613542557, 0.00014958641258999705, -0.01846451871097088, -0.004078384954482317, 0.0037151798605918884, -0.034191444516181946, -0.01241487730294466, 0.020487261936068535, 0.004675493575632572, -0.001711744931526482, -5.699709618056659e-06, -0.016188936308026314, 0.0009379374678246677, -0.004474718123674393, 0.015641530975699425, -0.031059851869940758,
0.017852166667580605, -0.010946747846901417, -0.012056040577590466, -0.024213045835494995, -0.012465649284422398, -0.006464261561632156, -0.011034192517399788, -0.008573409169912338, -0.016811594367027283, -0.022378386929631233, 0.0030896365642547607, -0.01829506829380989, -0.00021189880499150604, -0.008802076801657677, 0.004135396331548691, -0.0019236482912674546, -0.02637781947851181, -0.017801862210035324, -0.006381392478942871, -0.018069086596369743, -0.0036655464209616184, 0.013736056163907051, -0.009265280328691006, -0.027790579944849014, -0.012576323933899403, 0.04333537817001343, -7.037836439849343e-06, 0.026426875963807106, 0.005798666272312403, 0.0013659419491887093, -0.014491761103272438, -0.01638057827949524, -0.02981523796916008, -0.032532256096601486, -0.010090043768286705, -0.007593970745801926, -0.018417589366436005, -0.0216656606644392, 0.004707487300038338, 0.004459805320948362, -0.011068890802562237, -0.0145384157076478, -0.012747114524245262, -4.547689968603663e-05, -0.018158771097660065, -0.0016290376661345363, -0.007845909334719181, -0.024189548566937447, -0.0060073742642998695, -0.013039188459515572, 0.006702722515910864, -0.012077617458999157, -0.0007322088931687176, 0.0034031253308057785, -0.0008505430887453258, -0.017894163727760315, 0.027413401752710342, -0.03949275612831116, -7.241580533445813e-06, -0.019933350384235382, -0.053383633494377136, -0.0054626851342618465, -0.009955281391739845, -0.04589463770389557, -0.034236349165439606, 0.01580982841551304, 0.007976382039487362, 0.028724610805511475, 0.011486087925732136, -0.027824942022562027, 0.022402625530958176, 0.029602553695440292, 0.01704397052526474, 0.022052697837352753, -0.004771718755364418, 0.026639657095074654, -0.011267848312854767, 0.0033830017782747746, -0.015702372416853905, -0.034589529037475586, 0.034043051302433014, 0.009690974839031696, 0.01819804310798645, 0.018704038113355637, 0.0041338009759783745, 0.01277330331504345, 0.013342908583581448, -0.010100413113832474, 0.015592217445373535, -0.031007571145892143, -4.164448455412639e-06, -0.02336093783378601, -0.00736986193805933, -0.0021892155054956675, -0.004158016759902239, 0.040366824716329575, -0.009508250281214714, -0.015689341351389885, -0.02741144597530365, 0.0045163934119045734, -0.02123788185417652, -0.032169606536626816, -0.008436286821961403, 0.007711112964898348, -0.015981104224920273, -0.005847458727657795, -0.016302186995744705, -0.005028838757425547, -0.03451291099190712, -0.005411963909864426, -0.05700745806097984, -0.009519844315946102, 0.0006086266366764903, -0.015810880810022354, -0.013824393041431904, -0.005000389646738768, -0.02759696915745735, -0.04730289429426193, -0.017540261149406433, -0.04141391068696976, -0.041247956454753876, -0.012798106297850609, -5.439681444840971e-06, -0.008614210411906242, 0.0048933797515928745, -0.003266551299020648, -0.04772410914301872, -0.029737742617726326, -0.013271044939756393, -0.0097488509491086, 0.007987074553966522, -0.004178282339125872, 0.012320887297391891, 0.018136637285351753, -0.010289676487445831, -0.012029961682856083, 0.003997388761490583, 0.0027769876178354025, -0.00016121150110848248, -0.0068504842929542065, 0.0006498507573269308, -0.005065080709755421, -0.009735621511936188, 0.017527002841234207, -0.006097816396504641, -0.007242846302688122, -0.006019610911607742, 0.0008342362125404179, -0.023044561967253685, -0.013992048799991608, -0.0020959940738976, 0.011034240014851093, -0.024964068084955215, -0.014639698900282383, -5.802894520456903e-06, 0.013127168640494347, -0.012662719003856182, -0.0008862267713993788, 0.0016509606502950191, -0.04512324184179306,
-0.00812589656561613, 0.023091308772563934, 0.013341490179300308, -0.0017570563359186053, 0.011543834581971169, 0.004988478496670723, 0.02247282676398754, 0.03653952479362488, 0.007683734409511089, 0.0037880358286201954, 0.007956952787935734, 0.015365968458354473, 0.012251682579517365, -0.011300078593194485, 0.018807940185070038, -0.0016539369244128466, 0.01070421189069748, 0.011612690053880215, 0.03027413971722126, 0.004591582342982292, -0.0243303794413805, -0.014095880091190338, 0.01868494786322117, 0.008858193643391132, -0.04804064705967903, 0.016877762973308563, -5.198307917453349e-06, 0.007284262217581272, 0.005965469870716333, 0.005185986869037151, 0.0015474684769287705, 0.0014243163168430328, 0.014486664906144142, -0.0007930672145448625, -0.014664226211607456, -0.016457712277770042, -0.017403796315193176, 0.012685011141002178, -0.0038839769549667835, -2.389050496276468e-05, -0.0160866379737854, -0.01904400624334812, 0.004156769253313541, -0.008070499636232853, -0.0033578418660908937, -0.00516103021800518, 0.014172150753438473, 0.00791727751493454, -0.010331041179597378, -0.008183060213923454, -0.0030316549818962812, -0.018925121054053307, -0.025037286803126335, -0.018173744902014732, -0.008901157416403294, -0.006475025787949562, -0.045409832149744034, 0.007166015915572643, -7.585635557916248e-06, 0.0012800301192328334, 0.0006912891403771937, 0.0059029520489275455, -0.004367201589047909, -0.024956075474619865, 0.022586409002542496, 0.03446779027581215, -0.012960361316800117, -0.0014372625155374408, -0.014426053501665592, 0.01776641421020031, -0.00538691645488143, -0.005508242174983025, -0.008251170627772808, -0.006693737115710974, -0.00424883421510458, -0.0030098704155534506, 0.0014789323322474957, -8.246497600339353e-05, -0.012845523655414581, 0.025194581598043442, 0.0025184480473399162, -0.00496160052716732, -0.010554589331150055, -0.010357110761106014, 0.005486670881509781, -0.021662171930074692, -0.011405641213059425, -0.0068052071146667, -0.004323462024331093, -0.007439297158271074, -7.72375915403245e-06, -0.021758737042546272, 0.008226223289966583, 0.006653657183051109, -0.008580118417739868, 0.03419283404946327, -0.0004065808025188744, 0.002096658106893301, -0.007829351350665092, 0.01040695235133171, 0.004781882278621197, 0.005034750793129206, -0.016704533249139786, -0.016410555690526962, 0.0011981577845290303, 0.009445485658943653, -0.005858719814568758, -0.007212047465145588, -0.02453439123928547, -0.0071554724127054214, -0.014008383266627789, 0.005001842509955168, 0.00020401524670887738, -0.008169618435204029, -0.021851185709238052, 0.008030191995203495, -0.0050564780831336975, -0.02414780668914318, -0.013633708469569683, 0.006448823027312756, -0.029981538653373718, -0.03735398128628731, -6.921254680491984e-06, 0.03399209678173065, -0.004451010841876268, 0.004246181342750788, -0.032517194747924805, -0.01074709091335535, -0.004061675630509853, 0.0025288749020546675, 0.012356824241578579, 0.00828587356954813, 0.02730046585202217, -0.007290054112672806, 0.0016192658804357052, 0.00967408251017332, 0.014147035777568817, 0.01511610671877861, 0.01129476260393858, 0.005221985280513763, 0.013473305851221085, -0.007084429729729891, 0.01748768240213394, -0.018865350633859634, 0.00915855448693037, -0.011141966097056866, 0.005098120309412479, 0.012889760546386242, -0.019689016044139862, 0.0028594080358743668, 0.0053698960691690445, -0.004294142127037048, -0.014502201229333878, 0.014149459078907967, -4.726254246634198e-06, 0.00383391254581511, 0.01293114572763443, 0.004694880452007055, 0.013098621740937233, -0.01542270090430975
};

/// Third convolution biases
static const double conv3_biases[] = {
0.05037664
};
#endif
