/* This file has been automatically generated by builder part of the ferite distribution */
/* file: sys_Sys_env.c */
/* namespace: env */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_sys_Sys_env_del_s )
{
   FeriteString *key = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &key );

   { /* Main function body. */
#line 136 "env.fec"

        
#ifdef USING_SOLARIS
#if _LIBC
/* This lock protects against simultaneous modifications of `environ'. */
# include <bits/libc-lock.h>
__libc_lock_define_initialized (static, envlock)
# define LOCK __libc_lock_lock (envlock)
# define UNLOCK __libc_lock_unlock (envlock)
#else
# define LOCK
# define UNLOCK
#endif

/* In the GNU C library we must keep the namespace clean. */
#ifdef _LIBC
# define unsetenv __unsetenv
#endif

 size_t len;
 char **ep;
 char *name = key->data;
 
 if (name == NULL || *name == '\0' || strchr (name, '=') != NULL)
 {
 return;
 }
 
 len = strlen (name);
 
 LOCK;
 
 ep = environ;
 while (*ep != NULL) {
 if (!strncmp (*ep, name, len) && (*ep)[len] == '=')
 {
 /* Found it. Remove this pointer by moving later ones back. */
 char **dp = ep;
 
 /* Continue the loop in case NAME appears again. */
 do {
 dp[0] = dp[1];
 } while (*dp++);
 }
 else
 ++ep;
 }
 UNLOCK;
 
#ifdef _LIBC
# undef unsetenv
weak_alias (__unsetenv, unsetenv)
#endif
#else
#ifdef WIN32
 SetEnvironmentVariable(key->data, NULL);
#else
 unsetenv( key->data );
#endif
#endif
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_env_read_s )
{
   FeriteString *key = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &key );

   { /* Main function body. */
#line 95 "env.fec"

 
 char *ev_value = NULL;
 FeriteVariable *returnValue = NULL;

 if( (ev_value = getenv(key->data)) != NULL )
 returnValue = fe_new_str_static( "Environment::read-return", ev_value, 0, FE_CHARSET_DEFAULT );
 else
 returnValue = fe_new_str_static( "Environment::read-return", "", 0, FE_CHARSET_DEFAULT );
 FE_RETURN_VAR( returnValue );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_env_toArray_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 59 "env.fec"

 
 FeriteVariable *var = NULL, *val = NULL;
 char *currentValue = NULL;
 char *name, *value;
 int i = 0;
#ifdef USING_DARWIN
 char **environ = *_NSGetEnviron();
#endif
 var = ferite_create_uarray_variable( script, "Environment::toArray-element", 50, FE_STATIC );
 while( (currentValue = environ[i++]) != NULL )
 {
 if( strcmp( currentValue, "" ) != 0 && ferite_find_string( currentValue, "=" ) > -1 ) {
 
 name = memset( fmalloc( strlen(currentValue)+1 ), '\0', strlen(currentValue)+1 );
 value = memset( fmalloc( strlen(currentValue)+1 ), '\0', strlen(currentValue)+1 );
 
 strncpy( name, currentValue, ferite_find_string( currentValue, "=" ) );
 strcpy( value, currentValue + ferite_find_string( currentValue, "=" ) + 1 );
 val = fe_new_str( name, value, 0, FE_CHARSET_DEFAULT );
 ferite_uarray_add( script, VAUA(var), val, name, FE_ARRAY_ADD_AT_END );
 
 ffree( name );
 ffree( value );
 }
 }
 FE_RETURN_VAR( var );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_env_write_ss )
{
   FeriteString *key = NULL;
   FeriteString *value = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &key, &value );

   { /* Main function body. */
#line 114 "env.fec"

 
 /* Solaris is a PITA - it doesn't seem to have a setenv this is the work around */
#ifdef USING_SOLARIS
            char *buf = memset( malloc( key->length + value->length + 10 ), '\0', key->length + value->length + 10 );
            sprintf( buf, "%s=%s", key->data, value->data );
	    putenv(buf);
#else
#ifdef WIN32
		SetEnvironmentVariable( key->data, value->data );
#else
            setenv( key->data, value->data, 1 );
#endif
#endif
        
   }
   FE_RETURN_VOID;
   self = NULL;
}

