/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  stream_Stream_Stream.c */
/* class: Stream */

#include <ferite.h>       /* we need this without a doubt */
#include "stream_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_flush_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 283 "stream.fec"

       
           lock_object;
           stream_flush( script, self );
           unlock_object;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_setAggressive_n )
{
   double n = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &n );

   { /* Main function body. */
#line 167 "stream.fec"

       
           struct Stream *Stream = self->odata;
           Stream->aggressive = VAI(params[0]);
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_eos_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 508 "stream.fec"

 
 struct Stream *Stream = self->odata;
 if( Stream->input_buffer.length == 0 )
 {
 FE_RETURN_TRUE;
 }
 FE_RETURN_FALSE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_getError_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 133 "stream.fec"

       
           FeriteVariable *v;
           struct Stream *Stream = self->odata;
           v = fe_new_str_static("StreamError", Stream->errmsg, 0, FE_CHARSET_DEFAULT );
           if( Stream->errmsg )
             ffree( Stream->errmsg );
           Stream->errmsg = NULL;
           FE_RETURN_VAR( v );
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream___read___n )
{
   double count = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &count );

   { /* Main function body. */
#line 478 "stream.fec"

 
 FE_RETURN_VAR( fe_new_str_static( "read", NULL, 0, FE_CHARSET_DEFAULT ) );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_read_n )
{
   double c = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &c );

   { /* Main function body. */
#line 401 "stream.fec"

       
           FeriteVariable *retval,*v;
           long count = (long)c, left,length,i=0;
           struct Stream *Stream = self->odata;

           v = fe_new_str_static( "read", NULL, count, FE_CHARSET_DEFAULT );
           FE_STRLEN(v) = 0;
           left = count;
           lock_object;
           while( left &&  Stream->read != NULL )
           {
               length = 0;

                /* Check buffer and copy from here in first place */
               if( Stream->input_buffer.length ) {
//					printf("STREAM: reading from internal buffer [%d], wanting %d\n", Stream->input_buffer.length, count);
                   length = (Stream->input_buffer.length > count) ? count : Stream->input_buffer.length;
//					printf("STREAM: reading %d bytes from internal buffer\n", length);
                   memcpy( FE_STR2PTR(v), Stream->input_buffer.data, length );
//					printf("STREAM: copied: %s\n", FE_STR2PTR(v));
//					printf("STREAM: attempting to move: <[%s]>\n", Stream->input_buffer.data + length );
                   memmove( Stream->input_buffer.data, Stream->input_buffer.data + length, Stream->input_buffer.length - length );
//					printf("STREAM: buffer should now be: <[%s]>\n", Stream->input_buffer.data);
                  Stream->input_buffer.length -= length;
                   left -= length;
                   continue;
               }
                /* Call __read__ to fill up buffer (the buffer wasn't filled enough) */
 i = VAI(params[0]);
 VAI(params[0]) = (left > STREAM_READ_BUFFER) ? left : STREAM_READ_BUFFER;
 retval = ferite_call_function( script, self, NULL, Stream->read, params );
 VAI(params[0]) = i;
 if( FE_STRLEN(retval) == 0 )
 {
 ferite_variable_destroy( script, retval );
 break;
 }
 /* If we have got to much, copy the rest to the buffer */
 if( FE_STRLEN(retval) > left )
 {
 Stream->input_buffer.length = FE_STRLEN(retval) - left;
 memcpy( Stream->input_buffer.data, FE_STR2PTR(retval) + left , Stream->input_buffer.length );
 FE_STRLEN(retval) -= Stream->input_buffer.length;
 }
 memcpy( FE_STR2PTR(v) + (count - left), FE_STR2PTR(retval), FE_STRLEN(retval) );
 left -= FE_STRLEN(retval);
 ferite_variable_destroy( script, retval );

 }
 FE_STRLEN( v ) = count - left;
 unlock_object;
 FE_RETURN_VAR( v );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_readln_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 332 "stream.fec"

       
           FeriteVariable *v, *retval;
           struct Stream *Stream = self->odata;
           int i, len, eoflen = strlen(Stream->endofline);
           FeriteVariable **args;

           args = ferite_create_parameter_list_from_data( script, "n", (double)0 );
           args[0]->type = F_VAR_LONG;

           i = 0;
           lock_object;
           while( FE_TRUE /* i < STREAM_READ_BUFFER */ )
           {
               /* Search buffer for EOL, if found we create a string and move buffer up */
               for(; i < Stream->input_buffer.length ; i++ )
               {
                   if( Stream->input_buffer.data[i] == Stream->endofline[0] &&
                       memcmp( Stream->input_buffer.data + i, Stream->endofline, eoflen) == 0 )
                   {
                       if( i == 0)
                         Stream->input_buffer.data[0] = '\0';
                       v = fe_new_str_static( "read", Stream->input_buffer.data, i + eoflen, FE_CHARSET_DEFAULT );
                       memmove( Stream->input_buffer.data,
                                Stream->input_buffer.data + i + eoflen,
                                Stream->input_buffer.length - i - eoflen );
                       Stream->input_buffer.length -= i + eoflen;
                       ferite_delete_parameter_list( script, args );
                       unlock_object;
           
                       /* We have enough data within the buffer */
                       FE_RETURN_VAR( v );
                   }
               }
                /* Fill up the buffer by calling __read__ */
               VAI(args[0]) = STREAM_READ_BUFFER - Stream->input_buffer.length;
               retval = ferite_call_function( script, self, NULL, Stream->read, args );
               len = FE_STRLEN(retval);
               if( len > 0 )
               {
                   memcpy( Stream->input_buffer.data + Stream->input_buffer.length,
                           FE_STR2PTR( retval ), FE_STRLEN( retval ) );
                   Stream->input_buffer.length += len;
               }
               ferite_variable_destroy( script, retval );
               if( len == 0 )
                 break;
           }
           ferite_delete_parameter_list( script, args );

            /* Right, we didn't find a newline. We have either filled up the buffer or we have gotten the EOF */
 /* Let's get it out of here anyway */
           if( Stream->input_buffer.length == 0 )
             Stream->input_buffer.data[0] = '\0';

           v = fe_new_str_static( "read", Stream->input_buffer.data, Stream->input_buffer.length, FE_CHARSET_DEFAULT );
           Stream->input_buffer.data[0] = '\0';
           Stream->input_buffer.length = 0;
           unlock_object;
           FE_RETURN_VAR( v );
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_printf_sE )
{
   FeriteString *fmt = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 2, &fmt, NULL );

   { /* Main function body. */
#line 252 "stream.fec"

       
           FeriteFunction *func;
           FeriteNamespaceBucket *nsb;
           FeriteVariable *str, *len, **args;
           
           /* Call String.sprintf() to generate the formatted string: */
           if(!(nsb = ferite_find_namespace(script, script->mainns,
                                            "String.sprintf", FENS_FNC))) {
               FE_RETURN_LONG(-1);
           }
           func = (FeriteFunction *)nsb->data;           
           str = ferite_call_function(script, self, NULL, func, params );
           
           /* Call self.write() to output the string: */
           func = ferite_object_get_function(script, self, "write");
           args = ferite_create_parameter_list(script,2);
           args[0] = str;
           MARK_VARIABLE_AS_DISPOSABLE( str ); /* Just so that we get this cleared up */
           len = ferite_call_function(script, self, NULL, func, args);
           ferite_delete_parameter_list(script, args);

           /* Return the number of bytes written to the stream: */
           FE_RETURN_VAR(len);
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_clearInputBuffer_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 518 "stream.fec"
 
 struct Stream *Stream = self->odata;
 stream_clear_input( Stream );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream___write___s )
{
   FeriteString *s = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 465 "stream.fec"

 
 FE_RETURN_LONG( 0 );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_write_s )
{
   FeriteString *s = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 199 "stream.fec"

       
           struct Stream *Stream = self->odata;
           int eoflen = strlen( Stream->endofline );

           lock_object;
           ferite_buffer_add( script, Stream->output_buffer, s->data, s->length );
           if( Stream->aggressive || memcmp( s->data + s->length - eoflen, Stream->endofline, eoflen ) == 0 )
               stream_flush( script, self );
           unlock_object;
           FE_RETURN_LONG( s->length );
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_writeln_s )
{
   FeriteString *s = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 227 "stream.fec"

       
           struct Stream *Stream = self->odata;
           int length = strlen( Stream->endofline );

           lock_object;
           ferite_buffer_add( script, Stream->output_buffer, s->data, s->length );
           ferite_buffer_add( script, Stream->output_buffer, Stream->endofline, length );
           stream_flush( script, self );
           unlock_object;
           FE_RETURN_LONG( s->length + length );
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_setEndOfLine_s )
{
   FeriteString *s = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 149 "stream.fec"

       
           struct Stream *Stream = self->odata;
           lock_object;
           if( Stream->endofline )
             ffree( Stream->endofline );
           Stream->endofline = fstrdup( s->data );
           unlock_object;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_ungetc_s )
{
   FeriteString *c = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &c );

   { /* Main function body. */
#line 311 "stream.fec"

       
           /* TODO: Add a ungetstring() function */
           struct Stream *Stream = self->odata;
           if( c->length != 1 || !(Stream->input_buffer.length < STREAM_READ_BUFFER) )
             FE_RETURN_FALSE;
           lock_object;
           memmove( Stream->input_buffer.data + 1, Stream->input_buffer.data, Stream->input_buffer.length );
           Stream->input_buffer.length++;
           Stream->input_buffer.data[0] = c->data[0];
           unlock_object;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_destructor_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 104 "stream.fec"

       
           FeriteFunction *close;
           FeriteVariable *retval;
           struct Stream *Stream = self->odata;

           aphex_mutex_destroy( Stream->lock );
           stream_flush( script, self );
           ferite_buffer_delete( script, Stream->output_buffer );
           close = ferite_object_get_function( script, self, "__close__" );
           if( close != NULL )
           {
               retval = ferite_call_function( script, self, NULL, close, NULL );
               ferite_variable_destroy( script, retval );
           }
           ffree( Stream->input_buffer.data );
           ffree( Stream->endofline );
           if( Stream->errmsg != NULL )
           {
               ffree( Stream->errmsg );
           }
           ffree( Stream );
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_stream_Stream_Stream_constructor_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 88 "stream.fec"

       
           FeriteVariable *v = ferite_find_namespace_element_contents( script, script->mainns, "Stream.EndOfLine", FENS_VAR );
           struct Stream *Stream = fcalloc( 1, sizeof( struct Stream ) );
           Stream->lock = aphex_mutex_recursive_create();
           Stream->endofline = ( v != NULL ? fstrdup(VAS(v)->data) : fstrdup("\n") );
           Stream->input_buffer.data = fmalloc( STREAM_READ_BUFFER );
           Stream->input_buffer.length = 0;
           Stream->output_buffer = ferite_buffer_new( script, 0 );
           Stream->read = ferite_object_get_function( script, self, "__read__" );
           Stream->write = ferite_object_get_function( script, self, "__write__" );
           Stream->errmsg = NULL;
           Stream->eos = FE_FALSE;
           Stream->aggressive = FE_FALSE;
           self->odata = Stream;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

