/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  regexp_Regexp.c */
/* class: Regexp */

#include <ferite.h>       /* we need this without a doubt */
#include "regexp_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_regexp_Regexp___compile_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 372 "regexp.fec"

	
	FeriteVariable *regexp = ferite_object_get_var( script, self, "regexp" );
	FeriteVariable *flags = ferite_object_get_var( script, self, "flags" );
	self->odata = ferite_generate_regex( script, VAS(regexp)->data, VAS(flags)->data );	
	
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_regexp_Regexp___regexp_ssbb )
{
   FeriteString *match = NULL;
   FeriteString *replace = NULL;
   char all = FE_FALSE;
   char replacing = FE_FALSE;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 4, &match, &replace, &all, &replacing );

   { /* Main function body. */
#line 379 "regexp.fec"

	
	FeriteRegex *rgx = RegexpObject;
	FeriteVariable *retv = NULL; /* rturn value */
	size_t captured_str_cnt = 0; /* number of strings that will be captured in ()'s */
		int *offsets;		 /* array of subpattern offsets */
		int size_offsets;	 /* size of the array */
		size_t start_offset;	 /* damn nation, this is the new start :) */
		int current_var = 0;  /* the global variable we need to update */
		int current_match = 0;
		int count = 0;		/* count the number of subexpressions */
		size_t i;
		char **stringlist /* the subparts () values */;
		int g_notempty = 0;
		char **captured_str_names = NULL;
		
		FeriteVariable *c_match_object = NULL;
		FeriteVariable *c_match = NULL;
		FeriteVariable *c_start = NULL;
		FeriteVariable *c_end = NULL;
		FeriteVariable *c_groups = NULL;
		FeriteVariable **plist = NULL;
		
		FeriteVariable *rep_yield_ret = NULL;
		FeriteString   *rep_tmp_holder = NULL;
		FeriteString   *rep_new_string = NULL;
		int endOfLastMatch = 0;
		
		FE_ENTER_FUNCTION;
		/*
#ifdef FUD
#undef FUD
#define FUD( p ) printf p ;
#endif*/
		
		if( replacing )
			rep_new_string = ferite_str_new( script, "", 0, FE_CHARSET_DEFAULT );
		
		/* if the regex is not compiled already -> compile it */
		if( RegexpObject->compiled_re == NULL )
		{
			RegexpObject->compiled_re = ferite_compile_regex( script, RegexpObject->compile_buf, RegexpObject->pcre_options );
			if( RegexpObject->compiled_re == NULL )
			{
				ferite_error( script, 0, "Unable to compile regular expression '%s'\n", RegexpObject->compile_buf );
				retv = ferite_create_number_long_variable( script, "regex-exec-return", 0, FE_STATIC );
				FE_LEAVE_FUNCTION( retv );
			}
		}
		
		/* get the number of subparts */
		captured_str_cnt = pcre_info( rgx->compiled_re, NULL, NULL ) + 1;
		/* create an offset array */
		size_offsets = (int)(captured_str_cnt * 3);
		offsets = (int *)fmalloc(size_offsets * sizeof(int));

		/* get the named strings */
		captured_str_names = (char **)fcalloc(captured_str_cnt, sizeof(char *));
		{
			int name_cnt = 0, name_size, ni = 0, rc = 0;
			char *name_table = NULL;
			unsigned short name_idx;

#define ABORT_WITH_ERROR() \
				ferite_error( script, rc, "Trying to execute regexp: internal pcre_fullinfo() error %d", rc); \
				ffree(offsets); \
				ffree(captured_str_names); \
				retv = ferite_create_number_long_variable( script, "regex-exec-return", 0, FE_STATIC ); \
				FE_LEAVE_FUNCTION( retv );

			rc = pcre_fullinfo(rgx->compiled_re, rgx->extra_info, PCRE_INFO_NAMECOUNT, &name_cnt);
			if( rc < 0 ) {
				ABORT_WITH_ERROR();
			} else if( name_cnt > 0 ) {
				int rc1, rc2;
				rc1 = pcre_fullinfo(rgx->compiled_re, rgx->extra_info, PCRE_INFO_NAMETABLE, &name_table);
				rc2 = pcre_fullinfo(rgx->compiled_re, rgx->extra_info, PCRE_INFO_NAMEENTRYSIZE, &name_size);
				rc = rc2 ? rc2 : rc1;
				if (rc < 0) {
					ABORT_WITH_ERROR();
				}

				while (ni++ < name_cnt) {
					unsigned char major = (unsigned char)name_table[0];
					unsigned char minor = (unsigned char)name_table[1];
					name_idx = (0xff * major) + minor;
					if( name_idx < captured_str_cnt ) {
						captured_str_names[name_idx] = name_table + 2;
					} else {
						ferite_error( script, 0, "Fatal error trying to fetch names out of captured name table, please report regular expression and this message to ctr@ferite.org [index: %d, %d.%d]", name_idx, major, minor ); 
						ffree(offsets); 
						ffree(captured_str_names); 
						FE_RETURN_VOID;
					}
					name_table += name_size;
				}
			}
		}		
		
		
		/* setup the return value */
		retv = ferite_create_uarray_variable( script, "regex-exec-return", 32, FE_STATIC );
		
		start_offset = 0;
		current_var = 1;
		current_match = 1;
		
		do
		{
			/* execute regex */
			FUD(( "REGEX: Executing against \"%s\"\n", match->data ));
			count = pcre_exec( rgx->compiled_re, rgx->extra_info, match->data, (unsigned int)match->length,
							   (int)start_offset, g_notempty, offsets, size_offsets );
			/* check for too many substrings */
			if( count == 0 )
			{
				ferite_warning( script, "A match was found but too many substrings found.\n" );
				count = size_offsets / 3;
			}
			
			FUD(( "REGEX: match count = %d\n", count ));
			/* we matched something */
			if( count >= 0 )
			{
				/* get the list of substrings */
				if( pcre_get_substring_list( match->data, offsets, (int)count, (const char ***)&stringlist) < 0 )
				{
					ffree(offsets);
					ferite_error( script, 0, "Unable to obtain captured strings in regular expression.\n");
					
					if( retv != NULL )
						ferite_variable_destroy( script, retv );
					
					FE_RETURN_VOID;
				}
				
				c_match = ferite_create_string_variable_from_ptr( script, "RGX-MATCH", (char *)stringlist[0], strlen((char *)stringlist[0]), FE_CHARSET_DEFAULT, FE_STATIC );
				MARK_VARIABLE_AS_DISPOSABLE( c_match );				
				c_start = ferite_create_number_long_variable( script, "RGX-START", offsets[0], FE_STATIC );
				MARK_VARIABLE_AS_DISPOSABLE( c_start );
				c_end   = ferite_create_number_long_variable( script, "RGX-START", offsets[0] + strlen(stringlist[0]), FE_STATIC );
				MARK_VARIABLE_AS_DISPOSABLE( c_end );
				c_groups = ferite_create_uarray_variable( script, "RGX-GROUPS", count, FE_STATIC );
				MARK_VARIABLE_AS_DISPOSABLE( c_groups );
				
				FUD(( "c_match: %s, c_start: %d, c_end: %d, c_groups: %p\n", VAS(c_match)->data, VAI(c_start), VAI(c_end), c_groups ));
				for( i = 1; i < count; i++ )
				{
					FeriteVariable *var = ferite_create_string_variable_from_ptr( script, "RGX-GROUP-PTR", (char *)stringlist[i], strlen((char *)stringlist[i]), 
																				  FE_CHARSET_DEFAULT, FE_STATIC );
					ferite_uarray_add( script, VAUA(c_groups), var, captured_str_names[i], FE_ARRAY_ADD_AT_END );
				}
				
				plist = ferite_create_parameter_list( script, 5 );
				plist[0] = c_match;
				plist[1] = c_start;
				plist[2] = c_end;
				plist[3] = c_groups;
				
				c_match_object = ferite_new_object( script, ferite_find_class( script, script->mainns, "MatchObject" ), plist );
				UNMARK_VARIABLE_AS_DISPOSABLE( c_match_object );
				
				FUD(( "match object %p\n", c_match_object ));
				
				ferite_delete_parameter_list( script, plist );
				
				if( current_recipient != NULL )
				{
					FeriteFunction *f = NULL;
					FeriteVariable *yretv = NULL;
					
					if( replacing && replace->length > 0 )
					{
						ferite_warning( script, "Ignoring replacement string '%s' as a block has been passed\n", replace->data );
					}
					
					plist = ferite_create_parameter_list( script, 2 );
					plist[0] = c_match_object;
					
					f = ferite_object_get_function_for_params( script, current_recipient, "invoke", plist );
					yretv = ferite_call_function( script, current_recipient, NULL, f, plist );
					
					if( yretv == NULL )
					{
						ferite_error( script, 0, "Unable to invoke yield block\n" );
						FE_RETURN_VOID;
					}
					else if( !replacing )
						ferite_variable_destroy( script, yretv );
					else
						rep_yield_ret = yretv;
					
					ferite_delete_parameter_list( script, plist );					
				} 
				else if( replacing && current_recipient == NULL ) /* We only do this if there is no block */
				{
					FeriteString *replace_buffer = ferite_str_new( script, NULL, 0, FE_CHARSET_DEFAULT );
					int loc = 0;
					int endOfLastReplacement = 0;
					char target_backtick[3] = "";
					int target_index = 0;
					
					for( loc = 0; loc < replace->length && loc < (replace->length - 1); loc++ )
					{
						if( replace->data[loc] == '\\' )
						{
							if( fe_isnumeric( replace->data[loc+1] ) )
							{
								ferite_str_data_cat( script, replace_buffer, replace->data + endOfLastReplacement, loc - endOfLastReplacement );
								loc++; /* So we can look at the numbers */
								
								if( fe_isnumeric( replace->data[loc] ) )
								{
									target_backtick[0] = replace->data[loc];
									loc++;
									
									if( fe_isnumeric( replace->data[loc] ) )
									{
										target_backtick[1] = target_backtick[0];
										target_backtick[0] = replace->data[loc];
										loc++;
									}
									
									target_index = atol( target_backtick );
									
									if( target_index < count )
									{
										ferite_str_data_cat( script, replace_buffer, (char*)stringlist[target_index], strlen((char*)stringlist[target_index]) ); 
									}
								}
								endOfLastReplacement = loc;
								loc--;
								continue;
							}
						}
					}
					
					if( endOfLastReplacement < replace->length )
						ferite_str_data_cat( script, replace_buffer, replace->data + endOfLastReplacement, strlen(replace->data + endOfLastReplacement) );
					
					/* Do backref replacements */
					FUD(( "Duplicating replacement\n" ));
					rep_tmp_holder = replace_buffer;
				}

				FUD(( "are we replacing? %d\n", (int)replacing ));
				
				if( !replacing )
					ferite_uarray_add( script, VAUA(retv), c_match_object, NULL, FE_ARRAY_ADD_AT_END );
				else
				{
					FeriteString *replacement = NULL;
					
					FUD(( "rep_yield_rep: %p\n", rep_yield_ret ));
					
					if( rep_yield_ret != NULL )
						replacement = ferite_variable_to_str( script, rep_yield_ret, FE_FALSE );
					else
						replacement = rep_tmp_holder;
					
					FUD(( "replacement: %p\n", replacement ));
					/* 
						We cat from end of last match to the start of the current match from the original string 
					 Then we cat on the match
					 Then we set the end of the last match to be the end of this match 
					 */
					
					ferite_str_data_cat( script, rep_new_string, match->data + endOfLastMatch, offsets[0] - endOfLastMatch );
					ferite_str_cat( script, rep_new_string, replacement );
					endOfLastMatch = offsets[0] + strlen(stringlist[0]);
					
					ferite_str_destroy( script, replacement );
					ferite_variable_destroy( script, rep_yield_ret );
					ferite_variable_destroy( script, c_match_object );
					rep_yield_ret = NULL;
				}
				
				if( ferite_use_mm_with_pcre )
				{
					ffree( stringlist );
				}
				else
					pcre_free( stringlist );
			}
			else /* we didn't match something */
	{
	if (g_notempty != 0 && start_offset < (int)match->length )
	{
	offsets[0] = (int)start_offset;
	offsets[1] = (int)(start_offset + 1);
	}
	else
	break;
	}
	
	g_notempty = ( offsets[1] == offsets[0] ) ? PCRE_NOTEMPTY : 0;
	
	/* Advance to the position right after the last full match */
	start_offset = offsets[1];
	}
	while( all );
	
	if( replacing )
	{
	/* If there is some string left ? If so cat it onto the end */
	if( endOfLastMatch < match->length )
	ferite_str_data_cat( script, rep_new_string, match->data + endOfLastMatch, strlen(match->data + endOfLastMatch) );
	
	ferite_variable_destroy( script, retv );
	retv = ferite_create_string_variable( script, "retv", rep_new_string, FE_STATIC );
	ferite_str_destroy( script, rep_new_string );
	}
	ffree( captured_str_names );
	ffree( offsets );
	FE_RETURN_VAR( retv );
	
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_regexp_Regexp_destructor_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 353 "regexp.fec"

	
	if( RegexpObject != NULL )
	{
	ferite_delete_regex( RegexpObject );
	self->odata = NULL;
	}
	return NULL;
	
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

