/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  posix_Posix_Rlimit.c */
/* class: Rlimit */

#include <ferite.h>       /* we need this without a doubt */
#include "posix_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_posix_Posix_Rlimit_set_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 1521 "posix.fec"

       
           int res;
           struct rlimit rl;
           FeriteVariable *fv;

           fv = ferite_object_get_var(script, self, "resource");
           res = VAI(fv);
           fv = ferite_object_get_var(script, self, "current");
           rl.rlim_cur = VAI(fv);
           if(rl.rlim_cur == -1) rl.rlim_cur = RLIM_INFINITY;
           fv = ferite_object_get_var(script, self, "max");
           rl.rlim_max = VAI(fv);
           if(rl.rlim_max == -1) rl.rlim_max = RLIM_INFINITY;

           if(setrlimit(res, &rl) == -1)
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               FE_RETURN_FALSE;
           }
           else FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_Rlimit_constructor_n )
{
   double resource = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &resource );

   { /* Main function body. */
#line 1494 "posix.fec"

        
           struct rlimit rl;
           FeriteVariable *fv;

           if(getrlimit((int)resource, &rl) == -1)
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               FE_RETURN_NULL_OBJECT;
           }

           fv = ferite_object_get_var(script, self, "resource");
           VAI(fv) = (int)resource;
           fv = ferite_object_get_var(script, self, "current");
           VAI(fv) = rl.rlim_cur;
           fv = ferite_object_get_var(script, self, "max");
           VAI(fv) = rl.rlim_max;
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

