/* This file has been automatically generated by builder part of the ferite distribution */
/* file: number_Number.c */
/* namespace: Number */

#include <ferite.h>       /* we need this without a doubt */
#include "number_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_number_Number_sqrt_n )
{
   double num = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 267 "number.fec"

	
	if( num < 0 )
 ferite_error( script, 0, "Number.sqrt() can only take positive values\n" );
	else
	{
	FE_RETURN_DOUBLE( sqrt( num ) );
	}
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_atan_n )
{
   double degree = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 106 "number.fec"

	
	if( degree < -1 || degree > 1 )
	ferite_error( script, 0, "Number.atan() can only take values between -1 and 1\n" );
	else
	{
	FE_RETURN_DOUBLE( atan( degree ) );
	}
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_tan_n )
{
   double degree = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 284 "number.fec"

	
	FE_RETURN_DOUBLE( tan( degree ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_log10_n )
{
   double num = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 205 "number.fec"

	
	if( num <= 0 )
 ferite_error( script, 0, "Number.log10() can only take positive values\n" );
	else
	{
	FE_RETURN_DOUBLE( log10( num ) );
	}
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_log_n )
{
   double num = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 188 "number.fec"

	
	if( num <= 0 )
	ferite_error( script, 0, "Number.log() can only take positive values\n" );
	else
	{
	FE_RETURN_DOUBLE( log( num ) );
	}
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_ceil_n )
{
   double num = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 140 "number.fec"

	
	FE_RETURN_DOUBLE( ceil( num ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_isLong_n )
{
   double n = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &n );

   { /* Main function body. */
#line 312 "number.fec"

	
	if( params[0]->type == F_VAR_LONG )
	{
	FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_acos_n )
{
   double degree = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 69 "number.fec"

	
	if( degree < -1 || degree > 1 )
 ferite_error( script, 0, "Number.acos() can only take values between -1 and 1\n" );
	else
	{
	FE_RETURN_DOUBLE( acos( degree ) );
	}
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_cos_n )
{
   double degree = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 152 "number.fec"

	
	FE_RETURN_DOUBLE( cos( degree ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_floor_n )
{
   double num = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 176 "number.fec"

	
	FE_RETURN_DOUBLE( floor( num ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_round_n )
{
   double num = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 242 "number.fec"

	
	int sign = (num < 0 ? -1 : 1 );
	FE_RETURN_LONG( (long)(num+(0.5 * sign)) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_atan2_nn )
{
   double x = 0.0;
   double y = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &x, &y );

   { /* Main function body. */
#line 128 "number.fec"

	
	FE_RETURN_DOUBLE( atan2( x, y ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_abs_n )
{
   double num = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &num );

   { /* Main function body. */
#line 52 "number.fec"

	
	if( params[0]->type == F_VAR_DOUBLE )
	FE_RETURN_DOUBLE( fabs( num ) );
	FE_RETURN_LONG( labs( (long)num ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_asin_n )
{
   double degree = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 89 "number.fec"

	
	if( degree < -1 || degree > 1 )
 ferite_error( script, 0, "Number.asin() can only take values between -1 and 1\n" );
	else
	{
	FE_RETURN_DOUBLE( asin( degree ) );
	}
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_sin_n )
{
   double degree = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &degree );

   { /* Main function body. */
#line 255 "number.fec"

	
	FE_RETURN_DOUBLE( sin( degree ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_pow_nn )
{
   double base = 0.0;
   double exp = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &base, &exp );

   { /* Main function body. */
#line 223 "number.fec"

	
	FE_RETURN_DOUBLE( pow( base, exp ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_isDouble_n )
{
   double n = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &n );

   { /* Main function body. */
#line 296 "number.fec"

	
	if( params[0]->type == F_VAR_DOUBLE )
	{
	FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_number_Number_exp_n )
{
   double power = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &power );

   { /* Main function body. */
#line 164 "number.fec"

	
	FE_RETURN_DOUBLE( exp( power ) );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

