/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  network_Network_UDP_Stream.c */
/* class: Stream */

#include <ferite.h>       /* we need this without a doubt */
#include "network_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_network_Network_UDP_Stream___read___n )
{
   double maxlen = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &maxlen );

   { /* Main function body. */
#line 871 "network.fec"
 
                
                struct Stream *stream = self->odata;
                int sock = (int)(stream->filedata);
                FeriteVariable *fv = NULL;
                int len;
                char *buf = NULL;
                
#ifdef ENABLE_IPV6
                int rlen = sizeof(struct sockaddr_in6);
                unsigned char rbuf[sizeof(struct sockaddr_in6)];
#else
                int rlen = sizeof(struct sockaddr_in);
                unsigned char rbuf[sizeof(struct sockaddr_in)];
#endif                
                ferite_set_error(script, 0, "");
                
                if(sock == -1 || ((int)maxlen < 1) || !(buf = fmalloc((int)maxlen)))
                {
                    ferite_set_error(script, EINVAL, "Invalid arguments to __read__()");
                    fv = ferite_create_string_variable_from_ptr(script, "", "", 0, FE_CHARSET_DEFAULT, FE_STATIC);
                    FE_RETURN_VAR(fv);
                }
                
                memset( buf, 0, maxlen );
                if((len = recvfrom(sock, buf, (int)maxlen, 0, (struct sockaddr *)rbuf, &rlen)) == -1)
                {
                    ferite_set_error(script, errno, "%s", strerror(errno));
                    ffree(buf);
                    fv = ferite_create_string_variable_from_ptr(script, "", "", 0, FE_CHARSET_DEFAULT, FE_STATIC);
                    FE_RETURN_VAR(fv);
                }
                
                fv = ferite_object_get_var(script, self, "af");
                set_remoteip(script, self, (struct sockaddr *)rbuf, sock);
                
                /* We do this to make sure that we read-and-write to the same place */
                if(connect(sock, (struct sockaddr *)rbuf, rlen))
                    ferite_set_error(script, errno, "%s", strerror(errno));
                
                fv = ferite_create_string_variable_from_ptr(script, "", buf, len, FE_CHARSET_DEFAULT, FE_STATIC);
                
                ffree(buf);
                FE_RETURN_VAR(fv);
            
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_network_Network_UDP_Stream___write___s )
{
   FeriteString *dgram = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &dgram );

   { /* Main function body. */
#line 853 "network.fec"
 
                struct Stream *stream = self->odata;
                int sock = (int)(stream->filedata);
                
                if( sock == -1 )
                {
                    ferite_set_error(script, ENOENT, "Socket not connected");
                    FE_RETURN_FALSE;
                }
                
                if(send(sock, dgram->data, dgram->length, 0) == -1)
                {
                    ferite_set_error(script, errno, "%s", strerror(errno));
                    FE_RETURN_FALSE;
                }
                else FE_RETURN_TRUE;
            
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_network_Network_UDP_Stream___close___ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 917 "network.fec"

            
                struct Stream *stream = self->odata;
                int sock = (int)(stream->filedata);
                
                if(sock != -1)
                    close(sock);
                stream->filedata = (void*)-1;
            
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

