/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  network_Network_TCP_Stream.c */
/* class: Stream */

#include <ferite.h>       /* we need this without a doubt */
#include "network_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_network_Network_TCP_Stream_listen_n )
{
   double backlog = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &backlog );

   { /* Main function body. */
#line 298 "network.fec"

 
 int sock = (int)StreamObject->filedata;
 int retval = listen( sock, (long)backlog );
 FE_RETURN_LONG( retval );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_network_Network_TCP_Stream_accept_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 253 "network.fec"

 
 int sock;
 FeriteClass *cls;
 FeriteVariable *fv, *object, **args;
#ifdef ENABLE_IPV6
 unsigned int rlen = sizeof(struct sockaddr_in6);
 unsigned char rbuf[sizeof(struct sockaddr_in6)];
#else
 unsigned int rlen = sizeof(struct sockaddr_in);
 unsigned char rbuf[sizeof(struct sockaddr_in)];
#endif
 do
 {
 sock = accept((int)StreamObject->filedata, (struct sockaddr *)rbuf, &rlen);
 }
 while(sock == -1 && errno == EINTR);
 
 if(sock == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_NULL_OBJECT;
 }
 
 if((cls = ferite_find_class(script, script->mainns, "Network.TCP.Stream")))
 {
 args = ferite_create_parameter_list(script,4);
 args = ferite_add_to_parameter_list(args, fe_new_lng_static("socket", sock));
 MARK_VARIABLE_AS_DISPOSABLE(args[0]);
 object = ferite_new_object(script, cls, args);
 ferite_delete_parameter_list(script, args);
 fv = ferite_object_get_var(script, self, "af");
 set_remoteip(script, VAO(object), (struct sockaddr *)rbuf,
 VAI(fv));
 FE_RETURN_VAR(object);
 }
 FE_RETURN_NULL_OBJECT;
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_network_Network_TCP_Stream___read___n )
{
   double c = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &c );

   { /* Main function body. */
#line 304 "network.fec"
 
 struct Stream *Stream = self->odata;
 FeriteVariable *in = NULL;
	int r = 0, size = (int)c;
	
 in = fe_new_str_static("read", NULL, (int)c, FE_CHARSET_DEFAULT );
	//printf("requesting %d bytes\n", size);
 r = recv( (int)Stream->filedata, FE_STR2PTR(in), size, 0 );
 //printf("got %d bytes\n", r);
 Stream->eos = (r <= 0 ? FE_TRUE : FE_FALSE);
 if( r == -1 )
 {
 ferite_error( script, errno, "Network.TCP.Stream: Read: %s (%d)\n", strerror( errno ), errno );
 if( Stream->errmsg != NULL ) {
 ffree( Stream->errmsg );
 }
 Stream->errmsg = fstrdup( strerror( errno ) );
 FE_STRLEN(in) = 0;
 } else {
	FE_STRLEN(in) = r;
	//printf("NETWORK:__READ__:%d[%d]:'%s'", FE_STRLEN(in), r, FE_STR2PTR(in));
	}
 FE_RETURN_VAR( in );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_network_Network_TCP_Stream___write___s )
{
   FeriteString *s = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 328 "network.fec"
 
 struct Stream *Stream = self->odata;
	int fd = (int)Stream->filedata;
	char *buf = s->data;
	size_t amount_sent = 0, total_sent = 0, total_amount = s->length;
	int flags = 0;
	
	while( total_sent < total_amount ) {
	amount_sent = send( fd, buf + total_sent, (total_amount - total_sent), flags );
	if( amount_sent < 0 ) {
 ferite_error( script, errno, "Network.TCP.Stream: Write: %s (%d)\n", strerror( errno ), errno );
 if( Stream->errmsg != NULL ) {
 ffree( Stream->errmsg );
 }
 Stream->errmsg = fstrdup( strerror( errno ) );
 FE_RETURN_LONG( 0 );
	}
	total_sent += amount_sent;
	if( total_sent < total_amount ) {
	printf("Network.TCP.Stream: %d bytes remaining\n", (total_amount - total_sent));
	}
	}
 FE_RETURN_LONG( total_sent );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

