/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  ipc_IPCObject.c */
/* class: IPCObject */

#include <ferite.h>       /* we need this without a doubt */
#include "ipc_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_ipc_IPCObject_read_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 426 "ipc.fec"

 
 union semun arg;
 FeriteVariable *var;
 char *buffer = memset (fmalloc (strlen(SelfObj->data) +1), '\0', (long)strlen(SelfObj->data) +1);
 
 /* first check to see if I'm connected */
        if (!SelfObj->connected)
        {
            ferite_set_error (script, 0, "I am not connected");
            ffree(buffer);
            FE_RETURN_FALSE;
        }
        
        /* check to see if anyone wants to write */
        if ((int)semctl(SelfObj->semid, 1, GETVAL, &arg) == 1)
        {
            /* wait for the writers */
            SelfObj->sembuffer.sem_num = 1;
            SelfObj->sembuffer.sem_op = 0;
            
            if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1)
            {
                ffree(buffer);
                ferite_set_error (script, 0, "Unable to wait on writers");
                FE_RETURN_CSTR("",FE_FALSE);
            }
        }
        
        /* if no one is currently reading it is our job to lock out the writers */
        if ((int)semctl(SelfObj->semid, 2, GETVAL, &arg) == 0)
        {
            /* lock out the writers */
            SelfObj->sembuffer.sem_num = 0;
            SelfObj->sembuffer.sem_op = -1;  // {0, -1, 0}
            if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1)
            {
                ffree(buffer);
                ferite_set_error (script, 0, "Unable to lock writers semaphore.");
                FE_RETURN_CSTR("",FE_FALSE);
            }
        }
        
        /* increment readcount semaphore */
        SelfObj->sembuffer.sem_num = 2;
        SelfObj->sembuffer.sem_op = 1;
        if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1)
        {
            ffree(buffer);
            ferite_set_error (script, 0, "Unable to increment readcount semaphore.");
            FE_RETURN_CSTR("",FE_FALSE);
        }
        
        strncpy (buffer, SelfObj->data, strlen(SelfObj->data));
        var = fe_new_str("Ipc->read-return", buffer, 0, FE_CHARSET_DEFAULT);
        ffree(buffer);
        
        /* decrement readcount semaphore */
        SelfObj->sembuffer.sem_num = 2;
        SelfObj->sembuffer.sem_op = -1;
        if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1)
        {
            ffree(buffer);
            ferite_set_error (script, 0, "Could not decrement readcount semaphore");
            FE_RETURN_CSTR("",FE_FALSE);
        }
        
        /* if there's no more readers it is our job to signal the writers */
 if ((int)semctl(SelfObj->semid, 2, GETVAL, &arg) == 0)
 {
 
 SelfObj->sembuffer.sem_num = 0;
 SelfObj->sembuffer.sem_op = 1;
 if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1)
 {
 ffree(buffer);
 ferite_set_error (script, 0, "Could not unlock writers semaphore");
 FE_RETURN_CSTR("",FE_FALSE);
 }
 }
 
 FE_RETURN_VAR (var);
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_ipc_IPCObject_disconnect_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 306 "ipc.fec"

    
        struct shmid_ds buf;
        union semun dummy;
        
        /* first check to see if I'm connected */
 if (!SelfObj->connected)
 {
 ferite_set_error (script, 0, "I am not connected");
 FE_RETURN_FALSE;
 }
 
 /* detatch from the shm */
 if (shmdt(SelfObj->data) == -1)
 {
 ferite_set_error( script, 0, "shm detach failed");
 FE_RETURN_FALSE;
 }
 
 /* need to pick up some info in the shm's status */
        if (shmctl(SelfObj->shmid, IPC_STAT, &buf) == -1)
        {
            ferite_set_error (script, 0, "could not get shm stat");
            FE_RETURN_FALSE;
        }
        
        /*
         * If I'm the last process connected to the shm I have to
 * delete the shared memory segment and semaphore set
 */
 if (buf.shm_nattch == 0)
 {
 if (shmctl(SelfObj->shmid, IPC_RMID, NULL) == -1)
 {
 ferite_set_error (script, 0, "Could not delete shm or mark it for deletion");
 FE_RETURN_FALSE;
 }
 if (semctl(SelfObj->semid, IPC_RMID, 0, dummy) == -1)
 {
 ferite_set_error(script, 0, "Could not delete the semaphore set");
 FE_RETURN_FALSE;
 }
 }
 
 SelfObj->connected = 0;
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_ipc_IPCObject_write_s )
{
   FeriteString *msg = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &msg );

   { /* Main function body. */
#line 362 "ipc.fec"

 
 union semun arg;
 
 /* first check to see if I'm connected */
        if (!SelfObj->connected)
        {
            ferite_set_error (script, 0, "I am not connected");
            FE_RETURN_FALSE;
        }
        
        /* increment the readers semaphore where they'll be waiting for
 * it to get to 0 again
 */
 arg.val = 1;
 if (semctl(SelfObj->semid, 1, SETVAL, arg) == -1)
 {
 ferite_set_error (script, 0, "Could not set the readers sem from write");
 FE_RETURN_FALSE;
 }
 
 /* wait on the writers semaphore */
 SelfObj->sembuffer.sem_num = 0;
 SelfObj->sembuffer.sem_op = -1; // {0, -1, 0}
 if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1)
 {
 ferite_set_error (script, 0, "Unable to lock writer semaphore");
 FE_RETURN_FALSE;
 }
 
 strncpy (SelfObj->data, msg->data, SelfObj->size);
 
 /* unlock writer semaphore */
 SelfObj->sembuffer.sem_num = 0;
 SelfObj->sembuffer.sem_op = 1; // {0, 1, 0}
 if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1)
 {
 ferite_set_error (script, 0, "Unable to unlock the writer semaphore.");
 FE_RETURN_FALSE;
 }
 
 /* if there is no more writers it is our job to signal the
 * readers.
 */
 if ((int)semctl(SelfObj->semid, 0, GETNCNT, &arg) == 0)
 {
 
 /* unleash the readers */
 arg.val = 0;
 if (semctl(SelfObj->semid, 1, SETVAL, arg) == -1)
 {
 ferite_set_error (script, 0, "Could not unleash the readers.");
 FE_RETURN_FALSE;
 }
 }
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_ipc_IPCObject_connect_s )
{
   FeriteString *file = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &file );

   { /* Main function body. */
#line 204 "ipc.fec"

 
 
 union semun arg;
 arg.val = 1;
 
 /* create a key for the shm */
 SelfObj->key = ftok (file->data, 'E');
 if (SelfObj->key == -1)
 {
 ferite_set_error (script, 0, "Unable to create shm key.");
 FE_RETURN_FALSE;
 }
 
 /*
 * this tests if the shm already exists
 * If the shm does not exist we need to make a semaphore set
 * with 2 semaphores control read/write access to the shm
 */
 SelfObj->shmid = shmget (SelfObj->key,
 SelfObj->size,
 SelfObj->perm | IPC_EXCL | IPC_CREAT);
 if (SelfObj->shmid != -1)
 {
 
 /*
 * Create a semaphore set for access control to
 * the shm
 */
 SelfObj->semid = semget (SelfObj->key, 3, SelfObj->perm | IPC_CREAT);
 if (SelfObj->semid == -1)
 {
 ferite_set_error (script, 0, "Unable to create semaphore.");
 FE_RETURN_FALSE;
 }
 
 /* initialize the writer semaphores to 1 */
 if (semctl(SelfObj->semid, 0, SETVAL, arg) == -1)
 {
 ferite_set_error (script, 0, "Unable to set semaphore 1");
 FE_RETURN_FALSE;
 }
 /* initialize the reader semaphore to 0 */
 arg.val = 0;
 if (semctl(SelfObj->semid, 1, SETVAL, arg) == -1)
 {
 ferite_set_error (script, 0, "Unable to set semaphore 2");
 FE_RETURN_FALSE;
 }
 
 /* set readcount semaphore to 0 */
 if (semctl(SelfObj->semid, 2, SETVAL, arg) == -1)
 {
 ferite_set_error (script, 0, "Unable to set semaphore 3");
 FE_RETURN_FALSE;
 }
 }
 
 /* Grab the semaphore set id */
 SelfObj->semid = semget (SelfObj->key, 2, 0);
 if (SelfObj->semid == -1)
 {
 ferite_set_error (script, 0, "Unable to grab the semaphore.");
 FE_RETURN_FALSE;
 }
 
 /*
 * create the shm and get it's id
         * if an shm with this id already exist just connect to it
         */
        SelfObj->shmid = shmget (SelfObj->key,
                                 SelfObj->size,
                                 SelfObj->perm | IPC_CREAT);
        if (SelfObj->shmid == -1)
        {
            ferite_set_error (script, 0, "Unable to get shm id.");
            FE_RETURN_FALSE;
        }
        
        /* attach the data pointer to the shm */
        SelfObj->data = shmat (SelfObj->shmid, (void *)0, 0);
        if (SelfObj->data == (char*)(-1))
        {
            ferite_set_error (script, 0, "Unable to attach to the shm");
            FE_RETURN_FALSE;
        }
        
        SelfObj->connected = 1;
        
        FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_ipc_IPCObject_destructor_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 162 "ipc.fec"

 
 struct shmid_ds buf;
 union semun dummy;
 
 if (SelfObj->connected)
 {
 /* detatch from the shm */
 if (shmdt(SelfObj->data) == -1)
 ferite_error (script, 0, "shm detach failed");
 
 if (shmctl(SelfObj->shmid, IPC_STAT, &buf) == -1)
 ferite_error (script, 0, "could not stat shm");
 else
 {
 /* am I the last process connected to it */
 if (buf.shm_nattch == 0)
 {
 /* destroy shm */
 if (shmctl(SelfObj->shmid, IPC_RMID, NULL) == -1)
 ferite_error (script, 0, "could not delete the shm");
 
 /* destroy the semaphore */
 if (semctl(SelfObj->semid, IPC_RMID, 0, dummy) == -1)
 ferite_error (script, 0, "could not delete the sem set");
 }
 }
 }
 
 ffree (self->odata);
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_ipc_IPCObject_constructor_n )
{
   double segsize = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &segsize );

   { /* Main function body. */
#line 151 "ipc.fec"

 
 self->odata = fmalloc (sizeof(IpcData));
 SelfObj->key = 0;
 SelfObj->size = ((long)segsize == 0 ? DEFAULT_SEGMENT_SIZE : (long)segsize);
 SelfObj->perm = DEFAULT_PERMISSION;
 SelfObj->shmflag = 0;
 SelfObj->connected = 0;
 SelfObj->sembuffer.sem_flg = 0;
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

