/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  filesystem_Directory.c */
/* class: Directory */

#include <ferite.h>       /* we need this without a doubt */
#include "filesystem_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_filesystem_Directory_destructor_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 775 "filesystem.fec"

 
 if(self->odata != NULL)
 {
 aphex_directory_delete(self->odata);
 self->odata = NULL;
 FE_RETURN_TRUE;
 }
 FE_RETURN_FALSE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_Directory_constructor_s )
{
   FeriteString *directory = NULL;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &directory );

   { /* Main function body. */
#line 692 "filesystem.fec"

 
 if(self->odata) aphex_directory_delete(self->odata);
 if(!(self->odata = aphex_directory_read(directory->data)))
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_NULL_OBJECT;
 }
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_Directory_getEntry_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 715 "filesystem.fec"

 
 char *de = NULL;
 FeriteVariable *fv = NULL;
 AphexDirectory *dir = self->odata;

 if( dir == NULL )
 {
 ferite_set_error(script, EBADF, "The directory stream is not open");
 fv = ferite_create_string_variable_from_ptr(script, "", "", 0, FE_CHARSET_DEFAULT, FE_STATIC);
 FE_RETURN_VAR(fv);
 }
 
	if( dir->pos == dir->size )
	de = "";
	else
	de = dir->contents[dir->pos++];
	
	fv = ferite_create_string_variable_from_ptr(script,
	"Sys::Dir::readdir", de, 0,
	FE_CHARSET_DEFAULT, FE_STATIC);
 FE_RETURN_VAR(fv);
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_Directory_getCurrent_ )
{
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   { /* Main function body. */
#line 577 "filesystem.fec"

 
 int len = 128;
 FeriteVariable *v = NULL;
 char *buf = NULL, *ret = NULL;
 
 if((buf = fmalloc(len)))
 {
 do
 {
 if(!(ret = getcwd(buf, len - 1)) && errno == ERANGE)
 {
 len *= 2;
 buf = frealloc(buf, len);
 }
 }
 while(!ret && buf && errno == ERANGE);
 }
 
 if(ret)
 {
 v = fe_new_str_static("Sys::getcwd", ret, 0, FE_CHARSET_DEFAULT);
 }
 else
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 v = fe_new_str_static("", "", 0, FE_CHARSET_DEFAULT);
 }
 if(buf) ffree(buf);
 FE_RETURN_VAR(v);
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_Directory_name_s )
{
   FeriteString *name = NULL;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 1, &name );

   { /* Main function body. */
#line 795 "filesystem.fec"
 
	char *path = aphex_directory_name( name->data );
	char *ret = fstrdup(path);
	aphex_free( path );
	if( ret ) {
	FE_RETURN_CSTR( ret, FE_TRUE );
	}
	FE_RETURN_CSTR( "", FE_FALSE );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_Directory_make_sn )
{
   FeriteString *dirname = NULL;
   double mode = 0.0;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 2, &dirname, &mode );

   { /* Main function body. */
#line 557 "filesystem.fec"

 
#ifndef WIN32
 if( mkdir( dirname->data, (mode_t)mode ) == -1 )
#else
	if( mkdir( dirname->data ) == -1 )
#endif
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_FALSE;
 }
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_Directory_setCurrent_s )
{
   FeriteString *path = NULL;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 616 "filesystem.fec"

 
 if( chdir( path->data ) == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 FE_RETURN_FALSE;
 }
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

