// @generated by Thrift for [[[ program path ]]]
// This file is probably not the place you want to edit!

package module // [[[ program thrift source path ]]]

import (
    "fmt"
    "strings"

    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
)

// (needed to ensure safety because of naive import list construction)
var _ = fmt.Printf
var _ = strings.Split
var _ = thrift.ZERO


type ContainerTypedef = map[int16]string

func NewContainerTypedef() ContainerTypedef {
    return make(map[int16]string)
}

func WriteContainerTypedef(item ContainerTypedef, p thrift.Protocol) error {
    if err := p.WriteMapBegin(thrift.I16, thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteI16(item); err != nil {
    return err
}
    }

    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}
    return nil
}

func ReadContainerTypedef(p thrift.Protocol) (ContainerTypedef, error) {
    var decodeResult ContainerTypedef
    decodeErr := func() error {
        _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[int16]string, size)
for i := 0; i < size; i++ {
    var key int16
    {
        result, err := p.ReadI16()
if err != nil {
    return err
}
        key = result
    }

    var value string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type ComplexUnion struct {
    IntValue *int64 `thrift:"intValue,1" json:"intValue,omitempty" db:"intValue"`
    IntListValue []int64 `thrift:"intListValue,2" json:"intListValue,omitempty" db:"intListValue"`
    StringListValue []string `thrift:"stringListValue,3" json:"stringListValue,omitempty" db:"stringListValue"`
    StringValue *string `thrift:"stringValue,5" json:"stringValue,omitempty" db:"stringValue"`
    TypedefValue ContainerTypedef `thrift:"typedefValue,9" json:"typedefValue,omitempty" db:"typedefValue"`
    StringRef *string `thrift:"stringRef,14" json:"stringRef,omitempty" db:"stringRef"`
}
// Compile time interface enforcer
var _ thrift.Struct = &ComplexUnion{}

func NewComplexUnion() *ComplexUnion {
    return (&ComplexUnion{})
}

func (x *ComplexUnion) GetIntValueNonCompat() *int64 {
    return x.IntValue
}

func (x *ComplexUnion) GetIntValue() int64 {
    if !x.IsSetIntValue() {
        return 0
    }

    return *x.IntValue
}

func (x *ComplexUnion) GetIntListValueNonCompat() []int64 {
    return x.IntListValue
}

func (x *ComplexUnion) GetIntListValue() []int64 {
    if !x.IsSetIntListValue() {
        return make([]int64, 0)
    }

    return x.IntListValue
}

func (x *ComplexUnion) GetStringListValueNonCompat() []string {
    return x.StringListValue
}

func (x *ComplexUnion) GetStringListValue() []string {
    if !x.IsSetStringListValue() {
        return make([]string, 0)
    }

    return x.StringListValue
}

func (x *ComplexUnion) GetStringValueNonCompat() *string {
    return x.StringValue
}

func (x *ComplexUnion) GetStringValue() string {
    if !x.IsSetStringValue() {
        return ""
    }

    return *x.StringValue
}

func (x *ComplexUnion) GetTypedefValueNonCompat() ContainerTypedef {
    return x.TypedefValue
}

func (x *ComplexUnion) GetTypedefValue() ContainerTypedef {
    if !x.IsSetTypedefValue() {
        return NewContainerTypedef()
    }

    return x.TypedefValue
}

func (x *ComplexUnion) GetStringRefNonCompat() *string {
    return x.StringRef
}

func (x *ComplexUnion) GetStringRef() string {
    if !x.IsSetStringRef() {
        return ""
    }

    return *x.StringRef
}

func (x *ComplexUnion) SetIntValueNonCompat(value int64) *ComplexUnion {
    x.IntValue = &value
    return x
}

func (x *ComplexUnion) SetIntValue(value *int64) *ComplexUnion {
    x.IntValue = value
    return x
}

func (x *ComplexUnion) SetIntListValueNonCompat(value []int64) *ComplexUnion {
    x.IntListValue = value
    return x
}

func (x *ComplexUnion) SetIntListValue(value []int64) *ComplexUnion {
    x.IntListValue = value
    return x
}

func (x *ComplexUnion) SetStringListValueNonCompat(value []string) *ComplexUnion {
    x.StringListValue = value
    return x
}

func (x *ComplexUnion) SetStringListValue(value []string) *ComplexUnion {
    x.StringListValue = value
    return x
}

func (x *ComplexUnion) SetStringValueNonCompat(value string) *ComplexUnion {
    x.StringValue = &value
    return x
}

func (x *ComplexUnion) SetStringValue(value *string) *ComplexUnion {
    x.StringValue = value
    return x
}

func (x *ComplexUnion) SetTypedefValueNonCompat(value ContainerTypedef) *ComplexUnion {
    x.TypedefValue = value
    return x
}

func (x *ComplexUnion) SetTypedefValue(value ContainerTypedef) *ComplexUnion {
    x.TypedefValue = value
    return x
}

func (x *ComplexUnion) SetStringRefNonCompat(value string) *ComplexUnion {
    x.StringRef = &value
    return x
}

func (x *ComplexUnion) SetStringRef(value *string) *ComplexUnion {
    x.StringRef = value
    return x
}

func (x *ComplexUnion) IsSetIntValue() bool {
    return x != nil && x.IntValue != nil
}

func (x *ComplexUnion) IsSetIntListValue() bool {
    return x != nil && x.IntListValue != nil
}

func (x *ComplexUnion) IsSetStringListValue() bool {
    return x != nil && x.StringListValue != nil
}

func (x *ComplexUnion) IsSetStringValue() bool {
    return x != nil && x.StringValue != nil
}

func (x *ComplexUnion) IsSetTypedefValue() bool {
    return x != nil && x.TypedefValue != nil
}

func (x *ComplexUnion) IsSetStringRef() bool {
    return x != nil && x.StringRef != nil
}

func (x *ComplexUnion) writeField1(p thrift.Protocol) error {  // IntValue
    if !x.IsSetIntValue() {
        return nil
    }

    if err := p.WriteFieldBegin("intValue", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetIntValueNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ComplexUnion) writeField2(p thrift.Protocol) error {  // IntListValue
    if !x.IsSetIntListValue() {
        return nil
    }

    if err := p.WriteFieldBegin("intListValue", thrift.LIST, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntListValueNonCompat()
    if err := p.WriteListBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ComplexUnion) writeField3(p thrift.Protocol) error {  // StringListValue
    if !x.IsSetStringListValue() {
        return nil
    }

    if err := p.WriteFieldBegin("stringListValue", thrift.LIST, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStringListValueNonCompat()
    if err := p.WriteListBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ComplexUnion) writeField5(p thrift.Protocol) error {  // StringValue
    if !x.IsSetStringValue() {
        return nil
    }

    if err := p.WriteFieldBegin("stringValue", thrift.STRING, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetStringValueNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ComplexUnion) writeField9(p thrift.Protocol) error {  // TypedefValue
    if !x.IsSetTypedefValue() {
        return nil
    }

    if err := p.WriteFieldBegin("typedefValue", thrift.MAP, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTypedefValueNonCompat()
    err := WriteContainerTypedef(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ComplexUnion) writeField14(p thrift.Protocol) error {  // StringRef
    if !x.IsSetStringRef() {
        return nil
    }

    if err := p.WriteFieldBegin("stringRef", thrift.STRING, 14); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetStringRefNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ComplexUnion) readField1(p thrift.Protocol) error {  // IntValue
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetIntValueNonCompat(result)
    return nil
}

func (x *ComplexUnion) readField2(p thrift.Protocol) error {  // IntListValue
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetIntListValueNonCompat(result)
    return nil
}

func (x *ComplexUnion) readField3(p thrift.Protocol) error {  // StringListValue
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]string, 0, size)
for i := 0; i < size; i++ {
    var elem string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetStringListValueNonCompat(result)
    return nil
}

func (x *ComplexUnion) readField5(p thrift.Protocol) error {  // StringValue
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStringValueNonCompat(result)
    return nil
}

func (x *ComplexUnion) readField9(p thrift.Protocol) error {  // TypedefValue
    result, err := ReadContainerTypedef(p)
if err != nil {
    return err
}

    x.SetTypedefValueNonCompat(result)
    return nil
}

func (x *ComplexUnion) readField14(p thrift.Protocol) error {  // StringRef
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStringRefNonCompat(result)
    return nil
}

func (x *ComplexUnion) toString1() string {  // IntValue
    if x.IsSetIntValue() {
        return fmt.Sprintf("%v", *x.GetIntValueNonCompat())
    }
    return fmt.Sprintf("%v", x.GetIntValueNonCompat())
}

func (x *ComplexUnion) toString2() string {  // IntListValue
    return fmt.Sprintf("%v", x.GetIntListValueNonCompat())
}

func (x *ComplexUnion) toString3() string {  // StringListValue
    return fmt.Sprintf("%v", x.GetStringListValueNonCompat())
}

func (x *ComplexUnion) toString5() string {  // StringValue
    if x.IsSetStringValue() {
        return fmt.Sprintf("%v", *x.GetStringValueNonCompat())
    }
    return fmt.Sprintf("%v", x.GetStringValueNonCompat())
}

func (x *ComplexUnion) toString9() string {  // TypedefValue
    return fmt.Sprintf("%v", x.GetTypedefValueNonCompat())
}

func (x *ComplexUnion) toString14() string {  // StringRef
    if x.IsSetStringRef() {
        return fmt.Sprintf("%v", *x.GetStringRefNonCompat())
    }
    return fmt.Sprintf("%v", x.GetStringRefNonCompat())
}




func (x *ComplexUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetIntValue()) {
        count++
    }
    if (x.IsSetIntListValue()) {
        count++
    }
    if (x.IsSetStringListValue()) {
        count++
    }
    if (x.IsSetStringValue()) {
        count++
    }
    if (x.IsSetTypedefValue()) {
        count++
    }
    if (x.IsSetStringRef()) {
        count++
    }
    return count
}

func (x *ComplexUnion) CountSetFieldsComplexUnion() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
type ComplexUnionBuilder struct {
    obj *ComplexUnion
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewComplexUnionBuilder() *ComplexUnionBuilder {
    return &ComplexUnionBuilder{
        obj: NewComplexUnion(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ComplexUnionBuilder) IntValue(value *int64) *ComplexUnionBuilder {
    x.obj.IntValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ComplexUnionBuilder) IntListValue(value []int64) *ComplexUnionBuilder {
    x.obj.IntListValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ComplexUnionBuilder) StringListValue(value []string) *ComplexUnionBuilder {
    x.obj.StringListValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ComplexUnionBuilder) StringValue(value *string) *ComplexUnionBuilder {
    x.obj.StringValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ComplexUnionBuilder) TypedefValue(value ContainerTypedef) *ComplexUnionBuilder {
    x.obj.TypedefValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ComplexUnionBuilder) StringRef(value *string) *ComplexUnionBuilder {
    x.obj.StringRef = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ComplexUnionBuilder) Emit() *ComplexUnion {
    var objCopy ComplexUnion = *x.obj
    return &objCopy
}

func (x *ComplexUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("ComplexUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField14(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *ComplexUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // intValue
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.LIST)):  // intListValue
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.LIST)):  // stringListValue
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 5 && wireType == thrift.Type(thrift.STRING)):  // stringValue
            if err := x.readField5(p); err != nil {
                return err
            }
        case (id == 9 && wireType == thrift.Type(thrift.MAP)):  // typedefValue
            if err := x.readField9(p); err != nil {
                return err
            }
        case (id == 14 && wireType == thrift.Type(thrift.STRING)):  // stringRef
            if err := x.readField14(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *ComplexUnion) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("ComplexUnion({")
    sb.WriteString(fmt.Sprintf("IntValue:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("IntListValue:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("StringListValue:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("StringValue:%s ", x.toString5()))
    sb.WriteString(fmt.Sprintf("TypedefValue:%s ", x.toString9()))
    sb.WriteString(fmt.Sprintf("StringRef:%s", x.toString14()))
    sb.WriteString("})")

    return sb.String()
}

type ListUnion struct {
    IntListValue []int64 `thrift:"intListValue,2" json:"intListValue,omitempty" db:"intListValue"`
    StringListValue []string `thrift:"stringListValue,3" json:"stringListValue,omitempty" db:"stringListValue"`
}
// Compile time interface enforcer
var _ thrift.Struct = &ListUnion{}

func NewListUnion() *ListUnion {
    return (&ListUnion{})
}

func (x *ListUnion) GetIntListValueNonCompat() []int64 {
    return x.IntListValue
}

func (x *ListUnion) GetIntListValue() []int64 {
    if !x.IsSetIntListValue() {
        return make([]int64, 0)
    }

    return x.IntListValue
}

func (x *ListUnion) GetStringListValueNonCompat() []string {
    return x.StringListValue
}

func (x *ListUnion) GetStringListValue() []string {
    if !x.IsSetStringListValue() {
        return make([]string, 0)
    }

    return x.StringListValue
}

func (x *ListUnion) SetIntListValueNonCompat(value []int64) *ListUnion {
    x.IntListValue = value
    return x
}

func (x *ListUnion) SetIntListValue(value []int64) *ListUnion {
    x.IntListValue = value
    return x
}

func (x *ListUnion) SetStringListValueNonCompat(value []string) *ListUnion {
    x.StringListValue = value
    return x
}

func (x *ListUnion) SetStringListValue(value []string) *ListUnion {
    x.StringListValue = value
    return x
}

func (x *ListUnion) IsSetIntListValue() bool {
    return x != nil && x.IntListValue != nil
}

func (x *ListUnion) IsSetStringListValue() bool {
    return x != nil && x.StringListValue != nil
}

func (x *ListUnion) writeField2(p thrift.Protocol) error {  // IntListValue
    if !x.IsSetIntListValue() {
        return nil
    }

    if err := p.WriteFieldBegin("intListValue", thrift.LIST, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntListValueNonCompat()
    if err := p.WriteListBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ListUnion) writeField3(p thrift.Protocol) error {  // StringListValue
    if !x.IsSetStringListValue() {
        return nil
    }

    if err := p.WriteFieldBegin("stringListValue", thrift.LIST, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStringListValueNonCompat()
    if err := p.WriteListBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ListUnion) readField2(p thrift.Protocol) error {  // IntListValue
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetIntListValueNonCompat(result)
    return nil
}

func (x *ListUnion) readField3(p thrift.Protocol) error {  // StringListValue
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]string, 0, size)
for i := 0; i < size; i++ {
    var elem string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetStringListValueNonCompat(result)
    return nil
}

func (x *ListUnion) toString2() string {  // IntListValue
    return fmt.Sprintf("%v", x.GetIntListValueNonCompat())
}

func (x *ListUnion) toString3() string {  // StringListValue
    return fmt.Sprintf("%v", x.GetStringListValueNonCompat())
}

func (x *ListUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetIntListValue()) {
        count++
    }
    if (x.IsSetStringListValue()) {
        count++
    }
    return count
}

func (x *ListUnion) CountSetFieldsListUnion() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewListUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
type ListUnionBuilder struct {
    obj *ListUnion
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewListUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewListUnionBuilder() *ListUnionBuilder {
    return &ListUnionBuilder{
        obj: NewListUnion(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewListUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ListUnionBuilder) IntListValue(value []int64) *ListUnionBuilder {
    x.obj.IntListValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewListUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ListUnionBuilder) StringListValue(value []string) *ListUnionBuilder {
    x.obj.StringListValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewListUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ListUnionBuilder) Emit() *ListUnion {
    var objCopy ListUnion = *x.obj
    return &objCopy
}

func (x *ListUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("ListUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *ListUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 2 && wireType == thrift.Type(thrift.LIST)):  // intListValue
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.LIST)):  // stringListValue
            if err := x.readField3(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *ListUnion) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("ListUnion({")
    sb.WriteString(fmt.Sprintf("IntListValue:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("StringListValue:%s", x.toString3()))
    sb.WriteString("})")

    return sb.String()
}

type DataUnion struct {
    BinaryData []byte `thrift:"binaryData,1" json:"binaryData,omitempty" db:"binaryData"`
    StringData *string `thrift:"stringData,2" json:"stringData,omitempty" db:"stringData"`
}
// Compile time interface enforcer
var _ thrift.Struct = &DataUnion{}

func NewDataUnion() *DataUnion {
    return (&DataUnion{})
}

func (x *DataUnion) GetBinaryDataNonCompat() []byte {
    return x.BinaryData
}

func (x *DataUnion) GetBinaryData() []byte {
    if !x.IsSetBinaryData() {
        return []byte("")
    }

    return x.BinaryData
}

func (x *DataUnion) GetStringDataNonCompat() *string {
    return x.StringData
}

func (x *DataUnion) GetStringData() string {
    if !x.IsSetStringData() {
        return ""
    }

    return *x.StringData
}

func (x *DataUnion) SetBinaryDataNonCompat(value []byte) *DataUnion {
    x.BinaryData = value
    return x
}

func (x *DataUnion) SetBinaryData(value []byte) *DataUnion {
    x.BinaryData = value
    return x
}

func (x *DataUnion) SetStringDataNonCompat(value string) *DataUnion {
    x.StringData = &value
    return x
}

func (x *DataUnion) SetStringData(value *string) *DataUnion {
    x.StringData = value
    return x
}

func (x *DataUnion) IsSetBinaryData() bool {
    return x != nil && x.BinaryData != nil
}

func (x *DataUnion) IsSetStringData() bool {
    return x != nil && x.StringData != nil
}

func (x *DataUnion) writeField1(p thrift.Protocol) error {  // BinaryData
    if !x.IsSetBinaryData() {
        return nil
    }

    if err := p.WriteFieldBegin("binaryData", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetBinaryDataNonCompat()
    if err := p.WriteBinary(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *DataUnion) writeField2(p thrift.Protocol) error {  // StringData
    if !x.IsSetStringData() {
        return nil
    }

    if err := p.WriteFieldBegin("stringData", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetStringDataNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *DataUnion) readField1(p thrift.Protocol) error {  // BinaryData
    result, err := p.ReadBinary()
if err != nil {
    return err
}

    x.SetBinaryDataNonCompat(result)
    return nil
}

func (x *DataUnion) readField2(p thrift.Protocol) error {  // StringData
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStringDataNonCompat(result)
    return nil
}

func (x *DataUnion) toString1() string {  // BinaryData
    return fmt.Sprintf("%v", x.GetBinaryDataNonCompat())
}

func (x *DataUnion) toString2() string {  // StringData
    if x.IsSetStringData() {
        return fmt.Sprintf("%v", *x.GetStringDataNonCompat())
    }
    return fmt.Sprintf("%v", x.GetStringDataNonCompat())
}


func (x *DataUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetBinaryData()) {
        count++
    }
    if (x.IsSetStringData()) {
        count++
    }
    return count
}

func (x *DataUnion) CountSetFieldsDataUnion() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDataUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
type DataUnionBuilder struct {
    obj *DataUnion
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDataUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewDataUnionBuilder() *DataUnionBuilder {
    return &DataUnionBuilder{
        obj: NewDataUnion(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDataUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DataUnionBuilder) BinaryData(value []byte) *DataUnionBuilder {
    x.obj.BinaryData = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDataUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DataUnionBuilder) StringData(value *string) *DataUnionBuilder {
    x.obj.StringData = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDataUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DataUnionBuilder) Emit() *DataUnion {
    var objCopy DataUnion = *x.obj
    return &objCopy
}

func (x *DataUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("DataUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *DataUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // binaryData
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // stringData
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *DataUnion) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("DataUnion({")
    sb.WriteString(fmt.Sprintf("BinaryData:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("StringData:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}

type Val struct {
    StrVal string `thrift:"strVal,1" json:"strVal" db:"strVal"`
    IntVal int32 `thrift:"intVal,2" json:"intVal" db:"intVal"`
    TypedefValue ContainerTypedef `thrift:"typedefValue,9" json:"typedefValue" db:"typedefValue"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Val{}

func NewVal() *Val {
    return (&Val{}).
        SetStrValNonCompat("").
        SetIntValNonCompat(0).
        SetTypedefValueNonCompat(NewContainerTypedef())
}

func (x *Val) GetStrValNonCompat() string {
    return x.StrVal
}

func (x *Val) GetStrVal() string {
    return x.StrVal
}

func (x *Val) GetIntValNonCompat() int32 {
    return x.IntVal
}

func (x *Val) GetIntVal() int32 {
    return x.IntVal
}

func (x *Val) GetTypedefValueNonCompat() ContainerTypedef {
    return x.TypedefValue
}

func (x *Val) GetTypedefValue() ContainerTypedef {
    if !x.IsSetTypedefValue() {
        return NewContainerTypedef()
    }

    return x.TypedefValue
}

func (x *Val) SetStrValNonCompat(value string) *Val {
    x.StrVal = value
    return x
}

func (x *Val) SetStrVal(value string) *Val {
    x.StrVal = value
    return x
}

func (x *Val) SetIntValNonCompat(value int32) *Val {
    x.IntVal = value
    return x
}

func (x *Val) SetIntVal(value int32) *Val {
    x.IntVal = value
    return x
}

func (x *Val) SetTypedefValueNonCompat(value ContainerTypedef) *Val {
    x.TypedefValue = value
    return x
}

func (x *Val) SetTypedefValue(value ContainerTypedef) *Val {
    x.TypedefValue = value
    return x
}

func (x *Val) IsSetTypedefValue() bool {
    return x != nil && x.TypedefValue != nil
}

func (x *Val) writeField1(p thrift.Protocol) error {  // StrVal
    if err := p.WriteFieldBegin("strVal", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStrValNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Val) writeField2(p thrift.Protocol) error {  // IntVal
    if err := p.WriteFieldBegin("intVal", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntValNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Val) writeField9(p thrift.Protocol) error {  // TypedefValue
    if err := p.WriteFieldBegin("typedefValue", thrift.MAP, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTypedefValueNonCompat()
    err := WriteContainerTypedef(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Val) readField1(p thrift.Protocol) error {  // StrVal
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStrValNonCompat(result)
    return nil
}

func (x *Val) readField2(p thrift.Protocol) error {  // IntVal
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetIntValNonCompat(result)
    return nil
}

func (x *Val) readField9(p thrift.Protocol) error {  // TypedefValue
    result, err := ReadContainerTypedef(p)
if err != nil {
    return err
}

    x.SetTypedefValueNonCompat(result)
    return nil
}

func (x *Val) toString1() string {  // StrVal
    return fmt.Sprintf("%v", x.GetStrValNonCompat())
}

func (x *Val) toString2() string {  // IntVal
    return fmt.Sprintf("%v", x.GetIntValNonCompat())
}

func (x *Val) toString9() string {  // TypedefValue
    return fmt.Sprintf("%v", x.GetTypedefValueNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVal().Set<FieldNameFoo>().Set<FieldNameBar>()
type ValBuilder struct {
    obj *Val
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVal().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewValBuilder() *ValBuilder {
    return &ValBuilder{
        obj: NewVal(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVal().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ValBuilder) StrVal(value string) *ValBuilder {
    x.obj.StrVal = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVal().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ValBuilder) IntVal(value int32) *ValBuilder {
    x.obj.IntVal = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVal().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ValBuilder) TypedefValue(value ContainerTypedef) *ValBuilder {
    x.obj.TypedefValue = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVal().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ValBuilder) Emit() *Val {
    var objCopy Val = *x.obj
    return &objCopy
}

func (x *Val) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Val"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Val) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // strVal
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.I32)):  // intVal
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 9 && wireType == thrift.Type(thrift.MAP)):  // typedefValue
            if err := x.readField9(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *Val) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("Val({")
    sb.WriteString(fmt.Sprintf("StrVal:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("IntVal:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("TypedefValue:%s", x.toString9()))
    sb.WriteString("})")

    return sb.String()
}

type ValUnion struct {
    V1 *Val `thrift:"v1,1" json:"v1,omitempty" db:"v1"`
    V2 *Val `thrift:"v2,2" json:"v2,omitempty" db:"v2"`
}
// Compile time interface enforcer
var _ thrift.Struct = &ValUnion{}

func NewValUnion() *ValUnion {
    return (&ValUnion{})
}

func (x *ValUnion) GetV1NonCompat() *Val {
    return x.V1
}

func (x *ValUnion) GetV1() *Val {
    if !x.IsSetV1() {
        return nil
    }

    return x.V1
}

func (x *ValUnion) GetV2NonCompat() *Val {
    return x.V2
}

func (x *ValUnion) GetV2() *Val {
    if !x.IsSetV2() {
        return nil
    }

    return x.V2
}

func (x *ValUnion) SetV1NonCompat(value Val) *ValUnion {
    x.V1 = &value
    return x
}

func (x *ValUnion) SetV1(value *Val) *ValUnion {
    x.V1 = value
    return x
}

func (x *ValUnion) SetV2NonCompat(value Val) *ValUnion {
    x.V2 = &value
    return x
}

func (x *ValUnion) SetV2(value *Val) *ValUnion {
    x.V2 = value
    return x
}

func (x *ValUnion) IsSetV1() bool {
    return x != nil && x.V1 != nil
}

func (x *ValUnion) IsSetV2() bool {
    return x != nil && x.V2 != nil
}

func (x *ValUnion) writeField1(p thrift.Protocol) error {  // V1
    if !x.IsSetV1() {
        return nil
    }

    if err := p.WriteFieldBegin("v1", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetV1NonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ValUnion) writeField2(p thrift.Protocol) error {  // V2
    if !x.IsSetV2() {
        return nil
    }

    if err := p.WriteFieldBegin("v2", thrift.STRUCT, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetV2NonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ValUnion) readField1(p thrift.Protocol) error {  // V1
    result := *NewVal()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetV1NonCompat(result)
    return nil
}

func (x *ValUnion) readField2(p thrift.Protocol) error {  // V2
    result := *NewVal()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetV2NonCompat(result)
    return nil
}

func (x *ValUnion) toString1() string {  // V1
    return fmt.Sprintf("%v", x.GetV1NonCompat())
}

func (x *ValUnion) toString2() string {  // V2
    return fmt.Sprintf("%v", x.GetV2NonCompat())
}

// Deprecated: Use NewValUnion().GetV1() instead.
func (x *ValUnion) DefaultGetV1() *Val {
    if !x.IsSetV1() {
        return NewVal()
    }
    return x.V1
}

// Deprecated: Use NewValUnion().GetV2() instead.
func (x *ValUnion) DefaultGetV2() *Val {
    if !x.IsSetV2() {
        return NewVal()
    }
    return x.V2
}

func (x *ValUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetV1()) {
        count++
    }
    if (x.IsSetV2()) {
        count++
    }
    return count
}

func (x *ValUnion) CountSetFieldsValUnion() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewValUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
type ValUnionBuilder struct {
    obj *ValUnion
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewValUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewValUnionBuilder() *ValUnionBuilder {
    return &ValUnionBuilder{
        obj: NewValUnion(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewValUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ValUnionBuilder) V1(value *Val) *ValUnionBuilder {
    x.obj.V1 = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewValUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ValUnionBuilder) V2(value *Val) *ValUnionBuilder {
    x.obj.V2 = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewValUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ValUnionBuilder) Emit() *ValUnion {
    var objCopy ValUnion = *x.obj
    return &objCopy
}

func (x *ValUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("ValUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *ValUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // v1
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRUCT)):  // v2
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *ValUnion) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("ValUnion({")
    sb.WriteString(fmt.Sprintf("V1:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("V2:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}

type VirtualComplexUnion struct {
    ThingOne *string `thrift:"thingOne,1" json:"thingOne,omitempty" db:"thingOne"`
    ThingTwo *string `thrift:"thingTwo,2" json:"thingTwo,omitempty" db:"thingTwo"`
}
// Compile time interface enforcer
var _ thrift.Struct = &VirtualComplexUnion{}

func NewVirtualComplexUnion() *VirtualComplexUnion {
    return (&VirtualComplexUnion{})
}

func (x *VirtualComplexUnion) GetThingOneNonCompat() *string {
    return x.ThingOne
}

func (x *VirtualComplexUnion) GetThingOne() string {
    if !x.IsSetThingOne() {
        return ""
    }

    return *x.ThingOne
}

func (x *VirtualComplexUnion) GetThingTwoNonCompat() *string {
    return x.ThingTwo
}

func (x *VirtualComplexUnion) GetThingTwo() string {
    if !x.IsSetThingTwo() {
        return ""
    }

    return *x.ThingTwo
}

func (x *VirtualComplexUnion) SetThingOneNonCompat(value string) *VirtualComplexUnion {
    x.ThingOne = &value
    return x
}

func (x *VirtualComplexUnion) SetThingOne(value *string) *VirtualComplexUnion {
    x.ThingOne = value
    return x
}

func (x *VirtualComplexUnion) SetThingTwoNonCompat(value string) *VirtualComplexUnion {
    x.ThingTwo = &value
    return x
}

func (x *VirtualComplexUnion) SetThingTwo(value *string) *VirtualComplexUnion {
    x.ThingTwo = value
    return x
}

func (x *VirtualComplexUnion) IsSetThingOne() bool {
    return x != nil && x.ThingOne != nil
}

func (x *VirtualComplexUnion) IsSetThingTwo() bool {
    return x != nil && x.ThingTwo != nil
}

func (x *VirtualComplexUnion) writeField1(p thrift.Protocol) error {  // ThingOne
    if !x.IsSetThingOne() {
        return nil
    }

    if err := p.WriteFieldBegin("thingOne", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetThingOneNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *VirtualComplexUnion) writeField2(p thrift.Protocol) error {  // ThingTwo
    if !x.IsSetThingTwo() {
        return nil
    }

    if err := p.WriteFieldBegin("thingTwo", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetThingTwoNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *VirtualComplexUnion) readField1(p thrift.Protocol) error {  // ThingOne
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetThingOneNonCompat(result)
    return nil
}

func (x *VirtualComplexUnion) readField2(p thrift.Protocol) error {  // ThingTwo
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetThingTwoNonCompat(result)
    return nil
}

func (x *VirtualComplexUnion) toString1() string {  // ThingOne
    if x.IsSetThingOne() {
        return fmt.Sprintf("%v", *x.GetThingOneNonCompat())
    }
    return fmt.Sprintf("%v", x.GetThingOneNonCompat())
}

func (x *VirtualComplexUnion) toString2() string {  // ThingTwo
    if x.IsSetThingTwo() {
        return fmt.Sprintf("%v", *x.GetThingTwoNonCompat())
    }
    return fmt.Sprintf("%v", x.GetThingTwoNonCompat())
}



func (x *VirtualComplexUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetThingOne()) {
        count++
    }
    if (x.IsSetThingTwo()) {
        count++
    }
    return count
}

func (x *VirtualComplexUnion) CountSetFieldsVirtualComplexUnion() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVirtualComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
type VirtualComplexUnionBuilder struct {
    obj *VirtualComplexUnion
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVirtualComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewVirtualComplexUnionBuilder() *VirtualComplexUnionBuilder {
    return &VirtualComplexUnionBuilder{
        obj: NewVirtualComplexUnion(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVirtualComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *VirtualComplexUnionBuilder) ThingOne(value *string) *VirtualComplexUnionBuilder {
    x.obj.ThingOne = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVirtualComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *VirtualComplexUnionBuilder) ThingTwo(value *string) *VirtualComplexUnionBuilder {
    x.obj.ThingTwo = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewVirtualComplexUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *VirtualComplexUnionBuilder) Emit() *VirtualComplexUnion {
    var objCopy VirtualComplexUnion = *x.obj
    return &objCopy
}

func (x *VirtualComplexUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("VirtualComplexUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *VirtualComplexUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // thingOne
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // thingTwo
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *VirtualComplexUnion) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("VirtualComplexUnion({")
    sb.WriteString(fmt.Sprintf("ThingOne:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("ThingTwo:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}

type NonCopyableStruct struct {
    Num int64 `thrift:"num,1" json:"num" db:"num"`
}
// Compile time interface enforcer
var _ thrift.Struct = &NonCopyableStruct{}

func NewNonCopyableStruct() *NonCopyableStruct {
    return (&NonCopyableStruct{}).
        SetNumNonCompat(0)
}

func (x *NonCopyableStruct) GetNumNonCompat() int64 {
    return x.Num
}

func (x *NonCopyableStruct) GetNum() int64 {
    return x.Num
}

func (x *NonCopyableStruct) SetNumNonCompat(value int64) *NonCopyableStruct {
    x.Num = value
    return x
}

func (x *NonCopyableStruct) SetNum(value int64) *NonCopyableStruct {
    x.Num = value
    return x
}

func (x *NonCopyableStruct) writeField1(p thrift.Protocol) error {  // Num
    if err := p.WriteFieldBegin("num", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNumNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *NonCopyableStruct) readField1(p thrift.Protocol) error {  // Num
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetNumNonCompat(result)
    return nil
}

func (x *NonCopyableStruct) toString1() string {  // Num
    return fmt.Sprintf("%v", x.GetNumNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type NonCopyableStructBuilder struct {
    obj *NonCopyableStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewNonCopyableStructBuilder() *NonCopyableStructBuilder {
    return &NonCopyableStructBuilder{
        obj: NewNonCopyableStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *NonCopyableStructBuilder) Num(value int64) *NonCopyableStructBuilder {
    x.obj.Num = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *NonCopyableStructBuilder) Emit() *NonCopyableStruct {
    var objCopy NonCopyableStruct = *x.obj
    return &objCopy
}

func (x *NonCopyableStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("NonCopyableStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *NonCopyableStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // num
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *NonCopyableStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("NonCopyableStruct({")
    sb.WriteString(fmt.Sprintf("Num:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type NonCopyableUnion struct {
    S *NonCopyableStruct `thrift:"s,1" json:"s,omitempty" db:"s"`
}
// Compile time interface enforcer
var _ thrift.Struct = &NonCopyableUnion{}

func NewNonCopyableUnion() *NonCopyableUnion {
    return (&NonCopyableUnion{})
}

func (x *NonCopyableUnion) GetSNonCompat() *NonCopyableStruct {
    return x.S
}

func (x *NonCopyableUnion) GetS() *NonCopyableStruct {
    if !x.IsSetS() {
        return nil
    }

    return x.S
}

func (x *NonCopyableUnion) SetSNonCompat(value NonCopyableStruct) *NonCopyableUnion {
    x.S = &value
    return x
}

func (x *NonCopyableUnion) SetS(value *NonCopyableStruct) *NonCopyableUnion {
    x.S = value
    return x
}

func (x *NonCopyableUnion) IsSetS() bool {
    return x != nil && x.S != nil
}

func (x *NonCopyableUnion) writeField1(p thrift.Protocol) error {  // S
    if !x.IsSetS() {
        return nil
    }

    if err := p.WriteFieldBegin("s", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *NonCopyableUnion) readField1(p thrift.Protocol) error {  // S
    result := *NewNonCopyableStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetSNonCompat(result)
    return nil
}

func (x *NonCopyableUnion) toString1() string {  // S
    return fmt.Sprintf("%v", x.GetSNonCompat())
}

// Deprecated: Use NewNonCopyableUnion().GetS() instead.
func (x *NonCopyableUnion) DefaultGetS() *NonCopyableStruct {
    if !x.IsSetS() {
        return NewNonCopyableStruct()
    }
    return x.S
}

func (x *NonCopyableUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetS()) {
        count++
    }
    return count
}

func (x *NonCopyableUnion) CountSetFieldsNonCopyableUnion() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
type NonCopyableUnionBuilder struct {
    obj *NonCopyableUnion
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewNonCopyableUnionBuilder() *NonCopyableUnionBuilder {
    return &NonCopyableUnionBuilder{
        obj: NewNonCopyableUnion(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *NonCopyableUnionBuilder) S(value *NonCopyableStruct) *NonCopyableUnionBuilder {
    x.obj.S = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewNonCopyableUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *NonCopyableUnionBuilder) Emit() *NonCopyableUnion {
    var objCopy NonCopyableUnion = *x.obj
    return &objCopy
}

func (x *NonCopyableUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("NonCopyableUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *NonCopyableUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // s
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *NonCopyableUnion) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("NonCopyableUnion({")
    sb.WriteString(fmt.Sprintf("S:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

// RegisterTypes registers types found in this file that have a thrift_uri with the passed in registry.
func RegisterTypes(registry interface {
  RegisterType(name string, initializer func() any)
}) {

}
