// @generated by Thrift for thrift/compiler/test/fixtures/adapter/src/module.thrift
// This file is probably not the place you want to edit!

//! Mock definitions for `module`.
//!
//! Client mocks. For every service, a struct mock::TheService that implements
//! client::TheService.
//!
//! As an example of the generated API, for the following thrift service:
//!
//! ```thrift
//! service MyService {
//!     FunctionResponse myFunction(
//!         1: FunctionRequest request,
//!     ) throws {
//!         1: StorageException s,
//!         2: NotFoundException n,
//!     ),
//!
//!     // other functions
//! }
//! ```
//!
//! we would end up with this mock object under crate::mock::MyService:
//!
//! ```
//! # const _: &str = stringify! {
//! impl crate::client::MyService for MyService<'mock> {...}
//!
//! pub struct MyService<'mock> {
//!     pub myFunction: myFunction<'mock>,
//!     // ...
//! }
//!
//! impl dyn crate::client::MyService {
//!     pub fn mock<'mock>() -> MyService<'mock>;
//! }
//!
//! impl myFunction<'mock> {
//!     // directly return the given success response
//!     pub fn ret(&self, value: FunctionResponse);
//!
//!     // invoke closure to compute success response
//!     pub fn mock(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> FunctionResponse + Send + Sync + 'mock,
//!     );
//!
//!     // invoke closure to compute response
//!     pub fn mock_result(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> Result<FunctionResponse, crate::services::MyService::MyFunctionExn> + Send + Sync + 'mock,
//!     );
//!
//!     // return one of the function's declared exceptions
//!     pub fn throw<E>(&self, exception: E)
//!     where
//!         E: Clone + Into<crate::services::MyService::MyFunctionExn> + Send + Sync + 'mock;
//! }
//!
//! impl From<StorageException> for MyFunctionExn {...}
//! impl From<NotFoundException> for MyFunctionExn {...}
//! # };
//! ```
//!
//! The intended usage from a test would be:
//!
//! ```
//! # const _: &str = stringify! {
//! use std::sync::Arc;
//! use thrift_if::client::MyService;
//!
//! #[test]
//! fn test_my_client() {
//!     let mock = Arc::new(<dyn MyService>::mock());
//!
//!     // directly return a success response
//!     let resp = FunctionResponse {...};
//!     mock.myFunction.ret(resp);
//!
//!     // or give a closure to compute the success response
//!     mock.myFunction.mock(|request| FunctionResponse {...});
//!
//!     // or throw one of the function's exceptions
//!     mock.myFunction.throw(StorageException::ItFailed);
//!
//!     // or compute a Result (useful if your exceptions aren't Clone)
//!     mock.myFunction.mock_result(|request| Err(...));
//!
//!     let out = do_the_thing(mock).wait().unwrap();
//!     assert!(out.what_i_expected());
//! }
//!
//! fn do_the_thing(
//!     client: Arc<dyn MyService + Send + Sync + 'static>,
//! ) -> impl Future<Item = Out> {...}
//! # };
//! ```

pub struct Service<'mock> {
    pub func: r#impl::service::func<'mock>,
    _marker: ::std::marker::PhantomData<&'mock ()>,
}

impl dyn super::client::Service {
    pub fn mock<'mock>() -> Service<'mock> {
        Service {
            func: r#impl::service::func::unimplemented(),
            _marker: ::std::marker::PhantomData,
        }
    }
}

impl<'mock> super::client::Service for Service<'mock> {
    fn func(
        &self,
        arg_arg1: &::std::primitive::str,
        arg_arg2: &::std::primitive::str,
        arg_arg3: &crate::types::Foo,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::MyI32_4873, crate::errors::service::FuncError>> {
        let mut closure = self.func.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut(crate::types::StringWithAdapter_7208, ::std::string::String, crate::types::Foo) -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure(arg_arg1.to_owned(), arg_arg2.to_owned(), arg_arg3.clone())))
    }
}

pub struct AdapterService<'mock> {
    pub count: r#impl::adapter_service::count<'mock>,
    pub adaptedTypes: r#impl::adapter_service::adaptedTypes<'mock>,
    _marker: ::std::marker::PhantomData<&'mock ()>,
}

impl dyn super::client::AdapterService {
    pub fn mock<'mock>() -> AdapterService<'mock> {
        AdapterService {
            count: r#impl::adapter_service::count::unimplemented(),
            adaptedTypes: r#impl::adapter_service::adaptedTypes::unimplemented(),
            _marker: ::std::marker::PhantomData,
        }
    }
}

impl<'mock> super::client::AdapterService for AdapterService<'mock> {
    fn count(
        &self,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::CountingStruct, crate::errors::adapter_service::CountError>> {
        let mut closure = self.count.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut() -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure()))
    }
    fn adaptedTypes(
        &self,
        arg_arg: &crate::types::HeapAllocated,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<crate::types::HeapAllocated, crate::errors::adapter_service::AdaptedTypesError>> {
        let mut closure = self.adaptedTypes.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut(crate::types::HeapAllocated) -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure(arg_arg.clone())))
    }
}

pub mod r#impl {
    pub mod service {

        pub struct func<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut(crate::types::StringWithAdapter_7208, ::std::string::String, crate::types::Foo) -> ::std::result::Result<
                    crate::types::MyI32_4873,
                    crate::errors::service::FuncError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> func<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|_: crate::types::StringWithAdapter_7208, _: ::std::string::String, _: crate::types::Foo| panic!(
                        "{}::{} is not mocked",
                        "Service",
                        "func",
                    ))),
                }
            }

            pub fn ret(&self, value: crate::types::MyI32_4873) {
                self.mock(move |_: crate::types::StringWithAdapter_7208, _: ::std::string::String, _: crate::types::Foo| value.clone());
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut(crate::types::StringWithAdapter_7208, ::std::string::String, crate::types::Foo) -> crate::types::MyI32_4873 + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |arg1, arg2, arg3| ::std::result::Result::Ok(mock(arg1, arg2, arg3)));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut(crate::types::StringWithAdapter_7208, ::std::string::String, crate::types::Foo) -> ::std::result::Result<crate::types::MyI32_4873, crate::errors::service::FuncError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |arg1, arg2, arg3| mock(arg1, arg2, arg3));
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<crate::errors::service::FuncError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |_: crate::types::StringWithAdapter_7208, _: ::std::string::String, _: crate::types::Foo| ::std::result::Result::Err(exception.clone().into()));
            }
        }
    }
    pub mod adapter_service {

        pub struct count<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut() -> ::std::result::Result<
                    crate::types::CountingStruct,
                    crate::errors::adapter_service::CountError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> count<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|| panic!(
                        "{}::{} is not mocked",
                        "AdapterService",
                        "count",
                    ))),
                }
            }

            pub fn ret(&self, value: crate::types::CountingStruct) {
                self.mock(move || value.clone());
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut() -> crate::types::CountingStruct + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Ok(mock()));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut() -> ::std::result::Result<crate::types::CountingStruct, crate::errors::adapter_service::CountError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || mock());
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<crate::errors::adapter_service::CountError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move || ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct adaptedTypes<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut(crate::types::HeapAllocated) -> ::std::result::Result<
                    crate::types::HeapAllocated,
                    crate::errors::adapter_service::AdaptedTypesError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> adaptedTypes<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|_: crate::types::HeapAllocated| panic!(
                        "{}::{} is not mocked",
                        "AdapterService",
                        "adaptedTypes",
                    ))),
                }
            }

            pub fn ret(&self, value: crate::types::HeapAllocated) {
                self.mock(move |_: crate::types::HeapAllocated| value.clone());
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut(crate::types::HeapAllocated) -> crate::types::HeapAllocated + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |arg| ::std::result::Result::Ok(mock(arg)));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut(crate::types::HeapAllocated) -> ::std::result::Result<crate::types::HeapAllocated, crate::errors::adapter_service::AdaptedTypesError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |arg| mock(arg));
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<crate::errors::adapter_service::AdaptedTypesError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |_: crate::types::HeapAllocated| ::std::result::Result::Err(exception.clone().into()));
            }
        }
    }
}
