// @generated by Thrift for [[[ program path ]]]
// This file is probably not the place you want to edit!

package standard // [[[ program thrift source path ]]]

import (
    "fmt"
    "strings"

    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
)

// (needed to ensure safety because of naive import list construction)
var _ = fmt.Printf
var _ = strings.Split
var _ = thrift.ZERO


type ByteString = []byte

func NewByteString() ByteString {
    return []byte("")
}

func WriteByteString(item ByteString, p thrift.Protocol) error {
    if err := p.WriteBinary(item); err != nil {
    return err
}
    return nil
}

func ReadByteString(p thrift.Protocol) (ByteString, error) {
    var decodeResult ByteString
    decodeErr := func() error {
        result, err := p.ReadBinary()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type ByteBuffer = []byte

func NewByteBuffer() ByteBuffer {
    return []byte("")
}

func WriteByteBuffer(item ByteBuffer, p thrift.Protocol) error {
    if err := p.WriteBinary(item); err != nil {
    return err
}
    return nil
}

func ReadByteBuffer(p thrift.Protocol) (ByteBuffer, error) {
    var decodeResult ByteBuffer
    decodeErr := func() error {
        result, err := p.ReadBinary()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type Uri = string

func NewUri() Uri {
    return ""
}

func WriteUri(item Uri, p thrift.Protocol) error {
    if err := p.WriteString(item); err != nil {
    return err
}
    return nil
}

func ReadUri(p thrift.Protocol) (Uri, error) {
    var decodeResult Uri
    decodeErr := func() error {
        result, err := p.ReadString()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type Void int32

const (
    Void_Unused Void = 0
)

// Enum value maps for Void
var (
    VoidToName = map[Void]string {
        Void_Unused: "Unused",
    }

    VoidToValue = map[string]Void {
        "Unused": Void_Unused,
    }

    VoidNames = []string{
        "Unused",
    }

    VoidValues = []Void{
        Void_Unused,
    }
)

func (x Void) String() string {
    if v, ok := VoidToName[x]; ok {
        return v
    }
    return "<UNSET>"
}

func (x Void) Ptr() *Void {
    return &x
}

// Deprecated: Use VoidToValue instead (e.g. `x, ok := VoidToValue["name"]`).
func VoidFromString(s string) (Void, error) {
    if v, ok := VoidToValue[s]; ok {
        return v, nil
    }
    return Void(0), fmt.Errorf("not a valid Void string")
}

// Deprecated: Use Void.Ptr() instead.
func VoidPtr(v Void) *Void {
    return &v
}


type StandardProtocol int32

const (
    StandardProtocol_Custom StandardProtocol = 0
    StandardProtocol_Binary StandardProtocol = 1
    StandardProtocol_Compact StandardProtocol = 2
    StandardProtocol_Json StandardProtocol = 3
    StandardProtocol_SimpleJson StandardProtocol = 4
)

// Enum value maps for StandardProtocol
var (
    StandardProtocolToName = map[StandardProtocol]string {
        StandardProtocol_Custom: "Custom",
        StandardProtocol_Binary: "Binary",
        StandardProtocol_Compact: "Compact",
        StandardProtocol_Json: "Json",
        StandardProtocol_SimpleJson: "SimpleJson",
    }

    StandardProtocolToValue = map[string]StandardProtocol {
        "Custom": StandardProtocol_Custom,
        "Binary": StandardProtocol_Binary,
        "Compact": StandardProtocol_Compact,
        "Json": StandardProtocol_Json,
        "SimpleJson": StandardProtocol_SimpleJson,
    }

    StandardProtocolNames = []string{
        "Custom",
        "Binary",
        "Compact",
        "Json",
        "SimpleJson",
    }

    StandardProtocolValues = []StandardProtocol{
        StandardProtocol_Custom,
        StandardProtocol_Binary,
        StandardProtocol_Compact,
        StandardProtocol_Json,
        StandardProtocol_SimpleJson,
    }
)

func (x StandardProtocol) String() string {
    if v, ok := StandardProtocolToName[x]; ok {
        return v
    }
    return "<UNSET>"
}

func (x StandardProtocol) Ptr() *StandardProtocol {
    return &x
}

// Deprecated: Use StandardProtocolToValue instead (e.g. `x, ok := StandardProtocolToValue["name"]`).
func StandardProtocolFromString(s string) (StandardProtocol, error) {
    if v, ok := StandardProtocolToValue[s]; ok {
        return v, nil
    }
    return StandardProtocol(0), fmt.Errorf("not a valid StandardProtocol string")
}

// Deprecated: Use StandardProtocol.Ptr() instead.
func StandardProtocolPtr(v StandardProtocol) *StandardProtocol {
    return &v
}


type TypeUri struct {
    Uri *Uri `thrift:"uri,1" json:"uri,omitempty" db:"uri"`
    TypeHashPrefixSha2_256 ByteString `thrift:"typeHashPrefixSha2_256,2" json:"typeHashPrefixSha2_256,omitempty" db:"typeHashPrefixSha2_256"`
    ScopedName *string `thrift:"scopedName,3" json:"scopedName,omitempty" db:"scopedName"`
}
// Compile time interface enforcer
var _ thrift.Struct = &TypeUri{}

func NewTypeUri() *TypeUri {
    return (&TypeUri{})
}

func (x *TypeUri) GetUriNonCompat() *Uri {
    return x.Uri
}

func (x *TypeUri) GetUri() Uri {
    if !x.IsSetUri() {
        return NewUri()
    }

    return *x.Uri
}

func (x *TypeUri) GetTypeHashPrefixSha2_256NonCompat() ByteString {
    return x.TypeHashPrefixSha2_256
}

func (x *TypeUri) GetTypeHashPrefixSha2_256() ByteString {
    if !x.IsSetTypeHashPrefixSha2_256() {
        return NewByteString()
    }

    return x.TypeHashPrefixSha2_256
}

func (x *TypeUri) GetScopedNameNonCompat() *string {
    return x.ScopedName
}

func (x *TypeUri) GetScopedName() string {
    if !x.IsSetScopedName() {
        return ""
    }

    return *x.ScopedName
}

func (x *TypeUri) SetUriNonCompat(value Uri) *TypeUri {
    x.Uri = &value
    return x
}

func (x *TypeUri) SetUri(value *Uri) *TypeUri {
    x.Uri = value
    return x
}

func (x *TypeUri) SetTypeHashPrefixSha2_256NonCompat(value ByteString) *TypeUri {
    x.TypeHashPrefixSha2_256 = value
    return x
}

func (x *TypeUri) SetTypeHashPrefixSha2_256(value ByteString) *TypeUri {
    x.TypeHashPrefixSha2_256 = value
    return x
}

func (x *TypeUri) SetScopedNameNonCompat(value string) *TypeUri {
    x.ScopedName = &value
    return x
}

func (x *TypeUri) SetScopedName(value *string) *TypeUri {
    x.ScopedName = value
    return x
}

func (x *TypeUri) IsSetUri() bool {
    return x != nil && x.Uri != nil
}

func (x *TypeUri) IsSetTypeHashPrefixSha2_256() bool {
    return x != nil && x.TypeHashPrefixSha2_256 != nil
}

func (x *TypeUri) IsSetScopedName() bool {
    return x != nil && x.ScopedName != nil
}

func (x *TypeUri) writeField1(p thrift.Protocol) error {  // Uri
    if !x.IsSetUri() {
        return nil
    }

    if err := p.WriteFieldBegin("uri", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetUriNonCompat()
    err := WriteUri(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeUri) writeField2(p thrift.Protocol) error {  // TypeHashPrefixSha2_256
    if !x.IsSetTypeHashPrefixSha2_256() {
        return nil
    }

    if err := p.WriteFieldBegin("typeHashPrefixSha2_256", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTypeHashPrefixSha2_256NonCompat()
    err := WriteByteString(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeUri) writeField3(p thrift.Protocol) error {  // ScopedName
    if !x.IsSetScopedName() {
        return nil
    }

    if err := p.WriteFieldBegin("scopedName", thrift.STRING, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetScopedNameNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeUri) readField1(p thrift.Protocol) error {  // Uri
    result, err := ReadUri(p)
if err != nil {
    return err
}

    x.SetUriNonCompat(result)
    return nil
}

func (x *TypeUri) readField2(p thrift.Protocol) error {  // TypeHashPrefixSha2_256
    result, err := ReadByteString(p)
if err != nil {
    return err
}

    x.SetTypeHashPrefixSha2_256NonCompat(result)
    return nil
}

func (x *TypeUri) readField3(p thrift.Protocol) error {  // ScopedName
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetScopedNameNonCompat(result)
    return nil
}

func (x *TypeUri) toString1() string {  // Uri
    if x.IsSetUri() {
        return fmt.Sprintf("%v", *x.GetUriNonCompat())
    }
    return fmt.Sprintf("%v", x.GetUriNonCompat())
}

func (x *TypeUri) toString2() string {  // TypeHashPrefixSha2_256
    return fmt.Sprintf("%v", x.GetTypeHashPrefixSha2_256NonCompat())
}

func (x *TypeUri) toString3() string {  // ScopedName
    if x.IsSetScopedName() {
        return fmt.Sprintf("%v", *x.GetScopedNameNonCompat())
    }
    return fmt.Sprintf("%v", x.GetScopedNameNonCompat())
}



func (x *TypeUri) countSetFields() int {
    count := int(0)
    if (x.IsSetUri()) {
        count++
    }
    if (x.IsSetTypeHashPrefixSha2_256()) {
        count++
    }
    if (x.IsSetScopedName()) {
        count++
    }
    return count
}

func (x *TypeUri) CountSetFieldsTypeUri() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeUri().Set<FieldNameFoo>().Set<FieldNameBar>()
type TypeUriBuilder struct {
    obj *TypeUri
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeUri().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewTypeUriBuilder() *TypeUriBuilder {
    return &TypeUriBuilder{
        obj: NewTypeUri(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeUri().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeUriBuilder) Uri(value *Uri) *TypeUriBuilder {
    x.obj.Uri = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeUri().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeUriBuilder) TypeHashPrefixSha2_256(value ByteString) *TypeUriBuilder {
    x.obj.TypeHashPrefixSha2_256 = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeUri().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeUriBuilder) ScopedName(value *string) *TypeUriBuilder {
    x.obj.ScopedName = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeUri().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeUriBuilder) Emit() *TypeUri {
    var objCopy TypeUri = *x.obj
    return &objCopy
}

func (x *TypeUri) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("TypeUri"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *TypeUri) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // uri
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // typeHashPrefixSha2_256
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.STRING)):  // scopedName
            if err := x.readField3(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *TypeUri) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("TypeUri({")
    sb.WriteString(fmt.Sprintf("Uri:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("TypeHashPrefixSha2_256:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("ScopedName:%s", x.toString3()))
    sb.WriteString("})")

    return sb.String()
}

type TypeName struct {
    BoolType *Void `thrift:"boolType,1" json:"boolType,omitempty" db:"boolType"`
    ByteType *Void `thrift:"byteType,2" json:"byteType,omitempty" db:"byteType"`
    I16Type *Void `thrift:"i16Type,3" json:"i16Type,omitempty" db:"i16Type"`
    I32Type *Void `thrift:"i32Type,4" json:"i32Type,omitempty" db:"i32Type"`
    I64Type *Void `thrift:"i64Type,5" json:"i64Type,omitempty" db:"i64Type"`
    FloatType *Void `thrift:"floatType,6" json:"floatType,omitempty" db:"floatType"`
    DoubleType *Void `thrift:"doubleType,7" json:"doubleType,omitempty" db:"doubleType"`
    StringType *Void `thrift:"stringType,8" json:"stringType,omitempty" db:"stringType"`
    BinaryType *Void `thrift:"binaryType,9" json:"binaryType,omitempty" db:"binaryType"`
    EnumType *TypeUri `thrift:"enumType,10" json:"enumType,omitempty" db:"enumType"`
    StructType *TypeUri `thrift:"structType,11" json:"structType,omitempty" db:"structType"`
    UnionType *TypeUri `thrift:"unionType,12" json:"unionType,omitempty" db:"unionType"`
    ExceptionType *TypeUri `thrift:"exceptionType,13" json:"exceptionType,omitempty" db:"exceptionType"`
    ListType *Void `thrift:"listType,14" json:"listType,omitempty" db:"listType"`
    SetType *Void `thrift:"setType,15" json:"setType,omitempty" db:"setType"`
    MapType *Void `thrift:"mapType,16" json:"mapType,omitempty" db:"mapType"`
    TypedefType *TypeUri `thrift:"typedefType,17" json:"typedefType,omitempty" db:"typedefType"`
}
// Compile time interface enforcer
var _ thrift.Struct = &TypeName{}

func NewTypeName() *TypeName {
    return (&TypeName{})
}

func (x *TypeName) GetBoolTypeNonCompat() *Void {
    return x.BoolType
}

func (x *TypeName) GetBoolType() Void {
    if !x.IsSetBoolType() {
        return 0
    }

    return *x.BoolType
}

func (x *TypeName) GetByteTypeNonCompat() *Void {
    return x.ByteType
}

func (x *TypeName) GetByteType() Void {
    if !x.IsSetByteType() {
        return 0
    }

    return *x.ByteType
}

func (x *TypeName) GetI16TypeNonCompat() *Void {
    return x.I16Type
}

func (x *TypeName) GetI16Type() Void {
    if !x.IsSetI16Type() {
        return 0
    }

    return *x.I16Type
}

func (x *TypeName) GetI32TypeNonCompat() *Void {
    return x.I32Type
}

func (x *TypeName) GetI32Type() Void {
    if !x.IsSetI32Type() {
        return 0
    }

    return *x.I32Type
}

func (x *TypeName) GetI64TypeNonCompat() *Void {
    return x.I64Type
}

func (x *TypeName) GetI64Type() Void {
    if !x.IsSetI64Type() {
        return 0
    }

    return *x.I64Type
}

func (x *TypeName) GetFloatTypeNonCompat() *Void {
    return x.FloatType
}

func (x *TypeName) GetFloatType() Void {
    if !x.IsSetFloatType() {
        return 0
    }

    return *x.FloatType
}

func (x *TypeName) GetDoubleTypeNonCompat() *Void {
    return x.DoubleType
}

func (x *TypeName) GetDoubleType() Void {
    if !x.IsSetDoubleType() {
        return 0
    }

    return *x.DoubleType
}

func (x *TypeName) GetStringTypeNonCompat() *Void {
    return x.StringType
}

func (x *TypeName) GetStringType() Void {
    if !x.IsSetStringType() {
        return 0
    }

    return *x.StringType
}

func (x *TypeName) GetBinaryTypeNonCompat() *Void {
    return x.BinaryType
}

func (x *TypeName) GetBinaryType() Void {
    if !x.IsSetBinaryType() {
        return 0
    }

    return *x.BinaryType
}

func (x *TypeName) GetEnumTypeNonCompat() *TypeUri {
    return x.EnumType
}

func (x *TypeName) GetEnumType() *TypeUri {
    if !x.IsSetEnumType() {
        return nil
    }

    return x.EnumType
}

func (x *TypeName) GetStructTypeNonCompat() *TypeUri {
    return x.StructType
}

func (x *TypeName) GetStructType() *TypeUri {
    if !x.IsSetStructType() {
        return nil
    }

    return x.StructType
}

func (x *TypeName) GetUnionTypeNonCompat() *TypeUri {
    return x.UnionType
}

func (x *TypeName) GetUnionType() *TypeUri {
    if !x.IsSetUnionType() {
        return nil
    }

    return x.UnionType
}

func (x *TypeName) GetExceptionTypeNonCompat() *TypeUri {
    return x.ExceptionType
}

func (x *TypeName) GetExceptionType() *TypeUri {
    if !x.IsSetExceptionType() {
        return nil
    }

    return x.ExceptionType
}

func (x *TypeName) GetListTypeNonCompat() *Void {
    return x.ListType
}

func (x *TypeName) GetListType() Void {
    if !x.IsSetListType() {
        return 0
    }

    return *x.ListType
}

func (x *TypeName) GetSetTypeNonCompat() *Void {
    return x.SetType
}

func (x *TypeName) GetSetType() Void {
    if !x.IsSetSetType() {
        return 0
    }

    return *x.SetType
}

func (x *TypeName) GetMapTypeNonCompat() *Void {
    return x.MapType
}

func (x *TypeName) GetMapType() Void {
    if !x.IsSetMapType() {
        return 0
    }

    return *x.MapType
}

func (x *TypeName) GetTypedefTypeNonCompat() *TypeUri {
    return x.TypedefType
}

func (x *TypeName) GetTypedefType() *TypeUri {
    if !x.IsSetTypedefType() {
        return nil
    }

    return x.TypedefType
}

func (x *TypeName) SetBoolTypeNonCompat(value Void) *TypeName {
    x.BoolType = &value
    return x
}

func (x *TypeName) SetBoolType(value *Void) *TypeName {
    x.BoolType = value
    return x
}

func (x *TypeName) SetByteTypeNonCompat(value Void) *TypeName {
    x.ByteType = &value
    return x
}

func (x *TypeName) SetByteType(value *Void) *TypeName {
    x.ByteType = value
    return x
}

func (x *TypeName) SetI16TypeNonCompat(value Void) *TypeName {
    x.I16Type = &value
    return x
}

func (x *TypeName) SetI16Type(value *Void) *TypeName {
    x.I16Type = value
    return x
}

func (x *TypeName) SetI32TypeNonCompat(value Void) *TypeName {
    x.I32Type = &value
    return x
}

func (x *TypeName) SetI32Type(value *Void) *TypeName {
    x.I32Type = value
    return x
}

func (x *TypeName) SetI64TypeNonCompat(value Void) *TypeName {
    x.I64Type = &value
    return x
}

func (x *TypeName) SetI64Type(value *Void) *TypeName {
    x.I64Type = value
    return x
}

func (x *TypeName) SetFloatTypeNonCompat(value Void) *TypeName {
    x.FloatType = &value
    return x
}

func (x *TypeName) SetFloatType(value *Void) *TypeName {
    x.FloatType = value
    return x
}

func (x *TypeName) SetDoubleTypeNonCompat(value Void) *TypeName {
    x.DoubleType = &value
    return x
}

func (x *TypeName) SetDoubleType(value *Void) *TypeName {
    x.DoubleType = value
    return x
}

func (x *TypeName) SetStringTypeNonCompat(value Void) *TypeName {
    x.StringType = &value
    return x
}

func (x *TypeName) SetStringType(value *Void) *TypeName {
    x.StringType = value
    return x
}

func (x *TypeName) SetBinaryTypeNonCompat(value Void) *TypeName {
    x.BinaryType = &value
    return x
}

func (x *TypeName) SetBinaryType(value *Void) *TypeName {
    x.BinaryType = value
    return x
}

func (x *TypeName) SetEnumTypeNonCompat(value TypeUri) *TypeName {
    x.EnumType = &value
    return x
}

func (x *TypeName) SetEnumType(value *TypeUri) *TypeName {
    x.EnumType = value
    return x
}

func (x *TypeName) SetStructTypeNonCompat(value TypeUri) *TypeName {
    x.StructType = &value
    return x
}

func (x *TypeName) SetStructType(value *TypeUri) *TypeName {
    x.StructType = value
    return x
}

func (x *TypeName) SetUnionTypeNonCompat(value TypeUri) *TypeName {
    x.UnionType = &value
    return x
}

func (x *TypeName) SetUnionType(value *TypeUri) *TypeName {
    x.UnionType = value
    return x
}

func (x *TypeName) SetExceptionTypeNonCompat(value TypeUri) *TypeName {
    x.ExceptionType = &value
    return x
}

func (x *TypeName) SetExceptionType(value *TypeUri) *TypeName {
    x.ExceptionType = value
    return x
}

func (x *TypeName) SetListTypeNonCompat(value Void) *TypeName {
    x.ListType = &value
    return x
}

func (x *TypeName) SetListType(value *Void) *TypeName {
    x.ListType = value
    return x
}

func (x *TypeName) SetSetTypeNonCompat(value Void) *TypeName {
    x.SetType = &value
    return x
}

func (x *TypeName) SetSetType(value *Void) *TypeName {
    x.SetType = value
    return x
}

func (x *TypeName) SetMapTypeNonCompat(value Void) *TypeName {
    x.MapType = &value
    return x
}

func (x *TypeName) SetMapType(value *Void) *TypeName {
    x.MapType = value
    return x
}

func (x *TypeName) SetTypedefTypeNonCompat(value TypeUri) *TypeName {
    x.TypedefType = &value
    return x
}

func (x *TypeName) SetTypedefType(value *TypeUri) *TypeName {
    x.TypedefType = value
    return x
}

func (x *TypeName) IsSetBoolType() bool {
    return x != nil && x.BoolType != nil
}

func (x *TypeName) IsSetByteType() bool {
    return x != nil && x.ByteType != nil
}

func (x *TypeName) IsSetI16Type() bool {
    return x != nil && x.I16Type != nil
}

func (x *TypeName) IsSetI32Type() bool {
    return x != nil && x.I32Type != nil
}

func (x *TypeName) IsSetI64Type() bool {
    return x != nil && x.I64Type != nil
}

func (x *TypeName) IsSetFloatType() bool {
    return x != nil && x.FloatType != nil
}

func (x *TypeName) IsSetDoubleType() bool {
    return x != nil && x.DoubleType != nil
}

func (x *TypeName) IsSetStringType() bool {
    return x != nil && x.StringType != nil
}

func (x *TypeName) IsSetBinaryType() bool {
    return x != nil && x.BinaryType != nil
}

func (x *TypeName) IsSetEnumType() bool {
    return x != nil && x.EnumType != nil
}

func (x *TypeName) IsSetStructType() bool {
    return x != nil && x.StructType != nil
}

func (x *TypeName) IsSetUnionType() bool {
    return x != nil && x.UnionType != nil
}

func (x *TypeName) IsSetExceptionType() bool {
    return x != nil && x.ExceptionType != nil
}

func (x *TypeName) IsSetListType() bool {
    return x != nil && x.ListType != nil
}

func (x *TypeName) IsSetSetType() bool {
    return x != nil && x.SetType != nil
}

func (x *TypeName) IsSetMapType() bool {
    return x != nil && x.MapType != nil
}

func (x *TypeName) IsSetTypedefType() bool {
    return x != nil && x.TypedefType != nil
}

func (x *TypeName) writeField1(p thrift.Protocol) error {  // BoolType
    if !x.IsSetBoolType() {
        return nil
    }

    if err := p.WriteFieldBegin("boolType", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetBoolTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField2(p thrift.Protocol) error {  // ByteType
    if !x.IsSetByteType() {
        return nil
    }

    if err := p.WriteFieldBegin("byteType", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetByteTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField3(p thrift.Protocol) error {  // I16Type
    if !x.IsSetI16Type() {
        return nil
    }

    if err := p.WriteFieldBegin("i16Type", thrift.I32, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetI16TypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField4(p thrift.Protocol) error {  // I32Type
    if !x.IsSetI32Type() {
        return nil
    }

    if err := p.WriteFieldBegin("i32Type", thrift.I32, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetI32TypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField5(p thrift.Protocol) error {  // I64Type
    if !x.IsSetI64Type() {
        return nil
    }

    if err := p.WriteFieldBegin("i64Type", thrift.I32, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetI64TypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField6(p thrift.Protocol) error {  // FloatType
    if !x.IsSetFloatType() {
        return nil
    }

    if err := p.WriteFieldBegin("floatType", thrift.I32, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetFloatTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField7(p thrift.Protocol) error {  // DoubleType
    if !x.IsSetDoubleType() {
        return nil
    }

    if err := p.WriteFieldBegin("doubleType", thrift.I32, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetDoubleTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField8(p thrift.Protocol) error {  // StringType
    if !x.IsSetStringType() {
        return nil
    }

    if err := p.WriteFieldBegin("stringType", thrift.I32, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetStringTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField9(p thrift.Protocol) error {  // BinaryType
    if !x.IsSetBinaryType() {
        return nil
    }

    if err := p.WriteFieldBegin("binaryType", thrift.I32, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetBinaryTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField10(p thrift.Protocol) error {  // EnumType
    if !x.IsSetEnumType() {
        return nil
    }

    if err := p.WriteFieldBegin("enumType", thrift.STRUCT, 10); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetEnumTypeNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField11(p thrift.Protocol) error {  // StructType
    if !x.IsSetStructType() {
        return nil
    }

    if err := p.WriteFieldBegin("structType", thrift.STRUCT, 11); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStructTypeNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField12(p thrift.Protocol) error {  // UnionType
    if !x.IsSetUnionType() {
        return nil
    }

    if err := p.WriteFieldBegin("unionType", thrift.STRUCT, 12); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetUnionTypeNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField13(p thrift.Protocol) error {  // ExceptionType
    if !x.IsSetExceptionType() {
        return nil
    }

    if err := p.WriteFieldBegin("exceptionType", thrift.STRUCT, 13); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetExceptionTypeNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField14(p thrift.Protocol) error {  // ListType
    if !x.IsSetListType() {
        return nil
    }

    if err := p.WriteFieldBegin("listType", thrift.I32, 14); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetListTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField15(p thrift.Protocol) error {  // SetType
    if !x.IsSetSetType() {
        return nil
    }

    if err := p.WriteFieldBegin("setType", thrift.I32, 15); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSetTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField16(p thrift.Protocol) error {  // MapType
    if !x.IsSetMapType() {
        return nil
    }

    if err := p.WriteFieldBegin("mapType", thrift.I32, 16); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetMapTypeNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) writeField17(p thrift.Protocol) error {  // TypedefType
    if !x.IsSetTypedefType() {
        return nil
    }

    if err := p.WriteFieldBegin("typedefType", thrift.STRUCT, 17); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTypedefTypeNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TypeName) readField1(p thrift.Protocol) error {  // BoolType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetBoolTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField2(p thrift.Protocol) error {  // ByteType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetByteTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField3(p thrift.Protocol) error {  // I16Type
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetI16TypeNonCompat(result)
    return nil
}

func (x *TypeName) readField4(p thrift.Protocol) error {  // I32Type
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetI32TypeNonCompat(result)
    return nil
}

func (x *TypeName) readField5(p thrift.Protocol) error {  // I64Type
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetI64TypeNonCompat(result)
    return nil
}

func (x *TypeName) readField6(p thrift.Protocol) error {  // FloatType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetFloatTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField7(p thrift.Protocol) error {  // DoubleType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetDoubleTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField8(p thrift.Protocol) error {  // StringType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetStringTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField9(p thrift.Protocol) error {  // BinaryType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetBinaryTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField10(p thrift.Protocol) error {  // EnumType
    result := *NewTypeUri()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetEnumTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField11(p thrift.Protocol) error {  // StructType
    result := *NewTypeUri()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetStructTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField12(p thrift.Protocol) error {  // UnionType
    result := *NewTypeUri()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetUnionTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField13(p thrift.Protocol) error {  // ExceptionType
    result := *NewTypeUri()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetExceptionTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField14(p thrift.Protocol) error {  // ListType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetListTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField15(p thrift.Protocol) error {  // SetType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetSetTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField16(p thrift.Protocol) error {  // MapType
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Void(enumResult)

    x.SetMapTypeNonCompat(result)
    return nil
}

func (x *TypeName) readField17(p thrift.Protocol) error {  // TypedefType
    result := *NewTypeUri()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetTypedefTypeNonCompat(result)
    return nil
}

func (x *TypeName) toString1() string {  // BoolType
    if x.IsSetBoolType() {
        return fmt.Sprintf("%v", *x.GetBoolTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetBoolTypeNonCompat())
}

func (x *TypeName) toString2() string {  // ByteType
    if x.IsSetByteType() {
        return fmt.Sprintf("%v", *x.GetByteTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetByteTypeNonCompat())
}

func (x *TypeName) toString3() string {  // I16Type
    if x.IsSetI16Type() {
        return fmt.Sprintf("%v", *x.GetI16TypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetI16TypeNonCompat())
}

func (x *TypeName) toString4() string {  // I32Type
    if x.IsSetI32Type() {
        return fmt.Sprintf("%v", *x.GetI32TypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetI32TypeNonCompat())
}

func (x *TypeName) toString5() string {  // I64Type
    if x.IsSetI64Type() {
        return fmt.Sprintf("%v", *x.GetI64TypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetI64TypeNonCompat())
}

func (x *TypeName) toString6() string {  // FloatType
    if x.IsSetFloatType() {
        return fmt.Sprintf("%v", *x.GetFloatTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetFloatTypeNonCompat())
}

func (x *TypeName) toString7() string {  // DoubleType
    if x.IsSetDoubleType() {
        return fmt.Sprintf("%v", *x.GetDoubleTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetDoubleTypeNonCompat())
}

func (x *TypeName) toString8() string {  // StringType
    if x.IsSetStringType() {
        return fmt.Sprintf("%v", *x.GetStringTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetStringTypeNonCompat())
}

func (x *TypeName) toString9() string {  // BinaryType
    if x.IsSetBinaryType() {
        return fmt.Sprintf("%v", *x.GetBinaryTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetBinaryTypeNonCompat())
}

func (x *TypeName) toString10() string {  // EnumType
    return fmt.Sprintf("%v", x.GetEnumTypeNonCompat())
}

func (x *TypeName) toString11() string {  // StructType
    return fmt.Sprintf("%v", x.GetStructTypeNonCompat())
}

func (x *TypeName) toString12() string {  // UnionType
    return fmt.Sprintf("%v", x.GetUnionTypeNonCompat())
}

func (x *TypeName) toString13() string {  // ExceptionType
    return fmt.Sprintf("%v", x.GetExceptionTypeNonCompat())
}

func (x *TypeName) toString14() string {  // ListType
    if x.IsSetListType() {
        return fmt.Sprintf("%v", *x.GetListTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetListTypeNonCompat())
}

func (x *TypeName) toString15() string {  // SetType
    if x.IsSetSetType() {
        return fmt.Sprintf("%v", *x.GetSetTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSetTypeNonCompat())
}

func (x *TypeName) toString16() string {  // MapType
    if x.IsSetMapType() {
        return fmt.Sprintf("%v", *x.GetMapTypeNonCompat())
    }
    return fmt.Sprintf("%v", x.GetMapTypeNonCompat())
}

func (x *TypeName) toString17() string {  // TypedefType
    return fmt.Sprintf("%v", x.GetTypedefTypeNonCompat())
}










// Deprecated: Use NewTypeName().GetEnumType() instead.
func (x *TypeName) DefaultGetEnumType() *TypeUri {
    if !x.IsSetEnumType() {
        return NewTypeUri()
    }
    return x.EnumType
}

// Deprecated: Use NewTypeName().GetStructType() instead.
func (x *TypeName) DefaultGetStructType() *TypeUri {
    if !x.IsSetStructType() {
        return NewTypeUri()
    }
    return x.StructType
}

// Deprecated: Use NewTypeName().GetUnionType() instead.
func (x *TypeName) DefaultGetUnionType() *TypeUri {
    if !x.IsSetUnionType() {
        return NewTypeUri()
    }
    return x.UnionType
}

// Deprecated: Use NewTypeName().GetExceptionType() instead.
func (x *TypeName) DefaultGetExceptionType() *TypeUri {
    if !x.IsSetExceptionType() {
        return NewTypeUri()
    }
    return x.ExceptionType
}




// Deprecated: Use NewTypeName().GetTypedefType() instead.
func (x *TypeName) DefaultGetTypedefType() *TypeUri {
    if !x.IsSetTypedefType() {
        return NewTypeUri()
    }
    return x.TypedefType
}

func (x *TypeName) countSetFields() int {
    count := int(0)
    if (x.IsSetBoolType()) {
        count++
    }
    if (x.IsSetByteType()) {
        count++
    }
    if (x.IsSetI16Type()) {
        count++
    }
    if (x.IsSetI32Type()) {
        count++
    }
    if (x.IsSetI64Type()) {
        count++
    }
    if (x.IsSetFloatType()) {
        count++
    }
    if (x.IsSetDoubleType()) {
        count++
    }
    if (x.IsSetStringType()) {
        count++
    }
    if (x.IsSetBinaryType()) {
        count++
    }
    if (x.IsSetEnumType()) {
        count++
    }
    if (x.IsSetStructType()) {
        count++
    }
    if (x.IsSetUnionType()) {
        count++
    }
    if (x.IsSetExceptionType()) {
        count++
    }
    if (x.IsSetListType()) {
        count++
    }
    if (x.IsSetSetType()) {
        count++
    }
    if (x.IsSetMapType()) {
        count++
    }
    if (x.IsSetTypedefType()) {
        count++
    }
    return count
}

func (x *TypeName) CountSetFieldsTypeName() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
type TypeNameBuilder struct {
    obj *TypeName
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewTypeNameBuilder() *TypeNameBuilder {
    return &TypeNameBuilder{
        obj: NewTypeName(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) BoolType(value *Void) *TypeNameBuilder {
    x.obj.BoolType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) ByteType(value *Void) *TypeNameBuilder {
    x.obj.ByteType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) I16Type(value *Void) *TypeNameBuilder {
    x.obj.I16Type = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) I32Type(value *Void) *TypeNameBuilder {
    x.obj.I32Type = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) I64Type(value *Void) *TypeNameBuilder {
    x.obj.I64Type = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) FloatType(value *Void) *TypeNameBuilder {
    x.obj.FloatType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) DoubleType(value *Void) *TypeNameBuilder {
    x.obj.DoubleType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) StringType(value *Void) *TypeNameBuilder {
    x.obj.StringType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) BinaryType(value *Void) *TypeNameBuilder {
    x.obj.BinaryType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) EnumType(value *TypeUri) *TypeNameBuilder {
    x.obj.EnumType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) StructType(value *TypeUri) *TypeNameBuilder {
    x.obj.StructType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) UnionType(value *TypeUri) *TypeNameBuilder {
    x.obj.UnionType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) ExceptionType(value *TypeUri) *TypeNameBuilder {
    x.obj.ExceptionType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) ListType(value *Void) *TypeNameBuilder {
    x.obj.ListType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) SetType(value *Void) *TypeNameBuilder {
    x.obj.SetType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) MapType(value *Void) *TypeNameBuilder {
    x.obj.MapType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) TypedefType(value *TypeUri) *TypeNameBuilder {
    x.obj.TypedefType = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTypeName().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TypeNameBuilder) Emit() *TypeName {
    var objCopy TypeName = *x.obj
    return &objCopy
}

func (x *TypeName) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("TypeName"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField10(p); err != nil {
        return err
    }

    if err := x.writeField11(p); err != nil {
        return err
    }

    if err := x.writeField12(p); err != nil {
        return err
    }

    if err := x.writeField13(p); err != nil {
        return err
    }

    if err := x.writeField14(p); err != nil {
        return err
    }

    if err := x.writeField15(p); err != nil {
        return err
    }

    if err := x.writeField16(p); err != nil {
        return err
    }

    if err := x.writeField17(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *TypeName) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // boolType
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.I32)):  // byteType
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.I32)):  // i16Type
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.I32)):  // i32Type
            if err := x.readField4(p); err != nil {
                return err
            }
        case (id == 5 && wireType == thrift.Type(thrift.I32)):  // i64Type
            if err := x.readField5(p); err != nil {
                return err
            }
        case (id == 6 && wireType == thrift.Type(thrift.I32)):  // floatType
            if err := x.readField6(p); err != nil {
                return err
            }
        case (id == 7 && wireType == thrift.Type(thrift.I32)):  // doubleType
            if err := x.readField7(p); err != nil {
                return err
            }
        case (id == 8 && wireType == thrift.Type(thrift.I32)):  // stringType
            if err := x.readField8(p); err != nil {
                return err
            }
        case (id == 9 && wireType == thrift.Type(thrift.I32)):  // binaryType
            if err := x.readField9(p); err != nil {
                return err
            }
        case (id == 10 && wireType == thrift.Type(thrift.STRUCT)):  // enumType
            if err := x.readField10(p); err != nil {
                return err
            }
        case (id == 11 && wireType == thrift.Type(thrift.STRUCT)):  // structType
            if err := x.readField11(p); err != nil {
                return err
            }
        case (id == 12 && wireType == thrift.Type(thrift.STRUCT)):  // unionType
            if err := x.readField12(p); err != nil {
                return err
            }
        case (id == 13 && wireType == thrift.Type(thrift.STRUCT)):  // exceptionType
            if err := x.readField13(p); err != nil {
                return err
            }
        case (id == 14 && wireType == thrift.Type(thrift.I32)):  // listType
            if err := x.readField14(p); err != nil {
                return err
            }
        case (id == 15 && wireType == thrift.Type(thrift.I32)):  // setType
            if err := x.readField15(p); err != nil {
                return err
            }
        case (id == 16 && wireType == thrift.Type(thrift.I32)):  // mapType
            if err := x.readField16(p); err != nil {
                return err
            }
        case (id == 17 && wireType == thrift.Type(thrift.STRUCT)):  // typedefType
            if err := x.readField17(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *TypeName) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("TypeName({")
    sb.WriteString(fmt.Sprintf("BoolType:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("ByteType:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("I16Type:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("I32Type:%s ", x.toString4()))
    sb.WriteString(fmt.Sprintf("I64Type:%s ", x.toString5()))
    sb.WriteString(fmt.Sprintf("FloatType:%s ", x.toString6()))
    sb.WriteString(fmt.Sprintf("DoubleType:%s ", x.toString7()))
    sb.WriteString(fmt.Sprintf("StringType:%s ", x.toString8()))
    sb.WriteString(fmt.Sprintf("BinaryType:%s ", x.toString9()))
    sb.WriteString(fmt.Sprintf("EnumType:%s ", x.toString10()))
    sb.WriteString(fmt.Sprintf("StructType:%s ", x.toString11()))
    sb.WriteString(fmt.Sprintf("UnionType:%s ", x.toString12()))
    sb.WriteString(fmt.Sprintf("ExceptionType:%s ", x.toString13()))
    sb.WriteString(fmt.Sprintf("ListType:%s ", x.toString14()))
    sb.WriteString(fmt.Sprintf("SetType:%s ", x.toString15()))
    sb.WriteString(fmt.Sprintf("MapType:%s ", x.toString16()))
    sb.WriteString(fmt.Sprintf("TypedefType:%s", x.toString17()))
    sb.WriteString("})")

    return sb.String()
}

// RegisterTypes registers types found in this file that have a thrift_uri with the passed in registry.
func RegisterTypes(registry interface {
  RegisterType(name string, initializer func() any)
}) {
    registry.RegisterType("facebook.com/thrift/type/TypeUri", func() any { return NewTypeUri() })
    registry.RegisterType("facebook.com/thrift/type/TypeName", func() any { return NewTypeName() })

    registry.RegisterType("facebook.com/thrift/type/Void", func() any { return Void(0) })
    registry.RegisterType("facebook.com/thrift/type/StandardProtocol", func() any { return StandardProtocol(0) })
}
