// @generated by Thrift for src/module.thrift
// This file is probably not the place you want to edit!

#![recursion_limit = "100000000"]
#![allow(non_camel_case_types, non_snake_case, non_upper_case_globals, unused_crate_dependencies, clippy::type_complexity)]

pub use self::errors::*;
pub use self::types::*;

pub mod types;

#[doc(hidden)]
pub mod dependencies {
    pub use include as include;
}

pub mod services {
    pub mod some_service {
        #[derive(Clone, Debug)]
        pub enum BounceMapExn {
            #[doc(hidden)]
            Success(include::types::SomeMap),
            ApplicationException(::fbthrift::ApplicationException),
        }

        impl ::std::convert::From<::fbthrift::ApplicationException> for BounceMapExn {
            fn from(exn: ::fbthrift::ApplicationException) -> Self {
                BounceMapExn::ApplicationException(exn)
            }
        }

        impl ::fbthrift::ExceptionInfo for BounceMapExn {
            fn exn_name(&self) -> &'static str {
                match self {
                    BounceMapExn::Success(_) => panic!("ExceptionInfo::exn_name called on Success"),
                    BounceMapExn::ApplicationException(aexn) => aexn.exn_name(),
                }
            }

            fn exn_value(&self) -> String {
                match self {
                    BounceMapExn::Success(_) => panic!("ExceptionInfo::exn_value called on Success"),
                    BounceMapExn::ApplicationException(aexn) => aexn.exn_value(),
                }
            }

            fn exn_is_declared(&self) -> bool {
                match self {
                    BounceMapExn::Success(_) => panic!("ExceptionInfo::exn_is_declared called on Success"),
                    BounceMapExn::ApplicationException(aexn) => aexn.exn_is_declared(),
                }
            }
        }

        impl ::fbthrift::ResultInfo for BounceMapExn {
            fn result_type(&self) -> ::fbthrift::ResultType {
                match self {
                    BounceMapExn::Success(_) => ::fbthrift::ResultType::Return,
                    BounceMapExn::ApplicationException(_aexn) => ::fbthrift::ResultType::Exception,
                }
            }
        }

        impl ::fbthrift::GetTType for BounceMapExn {
            const TTYPE: ::fbthrift::TType = ::fbthrift::TType::Struct;
        }

        impl<P> ::fbthrift::Serialize<P> for BounceMapExn
        where
            P: ::fbthrift::ProtocolWriter,
        {
            fn write(&self, p: &mut P) {
                if let BounceMapExn::ApplicationException(aexn) = self {
                    return aexn.write(p);
                }
                p.write_struct_begin("BounceMap");
                match self {
                    BounceMapExn::Success(inner) => {
                        p.write_field_begin(
                            "Success",
                            ::fbthrift::TType::Map,
                            0i16,
                        );
                        inner.write(p);
                        p.write_field_end();
                    }
                    BounceMapExn::ApplicationException(_aexn) => unreachable!(),
                }
                p.write_field_stop();
                p.write_struct_end();
            }
        }

        impl<P> ::fbthrift::Deserialize<P> for BounceMapExn
        where
            P: ::fbthrift::ProtocolReader,
        {
            fn read(p: &mut P) -> ::anyhow::Result<Self> {
                static RETURNS: &[::fbthrift::Field] = &[
                    ::fbthrift::Field::new("Success", ::fbthrift::TType::Map, 0),
                ];
                let _ = p.read_struct_begin(|_| ())?;
                let mut once = false;
                let mut alt = ::std::option::Option::None;
                loop {
                    let (_, fty, fid) = p.read_field_begin(|_| (), RETURNS)?;
                    match ((fty, fid as ::std::primitive::i32), once) {
                        ((::fbthrift::TType::Stop, _), _) => {
                            p.read_field_end()?;
                            break;
                        }
                        ((::fbthrift::TType::Map, 0i32), false) => {
                            once = true;
                            alt = ::std::option::Option::Some(BounceMapExn::Success(::fbthrift::Deserialize::read(p)?));
                        }
                        ((ty, _id), false) => p.skip(ty)?,
                        ((badty, badid), true) => return ::std::result::Result::Err(::std::convert::From::from(
                            ::fbthrift::ApplicationException::new(
                                ::fbthrift::ApplicationExceptionErrorCode::ProtocolError,
                                format!(
                                    "unwanted extra union {} field ty {:?} id {}",
                                    "BounceMapExn",
                                    badty,
                                    badid,
                                ),
                            )
                        )),
                    }
                    p.read_field_end()?;
                }
                p.read_struct_end()?;
                alt.ok_or_else(||
                    ::fbthrift::ApplicationException::new(
                        ::fbthrift::ApplicationExceptionErrorCode::MissingResult,
                        format!("Empty union {}", "BounceMapExn"),
                    )
                    .into(),
                )
            }
        }

        #[derive(Clone, Debug)]
        pub enum BinaryKeyedMapExn {
            #[doc(hidden)]
            Success(::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>),
            ApplicationException(::fbthrift::ApplicationException),
        }

        impl ::std::convert::From<::fbthrift::ApplicationException> for BinaryKeyedMapExn {
            fn from(exn: ::fbthrift::ApplicationException) -> Self {
                BinaryKeyedMapExn::ApplicationException(exn)
            }
        }

        impl ::fbthrift::ExceptionInfo for BinaryKeyedMapExn {
            fn exn_name(&self) -> &'static str {
                match self {
                    BinaryKeyedMapExn::Success(_) => panic!("ExceptionInfo::exn_name called on Success"),
                    BinaryKeyedMapExn::ApplicationException(aexn) => aexn.exn_name(),
                }
            }

            fn exn_value(&self) -> String {
                match self {
                    BinaryKeyedMapExn::Success(_) => panic!("ExceptionInfo::exn_value called on Success"),
                    BinaryKeyedMapExn::ApplicationException(aexn) => aexn.exn_value(),
                }
            }

            fn exn_is_declared(&self) -> bool {
                match self {
                    BinaryKeyedMapExn::Success(_) => panic!("ExceptionInfo::exn_is_declared called on Success"),
                    BinaryKeyedMapExn::ApplicationException(aexn) => aexn.exn_is_declared(),
                }
            }
        }

        impl ::fbthrift::ResultInfo for BinaryKeyedMapExn {
            fn result_type(&self) -> ::fbthrift::ResultType {
                match self {
                    BinaryKeyedMapExn::Success(_) => ::fbthrift::ResultType::Return,
                    BinaryKeyedMapExn::ApplicationException(_aexn) => ::fbthrift::ResultType::Exception,
                }
            }
        }

        impl ::fbthrift::GetTType for BinaryKeyedMapExn {
            const TTYPE: ::fbthrift::TType = ::fbthrift::TType::Struct;
        }

        impl<P> ::fbthrift::Serialize<P> for BinaryKeyedMapExn
        where
            P: ::fbthrift::ProtocolWriter,
        {
            fn write(&self, p: &mut P) {
                if let BinaryKeyedMapExn::ApplicationException(aexn) = self {
                    return aexn.write(p);
                }
                p.write_struct_begin("BinaryKeyedMap");
                match self {
                    BinaryKeyedMapExn::Success(inner) => {
                        p.write_field_begin(
                            "Success",
                            ::fbthrift::TType::Map,
                            0i16,
                        );
                        inner.write(p);
                        p.write_field_end();
                    }
                    BinaryKeyedMapExn::ApplicationException(_aexn) => unreachable!(),
                }
                p.write_field_stop();
                p.write_struct_end();
            }
        }

        impl<P> ::fbthrift::Deserialize<P> for BinaryKeyedMapExn
        where
            P: ::fbthrift::ProtocolReader,
        {
            fn read(p: &mut P) -> ::anyhow::Result<Self> {
                static RETURNS: &[::fbthrift::Field] = &[
                    ::fbthrift::Field::new("Success", ::fbthrift::TType::Map, 0),
                ];
                let _ = p.read_struct_begin(|_| ())?;
                let mut once = false;
                let mut alt = ::std::option::Option::None;
                loop {
                    let (_, fty, fid) = p.read_field_begin(|_| (), RETURNS)?;
                    match ((fty, fid as ::std::primitive::i32), once) {
                        ((::fbthrift::TType::Stop, _), _) => {
                            p.read_field_end()?;
                            break;
                        }
                        ((::fbthrift::TType::Map, 0i32), false) => {
                            once = true;
                            alt = ::std::option::Option::Some(BinaryKeyedMapExn::Success(::fbthrift::Deserialize::read(p)?));
                        }
                        ((ty, _id), false) => p.skip(ty)?,
                        ((badty, badid), true) => return ::std::result::Result::Err(::std::convert::From::from(
                            ::fbthrift::ApplicationException::new(
                                ::fbthrift::ApplicationExceptionErrorCode::ProtocolError,
                                format!(
                                    "unwanted extra union {} field ty {:?} id {}",
                                    "BinaryKeyedMapExn",
                                    badty,
                                    badid,
                                ),
                            )
                        )),
                    }
                    p.read_field_end()?;
                }
                p.read_struct_end()?;
                alt.ok_or_else(||
                    ::fbthrift::ApplicationException::new(
                        ::fbthrift::ApplicationExceptionErrorCode::MissingResult,
                        format!("Empty union {}", "BinaryKeyedMapExn"),
                    )
                    .into(),
                )
            }
        }
    }
}

/// Client implementation for each service in `module`.
pub mod client {

    pub struct SomeServiceImpl<P, T, S = ::fbthrift::NoopSpawner> {
        transport: T,
        _phantom: ::std::marker::PhantomData<fn() -> (P, S)>,
    }

    impl<P, T, S> SomeServiceImpl<P, T, S>
    where
        P: ::fbthrift::Protocol,
        T: ::fbthrift::Transport,
        P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
        ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        pub fn new(
            transport: T,
        ) -> Self {
            Self {
                transport,
                _phantom: ::std::marker::PhantomData,
            }
        }

        pub fn transport(&self) -> &T {
            &self.transport
        }


        fn _bounce_map_impl(
            &self,
            arg_m: &include::types::SomeMap,
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>> {
            use ::const_cstr::const_cstr;
            use ::tracing::Instrument as _;
            use ::futures::FutureExt as _;

            const_cstr! {
                SERVICE_NAME = "SomeService";
                METHOD_NAME = "SomeService.bounce_map";
            }
            let args = self::Args_SomeService_bounce_map {
                m: arg_m,
                _phantom: ::std::marker::PhantomData,
            };

            // need to do call setup outside of async block because T: Transport isn't Send
            let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("bounce_map", &args) {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
            };

            let call = self.transport()
                .call(SERVICE_NAME.as_cstr(), METHOD_NAME.as_cstr(), request_env, rpc_options)
                .instrument(::tracing::trace_span!("call", function = "SomeService.bounce_map"));

            async move {
                let reply_env = call.await?;

                let de = P::deserializer(reply_env);
                let (res, _de): (::std::result::Result<crate::services::some_service::BounceMapExn, _>, _) =
                    ::fbthrift::help::async_deserialize_response_envelope::<P, _, S>(de).await?;

                match res {
                    ::std::result::Result::Ok(exn) => ::std::convert::From::from(exn),
                    ::std::result::Result::Err(aexn) =>
                        ::std::result::Result::Err(crate::errors::some_service::BounceMapError::ApplicationException(aexn))
                }
            }
            .instrument(::tracing::info_span!("SomeService.bounce_map"))
            .boxed()
        }

        fn _binary_keyed_map_impl(
            &self,
            arg_r: &[::std::primitive::i64],
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>> {
            use ::const_cstr::const_cstr;
            use ::tracing::Instrument as _;
            use ::futures::FutureExt as _;

            const_cstr! {
                SERVICE_NAME = "SomeService";
                METHOD_NAME = "SomeService.binary_keyed_map";
            }
            let args = self::Args_SomeService_binary_keyed_map {
                r: arg_r,
                _phantom: ::std::marker::PhantomData,
            };

            // need to do call setup outside of async block because T: Transport isn't Send
            let request_env = match ::fbthrift::help::serialize_request_envelope::<P, _>("binary_keyed_map", &args) {
                ::std::result::Result::Ok(res) => res,
                ::std::result::Result::Err(err) => return ::futures::future::err(err.into()).boxed(),
            };

            let call = self.transport()
                .call(SERVICE_NAME.as_cstr(), METHOD_NAME.as_cstr(), request_env, rpc_options)
                .instrument(::tracing::trace_span!("call", function = "SomeService.binary_keyed_map"));

            async move {
                let reply_env = call.await?;

                let de = P::deserializer(reply_env);
                let (res, _de): (::std::result::Result<crate::services::some_service::BinaryKeyedMapExn, _>, _) =
                    ::fbthrift::help::async_deserialize_response_envelope::<P, _, S>(de).await?;

                match res {
                    ::std::result::Result::Ok(exn) => ::std::convert::From::from(exn),
                    ::std::result::Result::Err(aexn) =>
                        ::std::result::Result::Err(crate::errors::some_service::BinaryKeyedMapError::ApplicationException(aexn))
                }
            }
            .instrument(::tracing::info_span!("SomeService.binary_keyed_map"))
            .boxed()
        }
    }

    pub trait SomeService: ::std::marker::Send {
        fn bounce_map(
            &self,
            arg_m: &include::types::SomeMap,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>>;

        fn binary_keyed_map(
            &self,
            arg_r: &[::std::primitive::i64],
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>>;
    }

    pub trait SomeServiceExt<T>: SomeService
    where
        T: ::fbthrift::Transport,
    {
        fn bounce_map_with_rpc_opts(
            &self,
            arg_m: &include::types::SomeMap,
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>>;
        fn binary_keyed_map_with_rpc_opts(
            &self,
            arg_r: &[::std::primitive::i64],
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>>;
    }

    struct Args_SomeService_bounce_map<'a> {
        m: &'a include::types::SomeMap,
        _phantom: ::std::marker::PhantomData<&'a ()>,
    }

    impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_SomeService_bounce_map<'a> {
        #[inline]
        #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "SomeService.bounce_map"))]
        fn write(&self, p: &mut P) {
            p.write_struct_begin("args");
            p.write_field_begin("m", ::fbthrift::TType::Map, 1i16);
            ::fbthrift::Serialize::write(&self.m, p);
            p.write_field_end();
            p.write_field_stop();
            p.write_struct_end();
        }
    }

    struct Args_SomeService_binary_keyed_map<'a> {
        r: &'a [::std::primitive::i64],
        _phantom: ::std::marker::PhantomData<&'a ()>,
    }

    impl<'a, P: ::fbthrift::ProtocolWriter> ::fbthrift::Serialize<P> for self::Args_SomeService_binary_keyed_map<'a> {
        #[inline]
        #[::tracing::instrument(skip_all, level = "trace", name = "serialize_args", fields(method = "SomeService.binary_keyed_map"))]
        fn write(&self, p: &mut P) {
            p.write_struct_begin("args");
            p.write_field_begin("r", ::fbthrift::TType::List, 1i16);
            ::fbthrift::Serialize::write(&self.r, p);
            p.write_field_end();
            p.write_field_stop();
            p.write_struct_end();
        }
    }

    impl<P, T, S> SomeService for SomeServiceImpl<P, T, S>
    where
        P: ::fbthrift::Protocol,
        T: ::fbthrift::Transport,
        P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
        ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        fn bounce_map(
            &self,
            arg_m: &include::types::SomeMap,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>> {
            let rpc_options = T::RpcOptions::default();
            self._bounce_map_impl(
                arg_m,
                rpc_options,
            )
        }
        fn binary_keyed_map(
            &self,
            arg_r: &[::std::primitive::i64],
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>> {
            let rpc_options = T::RpcOptions::default();
            self._binary_keyed_map_impl(
                arg_r,
                rpc_options,
            )
        }
    }

    impl<P, T, S> SomeServiceExt<T> for SomeServiceImpl<P, T, S>
    where
        P: ::fbthrift::Protocol,
        T: ::fbthrift::Transport,
        P::Frame: ::fbthrift::Framing<DecBuf = ::fbthrift::FramingDecoded<T>>,
        ::fbthrift::ProtocolEncoded<P>: ::fbthrift::BufMutExt<Final = ::fbthrift::FramingEncodedFinal<T>>,
        P::Deserializer: ::std::marker::Send,
        S: ::fbthrift::help::Spawner,
    {
        fn bounce_map_with_rpc_opts(
            &self,
            arg_m: &include::types::SomeMap,
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>> {
            self._bounce_map_impl(
                arg_m,
                rpc_options,
            )
        }
        fn binary_keyed_map_with_rpc_opts(
            &self,
            arg_r: &[::std::primitive::i64],
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>> {
            self._binary_keyed_map_impl(
                arg_r,
                rpc_options,
            )
        }
    }

    impl<'a, S> SomeService for S
    where
        S: ::std::convert::AsRef<dyn SomeService + 'a>,
        S: ::std::marker::Send,
    {
        fn bounce_map(
            &self,
            arg_m: &include::types::SomeMap,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>> {
            self.as_ref().bounce_map(
                arg_m,
            )
        }
        fn binary_keyed_map(
            &self,
            arg_r: &[::std::primitive::i64],
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>> {
            self.as_ref().binary_keyed_map(
                arg_r,
            )
        }
    }

    impl<'a, S, T> SomeServiceExt<T> for S
    where
        S: ::std::convert::AsRef<dyn SomeService + 'a>,
        S: ::std::convert::AsRef<dyn SomeServiceExt<T> + 'a>,
        S: ::std::marker::Send,
        T: ::fbthrift::Transport,
    {
        fn bounce_map_with_rpc_opts(
            &self,
            arg_m: &include::types::SomeMap,
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>> {
            <Self as ::std::convert::AsRef<dyn SomeServiceExt<T>>>::as_ref(self).bounce_map_with_rpc_opts(
                arg_m,
                rpc_options,
            )
        }
        fn binary_keyed_map_with_rpc_opts(
            &self,
            arg_r: &[::std::primitive::i64],
            rpc_options: T::RpcOptions,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>> {
            <Self as ::std::convert::AsRef<dyn SomeServiceExt<T>>>::as_ref(self).binary_keyed_map_with_rpc_opts(
                arg_r,
                rpc_options,
            )
        }
    }

    #[derive(Clone)]
    pub struct make_SomeService;

    /// To be called by user directly setting up a client. Avoids
    /// needing ClientFactory trait in scope, avoids unidiomatic
    /// make_Trait name.
    ///
    /// ```
    /// # const _: &str = stringify! {
    /// use bgs::client::BuckGraphService;
    ///
    /// let protocol = BinaryProtocol::new();
    /// let transport = HttpClient::new();
    /// let client = <dyn BuckGraphService>::new(protocol, transport);
    /// # };
    /// ```
    impl dyn SomeService {
        pub fn new<P, T>(
            protocol: P,
            transport: T,
        ) -> ::std::sync::Arc<impl SomeService + ::std::marker::Send + 'static>
        where
            P: ::fbthrift::Protocol<Frame = T>,
            T: ::fbthrift::Transport,
            P::Deserializer: ::std::marker::Send,
        {
            let spawner = ::fbthrift::help::NoopSpawner;
            Self::with_spawner(protocol, transport, spawner)
        }

        pub fn with_spawner<P, T, S>(
            protocol: P,
            transport: T,
            spawner: S,
        ) -> ::std::sync::Arc<impl SomeService + ::std::marker::Send + 'static>
        where
            P: ::fbthrift::Protocol<Frame = T>,
            T: ::fbthrift::Transport,
            P::Deserializer: ::std::marker::Send,
            S: ::fbthrift::help::Spawner,
        {
            let _ = protocol;
            let _ = spawner;
            ::std::sync::Arc::new(SomeServiceImpl::<P, T, S>::new(transport))
        }
    }

    impl<T> dyn SomeServiceExt<T>
    where
        T: ::fbthrift::Transport,
    {
        pub fn new<P>(
            protocol: P,
            transport: T,
        ) -> ::std::sync::Arc<impl SomeServiceExt<T> + ::std::marker::Send + 'static>
        where
            P: ::fbthrift::Protocol<Frame = T>,
            P::Deserializer: ::std::marker::Send,
        {
            let spawner = ::fbthrift::help::NoopSpawner;
            Self::with_spawner(protocol, transport, spawner)
        }

        pub fn with_spawner<P, S>(
            protocol: P,
            transport: T,
            spawner: S,
        ) -> ::std::sync::Arc<impl SomeServiceExt<T> + ::std::marker::Send + 'static>
        where
            P: ::fbthrift::Protocol<Frame = T>,
            P::Deserializer: ::std::marker::Send,
            S: ::fbthrift::help::Spawner,
        {
            let _ = protocol;
            let _ = spawner;
            ::std::sync::Arc::new(SomeServiceImpl::<P, T, S>::new(transport))
        }
    }

    pub type SomeServiceDynClient = <make_SomeService as ::fbthrift::ClientFactory>::Api;
    pub type SomeServiceClient = ::std::sync::Arc<SomeServiceDynClient>;

    /// The same thing, but to be called from generic contexts where we are
    /// working with a type parameter `C: ClientFactory` to produce clients.
    impl ::fbthrift::ClientFactory for make_SomeService {
        type Api = dyn SomeService + ::std::marker::Send + ::std::marker::Sync + 'static;

        fn with_spawner<P, T, S>(protocol: P, transport: T, spawner: S) -> ::std::sync::Arc<Self::Api>
        where
            P: ::fbthrift::Protocol<Frame = T>,
            T: ::fbthrift::Transport + ::std::marker::Sync,
            P::Deserializer: ::std::marker::Send,
            S: ::fbthrift::help::Spawner,
        {
            <dyn SomeService>::with_spawner(protocol, transport, spawner)
        }
    }

}

/// Server definitions for `module`.
pub mod server {
    #[::async_trait::async_trait]
    pub trait SomeService: ::std::marker::Send + ::std::marker::Sync + 'static {
        async fn bounce_map(
            &self,
            _m: include::types::SomeMap,
        ) -> ::std::result::Result<include::types::SomeMap, crate::services::some_service::BounceMapExn> {
            ::std::result::Result::Err(crate::services::some_service::BounceMapExn::ApplicationException(
                ::fbthrift::ApplicationException::unimplemented_method(
                    "SomeService",
                    "bounce_map",
                ),
            ))
        }
        async fn binary_keyed_map(
            &self,
            _r: ::std::vec::Vec<::std::primitive::i64>,
        ) -> ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::services::some_service::BinaryKeyedMapExn> {
            ::std::result::Result::Err(crate::services::some_service::BinaryKeyedMapExn::ApplicationException(
                ::fbthrift::ApplicationException::unimplemented_method(
                    "SomeService",
                    "binary_keyed_map",
                ),
            ))
        }
    }

    #[::async_trait::async_trait]
    impl<T> SomeService for ::std::boxed::Box<T>
    where
        T: SomeService + Send + Sync + ?Sized,
    {
        async fn bounce_map(
            &self,
            m: include::types::SomeMap,
        ) -> ::std::result::Result<include::types::SomeMap, crate::services::some_service::BounceMapExn> {
            (**self).bounce_map(
                m, 
            ).await
        }
        async fn binary_keyed_map(
            &self,
            r: ::std::vec::Vec<::std::primitive::i64>,
        ) -> ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::services::some_service::BinaryKeyedMapExn> {
            (**self).binary_keyed_map(
                r, 
            ).await
        }
    }

    /// Processor for SomeService's methods.
    #[derive(Clone, Debug)]
    pub struct SomeServiceProcessor<P, H, R, RS> {
        service: H,
        supa: ::fbthrift::NullServiceProcessor<P, R, RS>,
        _phantom: ::std::marker::PhantomData<(P, H, R, RS)>,
    }

    struct Args_SomeService_bounce_map {
        m: include::types::SomeMap,
    }
    impl<P: ::fbthrift::ProtocolReader> ::fbthrift::Deserialize<P> for self::Args_SomeService_bounce_map {
        #[inline]
        #[::tracing::instrument(skip_all, level = "trace", name = "deserialize_args", fields(method = "SomeService.bounce_map"))]
        fn read(p: &mut P) -> ::anyhow::Result<Self> {
            static ARGS: &[::fbthrift::Field] = &[
                ::fbthrift::Field::new("m", ::fbthrift::TType::Map, 1),
            ];
            let mut field_m = ::std::option::Option::None;
            let _ = p.read_struct_begin(|_| ())?;
            loop {
                let (_, fty, fid) = p.read_field_begin(|_| (), ARGS)?;
                match (fty, fid as ::std::primitive::i32) {
                    (::fbthrift::TType::Stop, _) => break,
                    (::fbthrift::TType::Map, 1) => field_m = ::std::option::Option::Some(::fbthrift::Deserialize::read(p)?),
                    (fty, _) => p.skip(fty)?,
                }
                p.read_field_end()?;
            }
            p.read_struct_end()?;
            ::std::result::Result::Ok(Self {
                m: field_m.ok_or_else(|| ::anyhow::anyhow!("`{}` missing arg `{}`", "SomeService.bounce_map", "m"))?,
            })
        }
    }

    struct Args_SomeService_binary_keyed_map {
        r: ::std::vec::Vec<::std::primitive::i64>,
    }
    impl<P: ::fbthrift::ProtocolReader> ::fbthrift::Deserialize<P> for self::Args_SomeService_binary_keyed_map {
        #[inline]
        #[::tracing::instrument(skip_all, level = "trace", name = "deserialize_args", fields(method = "SomeService.binary_keyed_map"))]
        fn read(p: &mut P) -> ::anyhow::Result<Self> {
            static ARGS: &[::fbthrift::Field] = &[
                ::fbthrift::Field::new("r", ::fbthrift::TType::List, 1),
            ];
            let mut field_r = ::std::option::Option::None;
            let _ = p.read_struct_begin(|_| ())?;
            loop {
                let (_, fty, fid) = p.read_field_begin(|_| (), ARGS)?;
                match (fty, fid as ::std::primitive::i32) {
                    (::fbthrift::TType::Stop, _) => break,
                    (::fbthrift::TType::List, 1) => field_r = ::std::option::Option::Some(::fbthrift::Deserialize::read(p)?),
                    (fty, _) => p.skip(fty)?,
                }
                p.read_field_end()?;
            }
            p.read_struct_end()?;
            ::std::result::Result::Ok(Self {
                r: field_r.ok_or_else(|| ::anyhow::anyhow!("`{}` missing arg `{}`", "SomeService.binary_keyed_map", "r"))?,
            })
        }
    }


    impl<P, H, R, RS> SomeServiceProcessor<P, H, R, RS>
    where
        P: ::fbthrift::Protocol + ::std::marker::Send + ::std::marker::Sync + 'static,
        P::Deserializer: ::std::marker::Send,
        H: SomeService,
        R: ::fbthrift::RequestContext<Name = ::std::ffi::CStr> + ::std::marker::Sync,
        RS: ::fbthrift::ReplyState<P::Frame>,
        <R as ::fbthrift::RequestContext>::ContextStack: ::fbthrift::ContextStack<Name = R::Name, Buffer = ::fbthrift::ProtocolDecoded<P>>
            + ::std::marker::Send + ::std::marker::Sync,
    {
        pub fn new(service: H) -> Self {
            Self {
                service,
                supa: ::fbthrift::NullServiceProcessor::new(),
                _phantom: ::std::marker::PhantomData,
            }
        }

        pub fn into_inner(self) -> H {
            self.service
        }

        #[::tracing::instrument(skip_all, fields(method = "SomeService.bounce_map"))]
        async fn handle_bounce_map<'a>(
            &'a self,
            p: &'a mut P::Deserializer,
            req_ctxt: &R,
            reply_state: ::std::sync::Arc<::std::sync::Mutex<RS>>,
            _seqid: ::std::primitive::u32,
        ) -> ::anyhow::Result<()> {
            use ::const_cstr::const_cstr;
            use ::tracing::Instrument as _;
            use ::futures::FutureExt as _;

            const_cstr! {
                SERVICE_NAME = "SomeService";
                METHOD_NAME = "SomeService.bounce_map";
            }
            let mut ctx_stack = req_ctxt.get_context_stack(
                SERVICE_NAME.as_cstr(),
                METHOD_NAME.as_cstr(),
            )?;
            ::fbthrift::ContextStack::pre_read(&mut ctx_stack)?;
            let _args: self::Args_SomeService_bounce_map = ::fbthrift::Deserialize::read(p)?;
            ::fbthrift::ContextStack::on_read_data(&mut ctx_stack, &::fbthrift::SerializedMessage {
                protocol: P::PROTOCOL_ID,
                method_name: METHOD_NAME.as_cstr(),
                buffer: ::std::marker::PhantomData, // FIXME P::into_buffer(p).reset(),
            })?;
            ::fbthrift::ContextStack::post_read(&mut ctx_stack, 0)?;

            let res = ::std::panic::AssertUnwindSafe(
                self.service.bounce_map(
                    _args.m,
                )
            )
            .catch_unwind()
            .instrument(::tracing::info_span!("service_handler", method = "SomeService.bounce_map"))
            .await;

            // nested results - panic catch on the outside, method on the inside
            let res = match res {
                ::std::result::Result::Ok(::std::result::Result::Ok(res)) => {
                    ::tracing::info!(method = "SomeService.bounce_map", "success");
                    crate::services::some_service::BounceMapExn::Success(res)
                }
                ::std::result::Result::Ok(::std::result::Result::Err(crate::services::some_service::BounceMapExn::Success(_))) => {
                    panic!(
                        "{} attempted to return success via error",
                        "bounce_map",
                    )
                }
                ::std::result::Result::Ok(::std::result::Result::Err(exn)) => {
                    ::tracing::error!(method = "SomeService.bounce_map", exception = ?exn);
                    exn
                }
                ::std::result::Result::Err(exn) => {
                    let aexn = ::fbthrift::ApplicationException::handler_panic("SomeService.bounce_map", exn);
                    crate::services::some_service::BounceMapExn::ApplicationException(aexn)
                }
            };

            let env = ::fbthrift::help::serialize_result_envelope::<P, R, _>(
                "bounce_map",
                METHOD_NAME.as_cstr(),
                _seqid,
                req_ctxt,
                &mut ctx_stack,
                res
            )?;
            reply_state.lock().unwrap().send_reply(env);
            Ok(())
        }

        #[::tracing::instrument(skip_all, fields(method = "SomeService.binary_keyed_map"))]
        async fn handle_binary_keyed_map<'a>(
            &'a self,
            p: &'a mut P::Deserializer,
            req_ctxt: &R,
            reply_state: ::std::sync::Arc<::std::sync::Mutex<RS>>,
            _seqid: ::std::primitive::u32,
        ) -> ::anyhow::Result<()> {
            use ::const_cstr::const_cstr;
            use ::tracing::Instrument as _;
            use ::futures::FutureExt as _;

            const_cstr! {
                SERVICE_NAME = "SomeService";
                METHOD_NAME = "SomeService.binary_keyed_map";
            }
            let mut ctx_stack = req_ctxt.get_context_stack(
                SERVICE_NAME.as_cstr(),
                METHOD_NAME.as_cstr(),
            )?;
            ::fbthrift::ContextStack::pre_read(&mut ctx_stack)?;
            let _args: self::Args_SomeService_binary_keyed_map = ::fbthrift::Deserialize::read(p)?;
            ::fbthrift::ContextStack::on_read_data(&mut ctx_stack, &::fbthrift::SerializedMessage {
                protocol: P::PROTOCOL_ID,
                method_name: METHOD_NAME.as_cstr(),
                buffer: ::std::marker::PhantomData, // FIXME P::into_buffer(p).reset(),
            })?;
            ::fbthrift::ContextStack::post_read(&mut ctx_stack, 0)?;

            let res = ::std::panic::AssertUnwindSafe(
                self.service.binary_keyed_map(
                    _args.r,
                )
            )
            .catch_unwind()
            .instrument(::tracing::info_span!("service_handler", method = "SomeService.binary_keyed_map"))
            .await;

            // nested results - panic catch on the outside, method on the inside
            let res = match res {
                ::std::result::Result::Ok(::std::result::Result::Ok(res)) => {
                    ::tracing::info!(method = "SomeService.binary_keyed_map", "success");
                    crate::services::some_service::BinaryKeyedMapExn::Success(res)
                }
                ::std::result::Result::Ok(::std::result::Result::Err(crate::services::some_service::BinaryKeyedMapExn::Success(_))) => {
                    panic!(
                        "{} attempted to return success via error",
                        "binary_keyed_map",
                    )
                }
                ::std::result::Result::Ok(::std::result::Result::Err(exn)) => {
                    ::tracing::error!(method = "SomeService.binary_keyed_map", exception = ?exn);
                    exn
                }
                ::std::result::Result::Err(exn) => {
                    let aexn = ::fbthrift::ApplicationException::handler_panic("SomeService.binary_keyed_map", exn);
                    crate::services::some_service::BinaryKeyedMapExn::ApplicationException(aexn)
                }
            };

            let env = ::fbthrift::help::serialize_result_envelope::<P, R, _>(
                "binary_keyed_map",
                METHOD_NAME.as_cstr(),
                _seqid,
                req_ctxt,
                &mut ctx_stack,
                res
            )?;
            reply_state.lock().unwrap().send_reply(env);
            Ok(())
        }
    }

    #[::async_trait::async_trait]
    impl<P, H, R, RS> ::fbthrift::ServiceProcessor<P> for SomeServiceProcessor<P, H, R, RS>
    where
        P: ::fbthrift::Protocol + ::std::marker::Send + ::std::marker::Sync + 'static,
        P::Deserializer: ::std::marker::Send,
        H: SomeService,
        P::Frame: ::std::marker::Send + 'static,
        R: ::fbthrift::RequestContext<Name = ::std::ffi::CStr> + ::std::marker::Send + ::std::marker::Sync + 'static,
        <R as ::fbthrift::RequestContext>::ContextStack: ::fbthrift::ContextStack<Name = R::Name, Buffer = ::fbthrift::ProtocolDecoded<P>>
            + ::std::marker::Send + ::std::marker::Sync + 'static,
        RS: ::fbthrift::ReplyState<P::Frame> + ::std::marker::Send + ::std::marker::Sync + 'static
    {
        type RequestContext = R;
        type ReplyState = RS;

        #[inline]
        fn method_idx(&self, name: &[::std::primitive::u8]) -> ::std::result::Result<::std::primitive::usize, ::fbthrift::ApplicationException> {
            match name {
                b"bounce_map" => ::std::result::Result::Ok(0usize),
                b"binary_keyed_map" => ::std::result::Result::Ok(1usize),
                _ => ::std::result::Result::Err(::fbthrift::ApplicationException::unknown_method()),
            }
        }

        #[allow(clippy::match_single_binding)]
        async fn handle_method(
            &self,
            idx: ::std::primitive::usize,
            _p: &mut P::Deserializer,
            _r: &R,
            _reply_state: ::std::sync::Arc<::std::sync::Mutex<RS>>,
            _seqid: ::std::primitive::u32,
        ) -> ::anyhow::Result<()> {
            match idx {
                0usize => {
                    self.handle_bounce_map(_p, _r, _reply_state, _seqid).await
                }
                1usize => {
                    self.handle_binary_keyed_map(_p, _r, _reply_state, _seqid).await
                }
                bad => panic!(
                    "{}: unexpected method idx {}",
                    "SomeServiceProcessor",
                    bad
                ),
            }
        }

        #[allow(clippy::match_single_binding)]
        #[inline]
        fn create_interaction_idx(&self, name: &str) -> ::anyhow::Result<::std::primitive::usize> {
            match name {
                _ => ::anyhow::bail!("Unknown interaction"),
            }
        }

        #[allow(clippy::match_single_binding)]
        fn handle_create_interaction(
            &self,
            idx: ::std::primitive::usize,
        ) -> ::anyhow::Result<
            ::std::sync::Arc<dyn ::fbthrift::ThriftService<P::Frame, Handler = (), RequestContext = Self::RequestContext, ReplyState = Self::ReplyState> + ::std::marker::Send + 'static>
        > {
            match idx {
                bad => panic!(
                    "{}: unexpected method idx {}",
                    "SomeServiceProcessor",
                    bad
                ),
            }
        }
    }

    #[::async_trait::async_trait]
    impl<P, H, R, RS> ::fbthrift::ThriftService<P::Frame> for SomeServiceProcessor<P, H, R, RS>
    where
        P: ::fbthrift::Protocol + ::std::marker::Send + ::std::marker::Sync + 'static,
        P::Deserializer: ::std::marker::Send,
        P::Frame: ::std::marker::Send + 'static,
        H: SomeService,
        R: ::fbthrift::RequestContext<Name = ::std::ffi::CStr> + ::std::marker::Send + ::std::marker::Sync + 'static,
        <R as ::fbthrift::RequestContext>::ContextStack: ::fbthrift::ContextStack<Name = R::Name, Buffer = ::fbthrift::ProtocolDecoded<P>>
            + ::std::marker::Send + ::std::marker::Sync + 'static,
        RS: ::fbthrift::ReplyState<P::Frame> + ::std::marker::Send + ::std::marker::Sync + 'static
    {
        type Handler = H;
        type RequestContext = R;
        type ReplyState = RS;

        #[tracing::instrument(level="trace", skip_all, fields(service = "SomeService"))]
        async fn call(
            &self,
            req: ::fbthrift::ProtocolDecoded<P>,
            req_ctxt: &R,
            reply_state: ::std::sync::Arc<::std::sync::Mutex<RS>>,
        ) -> ::anyhow::Result<()> {
            use ::fbthrift::{BufExt as _, ProtocolReader as _, ServiceProcessor as _};
            let mut p = P::deserializer(req);
            let (idx, mty, seqid) = p.read_message_begin(|name| self.method_idx(name))?;
            if mty != ::fbthrift::MessageType::Call {
                return ::std::result::Result::Err(::std::convert::From::from(::fbthrift::ApplicationException::new(
                    ::fbthrift::ApplicationExceptionErrorCode::InvalidMessageType,
                    format!("message type {:?} not handled", mty)
                )));
            }
            let idx = match idx {
                ::std::result::Result::Ok(idx) => idx,
                ::std::result::Result::Err(_) => {
                    let cur = P::into_buffer(p).reset();
                    return self.supa.call(cur, req_ctxt, reply_state).await;
                }
            };
            self.handle_method(idx, &mut p, req_ctxt, reply_state, seqid).await?;
            p.read_message_end()?;

            Ok(())
        }

        fn create_interaction(
            &self,
            name: &str,
        ) -> ::anyhow::Result<
            ::std::sync::Arc<dyn ::fbthrift::ThriftService<P::Frame, Handler = (), RequestContext = R, ReplyState = RS> + ::std::marker::Send + 'static>
        > {
            use ::fbthrift::{ServiceProcessor as _};
            let idx = self.create_interaction_idx(name);
            let idx = match idx {
                ::anyhow::Result::Ok(idx) => idx,
                ::anyhow::Result::Err(_) => {
                    return self.supa.create_interaction(name);
                }
            };
            self.handle_create_interaction(idx)
        }
    }

    /// Construct a new instance of a SomeService service.
    ///
    /// This is called when a new instance of a Thrift service Processor
    /// is needed for a particular Thrift protocol.
    #[::tracing::instrument(level="debug", skip_all, fields(proto = ?proto))]
    pub fn make_SomeService_server<F, H, R, RS>(
        proto: ::fbthrift::ProtocolID,
        handler: H,
    ) -> ::std::result::Result<::std::boxed::Box<dyn ::fbthrift::ThriftService<F, Handler = H, RequestContext = R, ReplyState = RS> + ::std::marker::Send + 'static>, ::fbthrift::ApplicationException>
    where
        F: ::fbthrift::Framing + ::std::marker::Send + ::std::marker::Sync + 'static,
        H: SomeService,
        R: ::fbthrift::RequestContext<Name = ::std::ffi::CStr> + ::std::marker::Send + ::std::marker::Sync + 'static,
        <R as ::fbthrift::RequestContext>::ContextStack: ::fbthrift::ContextStack<Name = R::Name, Buffer = F::DecBuf> + ::std::marker::Send + ::std::marker::Sync + 'static,
        RS: ::fbthrift::ReplyState<F> + ::std::marker::Send + ::std::marker::Sync + 'static
    {
        match proto {
            ::fbthrift::ProtocolID::BinaryProtocol => {
                ::std::result::Result::Ok(::std::boxed::Box::new(SomeServiceProcessor::<::fbthrift::BinaryProtocol<F>, H, R, RS>::new(handler)))
            }
            ::fbthrift::ProtocolID::CompactProtocol => {
                ::std::result::Result::Ok(::std::boxed::Box::new(SomeServiceProcessor::<::fbthrift::CompactProtocol<F>, H, R, RS>::new(handler)))
            }
            bad => {
                ::tracing::error!(method = "SomeService.", invalid_protocol = ?bad);
                ::std::result::Result::Err(::fbthrift::ApplicationException::invalid_protocol(bad))
            }
        }
    }
}

/// Client mocks. For every service, a struct mock::TheService that implements
/// client::TheService.
///
/// As an example of the generated API, for the following thrift service:
///
/// ```thrift
/// service MyService {
///     FunctionResponse myFunction(
///         1: FunctionRequest request,
///     ) throws {
///         1: StorageException s,
///         2: NotFoundException n,
///     ),
///
///     // other functions
/// }
/// ```
///
/// we would end up with this mock object under crate::mock::MyService:
///
/// ```
/// # const _: &str = stringify! {
/// impl crate::client::MyService for MyService<'mock> {...}
///
/// pub struct MyService<'mock> {
///     pub myFunction: myFunction<'mock>,
///     // ...
/// }
///
/// impl dyn crate::client::MyService {
///     pub fn mock<'mock>() -> MyService<'mock>;
/// }
///
/// impl myFunction<'mock> {
///     // directly return the given success response
///     pub fn ret(&self, value: FunctionResponse);
///
///     // invoke closure to compute success response
///     pub fn mock(
///         &self,
///         mock: impl FnMut(FunctionRequest) -> FunctionResponse + Send + Sync + 'mock,
///     );
///
///     // invoke closure to compute response
///     pub fn mock_result(
///         &self,
///         mock: impl FnMut(FunctionRequest) -> Result<FunctionResponse, crate::services::MyService::MyFunctionExn> + Send + Sync + 'mock,
///     );
///
///     // return one of the function's declared exceptions
///     pub fn throw<E>(&self, exception: E)
///     where
///         E: Clone + Into<crate::services::MyService::MyFunctionExn> + Send + Sync + 'mock;
/// }
///
/// impl From<StorageException> for MyFunctionExn {...}
/// impl From<NotFoundException> for MyFunctionExn {...}
/// # };
/// ```
///
/// The intended usage from a test would be:
///
/// ```
/// # const _: &str = stringify! {
/// use std::sync::Arc;
/// use thrift_if::client::MyService;
///
/// #[test]
/// fn test_my_client() {
///     let mock = Arc::new(<dyn MyService>::mock());
///
///     // directly return a success response
///     let resp = FunctionResponse {...};
///     mock.myFunction.ret(resp);
///
///     // or give a closure to compute the success response
///     mock.myFunction.mock(|request| FunctionResponse {...});
///
///     // or throw one of the function's exceptions
///     mock.myFunction.throw(StorageException::ItFailed);
///
///     // or compute a Result (useful if your exceptions aren't Clone)
///     mock.myFunction.mock_result(|request| Err(...));
///
///     let out = do_the_thing(mock).wait().unwrap();
///     assert!(out.what_i_expected());
/// }
///
/// fn do_the_thing(
///     client: Arc<dyn MyService + Send + Sync + 'static>,
/// ) -> impl Future<Item = Out> {...}
/// # };
/// ```
pub mod mock {
    pub struct SomeService<'mock> {
        pub bounce_map: r#impl::some_service::bounce_map<'mock>,
        pub binary_keyed_map: r#impl::some_service::binary_keyed_map<'mock>,
        _marker: ::std::marker::PhantomData<&'mock ()>,
    }

    impl dyn super::client::SomeService {
        pub fn mock<'mock>() -> SomeService<'mock> {
            SomeService {
                bounce_map: r#impl::some_service::bounce_map::unimplemented(),
                binary_keyed_map: r#impl::some_service::binary_keyed_map::unimplemented(),
                _marker: ::std::marker::PhantomData,
            }
        }
    }

    impl<'mock> super::client::SomeService for SomeService<'mock> {
        fn bounce_map(
            &self,
            arg_m: &include::types::SomeMap,
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError>> + ::std::marker::Send + 'static>> {
            let mut closure = self.bounce_map.closure.lock().unwrap();
            let closure: &mut dyn ::std::ops::FnMut(include::types::SomeMap) -> _ = &mut **closure;
            ::std::boxed::Box::pin(::futures::future::ready(closure(arg_m.clone())))
        }
        fn binary_keyed_map(
            &self,
            arg_r: &[::std::primitive::i64],
        ) -> ::std::pin::Pin<::std::boxed::Box<dyn ::std::future::Future<Output = ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError>> + ::std::marker::Send + 'static>> {
            let mut closure = self.binary_keyed_map.closure.lock().unwrap();
            let closure: &mut dyn ::std::ops::FnMut(::std::vec::Vec<::std::primitive::i64>) -> _ = &mut **closure;
            ::std::boxed::Box::pin(::futures::future::ready(closure(arg_r.to_owned())))
        }
    }

    mod r#impl {
        pub mod some_service {

            pub struct bounce_map<'mock> {
                pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                    dyn ::std::ops::FnMut(include::types::SomeMap) -> ::std::result::Result<
                        include::types::SomeMap,
                        crate::errors::some_service::BounceMapError,
                    > + ::std::marker::Send + ::std::marker::Sync + 'mock,
                >>,
            }

            #[allow(clippy::redundant_closure)]
            impl<'mock> bounce_map<'mock> {
                pub fn unimplemented() -> Self {
                    Self {
                        closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|_: include::types::SomeMap| panic!(
                            "{}::{} is not mocked",
                            "SomeService",
                            "bounce_map",
                        ))),
                    }
                }

                pub fn ret(&self, value: include::types::SomeMap) {
                    self.mock(move |_: include::types::SomeMap| value.clone());
                }

                pub fn mock(&self, mut mock: impl ::std::ops::FnMut(include::types::SomeMap) -> include::types::SomeMap + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                    let mut closure = self.closure.lock().unwrap();
                    *closure = ::std::boxed::Box::new(move |m| ::std::result::Result::Ok(mock(m)));
                }

                pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut(include::types::SomeMap) -> ::std::result::Result<include::types::SomeMap, crate::errors::some_service::BounceMapError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                    let mut closure = self.closure.lock().unwrap();
                    *closure = ::std::boxed::Box::new(move |m| mock(m));
                }

                pub fn throw<E>(&self, exception: E)
                where
                    E: ::std::convert::Into<crate::errors::some_service::BounceMapError>,
                    E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
                {
                    let mut closure = self.closure.lock().unwrap();
                    *closure = ::std::boxed::Box::new(move |_: include::types::SomeMap| ::std::result::Result::Err(exception.clone().into()));
                }
            }

            pub struct binary_keyed_map<'mock> {
                pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                    dyn ::std::ops::FnMut(::std::vec::Vec<::std::primitive::i64>) -> ::std::result::Result<
                        ::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>,
                        crate::errors::some_service::BinaryKeyedMapError,
                    > + ::std::marker::Send + ::std::marker::Sync + 'mock,
                >>,
            }

            #[allow(clippy::redundant_closure)]
            impl<'mock> binary_keyed_map<'mock> {
                pub fn unimplemented() -> Self {
                    Self {
                        closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|_: ::std::vec::Vec<::std::primitive::i64>| panic!(
                            "{}::{} is not mocked",
                            "SomeService",
                            "binary_keyed_map",
                        ))),
                    }
                }

                pub fn ret(&self, value: ::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>) {
                    self.mock(move |_: ::std::vec::Vec<::std::primitive::i64>| value.clone());
                }

                pub fn mock(&self, mut mock: impl ::std::ops::FnMut(::std::vec::Vec<::std::primitive::i64>) -> ::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                    let mut closure = self.closure.lock().unwrap();
                    *closure = ::std::boxed::Box::new(move |r| ::std::result::Result::Ok(mock(r)));
                }

                pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut(::std::vec::Vec<::std::primitive::i64>) -> ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, crate::errors::some_service::BinaryKeyedMapError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                    let mut closure = self.closure.lock().unwrap();
                    *closure = ::std::boxed::Box::new(move |r| mock(r));
                }

                pub fn throw<E>(&self, exception: E)
                where
                    E: ::std::convert::Into<crate::errors::some_service::BinaryKeyedMapError>,
                    E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
                {
                    let mut closure = self.closure.lock().unwrap();
                    *closure = ::std::boxed::Box::new(move |_: ::std::vec::Vec<::std::primitive::i64>| ::std::result::Result::Err(exception.clone().into()));
                }
            }
        }
    }
}

/// Error return types.
pub mod errors {
    /// Errors for SomeService functions.
    pub mod some_service {

        pub type BounceMapError = ::fbthrift::NonthrowingFunctionError;

        impl ::std::convert::From<crate::services::some_service::BounceMapExn> for
            ::std::result::Result<include::types::SomeMap, BounceMapError>
        {
            fn from(e: crate::services::some_service::BounceMapExn) -> Self {
                match e {
                    crate::services::some_service::BounceMapExn::Success(res) =>
                        ::std::result::Result::Ok(res),
                    crate::services::some_service::BounceMapExn::ApplicationException(aexn) =>
                        ::std::result::Result::Err(BounceMapError::ApplicationException(aexn)),
                }
            }
        }

        pub type BinaryKeyedMapError = ::fbthrift::NonthrowingFunctionError;

        impl ::std::convert::From<crate::services::some_service::BinaryKeyedMapExn> for
            ::std::result::Result<::std::collections::BTreeMap<crate::types::TBinary, ::std::primitive::i64>, BinaryKeyedMapError>
        {
            fn from(e: crate::services::some_service::BinaryKeyedMapExn) -> Self {
                match e {
                    crate::services::some_service::BinaryKeyedMapExn::Success(res) =>
                        ::std::result::Result::Ok(res),
                    crate::services::some_service::BinaryKeyedMapExn::ApplicationException(aexn) =>
                        ::std::result::Result::Err(BinaryKeyedMapError::ApplicationException(aexn)),
                }
            }
        }

    }

}

mod r#impl {
    use ref_cast::RefCast;

    #[derive(RefCast)]
    #[repr(transparent)]
    pub(crate) struct LocalImpl<T>(T);

    #[allow(unused)]
    pub(crate) fn write<T, P>(value: &T, p: &mut P)
    where
        LocalImpl<T>: ::fbthrift::Serialize<P>,
        P: ::fbthrift::ProtocolWriter,
    {
        ::fbthrift::Serialize::write(LocalImpl::ref_cast(value), p);
    }

    #[allow(unused)]
    pub(crate) fn read<T, P>(p: &mut P) -> ::anyhow::Result<T>
    where
        LocalImpl<T>: ::fbthrift::Deserialize<P>,
        P: ::fbthrift::ProtocolReader,
    {
        let value: LocalImpl<T> = ::fbthrift::Deserialize::read(p)?;
        ::std::result::Result::Ok(value.0)
    }

    impl<P> ::fbthrift::Serialize<P> for LocalImpl<::sorted_vector_map::SortedVectorMap<::std::primitive::i32, ::std::string::String>>
    where
        P: ::fbthrift::ProtocolWriter,
    {
        fn write(&self, p: &mut P) {
            p.write_map_begin(
                <::std::primitive::i32 as ::fbthrift::GetTType>::TTYPE,
                <::std::string::String as ::fbthrift::GetTType>::TTYPE,
                self.0.len(),
            );
            for (k, v) in &self.0 {
                p.write_map_key_begin();
                ::fbthrift::Serialize::write(k, p);
                p.write_map_value_begin();
                ::fbthrift::Serialize::write(v, p);
            }
            p.write_map_end();
        }
    }

    impl<P> ::fbthrift::Deserialize<P> for LocalImpl<::sorted_vector_map::SortedVectorMap<::std::primitive::i32, ::std::string::String>>
    where
        P: ::fbthrift::ProtocolReader,
    {
        fn read(p: &mut P) -> ::anyhow::Result<Self> {
            let (_key_ty, _val_ty, len) = p.read_map_begin()?;
            let mut map = <::sorted_vector_map::SortedVectorMap<::std::primitive::i32, ::std::string::String>>::with_capacity(len.unwrap_or_default());

            if let Some(0) = len {
                return Ok(LocalImpl(map));
            }

            let mut idx = 0;
            loop {
                let more = p.read_map_key_begin()?;
                if !more {
                    break;
                }
                let k: ::std::primitive::i32 = ::fbthrift::Deserialize::read(p)?;
                p.read_map_value_begin()?;
                let v: ::std::string::String = ::fbthrift::Deserialize::read(p)?;
                p.read_map_value_end()?;
                map.insert(k, v);

                idx += 1;
                if ::fbthrift::protocol::should_break(len, more, idx) {
                    break;
                }
            }
            p.read_map_end()?;
            ::std::result::Result::Ok(LocalImpl(map))
        }
    }

    impl<P> ::fbthrift::Serialize<P> for LocalImpl<::sorted_vector_map::SortedVectorSet<::std::primitive::i32>>
    where
        P: ::fbthrift::ProtocolWriter,
    {
        fn write(&self, p: &mut P) {
            p.write_set_begin(
                <::std::primitive::i32 as ::fbthrift::GetTType>::TTYPE,
                self.0.len(),
            );
            for v in &self.0 {
                p.write_set_value_begin();
                ::fbthrift::Serialize::write(v, p);
            }
            p.write_set_end();
        }
    }

    impl<P> ::fbthrift::Deserialize<P> for LocalImpl<::sorted_vector_map::SortedVectorSet<::std::primitive::i32>>
    where
        P: ::fbthrift::ProtocolReader,
    {
        fn read(p: &mut P) -> ::anyhow::Result<Self> {
            let (_elem_ty, len) = p.read_set_begin()?;
            let mut set = <::sorted_vector_map::SortedVectorSet<::std::primitive::i32>>::with_capacity(len.unwrap_or_default());

            if let Some(0) = len {
                return Ok(LocalImpl(set));
            }

            let mut idx = 0;
            loop {
                let more = p.read_set_value_begin()?;
                if !more {
                    break;
                }
                let v: ::std::primitive::i32 = ::fbthrift::Deserialize::read(p)?;
                p.read_set_value_end()?;
                set.insert(v);

                idx += 1;
                if ::fbthrift::protocol::should_break(len, more, idx) {
                    break;
                }
            }
            p.read_set_end()?;
            ::std::result::Result::Ok(LocalImpl(set))
        }
    }
}
