from enum import Enum
from typing import Mapping, Iterator

class Priority(Enum):
    HIGH_IMPORTANCE: Priority = ...
    HIGH: Priority = ...
    IMPORTANT: Priority = ...
    NORMAL: Priority = ...
    BEST_EFFORT: Priority = ...
    N_PRIORITIES: Priority = ...
    value: int


class Headers(Mapping[str, str]):
    def __repr__(self) -> str: ...
    def __len__(self) -> int: ...
    def __contains__(self, x: object) -> bool: ...
    def __getitem__(self, key: str) -> str: ...
    def __iter__(self) -> Iterator[str]: ...


class ReadHeaders(Headers): ...
class WriteHeaders(Headers): ...

class RpcOptions:
    @property
    def timeout(self) -> float: ...
    @timeout.setter
    def timeout(self, seconds: float) -> None: ...
    @property
    def priority(self) -> Priority: ...
    @priority.setter
    def priority(self, value: Priority) -> None: ...
    @property
    def chunk_timeout(self) -> float: ...
    @chunk_timeout.setter
    def chunk_timeout(self, seconds: float) -> None: ...
    @property
    def queue_timeout(self) -> float: ...
    @queue_timeout.setter
    def queue_timeout(self, seconds: float) -> None: ...
    def set_header(self, key: str, value: str) -> None: ...
    @property
    def read_headers(self) -> ReadHeaders: ...
    @property
    def write_headers(self) -> WriteHeaders: ...
