// Autogenerated by Thrift Compiler (facebook)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
// @generated

package main

import (
        "flag"
        "fmt"
        "math"
        "net"
        "net/url"
        "os"
        "strconv"
        "strings"
        "github.com/facebook/fbthrift-go"
        "module"
)

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  void mapList( foo)")
  fmt.Fprintln(os.Stderr, "  void mapSet( foo)")
  fmt.Fprintln(os.Stderr, "  void listMap( foo)")
  fmt.Fprintln(os.Stderr, "  void listSet( foo)")
  fmt.Fprintln(os.Stderr, "  void turtles( foo)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  var parsedUrl url.URL
  var trans thrift.Transport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Parse()
  
  if len(urlString) > 0 {
    parsedUrl, err := url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewHttpClient(parsedUrl.String())
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.ProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  client := module.NewNestedContainersClientFactory(trans, protocolFactory)
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "mapList":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "MapList requires 1 args")
      flag.Usage()
    }
    arg40 := flag.Arg(1)
    mbTrans41 := thrift.NewMemoryBufferLen(len(arg40))
    defer mbTrans41.Close()
    _, err42 := mbTrans41.WriteString(arg40)
    if err42 != nil { 
      Usage()
      return
    }
    factory43 := thrift.NewSimpleJSONProtocolFactory()
    jsProt44 := factory43.GetProtocol(mbTrans41)
    containerStruct0 := module.NewNestedContainersMapListArgs()
    err45 := containerStruct0.ReadField1(jsProt44)
    if err45 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.MapList(value0))
    fmt.Print("\n")
    break
  case "mapSet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "MapSet requires 1 args")
      flag.Usage()
    }
    arg46 := flag.Arg(1)
    mbTrans47 := thrift.NewMemoryBufferLen(len(arg46))
    defer mbTrans47.Close()
    _, err48 := mbTrans47.WriteString(arg46)
    if err48 != nil { 
      Usage()
      return
    }
    factory49 := thrift.NewSimpleJSONProtocolFactory()
    jsProt50 := factory49.GetProtocol(mbTrans47)
    containerStruct0 := module.NewNestedContainersMapSetArgs()
    err51 := containerStruct0.ReadField1(jsProt50)
    if err51 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.MapSet(value0))
    fmt.Print("\n")
    break
  case "listMap":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ListMap requires 1 args")
      flag.Usage()
    }
    arg52 := flag.Arg(1)
    mbTrans53 := thrift.NewMemoryBufferLen(len(arg52))
    defer mbTrans53.Close()
    _, err54 := mbTrans53.WriteString(arg52)
    if err54 != nil { 
      Usage()
      return
    }
    factory55 := thrift.NewSimpleJSONProtocolFactory()
    jsProt56 := factory55.GetProtocol(mbTrans53)
    containerStruct0 := module.NewNestedContainersListMapArgs()
    err57 := containerStruct0.ReadField1(jsProt56)
    if err57 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.ListMap(value0))
    fmt.Print("\n")
    break
  case "listSet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ListSet requires 1 args")
      flag.Usage()
    }
    arg58 := flag.Arg(1)
    mbTrans59 := thrift.NewMemoryBufferLen(len(arg58))
    defer mbTrans59.Close()
    _, err60 := mbTrans59.WriteString(arg58)
    if err60 != nil { 
      Usage()
      return
    }
    factory61 := thrift.NewSimpleJSONProtocolFactory()
    jsProt62 := factory61.GetProtocol(mbTrans59)
    containerStruct0 := module.NewNestedContainersListSetArgs()
    err63 := containerStruct0.ReadField1(jsProt62)
    if err63 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.ListSet(value0))
    fmt.Print("\n")
    break
  case "turtles":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Turtles requires 1 args")
      flag.Usage()
    }
    arg64 := flag.Arg(1)
    mbTrans65 := thrift.NewMemoryBufferLen(len(arg64))
    defer mbTrans65.Close()
    _, err66 := mbTrans65.WriteString(arg64)
    if err66 != nil { 
      Usage()
      return
    }
    factory67 := thrift.NewSimpleJSONProtocolFactory()
    jsProt68 := factory67.GetProtocol(mbTrans65)
    containerStruct0 := module.NewNestedContainersTurtlesArgs()
    err69 := containerStruct0.ReadField1(jsProt68)
    if err69 != nil {
      Usage()
      return
    }
    argvalue0 := containerStruct0.Foo
    value0 := argvalue0
    fmt.Print(client.Turtles(value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
