/* -----------------------------------------------------------------------------
 * gssapi.h defines RFC 2743 GSS-API APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#include "../../include/gssapi.h"

#include <openssl/asn1t.h>

ASN1_SEQUENCE (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY) = {
    ASN1_SIMPLE (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY, thisMech,          ASN1_OBJECT),
    ASN1_SIMPLE (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY, innerContextToken, ASN1_ANY)
} ASN1_SEQUENCE_END (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY)

IMPLEMENT_ASN1_FUNCTIONS (GSSAPI_INITIAL_CONTEXT_TOKEN_BODY)

/* [APPLICATION 0] IMPLICIT */

ASN1_ITEM_TEMPLATE (GSSAPI_INITIAL_CONTEXT_TOKEN) = 
    ASN1_EX_TEMPLATE_TYPE (ASN1_TFLG_APPLICATION | ASN1_TFLG_IMPTAG,
                           0,
                           GSSAPI_INITIAL_CONTEXT_TOKEN,
                           GSSAPI_INITIAL_CONTEXT_TOKEN_BODY)
ASN1_ITEM_TEMPLATE_END(GSSAPI_INITIAL_CONTEXT_TOKEN)

IMPLEMENT_ASN1_FUNCTIONS (GSSAPI_INITIAL_CONTEXT_TOKEN)
