/*
 * Decompiled with CFR 0.152.
 */
package jnicli;

import java.io.Serializable;
import java.util.NoSuchElementException;
import jnicli.ClassDescriptor;
import jnicli.CliException;
import jnicli.Cursor;
import jnicli.DatabaseJNI;

public class PrefetchedCursor
implements Cursor,
Serializable {
    public Object[] objects;
    public long[] oids;
    transient int i;

    public PrefetchedCursor() {
    }

    PrefetchedCursor(DatabaseJNI db, long cursor, ClassDescriptor desc) {
        int size = db.jniGetNumberOfSelectedRecords(cursor);
        this.objects = new Object[size];
        this.oids = new long[size];
        for (int i = 0; i < size; ++i) {
            this.oids[i] = db.jniNext(cursor);
            this.objects[i] = db.unswizzleObject(cursor, desc);
        }
        db.jniCloseCursor(cursor);
    }

    public boolean hasMoreElements() {
        return this.i < this.objects.length;
    }

    public Object nextElement() {
        if (this.i >= this.objects.length) {
            throw new NoSuchElementException();
        }
        return this.objects[this.i++];
    }

    public long getOid() {
        if (this.i == 0) {
            throw new NoSuchElementException();
        }
        return this.oids[this.i - 1];
    }

    public void update() {
        throw new CliException("Cursor not in update mode");
    }

    public int size() {
        return this.objects.length;
    }
}

