/*
 * Decompiled with CFR 0.152.
 */
package jnicli;

import java.util.NoSuchElementException;
import jnicli.ClassDescriptor;
import jnicli.CliException;
import jnicli.Cursor;
import jnicli.DatabaseJNI;

class IncrementalCursor
implements Cursor {
    DatabaseJNI db;
    long oid;
    long cursor;
    ClassDescriptor desc;

    IncrementalCursor(DatabaseJNI db, long cursor, ClassDescriptor desc) {
        this.db = db;
        this.desc = desc;
        this.cursor = cursor;
        this.oid = db.jniNext(cursor);
    }

    public int size() {
        return this.db.jniGetNumberOfSelectedRecords(this.cursor);
    }

    public boolean hasMoreElements() {
        return this.oid > 0L;
    }

    public Object nextElement() {
        if (this.oid == 0L) {
            throw new NoSuchElementException();
        }
        Object obj = this.db.unswizzleObject(this.cursor, this.desc);
        this.oid = this.db.jniNext(this.cursor);
        return obj;
    }

    public long getOid() {
        return this.oid;
    }

    public void update() {
        throw new CliException("Cursor not in update mode");
    }

    protected void finalize() {
        if (this.oid != 0L) {
            this.db.jniCloseCursor(this.cursor);
        }
    }
}

