/*
 * Decompiled with CFR 0.152.
 */
package javacli;

import javacli.CliError;
import javacli.ComBuffer;
import javacli.Reference;
import javacli.Statement;

public class ObjectSet {
    protected Statement stmt;
    protected int nObjects;
    protected int currOid;
    protected Object currObj;
    protected boolean updated;

    public Object getFirst() {
        return this.getObject(3, 0);
    }

    public Object getLast() {
        return this.getObject(4, 0);
    }

    public Object getNext() {
        return this.getObject(5, 0);
    }

    public Object getPrev() {
        return this.getObject(6, 0);
    }

    Object skip(int n) {
        return this.getObject(18, n);
    }

    public Reference getRef() {
        return this.currOid != 0 ? new Reference(this.currOid) : null;
    }

    public void update() {
        if (this.stmt == null) {
            throw new CliError("ObjectSet was aleady closed");
        }
        if (this.stmt.con == null) {
            throw new CliError("Statement was closed");
        }
        if (this.currOid == 0) {
            throw new CliError("No object was selected");
        }
        if (!this.stmt.forUpdate) {
            throw new CliError("Updates not allowed");
        }
        if (this.updated) {
            throw new CliError("Record was already updated");
        }
        ComBuffer buf = new ComBuffer(10, this.stmt.stmtId);
        this.stmt.tableDesc.writeColumnValues(buf, this.currObj);
        this.stmt.con.sendReceive(buf);
    }

    public void removeAll() {
        if (this.stmt == null) {
            throw new CliError("ObjectSet was aleady closed");
        }
        if (this.stmt.con == null) {
            throw new CliError("Statement was closed");
        }
        if (!this.stmt.forUpdate) {
            throw new CliError("Updates not allowed");
        }
        this.stmt.con.sendReceive(11, this.stmt.stmtId);
    }

    public int size() {
        return this.nObjects;
    }

    public void close() {
        if (this.stmt == null) {
            throw new CliError("ObjectSet was aleady closed");
        }
        this.stmt = null;
    }

    protected Object getObject(int cmd, int n) {
        if (this.stmt == null) {
            throw new CliError("ObjectSet was aleady closed");
        }
        if (this.stmt.con == null) {
            throw new CliError("Statement was closed");
        }
        ComBuffer buf = new ComBuffer(cmd, this.stmt.stmtId);
        if (cmd == 18) {
            buf.putInt(n);
        }
        this.stmt.con.send(buf);
        buf.reset(4);
        this.stmt.con.receive(buf, 4);
        int len = buf.getInt();
        if (len == -13) {
            return null;
        }
        if (len <= 0) {
            throw new CliError("Failed to get object");
        }
        buf.reset(len - 4);
        this.stmt.con.receive(buf, len - 4);
        this.currOid = buf.getInt();
        if (this.currOid == 0) {
            return null;
        }
        this.updated = false;
        this.currObj = this.stmt.tableDesc.readObject(buf);
        return this.currObj;
    }

    protected ObjectSet(Statement stmt, int nObjects) {
        this.stmt = stmt;
        this.nObjects = nObjects;
    }
}

