/*
 * Decompiled with CFR 0.152.
 */
package javacli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javacli.CliError;
import javacli.ComBuffer;
import javacli.ConnectionPool;
import javacli.LocalSocket;
import javacli.Rectangle;
import javacli.Reference;
import javacli.Statement;
import javacli.TableDescriptor;

public class Connection {
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    protected ConnectionPool pool;
    protected Connection next;
    protected String address;
    protected int port;
    protected String[] pkgs;
    int nStatements;
    static Hashtable tableHash = new Hashtable();
    protected static final int cli_cmd_close_session = 0;
    protected static final int cli_cmd_prepare_and_execute = 1;
    protected static final int cli_cmd_execute = 2;
    protected static final int cli_cmd_get_first = 3;
    protected static final int cli_cmd_get_last = 4;
    protected static final int cli_cmd_get_next = 5;
    protected static final int cli_cmd_get_prev = 6;
    protected static final int cli_cmd_free_statement = 7;
    protected static final int cli_cmd_abort = 8;
    protected static final int cli_cmd_commit = 9;
    protected static final int cli_cmd_update = 10;
    protected static final int cli_cmd_remove = 11;
    protected static final int cli_cmd_remove_current = 12;
    protected static final int cli_cmd_insert = 13;
    protected static final int cli_cmd_prepare_and_insert = 14;
    protected static final int cli_cmd_describe_table = 15;
    protected static final int cli_cmd_show_tables = 16;
    protected static final int cli_cmd_precommit = 17;
    protected static final int cli_cmd_skip = 18;
    protected static final int cli_cmd_create_table = 19;
    protected static final int cli_cmd_drop_table = 20;
    protected static final int cli_cmd_alter_index = 21;
    protected static final int cli_cmd_freeze = 22;
    protected static final int cli_cmd_unfreeze = 23;
    protected static final int cli_cmd_seek = 24;
    protected static final int cli_cmd_alter_table = 25;
    public static final int cli_ok = 0;
    public static final int cli_bad_address = -1;
    public static final int cli_connection_refused = -2;
    public static final int cli_database_not_found = -3;
    public static final int cli_bad_statement = -4;
    public static final int cli_parameter_not_found = -5;
    public static final int cli_unbound_parameter = -6;
    public static final int cli_column_not_found = -7;
    public static final int cli_incompatible_type = -8;
    public static final int cli_network_error = -9;
    public static final int cli_runtime_error = -10;
    public static final int cli_closed_statement = -11;
    public static final int cli_unsupported_type = -12;
    public static final int cli_not_found = -13;
    public static final int cli_not_update_mode = -14;
    public static final int cli_table_not_found = -15;
    public static final int cli_not_all_columns_specified = -16;
    public static final int cli_not_fetched = -17;
    public static final int cli_already_updated = -18;
    public static final int cli_table_already_exists = -19;
    public static final int cli_not_implemented = -20;
    public static final int cli_login_failed = -21;
    public static final int cli_empty_parameter = -22;
    public static final int cli_closed_connection = -23;
    protected static final int cli_oid = 0;
    protected static final int cli_bool = 1;
    protected static final int cli_int1 = 2;
    protected static final int cli_int2 = 3;
    protected static final int cli_int4 = 4;
    protected static final int cli_int8 = 5;
    protected static final int cli_real4 = 6;
    protected static final int cli_real8 = 7;
    protected static final int cli_decimal = 8;
    protected static final int cli_asciiz = 9;
    protected static final int cli_pasciiz = 10;
    protected static final int cli_cstring = 11;
    protected static final int cli_array_of_oid = 12;
    protected static final int cli_array_of_bool = 13;
    protected static final int cli_array_of_int1 = 14;
    protected static final int cli_array_of_int2 = 15;
    protected static final int cli_array_of_int4 = 16;
    protected static final int cli_array_of_int8 = 17;
    protected static final int cli_array_of_real4 = 18;
    protected static final int cli_array_of_real8 = 19;
    protected static final int cli_array_of_decimal = 20;
    protected static final int cli_array_of_string = 21;
    protected static final int cli_any = 22;
    protected static final int cli_datetime = 23;
    protected static final int cli_autoincrement = 24;
    protected static final int cli_rectangle = 25;
    protected static final int cli_undefined = 26;
    protected static final int cli_hashed = 1;
    protected static final int cli_indexed = 2;
    protected static final int cli_case_insensitive = 4;

    public void open(String hostAddress, int hostPort) {
        this.address = hostAddress;
        this.port = hostPort;
        try {
            this.socket = null;
            if (hostAddress.equals("localhost")) {
                try {
                    this.socket = new LocalSocket(hostAddress, hostPort);
                }
                catch (Throwable x) {
                    // empty catch block
                }
            }
            if (this.socket == null) {
                this.socket = new Socket(hostAddress, hostPort);
            }
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (NoSuchMethodError er) {
                // empty catch block
            }
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (IOException x) {
            throw new CliError("Faield to open database: " + x);
        }
    }

    public void addPackage(String pkName) {
        if (this.pkgs == null) {
            this.pkgs = new String[1];
        } else {
            String[] np = new String[this.pkgs.length + 1];
            System.arraycopy(this.pkgs, 0, np, 0, this.pkgs.length);
            this.pkgs = np;
        }
        this.pkgs[this.pkgs.length - 1] = pkName;
    }

    public void close() {
        if (this.socket == null) {
            throw new CliError("Session is not opened");
        }
        if (this.pool != null) {
            this.pool.releaseConnection(this);
            return;
        }
        ComBuffer buf = new ComBuffer(0);
        this.send(buf);
        try {
            this.socket.close();
        }
        catch (IOException x) {
            this.socket = null;
            throw new CliError("Close failed: " + x);
        }
        this.socket = null;
    }

    public Statement createStatement(String sql) {
        if (this.socket == null) {
            throw new CliError("Session is not opened");
        }
        return new Statement(this, sql, ++this.nStatements);
    }

    public void commit() {
        if (this.socket == null) {
            throw new CliError("Session is not opened");
        }
        this.sendReceive(9, 0);
    }

    public void precommit() {
        if (this.socket == null) {
            throw new CliError("Session is not opened");
        }
        this.sendReceive(17, 0);
    }

    public void rollback() {
        if (this.socket == null) {
            throw new CliError("Session is not opened");
        }
        this.sendReceive(8, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference insert(Object obj) {
        TableDescriptor tableDesc;
        if (this.socket == null) {
            throw new CliError("Session is not opened");
        }
        Class<?> clazz = obj.getClass();
        String className = clazz.getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        Hashtable hashtable = tableHash;
        synchronized (hashtable) {
            tableDesc = (TableDescriptor)tableHash.get(className);
            if (tableDesc == null) {
                tableDesc = new TableDescriptor(clazz);
                tableHash.put(className, tableDesc);
            }
        }
        ComBuffer buf = new ComBuffer(14);
        buf.putAsciiz("insert into " + className);
        buf.putByte(tableDesc.nColumns);
        tableDesc.writeColumnDefs(buf);
        tableDesc.writeColumnValues(buf, obj);
        this.send(buf);
        this.receive(buf, 12);
        int rc = buf.getInt();
        if (rc == 0) {
            int rowid = buf.getInt();
            int oid = buf.getInt();
            if (tableDesc.autoincrement) {
                try {
                    int i = tableDesc.nColumns;
                    while (--i >= 0) {
                        if (tableDesc.types[i] != 24) continue;
                        tableDesc.columns[i].setInt(obj, rowid);
                    }
                }
                catch (IllegalAccessException x) {
                    throw new CliError("Failed to assigned value to autoincremented field: " + x);
                }
            }
            return oid != 0 ? new Reference(oid) : null;
        }
        throw new CliError("Insert object operation failed with status " + rc);
    }

    public boolean createTable(Class cls) {
        return this.createTable(cls, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createTable(Class cls, HashMap referenceMap) {
        int i;
        Class c;
        if (this.socket == null) {
            throw new CliError("Session is not opened");
        }
        int nColumns = 0;
        for (c = cls; c != null; c = c.getSuperclass()) {
            Field[] classFields = c.getDeclaredFields();
            for (i = 0; i < classFields.length; ++i) {
                if ((classFields[i].getModifiers() & 0x88) != 0) continue;
                ++nColumns;
            }
        }
        ComBuffer buf = new ComBuffer(19);
        String tableName = cls.getName();
        tableName = tableName.substring(tableName.lastIndexOf(46) + 1);
        buf.putAsciiz(tableName);
        buf.putByte(nColumns);
        for (c = cls; c != null; c = c.getSuperclass()) {
            Field[] classFields = c.getDeclaredFields();
            for (i = 0; i < classFields.length; ++i) {
                int cliType;
                Field f = classFields[i];
                if ((classFields[i].getModifiers() & 0x88) != 0) continue;
                Class<?> type = f.getType();
                String refTableName = "";
                if (type == Byte.TYPE) {
                    cliType = 2;
                } else if (type == Short.TYPE) {
                    cliType = 3;
                } else if (type == Integer.TYPE) {
                    cliType = (f.getModifiers() & 0x40) != 0 ? 24 : 4;
                } else if (type == Boolean.TYPE) {
                    cliType = 1;
                } else if (type == Long.TYPE) {
                    cliType = 5;
                } else if (type == Float.TYPE) {
                    cliType = 6;
                } else if (type == Double.TYPE) {
                    cliType = 7;
                } else if (type == Reference.TYPE) {
                    if (referenceMap == null || (refTableName = (String)referenceMap.get(classFields[i].getName())) == null) {
                        throw new CliError("Rererenced table should be specified for reference field");
                    }
                    cliType = 0;
                } else if (type == Rectangle.TYPE) {
                    cliType = 25;
                } else if (type == String.class) {
                    cliType = 9;
                } else if (type == Date.class) {
                    cliType = 23;
                } else {
                    if (!type.isArray()) throw new CliError("Unsupported field type " + type.getName());
                    if ((type = type.getComponentType()) == Byte.TYPE) {
                        cliType = 14;
                    } else if (type == Short.TYPE) {
                        cliType = 15;
                    } else if (type == Integer.TYPE) {
                        cliType = 16;
                    } else if (type == Boolean.TYPE) {
                        cliType = 13;
                    } else if (type == Long.TYPE) {
                        cliType = 17;
                    } else if (type == Float.TYPE) {
                        cliType = 18;
                    } else if (type == Double.TYPE) {
                        cliType = 19;
                    } else if (type == Reference.TYPE) {
                        cliType = 12;
                        if (referenceMap == null || (refTableName = (String)referenceMap.get(classFields[i].getName())) == null) {
                            throw new CliError("Rererenced table should be specified for reference field");
                        }
                    } else {
                        if (type != String.class) throw new CliError("Unsupported array type " + type.getName());
                        cliType = 21;
                    }
                }
                buf.putByte(cliType);
                buf.putByte(0);
                buf.putAsciiz(f.getName());
                buf.putAsciiz(refTableName);
                buf.putAsciiz("");
            }
        }
        this.send(buf);
        this.receive(buf, 4);
        int rc = buf.getInt();
        if (rc == -19) {
            return false;
        }
        if (rc >= 0) return true;
        throw new CliError("Create table failed with status: " + rc);
    }

    public void dropTable(Class cls) {
        String tableName = cls.getName();
        tableName = tableName.substring(tableName.lastIndexOf(46) + 1);
        this.dropTable(tableName);
    }

    public void dropTable(String tableName) {
        ComBuffer buf = new ComBuffer(19);
        buf.putAsciiz(tableName);
        this.sendReceive(buf);
    }

    public void addIndex(String tableName, String fieldName) {
        this.addIndex(tableName, fieldName, false);
    }

    public void addIndex(String tableName, String fieldName, boolean caseInsensitive) {
        ComBuffer buf = new ComBuffer(21);
        buf.putAsciiz(tableName);
        buf.putAsciiz(fieldName);
        buf.putByte(caseInsensitive ? 6 : 2);
        this.sendReceive(buf);
    }

    public void dropIndex(String tableName, String fieldName) {
        ComBuffer buf = new ComBuffer(21);
        buf.putAsciiz(tableName);
        buf.putAsciiz(fieldName);
        buf.putByte(0);
        this.sendReceive(buf);
    }

    public Connection() {
    }

    Connection(ConnectionPool pool) {
        this.pool = pool;
    }

    protected int sendReceive(int cmd, int stmtId) {
        return this.sendReceive(new ComBuffer(cmd, stmtId));
    }

    protected int sendReceive(ComBuffer buf) {
        this.send(buf);
        this.receive(buf, 4);
        int rc = buf.getInt();
        if (rc < 0) {
            throw new CliError("Request failed with status " + rc);
        }
        return rc;
    }

    protected void send(ComBuffer com) {
        try {
            com.end();
            this.out.write(com.buf, 0, com.pos);
        }
        catch (IOException x) {
            throw new CliError("Communication error: " + x);
        }
    }

    protected void receive(ComBuffer com, int len) {
        com.reset(len);
        int offs = 0;
        try {
            while (len > 0) {
                int rc = this.in.read(com.buf, offs, len);
                if (rc < 0) {
                    throw new CliError("Failed to read response");
                }
                len -= rc;
                offs += rc;
            }
        }
        catch (IOException x) {
            throw new CliError("Communication error: " + x);
        }
    }
}

