/*
 * Copyright 2012 Sean Farley
 *
 * This guy called Sean wrote this sweet code. You are hereby granted
 * permission to do whatever you feel like doing with it on the understanding
 * that he's not responsible for anything that results from your use of this
 * sweet code.
 */

#include "fast-hg-common.h"

int parse_bookmarks(const char *pwd) {
  if (cat_file(pwd, ".hg/bookmarks.current")) {
    /* fallback to branch name if bookmark isn't active */
    return cat_file(pwd, ".hg/branch");
  }

  return 0;
}

int main() {
  return map(parse_bookmarks);
}
