/*
 * Decompiled with CFR 0.152.
 */
package fanx.util;

import fan.sys.ArgErr;
import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanInt;
import fan.sys.FuncType;
import fan.sys.MapType;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Type;
import java.util.ArrayList;

public class TypeParser {
    private String sig;
    private int len;
    private int pos;
    private int cur;
    private int peek;
    private boolean checked;
    private Pod loadingPod;

    public static Type load(String string, boolean bl, Pod pod) {
        char c;
        int n = string.length();
        char c2 = c = n > 1 ? string.charAt(n - 1) : (char)'\u0000';
        if (c == '?') {
            return TypeParser.load(string.substring(0, n - 1), bl, pod).toNullable();
        }
        if (c != ']' && c != '|') {
            String string2;
            String string3;
            try {
                int n2 = string.indexOf("::");
                string3 = string.substring(0, n2);
                string2 = string.substring(n2 + 2);
                if (string3.length() == 0 || string2.length() == 0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw ArgErr.make("Invalid type signature '" + string + "', use <pod>::<type>");
            }
            if (string3.charAt(0) == '[') {
                return Env.cur().loadJavaType(string3, string2);
            }
            if (pod != null && string3.equals(pod.name())) {
                return pod.type(string2, bl);
            }
            return TypeParser.find(string3, string2, bl);
        }
        try {
            return new TypeParser(string, bl, pod).loadTop();
        }
        catch (Err err) {
            throw err;
        }
        catch (Exception exception) {
            throw TypeParser.err(string);
        }
    }

    public static Type find(String string, String string2, boolean bl) {
        Pod pod = Pod.find(string, bl);
        if (pod == null) {
            return null;
        }
        return pod.type(string2, bl);
    }

    private TypeParser(String string, boolean bl, Pod pod) {
        this.sig = string;
        this.len = string.length();
        this.pos = 0;
        this.cur = string.charAt(this.pos);
        this.peek = string.charAt(this.pos + 1);
        this.checked = bl;
        this.loadingPod = pod;
    }

    private Type loadTop() {
        Type type = this.load();
        if (this.cur != 0) {
            throw this.err();
        }
        return type;
    }

    private Type load() {
        Type type;
        if (this.cur == 124) {
            type = this.loadFunc();
        } else if (this.cur == 91) {
            boolean bl = true;
            for (int i = this.pos + 1; i < this.len; ++i) {
                char c = this.sig.charAt(i);
                if (TypeParser.isIdChar(c)) continue;
                bl = c == ']';
                break;
            }
            type = bl ? this.loadFFI() : this.loadMap();
        } else {
            type = this.loadBasic();
        }
        if (this.cur == 63) {
            this.consume(63);
            type = type.toNullable();
        }
        while (this.cur == 91) {
            this.consume(91);
            this.consume(93);
            type = type.toListOf();
            if (this.cur != 63) continue;
            this.consume(63);
            type = type.toNullable();
        }
        if (this.cur == 63) {
            this.consume(63);
            type = type.toNullable();
        }
        return type;
    }

    private Type loadMap() {
        this.consume(91);
        Type type = this.load();
        this.consume(58);
        Type type2 = this.load();
        this.consume(93);
        return new MapType(type, type2);
    }

    private Type loadFunc() {
        this.consume(124);
        ArrayList<Type> arrayList = new ArrayList<Type>(8);
        if (this.cur != 45) {
            while (true) {
                arrayList.add(this.load());
                if (this.cur == 45) break;
                this.consume(44);
            }
        }
        this.consume(45);
        this.consume(62);
        Type type = this.load();
        this.consume(124);
        return new FuncType(arrayList.toArray(new Type[arrayList.size()]), type);
    }

    private Type loadFFI() {
        int n = this.pos;
        while (this.cur != 58 || this.peek != 58) {
            this.consume();
        }
        String string = this.sig.substring(n, this.pos);
        this.consume(58);
        this.consume(58);
        n = this.pos;
        while (this.cur == 91) {
            this.consume();
        }
        while (TypeParser.isIdChar(this.cur)) {
            this.consume();
        }
        String string2 = this.sig.substring(n, this.pos);
        return Env.cur().loadJavaType(string, string2);
    }

    private Type loadBasic() {
        Type type;
        String string = this.consumeId();
        this.consume(58);
        this.consume(58);
        String string2 = this.consumeId();
        if (string2.length() == 1 && string.equals("sys") && (type = Sys.genericParamType(string2)) != null) {
            return type;
        }
        if (this.loadingPod != null && string.equals(this.loadingPod.name())) {
            return this.loadingPod.type(string2, this.checked);
        }
        return TypeParser.find(string, string2, this.checked);
    }

    private String consumeId() {
        int n = this.pos;
        while (TypeParser.isIdChar(this.cur)) {
            this.consume();
        }
        return this.sig.substring(n, this.pos);
    }

    public static boolean isIdChar(int n) {
        return FanInt.isAlphaNum(n) || n == 95;
    }

    private void consume(int n) {
        if (this.cur != n) {
            throw this.err();
        }
        this.consume();
    }

    private void consume() {
        if (this.pos > this.len + 10) {
            throw new RuntimeException("Unexpected end of string");
        }
        this.cur = this.peek;
        ++this.pos;
        this.peek = this.pos + 1 < this.len ? (int)this.sig.charAt(this.pos + 1) : 0;
    }

    private Err err() {
        return TypeParser.err(this.sig);
    }

    private static Err err(String string) {
        return ArgErr.make("Invalid type signature '" + string + "'");
    }
}

