/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Date;
import fan.sys.DateTimeStr;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.FanObj;
import fan.sys.Locale;
import fan.sys.Month;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Time;
import fan.sys.TimeZone;
import fan.sys.Type;
import fan.sys.Weekday;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicLong;

public final class DateTime
extends FanObj {
    static final long diffJava = 946684800000L;
    static final long nsPerYear = 31536000000000000L;
    static final long nsPerDay = 86400000000000L;
    static final long nsPerHour = 3600000000000L;
    static final long nsPerMin = 60000000000L;
    static final long nsPerSec = 1000000000L;
    static final long nsPerMilli = 1000000L;
    static final long minTicks = -3124137600000000000L;
    static final long maxTicks = 3155760000000000000L;
    private static final SimpleDateFormat[] httpFormats;
    static long[] yearTicks;
    static byte[] firstWeekdayOfYear;
    static final int[] daysInMon;
    static final int[] daysInMonLeap;
    static final int[] dayOfYearForFirstOfMon;
    static final int[] dayOfYearForFirstOfMonLeap;
    static byte[] monForDayOfYear;
    static byte[] dayForDayOfYear;
    static byte[] monForDayOfYearLeap;
    static byte[] dayForDayOfYearLeap;
    private static final Duration toleranceDefault;
    private static volatile DateTime cached;
    private static volatile DateTime cachedUtc;
    private static Object nowUniqueLock;
    private static long nowUniqueLast;
    private static AtomicLong nowTicksCounter;
    private static final String localeKey = "dateTime";
    public static final DateTime defVal;
    private final long ticks;
    private final int fields;
    private final TimeZone tz;

    public static DateTime now() {
        return DateTime.now(toleranceDefault);
    }

    public static DateTime now(Duration duration) {
        long l = DateTime.nowTicks();
        DateTime dateTime = cached;
        if (duration != null && l - dateTime.ticks <= duration.ticks) {
            return dateTime;
        }
        cached = new DateTime(l, TimeZone.cur);
        return cached;
    }

    public static DateTime nowUtc() {
        return DateTime.nowUtc(toleranceDefault);
    }

    public static DateTime nowUtc(Duration duration) {
        long l = DateTime.nowTicks();
        DateTime dateTime = cachedUtc;
        if (duration != null && l - dateTime.ticks <= duration.ticks) {
            return dateTime;
        }
        cachedUtc = new DateTime(l, TimeZone.utc);
        return cachedUtc;
    }

    public static long nowTicks() {
        return DateTime.fromJavaToTicks(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nowUnique() {
        Object object = nowUniqueLock;
        synchronized (object) {
            long l = (System.currentTimeMillis() - 946684800000L) * 1000000L;
            if (l <= nowUniqueLast) {
                l = nowUniqueLast + 1L;
            }
            nowUniqueLast = l;
            return nowUniqueLast;
        }
    }

    public static DateTime boot() {
        return Sys.bootDateTime;
    }

    public static DateTime make(long l, Month month, long l2, long l3, long l4) {
        return DateTime.make(l, month, l2, l3, l4, 0L, 0L, TimeZone.cur);
    }

    public static DateTime make(long l, Month month, long l2, long l3, long l4, long l5) {
        return DateTime.make(l, month, l2, l3, l4, l5, 0L, TimeZone.cur);
    }

    public static DateTime make(long l, Month month, long l2, long l3, long l4, long l5, long l6) {
        return DateTime.make(l, month, l2, l3, l4, l5, l6, TimeZone.cur);
    }

    public static DateTime make(long l, Month month, long l2, long l3, long l4, long l5, long l6, TimeZone timeZone) {
        return new DateTime((int)l, month.ord, (int)l2, (int)l3, (int)l4, (int)l5, l6, Integer.MAX_VALUE, timeZone);
    }

    DateTime(int n, int n2, int n3, int n4, int n5, int n6, long l, int n7, TimeZone timeZone) {
        boolean bl;
        int n8;
        if (n < 1901 || n > 2099) {
            throw ArgErr.make("year " + n);
        }
        if (n2 < 0 || n2 > 11) {
            throw ArgErr.make("month " + n2);
        }
        if (n3 < 1 || n3 > DateTime.numDaysInMonth(n, n2)) {
            throw ArgErr.make("day " + n3);
        }
        if (n4 < 0 || n4 > 23) {
            throw ArgErr.make("hour " + n4);
        }
        if (n5 < 0 || n5 > 59) {
            throw ArgErr.make("min " + n5);
        }
        if (n6 < 0 || n6 > 59) {
            throw ArgErr.make("sec " + n6);
        }
        if (l < 0L || l > 999999999L) {
            throw ArgErr.make("ns " + l);
        }
        int n9 = DateTime.dayOfYear(n, n2, n3);
        int n10 = n4 * 3600 + n5 * 60 + n6;
        long l2 = yearTicks[n - 1900] + (long)n9 * 86400000000000L + (long)n10 * 1000000000L + l;
        TimeZone.Rule rule = timeZone.rule(n);
        if (n7 == Integer.MAX_VALUE) {
            l2 -= (long)rule.offset * 1000000000L;
            n8 = TimeZone.dstOffset(rule, n, n2, n3, n10);
            if (n8 != 0) {
                l2 -= (long)n8 * 1000000000L;
            }
            bl = n8 != 0;
        } else {
            l2 -= (long)n7 * 1000000000L;
            bl = n7 != rule.offset;
        }
        n8 = (DateTime.firstWeekday(n, n2) + n3 - 1) % 7;
        int n11 = 0;
        n11 |= (n - 1900 & 0xFF) << 0;
        n11 |= (n2 & 0xF) << 8;
        n11 |= (n3 & 0x1F) << 12;
        n11 |= (n4 & 0x1F) << 17;
        n11 |= (n5 & 0x3F) << 22;
        n11 |= (n8 & 7) << 28;
        int n12 = bl ? 1 : 0;
        this.ticks = l2;
        this.tz = timeZone;
        this.fields = n11 |= n12 << 31;
    }

    static DateTime makeDT(Date date, Time time) {
        return DateTime.makeDT(date, time, TimeZone.cur);
    }

    static DateTime makeDT(Date date, Time time, TimeZone timeZone) {
        return new DateTime(date.year, date.month, date.day, time.hour, time.min, time.sec, time.ns, Integer.MAX_VALUE, timeZone);
    }

    public static DateTime makeTicks(long l) {
        return DateTime.makeTicks(l, TimeZone.cur);
    }

    public static DateTime makeTicks(long l, TimeZone timeZone) {
        return new DateTime(l, timeZone);
    }

    private DateTime(long l, TimeZone timeZone) {
        byte by;
        byte by2;
        int n;
        long l2;
        if (l < -3124137600000000000L || l >= 3155760000000000000L) {
            throw ArgErr.make("Ticks out of range 1901 to 2099");
        }
        this.ticks = l;
        this.tz = timeZone;
        int n2 = DateTime.ticksToYear(l);
        TimeZone.Rule rule = timeZone.rule(n2);
        l += (long)rule.offset * 1000000000L;
        int n3 = 0;
        while (true) {
            if ((l2 = l - yearTicks[(n2 = DateTime.ticksToYear(l)) - 1900]) < 0L) {
                l2 += 31536000000000000L;
            }
            n = (int)(l2 / 86400000000000L);
            l2 %= 86400000000000L;
            if (DateTime.isLeapYear(n2)) {
                by2 = monForDayOfYearLeap[n];
                by = dayForDayOfYearLeap[n];
            } else {
                by2 = monForDayOfYear[n];
                by = dayForDayOfYear[n];
            }
            if (n3 == Integer.MAX_VALUE) {
                n3 = 0;
                break;
            }
            if (n3 != 0) {
                if (!rule.isWallTime() || TimeZone.dstOffset(rule, n2, by2, by, (int)(l2 / 1000000000L)) != 0) break;
                l -= (long)n3 * 1000000000L;
                n3 = Integer.MAX_VALUE;
                continue;
            }
            n3 = TimeZone.dstOffset(rule, n2, by2, by, (int)(l2 / 1000000000L));
            if (n3 == 0) break;
            l += (long)n3 * 1000000000L;
        }
        n = (int)(l2 / 3600000000000L);
        int n4 = (int)((l2 %= 3600000000000L) / 60000000000L);
        l2 %= 60000000000L;
        int n5 = (DateTime.firstWeekday(n2, by2) + by - 1) % 7;
        int n6 = 0;
        n6 |= (n2 - 1900 & 0xFF) << 0;
        n6 |= (by2 & 0xF) << 8;
        n6 |= (by & 0x1F) << 12;
        n6 |= (n & 0x1F) << 17;
        n6 |= (n4 & 0x3F) << 22;
        n6 |= (n5 & 7) << 28;
        this.fields = n6 |= (n3 != 0 ? 1 : 0) << 31;
    }

    public static DateTime fromStr(String string) {
        return DateTime.fromStr(string, true, false);
    }

    public static DateTime fromStr(String string, boolean bl) {
        return DateTime.fromStr(string, bl, false);
    }

    private static DateTime fromStr(String string, boolean bl, boolean bl2) {
        try {
            TimeZone timeZone;
            char c;
            int n;
            int n2 = DateTime.num(string, 0) * 1000 + DateTime.num(string, 1) * 100 + DateTime.num(string, 2) * 10 + DateTime.num(string, 3);
            int n3 = DateTime.num(string, 5) * 10 + DateTime.num(string, 6) - 1;
            int n4 = DateTime.num(string, 8) * 10 + DateTime.num(string, 9);
            int n5 = DateTime.num(string, 11) * 10 + DateTime.num(string, 12);
            int n6 = DateTime.num(string, 14) * 10 + DateTime.num(string, 15);
            int n7 = DateTime.num(string, 17) * 10 + DateTime.num(string, 18);
            if (string.charAt(4) != '-' || string.charAt(7) != '-' || string.charAt(10) != 'T' || string.charAt(13) != ':' || string.charAt(16) != ':') {
                throw new Exception();
            }
            int n8 = 19;
            int n9 = 0;
            int n10 = 100000000;
            if (string.charAt(n8) == '.') {
                ++n8;
                while ((n = string.charAt(n8)) >= 48 && n <= 57) {
                    n9 += (n - 48) * n10;
                    n10 /= 10;
                    ++n8;
                }
            }
            n = 0;
            if ((c = string.charAt(n8++)) != 'Z') {
                int n11 = DateTime.num(string, n8++) * 10 + DateTime.num(string, n8++);
                if (string.charAt(n8++) != ':') {
                    throw new Exception();
                }
                int n12 = DateTime.num(string, n8++) * 10 + DateTime.num(string, n8++);
                n = n11 * 3600 + n12 * 60;
                if (c == '-') {
                    n = -n;
                } else if (c != '+') {
                    throw new Exception();
                }
            }
            if (bl2) {
                if (n8 < string.length()) {
                    throw new Exception();
                }
                timeZone = TimeZone.fromGmtOffset(n);
            } else {
                if (string.charAt(n8++) != ' ') {
                    throw new Exception();
                }
                timeZone = TimeZone.fromStr(string.substring(n8), true);
            }
            return new DateTime(n2, n3, n4, n5, n6, n7, n9, n, timeZone);
        }
        catch (ParseErr parseErr) {
            if (!bl) {
                return null;
            }
            throw parseErr;
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("DateTime", string);
        }
    }

    static int num(String string, int n) {
        return string.charAt(n) - 48;
    }

    public final boolean equals(Object object) {
        if (object instanceof DateTime) {
            return this.ticks == ((DateTime)object).ticks;
        }
        return false;
    }

    public long compare(Object object) {
        long l = ((DateTime)object).ticks;
        if (this.ticks < l) {
            return -1L;
        }
        return this.ticks == l ? 0L : 1L;
    }

    public int hashCode() {
        return (int)(this.ticks ^ this.ticks >>> 32);
    }

    public long hash() {
        return this.ticks;
    }

    public Type typeof() {
        return Sys.DateTimeType;
    }

    public final long ticks() {
        return this.ticks;
    }

    public final Date date() {
        return new Date(this.getYear(), this.month().ord, this.getDay());
    }

    public final Time time() {
        return new Time(this.getHour(), this.getMin(), this.getSec(), this.getNanoSec());
    }

    public final long year() {
        return (this.fields & 0xFF) + 1900;
    }

    public final int getYear() {
        return (this.fields & 0xFF) + 1900;
    }

    public final Month month() {
        return Month.array[this.fields >> 8 & 0xF];
    }

    private final int getMonth() {
        return this.fields >> 8 & 0xF;
    }

    public final long day() {
        return this.fields >> 12 & 0x1F;
    }

    public final int getDay() {
        return this.fields >> 12 & 0x1F;
    }

    public final long hour() {
        return this.fields >> 17 & 0x1F;
    }

    public final int getHour() {
        return this.fields >> 17 & 0x1F;
    }

    public final long min() {
        return this.fields >> 22 & 0x3F;
    }

    public final int getMin() {
        return this.fields >> 22 & 0x3F;
    }

    public final long sec() {
        return this.getSec();
    }

    public final int getSec() {
        long l = this.ticks >= 0L ? this.ticks : this.ticks - yearTicks[0];
        return (int)(l % 60000000000L / 1000000000L);
    }

    public final long nanoSec() {
        return this.getNanoSec();
    }

    public final int getNanoSec() {
        long l = this.ticks >= 0L ? this.ticks : this.ticks - yearTicks[0];
        return (int)(l % 1000000000L);
    }

    public final Weekday weekday() {
        return Weekday.array[this.fields >> 28 & 7];
    }

    public final TimeZone tz() {
        return this.tz;
    }

    public final boolean dst() {
        return (this.fields >> 31 & 1) != 0;
    }

    public final String tzAbbr() {
        return this.dst() ? this.tz.dstAbbr(this.year()) : this.tz.stdAbbr(this.year());
    }

    public final long dayOfYear() {
        return DateTime.dayOfYear(this.getYear(), this.month().ord, this.getDay()) + 1;
    }

    public String toLocale() {
        return this.toLocale(null, null);
    }

    public String toLocale(String string) {
        return this.toLocale(string, null);
    }

    private String toLocale(String string, Locale locale) {
        if (string == null) {
            if (locale == null) {
                locale = Locale.cur();
            }
            string = Env.cur().locale(Sys.sysPod, localeKey, "D-MMM-YYYY WWW hh:mm:ss zzz", locale);
        }
        return new DateTimeStr(string, locale, this).format();
    }

    public static DateTime fromLocale(String string, String string2) {
        return DateTime.fromLocale(string, string2, TimeZone.cur(), true);
    }

    public static DateTime fromLocale(String string, String string2, TimeZone timeZone) {
        return DateTime.fromLocale(string, string2, timeZone, true);
    }

    public static DateTime fromLocale(String string, String string2, TimeZone timeZone, boolean bl) {
        return new DateTimeStr(string2, null).parseDateTime(string, timeZone, bl);
    }

    public Duration minusDateTime(DateTime dateTime) {
        return Duration.make(this.ticks - dateTime.ticks);
    }

    public DateTime plus(Duration duration) {
        long l = duration.ticks;
        if (l == 0L) {
            return this;
        }
        return DateTime.makeTicks(this.ticks + l, this.tz);
    }

    public DateTime minus(Duration duration) {
        long l = duration.ticks;
        if (l == 0L) {
            return this;
        }
        return DateTime.makeTicks(this.ticks - l, this.tz);
    }

    public final DateTime toTimeZone(TimeZone timeZone) {
        if (this.tz == timeZone) {
            return this;
        }
        if (timeZone == TimeZone.rel || this.tz == TimeZone.rel) {
            return new DateTime(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMin(), this.getSec(), this.getNanoSec(), Integer.MAX_VALUE, timeZone);
        }
        return DateTime.makeTicks(this.ticks, timeZone);
    }

    public final DateTime toUtc() {
        return this.toTimeZone(TimeZone.utc);
    }

    public final DateTime toRel() {
        return this.toTimeZone(TimeZone.rel);
    }

    public final DateTime floor(Duration duration) {
        if (this.ticks % duration.ticks == 0L) {
            return this;
        }
        return DateTime.makeTicks(this.ticks - this.ticks % duration.ticks, this.tz);
    }

    public final DateTime midnight() {
        return DateTime.make(this.year(), this.month(), this.day(), 0L, 0L, 0L, 0L, this.tz);
    }

    public final boolean isMidnight() {
        return this.hour() == 0L && this.min() == 0L && this.sec() == 0L && this.getNanoSec() == 0;
    }

    public final String toStr() {
        return this.toLocale("YYYY-MM-DD'T'hh:mm:ss.FFFFFFFFFz zzzz");
    }

    public static boolean isLeapYear(long l) {
        return DateTime.isLeapYear((int)l);
    }

    public static boolean isLeapYear(int n) {
        if ((n & 3) != 0) {
            return false;
        }
        return n % 100 != 0 || n % 400 == 0;
    }

    public static long weekdayInMonth(long l, Month month, Weekday weekday, long l2) {
        return DateTime.weekdayInMonth((int)l, month.ord, weekday.ord, (int)l2);
    }

    public static int weekdayInMonth(int n, int n2, int n3, int n4) {
        int n5;
        DateTime.checkYear(n);
        if (n4 == 0) {
            throw ArgErr.make("Pos is zero");
        }
        int n6 = DateTime.firstWeekday(n, n2);
        int n7 = DateTime.numDaysInMonth(n, n2);
        if (n4 > 0) {
            int n8 = n3 - n6 + 1;
            if (n8 <= 0) {
                n8 = 8 - n6 + n3;
            }
            if ((n8 += (n4 - 1) * 7) > n7) {
                throw ArgErr.make("Pos out of range " + n4);
            }
            return n8;
        }
        int n9 = (n6 + n7 - 1) % 7;
        int n10 = n9 - n3;
        if (n10 < 0) {
            n10 = 7 + n10;
        }
        if ((n5 = n7 - (n10 -= (n4 + 1) * 7)) < 1) {
            throw ArgErr.make("Pos out of range " + n4);
        }
        return n5;
    }

    public static int dayOfYear(int n, int n2, int n3) {
        return DateTime.isLeapYear(n) ? dayOfYearForFirstOfMonLeap[n2] + n3 - 1 : dayOfYearForFirstOfMon[n2] + n3 - 1;
    }

    static int numDaysInMonth(int n, int n2) {
        if (n2 == 1 && DateTime.isLeapYear(n)) {
            return 29;
        }
        return daysInMon[n2];
    }

    static int ticksToYear(long l) {
        int n = (int)(l / 31536000000000000L) + 2000;
        if (yearTicks[n - 1900] > l) {
            --n;
        }
        return n;
    }

    static int firstWeekday(int n, int n2) {
        int n3 = DateTime.isLeapYear(n) ? dayOfYearForFirstOfMonLeap[n2] : dayOfYearForFirstOfMon[n2];
        return (firstWeekdayOfYear[n - 1900] + n3) % 7;
    }

    static void checkYear(int n) {
        if (n < 1901 || n > 2099) {
            throw ArgErr.make("Year out of range " + n);
        }
    }

    public String toHttpStr() {
        return this.toTimeZone(TimeZone.utc).toLocale("WWW, DD MMM YYYY hh:mm:ss", Locale.en) + " GMT";
    }

    public static DateTime fromHttpStr(String string) {
        return DateTime.fromHttpStr(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTime fromHttpStr(String string, boolean bl) {
        SimpleDateFormat[] simpleDateFormatArray = httpFormats;
        synchronized (httpFormats) {
            for (int i = 0; i < httpFormats.length; ++i) {
                try {
                    java.util.Date date = httpFormats[i].parse(string);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return DateTime.fromJava(date.getTime());
                }
                catch (Exception exception) {
                    continue;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Invalid HTTP DateTime: '" + string + "'");
        }
    }

    public static long fromJavaToTicks(long l) {
        return (l - 946684800000L) * 1000000L;
    }

    public static DateTime fromJava(long l) {
        return DateTime.fromJava(l, TimeZone.cur);
    }

    public static DateTime fromJava(long l, TimeZone timeZone) {
        if (l <= 0L) {
            return null;
        }
        return new DateTime(DateTime.fromJavaToTicks(l), timeZone);
    }

    public long toJava() {
        return this.ticks / 1000000L + 946684800000L;
    }

    public String toIso() {
        return this.toLocale("YYYY-MM-DD'T'hh:mm:ss.FFFFFFFFFz");
    }

    public static DateTime fromIso(String string) {
        return DateTime.fromStr(string, true, true);
    }

    public static DateTime fromIso(String string, boolean bl) {
        return DateTime.fromStr(string, bl, true);
    }

    public String toCode() {
        if (this.equals(defVal)) {
            return "DateTime.defVal";
        }
        return "DateTime(\"" + this.toString() + "\")";
    }

    static void fillInDayOfYear(byte[] byArray, byte[] byArray2, int[] nArray) {
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)n;
            byArray2[i] = (byte)n2++;
            if (n2 <= nArray[n]) continue;
            ++n;
            n2 = 1;
        }
    }

    static {
        int n;
        int n2;
        httpFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", java.util.Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", java.util.Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", java.util.Locale.US)};
        java.util.TimeZone timeZone = java.util.TimeZone.getTimeZone("GMT");
        for (n2 = 0; n2 < httpFormats.length; ++n2) {
            httpFormats[n2].setTimeZone(timeZone);
        }
        yearTicks = new long[202];
        firstWeekdayOfYear = new byte[202];
        DateTime.yearTicks[0] = -3155673600000000000L;
        DateTime.firstWeekdayOfYear[0] = 1;
        for (n = 1; n < yearTicks.length; ++n) {
            n2 = 365;
            if (DateTime.isLeapYear(n + 1900 - 1)) {
                n2 = 366;
            }
            DateTime.yearTicks[n] = yearTicks[n - 1] + (long)n2 * 86400000000000L;
            DateTime.firstWeekdayOfYear[n] = (byte)((firstWeekdayOfYear[n - 1] + n2) % 7);
        }
        daysInMon = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        daysInMonLeap = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        dayOfYearForFirstOfMon = new int[12];
        dayOfYearForFirstOfMonLeap = new int[12];
        for (n = 1; n < 12; ++n) {
            DateTime.dayOfYearForFirstOfMon[n] = dayOfYearForFirstOfMon[n - 1] + daysInMon[n - 1];
            DateTime.dayOfYearForFirstOfMonLeap[n] = dayOfYearForFirstOfMonLeap[n - 1] + daysInMonLeap[n - 1];
        }
        monForDayOfYear = new byte[365];
        dayForDayOfYear = new byte[365];
        monForDayOfYearLeap = new byte[366];
        dayForDayOfYearLeap = new byte[366];
        DateTime.fillInDayOfYear(monForDayOfYear, dayForDayOfYear, daysInMon);
        DateTime.fillInDayOfYear(monForDayOfYearLeap, dayForDayOfYearLeap, daysInMonLeap);
        toleranceDefault = Duration.makeMillis(250L);
        cached = new DateTime(0L, TimeZone.cur);
        cachedUtc = new DateTime(0L, TimeZone.utc);
        nowUniqueLock = new Object();
        nowTicksCounter = new AtomicLong();
        defVal = DateTime.make(2000L, Month.jan, 1L, 0L, 0L, 0L, 0L, TimeZone.utc());
    }
}

