.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
..
.TH ft_thread_generate, 1
.SH NAME
ft_thread_generate, ft_thread_await \- generate and await an event
.SS SYNOPSIS

.Sp
.nf
\fB#include\fR <fthread.h>

int \fBft_thread_generate\fR       (ft_event_t evt);

int \fBft_thread_generate_value\fR (ft_event_t evt,void *val);

int \fBft_thread_await\fR          (ft_event_t evt);

int \fBft_thread_await_n\fR        (ft_event_t evt,int n);

int \fBft_thread_select\fR         (int len,ft_event_t *array,int *mask);

int \fBft_thread_select_n\fR       (int len,ft_event_t *array,int *mask,int timeout);

.Sp
.fi
.SS DESCRIPTION

\fBft_thread_generate\fR generates the event \fBevt\fR for the current instant of
the scheduler in which the calling thread is running. The event is thus present for this
instant; it will be automatically reset to absent at the begining of the next instant.

The value \fBval\fR is associated
to \fBevt\fR when \fBft_thread_generate_value\fR is used.


.P

\fBft_thread_await\fR suspends the calling thread until \fBevt\fR becomes generated
in the scheduler in which it is running. The waiting takes as many instants as the
generation of \fBevt\fR takes.

\fBft_thread_await_n (evt,k)\fR is similar to \fBft_thread_await (evt)\fR except
that the waiting of \fBevt\fR lasts at most \fBk\fR instants.


.P
 \fBft_thread_select\fR suspends the calling thread until one
element of \fBarray\fR becomes generated in the scheduler in which
the thread is running; \fBarray\fR should be of length
\fBk\fR.  On resumption, \fBmask\fR which is an array of
\fBk\fR integers, is set accordingly: \fBmask[i]\fR is 1 if
\fBarray[i]\fR was generated; \fBmask[i]\fR is 0,
otherwise.

\fBft_thread_select_n (k,array,mask,p)\fR is similar to \fBft_thread_select (k,array,mask)\fR except
that the waiting lasts at most \fBp\fR instants.
.SS RETURN VALUES

On success the value 0 is returned and a non-zero error code is returned on error.
.SS ERRORS

.RS 3
.TP
\&\fBBADCREATE\fR 
The exist an event (either \fBevt\fR or an element of \fBarray\fR)
which is not correctly created.
.RE



.RS 3
.TP
\&\fBBADLINK\fR 
Either the calling thread is unlinked, or the scheduler of the calling thread 
and the one of a considered event (\fBevt\fR or an element of \fBarray\fR) are different.
.RE


.RS 3
.TP
\&\fBBADMEM\fR 
Not enough memory (can only occur with 
\fBft_thread_generate_value\fR). 
.RE


.RS 3
.TP
\&\fBTIMEOUT\fR 
The timeout is reached.
.RE


.SS SEE ALSO

\fBft_event_create\fR (3),
\fBft_thread_get_value\fR (3).

.SH AUTHOR


