#!/bin/sh

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

param_c=1.0
param_t=0
param_d=2
param_u=1

if [ $# -ne 2 ]
then
  echo "usage: train.sh <*.ft> <*.mdl> < <*.tsv>" 1>&2
  exit 1
fi

dir=`dirname $0`
tmp=${TMPDIR:-.}
exlib=${EXOPLIB:-.}
ftfile=$1
mdlfile=$2
fvfile=$tmp/train.$$.fv
svfile=$tmp/train.$$.sv

$dir/tsvconv.awk -f $exlib/utility.awk -v SCRIPT=$dir/tsvconv.awk | $dir/makefv.awk -f $exlib/utility.awk -v SCRIPT=$dir/makefv.awk  > $fvfile
$dir/../svmtools/svm_fv2ft < $fvfile > $ftfile
$dir/../svmtools/svm_fv2sv $ftfile < $fvfile > $svfile
$dir/../svmtools/svm_mc_train -u $param_u -c $param_c -t $param_t -d $param_d $svfile $mdlfile

rm -f $fvfile $svfile
