#!/usr/bin/gawk -f

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

# EUC-JP¸뤳

BEGIN {
  FS = "\t";
  OFS = "\t";

  if (ARGC != 3) {
    printf "usage: %s <*.tsv> <*.out>\n", SCRIPT > "/dev/stderr";
    EXIT = 1;
    exit EXIT;
  }
  outfile = ARGV[2];
  ARGV[2] = "";

  type[0] = "";
  type[1] = "˾";
  type[2] = "+";
  type[3] = "ɾ+";
  type[4] = "+";
  type[5] = "å+";
  type[6] = "+";
}

{
  if ($8 == "") {
    print;
    next;
  }

  n8 = split($8, a8, /\\n/);

  typ = "";
  for (i = 1; i <= n8; i++) {
#    if (getline y < outfile <= 0) exit("unexpected EOF");
    if (getline y < outfile < 0) exit("unexpected EOF");
    s = type[y];
    typ = typ "\\n" s;
  }
  typ = substr(typ, 3);
  $9 = typ;
  print;
}

END {
  if (EXIT != "") exit EXIT;

  if (getline < outfile != 0) error("wrong *.out file");
}
