/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  svmtools
  Solver module
*/


#ifndef _SVM_SMO_H_
#define _SVM_SMO_H_


#include "svm_common.h"


/* Training parameter */
typedef struct Svm_tprm {
  SVM_KPRM kprm;	/* $B%+!<%M%k%Q%i%a!<%?(B */
  double c;	/* $B%=%U%H%^!<%8%s(BC */
  int kc_size;	/* $B%+!<%M%k%-%c%C%7%e%5%$%:(B(MB) */
  int shrink_loop;	/* srhinking$B$r9T$&ogCM(B */
  int expand_loop;	/* $B%-%c%C%7%e3HD%$r9T$&ogCM(B */
  double kkt_del;	/* $B<}B+>r7o(B(KKT) */
  double grad_del;	/* $B<}B+>r7o(B(gradient) */
  double alpha_eps;	/* $B&A$,(Bbound$B$+$I$&$+$NogCM(B */
  double kkt_eps;	/* shrinking$BMQogCM(B */
} SVM_TPRM;


int svm_smo(SVM_TPRM *tprm, SVM_EXM *exm, double *alpha, double *b);


#endif
