/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  svmtools
  Decision program
*/


#include <stdio.h>
#include <stdlib.h>
#include "exception.h"
#include "svm_common.h"
#include "svm_fv.h"


int main(int argc, char **argv) {
  char *mdlfile;
  FILE *fp;
  SVM_FT *ft;
  SVM_MDL *mdl;
  SVM_SV sv, svbuf;
  int svbuf_size;

  /* $B0z?t$N=hM}(B */
  if (argc != 2) {
    fprintf(stderr, "usage: %s <model file (*.fvmdl)> < <example file>\n", argv[0]);
    return 1;
  }
  mdlfile = argv[1];

  /* $B%b%G%k%G!<%?$NFI$_9~$_(B */
  fp = fopen(mdlfile, "rt");
  exception(fp == NULL, "cannot open the model file '%s'", mdlfile);
  ft = NULL;
  mdl = svm_fv_readmdl(&ft, fp);
  exception(mdl == NULL, "cannot read the model file '%s'", mdlfile);
  fclose(fp);

  svm_verbose = 0;

  /* $B=i4|2=(B */
  svbuf.idx = NULL;
  svbuf.val = NULL;
  svbuf_size = 0;

  /* $BJ,N`(B */
  for (; ; ) {
    float d;
    int label;

    if (svm_fv_readvec(ft, stdin, &label, &svbuf, &svbuf_size, &sv)) break;

    d = svm_decision(mdl, &sv);

    printf("%.7g\n", d);
    fflush(stdout);
  }

  return 0;
}
