/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  svmtools
  Multiclass decision program
*/


#include <stdio.h>
#include <stdlib.h>
#include "exception.h"
#include "svm_common.h"
#include "svm_fv.h"
#include "svm_mc.h"


int main(int argc, char **argv) {
  char *mcmdlfile;
  FILE *fp;
  SVM_MC_MDL *mcmdl;
  SVM_SV sv, svbuf;
  int svbuf_size;

  /* $B0z?t$N=hM}(B */
  if (argc != 2) {
    fprintf(stderr, "usage: %s <model file (*.mcmdl)> < <example file>\n", argv[0]);
    return 1;
  }
  mcmdlfile = argv[1];

  /* $B%b%G%k%G!<%?$NFI$_9~$_(B */
  fp = fopen(mcmdlfile, "rt");
  exception(fp == NULL, "cannot open the model file '%s'", mcmdlfile);
  mcmdl = svm_mc_readmdl(fp);
  exception(mcmdl == NULL, "cannot read the model file '%s'", mcmdlfile);
  fclose(fp);

  svm_verbose = 0;

  /* $B=i4|2=(B */
  svbuf.idx = NULL;
  svbuf.val = NULL;
  svbuf_size = 0;

  /* $BJ,N`(B */
  for (; ; ) {
    int d;
    int label;

    if (svm_readvec(stdin, &label, &svbuf, &svbuf_size, &sv)) break;

    d = svm_mc_decision(mcmdl, &sv);

    printf("%d\n", d);
    fflush(stdout);
  }

  return 0;
}
