/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  svmtools
  Multiclass classification module
*/


#ifndef _SVM_MC_H_
#define _SVM_MC_H_


#include "svm_common.h"
#include "svm_smo.h"


#define SVM_MC_METHOD_OVR 0
#define SVM_MC_METHOD_PAIRWISE 1
#define SVM_MC_METHOD_SBT 2


typedef struct Svm_mc_mdl {
  int method;	/* Multi-class$B$NJ}K!(B */
  int class;	/* $B%/%i%9$N?t(B */
  int *rank;	/* $B3NN($N9b$$=gHV$K%/%i%9HV9f$r3JG<(B */
  int *vote;	/* $BJ,N`;~$NEjI<?t(B */
  SVM_MDL **mdl;	/* SVM$B$N%b%G%k$NG[Ns(B */
} SVM_MC_MDL;


int svm_mc_makemdl(int method, int class, SVM_TPRM *tprm, SVM_EXM *mcexm, FILE *fp);
SVM_MC_MDL *svm_mc_readmdl(FILE *fp);
int svm_mc_decision(SVM_MC_MDL *mcmdl, SVM_SV *x);
int svm_mc_writemdl(SVM_MC_MDL *mcmdl, FILE *fp);


#endif
