/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  svmtools
  Feature vector module
*/


#ifndef _SVM_FV_H_
#define _SVM_FV_H_


#include <stdio.h>
#include "svm_common.h"


struct Sdb;
typedef struct Sdb SVM_FT;

typedef struct Svm_fv {
  int num;
  char **ftr;
  float *val;	/* 2$BCM$N>l9g$O(BNULL */
} SVM_FV;


SVM_FT *svm_fv_readft(FILE *fp);
int svm_fv_writeft(SVM_FT *ft, FILE *fp);
int svm_fv_fv2sv(SVM_FT *ft, SVM_FV *fv, SVM_SV *sv, int add, int sum);
int svm_fv_sv2fv(SVM_FT *ft, SVM_SV *sv, SVM_FV *fv);
SVM_MDL *svm_fv_readmdl(SVM_FT **ft, FILE *fp);
int svm_fv_createmdl(SVM_FT *ft, SVM_KPRM *kprm, SVM_EXM *exm, double *alpha, double b, FILE *fp);
int svm_fv_readvec(SVM_FT *ft, FILE *fp, int *label, SVM_SV *svbuf, int *svbuf_size, SVM_SV *sv);


#endif
