/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  Split library
*/


#include <string.h>
#include "split.h"


/*
  Split the string <str> into the array <ptr> with the delimiter <del> up to
  <size> elements, and returns the number of the elements.
*/
size_t split(char *str, char del, char **ptr, size_t size) {
  size_t n;

  if (size == 0 || *str == '\0') return 0;
  n = 0;
  ptr[n++] = str;
  while (n < size && (str = index(str, del)) != NULL) {
    *(str++) = '\0';
    ptr[n++] = str;
  }
  return n;
}
