#!/bin/sh

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

crf_learn=crf_learn
param_c=1.0
param_p=12

if [ $# -ne 1 ]
then
  echo "usage: crftrain.sh <*.crfmdl> < <*.tsv>" 1>&2
  exit 1
fi

dir=`dirname $0`
tmp=${TMPDIR:-.}
exlib=${EXOPLIB:-.}
mdlfile=$1
tagfile=$tmp/crftrain.$$.tag

$dir/tsv2tag.awk -f $exlib/utility.awk -v SCRIPT=$dir/tsv2tag.awk > $tagfile
$crf_learn -c $param_c -p $param_p $dir/template $tagfile $mdlfile

rm -f $tagfile
