#!/bin/sh

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

if [ $# -ne 1 ]
then 
  echo "usage: $0 <*.mdl> < <*.tsv>" 2>&1
  exit 1
fi

dir=`dirname $0`
tmp=${TMPDIR:-.}
exlib=${EXOPLIB:-.}
mdlfile=$1
datfile=$tmp/train.$$.dat

$dir/tsv2par.awk -f $exlib/utility.awk -v SCRIPT=$dir/tsv2par.awk | $dir/par2dat.awk -f $exlib/utility.awk -v SCRIPT=$dir/par2dat.awk $dictionary/dictionary.dic $dictionary/reverse.dic > $datfile
$dir/lsm_train < $datfile > $mdlfile

rm -f $datfile
