#!/usr/bin/gawk -f

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

BEGIN {
  FS = "\t";

  if (ARGC < 3) {
    printf "usage: par2dat.awk <dictionary.dic> <reverse.dic> [<*.par>]\n" > "/dev/stderr";
    exit 1;
  }
  dicfile = ARGV[1];
  ARGV[1] = "";
  dirfile = ARGV[2];
  ARGV[2] = "";

  # ɤ߹(w/ ǲ)+ȥ饤˳Ǽ
  ndic = dicread(dicfile, dicw, dicp, trie_flg, trie_val);
  ndic2 = dicread(dirfile, dicw2, dicp2, trie_flg2, trie_val2);
}

{
  cls = $1;
  n = split($3, surf, / /);
  n = split($4, base, / /);
  n = split($5, cpos, / /);
  n = split($6, fpos, / /);
  m = split($7, chnk, / /);
  m = split($8, head, / /);
  m = split($9, type, / /);
  chnk[m + 1] = n + 1;
  for (i = 1; i <= n; i++) if (fpos[i] == "*") fpos[i] = cpos[i];

  # ¤ην
  for (i = 1; i < m; i++) {
    if (type[i] == "P") {
      type[i] = type[head[i]];
      head[i] = head[head[i]];
      i--;
      continue;
    }
  }

  # Ϳ(trieõ)
  for (i = 1; i <= n; i++) pole[i] = "*";
  nlist = lookup(n, base, 1, n, trie_flg, trie_val, listv, listb, listl);
  for (i = 0; i < nlist; i++) {
    j = listb[i] + listl[i];

    # ִ򤷤¤פΤ褦ɽ
    if (fpos[j] == "Ū̾") continue;
    # ѡפŪˡξ㳰(ֺʪˤɤפʤ)
    if (dicw[listv[i]] == "Ѥ" && (cpos[j + 1] == "ƻ" || cpos[j + 1] == "̾" || cpos[j + 1] == "ư")) continue;

    pole[j] = dicp[listv[i]];
    if (pole[j] == "0") pole[j] = "*";

    # ˡסԴס̤Ĵפʤ
    if (listb[i] >= 2 && pole[j] != "*" && cpos[j] == "̾" && fpos[listb[i] - 1] == "ʷƻƬ" && (base[listb[i] - 1] == "" || base[listb[i] - 1] == "" || base[list[i] - 1] == "̤")) {
      pole[j] = ((pole[j] == "*") ? "*" : ((pole[j] == "+") ? "-" : "+"));
    }
  }

  # ְפʤɤн
  for (i = 1; i < n; i++) {
    if (pole[i] != "*" && cpos[i] == "ƻ" && fpos[i + 1] == "̾Ҹ") {
      pole[i + 1] = pole[i];
      pole[i] = "*";
    }
  }

  # ʸ˶ĸ줬ʣϺǸΤΤȤ
  for (i = 1; i <= m; i++) {
    flag = 0;
    for (j = chnk[i + 1] - 1; j >= chnk[i]; j--) {
      if (pole[j] != "*") {
	if (flag == 0) {
	  flag = j;
	} else {
	  pole[j] = "*";
	}
      }
    }
  }

  for (i = 1; i <= n; i++) dir[i] = "*";
  nlist2 = lookup(n, base, 1, n, trie_flg2, trie_val2, listv2, listb2, listl2);
  for (i = 0; i < nlist2; i++) {
    j = listb2[i] + listl2[i];

    if (!(cpos[j] == "ư" || cpos[j] == "ƻ" || cpos[j] == "̾")) continue; #֤ʤפʤɤ
    if (dicp2[listv2[i]] == "0") continue;	# 0ѤΥߡ

    dir[j] = dicp2[listv2[i]];
  }
  for (i = 1; i <= m; i++) {
    dir2[i] = 0;
    for (j = chnk[i]; j < chnk[i + 1]; j++) {
      if (dir[j] == "+") dir2[i]++; else if (dir[j] == "-") dir2[i]--;
    }
    if (dir2[i] > 0) dir2[i] = "+"; else if (dir2[i] < 0) dir2[i] = "-"; else dir2[i] = "0";
  }

  # ǽˤ
  # ֿۤʤפʤ
  for (i = 1; i <= n - 1; i++) {
    if (pole[i] != "*" && (base[i + 1] == "ʤ" || base[i + 1] == "̵") && fpos[i + 1] == "̾̾") {
      pole[i] = ((pole[i] == "*") ? "*" : ((pole[i] == "+") ? "-" : "+"));
    }
  }
  # ̤
  for (i = 1; i <= m; i++) {
    for (j = chnk[i]; j < chnk[i + 1]; j++) {
      l = j;
      if ((base[j] == "ʤ" && cpos[j] == "") || (base[j] == "" && cpos[j] == "ư") || (base[j] == "ˤ" && cpos[j] == "") || (base[j] == "Ť餤" && cpos[j] == "") || (base[j] == "ޤ" && fpos[j] == "ư") || (base[j] == "ͤ" && fpos[j] == "ư")) break;
      if (base[j] == "" && fpos[j] == "̾" && (base[j + 1] == "ʤ" || base[j + 1] == "̵") && cpos[j + 1] == "ƻ") break;
    }
    if (j == chnk[i + 1]) continue;
    # ֤ˤؤ餺פ㳰
    if (base[l] == "" && base[l - 3] == "" && base[l - 2] == "" && (base[l - 1] == "" || base[l - 1] == "ؤ")) continue;
    # ֡ʤɤס֡ʤס֡ǤϤʤס֤ФǤʤפ㳰
    for (j = chnk[i]; j < chnk[i + 1]; j++) {
      if (base[j] == "" && (fpos[j] == "³" || fpos[j] == "")) break;
      if ((base[j] == "" || base[j] == "Τ") && cpos[j] == "ư") break;
      if (j < l && base[j] == "" && base[j + 1] == "") break;
      if (j < l && base[j] == "Ф" && base[j + 1] == "") break;
      if (j < l && base[j] == "Ф") break;
      # ֡ʤФʤʤס֡ʤϤʤ
      if (j > l && ((base[j] == "ʤ" && cpos[j] == "") || (base[j] == "" && cpos[j] == "ư") || (base[j] == "ޤ" && fpos[j] == "ư"))) break;
    }
    if (j < chnk[i + 1]) continue;
    for (j = chnk[i]; j < chnk[i + 1] && j < l; j++) {
      pole[j] = ((pole[j] == "*") ? "*" : ((pole[j] == "+") ? "-" : "+"));
    }
    if (dir2[i] == "-") {
      dir2[i] = "+";
    } else {
      dir2[i] = "-"; #ǥեȤ+Ȥ
    }
  }

  # °
  for (i = 1; i <= m; i++) {
    pol[i] = "0";
    for (j = chnk[i + 1] - 1; j >= chnk[i]; j--) {
      if (pole[j] != "*") {
	pol[i] = ((pole[j] == "+") ? "1" : "2");
	break;
      }
    }
  }
  for (i = 1; i <= m; i++) {
    rev[i] = ((dir2[i] == "-") ? "1" : "0");
  }

  # 
  printf "%d", cls;
  for (i = 1; i <= m; i++) {
    s = "";
    b = "";
    c = "";
    f = "";
    for (j = chnk[i]; j < chnk[i + 1]; j++) {
      s = s surf[j] " ";
      b = b base[j] " ";
      c = c cpos[j] " ";
      f = f fpos[j] " ";
    }
    printf "\t%d\t%s\t%s\t%s\t%s\t%s\t%s", head[i], s, b, c, f, pol[i], rev[i];
  }
  printf "\n";
}
