#!/usr/bin/gawk -f

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

# EUC-JP¸뤳

BEGIN {
  FS = "\t";
  OFS = "\t";

  if (ARGC != 3) {
    printf "usage: %s <*.tsv> <*.out>\n", SCRIPT > "/dev/stderr";
    EXIT = 1;
    exit EXIT;
  }
  outfile = ARGV[2];
  ARGV[2] = "";
}

{
  if ($8 == "") {
    print;
    next;
  }

  n8 = split($8, a8, /\\n/);
  n9 = split($9, a9, /\\n/);

  pol = "";
  for (i = 1; i <= n8; i++) {
    if (a9[i] !~ /+$/ && a9[i] !~ /-$/) {
      pol = pol "\\n" a9[i];
      continue;
    }
#    if (getline y < outfile <= 0) exit("unexpected EOF");
    if (getline y < outfile < 0) exit("unexpected EOF");
    s = ((y > 0.0) ? "+" : "-");
#    pol = pol "\\n" substr(a9[i], 1, length(a9[i]) - 2) s;
    pol = pol "\\n" substr(a9[i], 1, length(a9[i]) - 1) s;
  }
  pol = substr(pol, 3);
  $9 = pol;
  print;
}

END {
  if (EXIT != "") exit EXIT;

  if (getline < outfile != 0) error("wrong *.out file");
}
