/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  A Latent Variable Model for Sentiment Classification
  ̥⥸塼
*/


#ifndef _LSM_COMMON_H_
#define _LSM_COMMON_H_


#include <stdio.h>
#include "hashtable.h"


#define TKN_MAX (32*256)	/* ʸ˴ޤޤȡ */
#define CLS_MAX 2	/* ѿΥ饹ο */
#define PRB1(prb, i, c) ((prb)[CLS_MAX * (i) + (c)])
#define PRB2(prb, i, c, d) ((prb)[CLS_MAX * CLS_MAX * (i) + CLS_MAX * (c) + (d)])
#define POT1(pot, i, c) ((pot)[CLS_MAX * (i) + (c)])
#define POT2(pot, i, c, d) ((pot)[CLS_MAX * CLS_MAX * (i) + CLS_MAX * (c) + (d)])


/*
  ɾɽ(ȡʬ򤷤ä)
*/
typedef struct Xpr {
  int lbl;		/* ٥ */
  int num;
  int head[TKN_MAX];
  char *surf[TKN_MAX];
  char *base[TKN_MAX];
  char *cpos[TKN_MAX];
  char *fpos[TKN_MAX];
  int pol[TKN_MAX];
  int rev[TKN_MAX];
  int buf_size;
  char *buf;
} XPR;

/*
  variableΡ
*/
typedef struct Var {
  int con;	/* ͤܤƤ뤫 */
  int cnt;	/* å򲿸ļä */
  int flg;	/* Ԥä */
} VAR;

/*
  factorΡ
*/
typedef struct Fac {
  int con;	/* ͤܤƤ뤫 */
  int cnt;	/* å򲿸ļä */
  int flg;	/* Ԥä */
  int nbr[2];	/* ïܤƤ뤫 */
  int rcv[2];	/* facΡɤåäɤ */
  int snd[2];	/* facΡɤåäɤ */
  double v2f[2][CLS_MAX];	/* variableäå */
  double f2v[2][CLS_MAX];	/* variableϤå */
} FAC;


int readxpr(XPR *xpr, FILE *fp);
void makeftr1(SDB *ft, int add, XPR *xpr, int i, int c, int ftr_size, int *ftr_num, int *ftr);
void makeftr2(SDB *ft, int add, XPR *xpr, int i, int j, int c, int d, int ftr_size, int *ftr_num, int *ftr);
void bp(XPR *xpr, double *pot1, double *pot2, VAR *v, FAC *f, double *prb1, double *prb2);


#endif
