/*
Copyright(C) 2007-2012 National Institute of Information and Communications Technology

This code, which implements L-BFGS optimization algorithm, is translated into C by hand
from the original Fortran code.
The original Fortran code is written by Prof. Jorge Nocedal and released under the BSD license.
*/

/*
  Software for Large-scale Unconstrained Optimization
  L-BFGS is a limited-memory quasi-Newton code for unconstrained
  optimization.

  http://www.ece.northwestern.edu/~nocedal/lbfgs.html

  Authors
  Jorge Nocedal

  References
  - J. Nocedal. Updating Quasi-Newton Matrices with Limited Storage(1980),
    Mathematics of Computation 35, pp. 773-782.
  - D.C. Liu and J. Nocedal. On the Limited Memory Method for
    Large Scale Optimization(1989),  Mathematical Programming B, 45, 3, pp. 503-528.
*/

void lbfgs(int N, int M, double *X, double F, double *G, int DIAGCO, double *DIAG, int *IPRINT, double EPS, double XTOL, double *W, int (*IFLAG));
