#!/bin/sh

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

if [ $# -ne 2 ]
then 
  echo "usage: $0 <*.mdl> <*.tsv> > <*.tsv>" 2>&1
  exit 1
fi

dir=`dirname $0`
tmp=${TMPDIR:-.}
exlib=${EXOPLIB:-.}
mdlfile=$1
tsvfile=$2
datfile=$tmp/test.$$.dat
outfile=$tmp/test.$$.out

$dir/tsv2par.awk -f $exlib/utility.awk -v SCRIPT=$dir/tsv2par.awk $tsvfile | $dir/par2dat.awk -f $exlib/utility.awk -v SCRIPT=$dir/par2dat.awk $dictionary/dictionary.dic $dictionary/reverse.dic > $datfile
$dir/lsm_classify $mdlfile < $datfile > $outfile 2> /dev/null
$dir/out2tsv.awk -f $exlib/utility.awk -v SCRIPT=$dir/out2tsv.awk $tsvfile $outfile

rm -f $datfile $outfile
