/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  Exception library
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "exception.h"


void exception_(char *file, int line, int bool, char *format, ...) {
  va_list ap;

  if (!bool) return;
  fprintf(stderr, "EXCEPTION(%s:%d): ", file, line);
  va_start(ap, format);
  vfprintf(stderr, format, ap);
  va_end(ap);
  fprintf(stderr, "\n");
  abort();
  return;	/* void */
}


void *scalloc_(char *file, int line, size_t nmemb, size_t size) {
  void *p;
  p = calloc(nmemb, size);
  exception_(file, line, (p == NULL), "calloc() failed");
  return p;
}


void *smalloc_(char *file, int line, size_t size) {
  void *p;
  p = malloc(size);
  exception_(file, line, (p == NULL), "malloc() failed");
  return p;
}


void *srealloc_(char *file, int line, void *ptr, size_t size) {
  void *p;
  p = realloc(ptr, size);
  exception_(file, line, (size != 0 && p == NULL), "realloc() failed");
  return p;
}


char *sstrdup_(char *file, int line, const char *s) {
  char *p;
  p = strdup(s);
  exception_(file, line, (p == NULL), "realloc() failed");
  return p;
}
