#
#  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#  


# Utility library
# SCRIPT: ץ̾
# EXIT: ""ʳξϰ۾ｪλ(EXIT=λơ)

# ǲϷ̤μ
function ma(mrp, surf, base, cpos, fpos,  mrpelem, num, n) {
  num = split(mrp, mrpelem, /:/);
  if (num != 4) error("wrong mrp field");
  n = split(mrpelem[1], surf, /_/);
  num = n;
  n = split(mrpelem[2], base, /_/);
  if (n != num) error("wrong mrp field 1")
  n = split(mrpelem[3], cpos, /_/);
  if (n != num) error("wrong mrp field 2")
  n = split(mrpelem[4], fpos, /_/);
  if (n != num) error("wrong mrp field 3")
  return num;
}

# ʸϷ̤μ
# bnst[i]iܤʸκǸηǤμηǤID
# ʸΤheadɽʸID0
function da(dep, bnst, head, type,  depelem, num, m) {
  num = split(dep, depelem, /:/);
  if (num != 3) error("wrong dep field");
  m = split(depelem[1], bnst, /_/);
  bnst[0] = 1;
  num = m;
  m = split(depelem[2], head, /_/);
  if (m != num) error("wrong dep field 1")
  m = split(depelem[3], type, /_/);
  if (m != num) error("wrong dep field 2")
  return num;
}

# 2 byteʸindex
function eucindex(s, t,  o, i) {
  o = 0;
  for (; ; ) {
    i = index(substr(s, 1 + o), t);
    if (i == 0) return 0;
    if (i % 2 == 1) break;
    o += i;
  }
  i += o;
  return i;
}

# ʸ(EUC)νиǤϰϤꤹ(: PSTART, λ: PEND)
# s: ʸ, n: ñ, w: ñ, t: õʸ, b: õϤ(byte, 0-base)
# : դäϰϤμΰ(byte, 0-base)դʤ-1
function position(s, n, w, t, b,  i, j, l) {
  PSTART = -1;
  PEND = -1;

  i = eucindex(substr(s, 1 + b), t) - 1;
  if (i == -1) return -1;
  i += b;
  l = 0;
  for (j = 1; j <= n; j++) {
    l += length(w[j]);
    if (l > i) break;
  }
  PSTART = j;
  for (j++; j <= n; j++) {
    if (l >= i + length(t)) break;
    l += length(w[j]);
  }
  PEND = j - 1;
  return l;
}

# 顼
function error(s) {
  printf "ERROR(%s): %s\n", SCRIPT, s > "/dev/stderr";
  EXIT = 1;
  exit(1);
}

# 顼ɽ
function showError(s) {
  printf "ERROR(%s): %s", SCRIPT, s > "/dev/stderr";
}

# ɤ߹
function dicread(dicfile, dicw, dicp, trie_flg, trie_val,  ndic, buf, nelem, elem, s, i, r) {
  ndic = 0;
  for (; ; ) {
    r = getline buf < dicfile;
    if (r < 0) error("cannot read the dictionary");
    if (r == 0) break;
    # Ͽ
    nelem = split(buf, elem, /\t/);
    if (nelem < 3) error("wrong dictinoary");
    dicw[ndic] = elem[1];
    dicp[ndic] = elem[2];
    # ȥ饤Ͽ
    s = "";
    for (i = 3; i <= nelem - 1; i++) {
      s = s "\t" elem[i];
      trie_flg[s] = 1;
    }
    s = s "\t" elem[i];
    trie_val[s] = ndic;
    ndic++;
  }
  close(dicfile);

  return ndic;
}

# lookup
function lookup(n, w, b, e, trie_flg, trie_val, listv, listb, listl,  nlist, i, s, j, b0, e0, b1, e1) {
  nlist = 0;
  for (i = b; i <= e; i++) {
    s = "";
    for (j = 0; i + j <= e; j++) {
      s = s "\t" w[i + j];
      if (trie_val[s] != "") {
	listv[nlist] = trie_val[s];
	listb[nlist] = i;
	listl[nlist] = j;
	nlist++;
      }
      if (trie_flg[s] == "") break;
    }
  }
  # overlapûΤ
  for (i = 0; i < nlist; i++) {
    # ϡλ
    b0 = listb[i];
    e0 = listb[i] + listl[i];
    # i֤Τɤ줫˴ޤޤΤʤк
    for (j = 0; j < nlist; j++) {
      if (i == j) continue;
      b1 = listb[j];
      e1 = listb[j] + listl[j];
      if (b1 <= b0 && e0 <= e1) break;
    }
    # 
    if (j != nlist) {
      listv[i] = listv[nlist - 1];
      listb[i] = listb[nlist - 1];
      listl[i] = listl[nlist - 1];
      nlist--;
      i--;
    }
  }

  return nlist;
}
