#!/bin/sh -x

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

# $B0z?t$N@bL@(B:
#  <model name>: $B@8@.$5$l$k%b%G%kL>$N(Bprefix
#  <xpr *.tsv>: $BI>2AI=8=Cj=P$N$?$a$N%3!<%Q%9(B
#  <src *.tsv>: $BI>2AJ];}<TCj=P$N$?$a$N%3!<%Q%9(B
#  <typ *.tsv>: $BI>2A%?%$%WJ,N`$N$?$a$N%3!<%Q%9(B
#  <pol *.tsv>: $BI>2A6K@-J,N`$N$?$a$N%3!<%Q%9(B

if [ $# -ne 6 ]
then
  echo "usage: _train.sh <model name> <xpr *.tsv> <src *.tsv> <typ *.tsv> <pol *.tsv>" 1>&2
  exit 1
fi

dir=`cd $(dirname $0) && pwd`
mdldir=$1
xprmdlfile=$mdldir".xpr_mdl"
srcftfile=$mdldir".src_ft"
srcsvmmdlfile=$mdldir".src_svmmdl"
srccrfmdlfile=$mdldir".src_crfmdl"
typftfile=$mdldir".typ_ft"
typmdlfile=$mdldir".typ_mdl"
polmdlfile=$mdldir".pol_mdl"
#scrftfile=$mdldir".scr_ft"
#scrmdlfile=$mdldir".scr_mdl"
tsvfile_xpr=$2
tsvfile_src=$3
tsvfile_typ=$4
tsvfile_pol=$5
tsvfile_scr=$5

$dir/xpr/train.sh $xprmdlfile < $tsvfile_xpr
$dir/src/train.sh $srcftfile $srcsvmmdlfile $srccrfmdlfile $tsvfile_src
$dir/typ/train.sh $typftfile $typmdlfile < $tsvfile_typ
$dir/pol/train.sh $polmdlfile < $tsvfile_pol
#$dir/scr/train.sh $scrftfile $scrmdlfile < $tsvfile_scr
